/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductSettings;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Contract2ModelContract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.ContractActions;
import com.gridnine.xtrip.common.model.rules.standard.HotelProperties;
import com.gridnine.xtrip.common.model.rules.standard.SupplierActions;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.hotelProductSettings.HotelProductSettingsActions;
import com.gridnine.xtrip.common.model.rules.standard.hotelProductSettings.HotelProductSettingsTargets;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class MigrateHotelSupplierActionsTask
extends BaseLongRunningTask<Serializable> {
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("hotel supplier actions migration started");
        EntityContainer hotelProductSettings = HotelProductHelper.getSettings();
        List hotelProductSettingsRules = ((HotelProductSettings)hotelProductSettings.getEntity()).getRuleSet().getRules();
        EntityStorage storage = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)ContractType.VENDOR));
        List contractIndexList = storage.search(ContractIndex.class, query).getData();
        for (ContractIndex contractIndex : contractIndexList) {
            EntityContainer contractCtr = storage.resolve(contractIndex.getSource());
            if (!EntityStorageHelper.nonEmpty((EntityContainer)contractCtr)) continue;
            Contract contract = (Contract)contractCtr.getEntity();
            for (Contract2ModelContract contract2ModelContract : contract.getModelContracts()) {
                ModelContract modelContract;
                EntityContainer modelContractCtr;
                if (contract2ModelContract.getEndDate() != null && !contract2ModelContract.getEndDate().after(new Date()) || !EntityStorageHelper.nonEmpty((EntityContainer)(modelContractCtr = EntityStorage.get().resolve(contract2ModelContract.getModelContract()))) || (modelContract = (ModelContract)modelContractCtr.getEntity()).getRuleSet() == null) continue;
                for (RuleSettings rules : modelContract.getRuleSet().getRules()) {
                    if (rules.getPeriodEnd() != null && !rules.getPeriodEnd().after(new Date()) || rules.getTarget() != Targets.HOTELS_COMMISSION || !rules.getResults().stream().anyMatch(result -> result.getAction() == ContractActions.CONTRACT || result.getAction() == SupplierActions.SUPPLIER || result.getAction() == SupplierActions.PRODUCT_BLANK_OWNER)) continue;
                    callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)(contract.getName() + " - " + modelContract.getName()), (Object[])new Object[0]));
                    RuleSettings ruleSettings = new RuleSettings();
                    ruleSettings.setName(rules.getName());
                    ruleSettings.setDescription(rules.getDescription());
                    ruleSettings.setPeriodBegin(rules.getPeriodBegin());
                    ruleSettings.setPeriodEnd(rules.getPeriodEnd());
                    ruleSettings.setRemarks(rules.getRemarks());
                    ruleSettings.setTarget((RuleTarget)HotelProductSettingsTargets.HOTEL_PRODUCT_SETTINGS);
                    ruleSettings.getRestrictions().addAll(rules.getRestrictions().stream().map(restriction -> {
                        if ("GDS_ACCOUNT".equals(restriction.getProperty().getId())) {
                            RuleRestriction ruleRestriction = new RuleRestriction();
                            ruleRestriction.setProperty((RuleProperty)HotelProperties.HOTEL_GDS_ACCOUNT);
                            ruleRestriction.setCondition(restriction.getCondition());
                            ruleRestriction.setValue(restriction.getValue());
                            return ruleRestriction;
                        }
                        return restriction;
                    }).collect(Collectors.toList()));
                    if (ruleSettings.getRestrictions().stream().noneMatch(ruleRestriction -> ruleRestriction.getProperty() == HotelProperties.HOTEL_GDS_ACCOUNT || ruleRestriction.getProperty() == HotelProperties.HOTEL_PROVIDER || ruleRestriction.getProperty() == HotelProperties.HOTEL_SUBPROVIDER) && contract.getProvider() != null) {
                        RuleRestriction ruleRestriction2 = new RuleRestriction();
                        ruleRestriction2.setProperty((RuleProperty)HotelProperties.HOTEL_PROVIDER);
                        ruleRestriction2.setCondition((RuleCondition)Conditions.EQUALS);
                        ruleRestriction2.setValue(Collections.singletonList(contract.getProvider()));
                        ruleSettings.getRestrictions().add(ruleRestriction2);
                    }
                    ruleSettings.getResults().addAll(rules.getResults().stream().map(result -> {
                        if (result.getAction() == ContractActions.CONTRACT) {
                            RuleResult contractResult = new RuleResult();
                            contractResult.setAction((RuleAction)HotelProductSettingsActions.HOTEL_VENDOR_CONTRACT);
                            contractResult.setValue((Object)contractIndex.getSource());
                            return contractResult;
                        }
                        if (result.getAction() == SupplierActions.SUPPLIER || result.getAction() == SupplierActions.PRODUCT_BLANK_OWNER) {
                            return result;
                        }
                        return null;
                    }).filter(Objects::nonNull).collect(Collectors.toList()));
                    hotelProductSettingsRules.add(ruleSettings);
                }
            }
        }
        storage.save(hotelProductSettings, false);
        callback.taskFinished();
        this.log.debug("hotel supplier actions migration finished");
    }

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.MigrateHotelSupplierActionsTask_description, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }
}

