/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Date;
import org.w3c.dom.Element;

public class OpenCloseDatesUpdateTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.OpenCloseDatesUpdateTask_updateDateOpenClose, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        this.updateSalesPoints(callback);
        callback.updateProgress((byte)30);
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.OpenCloseDatesUpdateTask_updateDateOpenCloseSalePoint, (Object[])new Object[0]));
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        this.updatePersons(callback);
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.OpenCloseDatesUpdateTask_updateDateOpenCloseIndividual, (Object[])new Object[0]));
        callback.updateProgress((byte)60);
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        this.updateContracts(callback);
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.OpenCloseDatesUpdateTask_updateDateOpenCloseContract, (Object[])new Object[0]));
        callback.updateProgress((byte)100);
        callback.taskFinished();
    }

    private void updateContracts(LongRunningTask.EventsCallback callback) throws Exception {
        EntityStorage es = EntityStorage.get();
        for (ContractIndex index : es.search(ContractIndex.class, new SearchQuery()).getData()) {
            try {
                EntityContainer ctr = es.resolve(index.getSource());
                boolean updated = false;
                for (ContractCustomerInfo info : ((Contract)ctr.getEntity()).getCustomers()) {
                    Date newDate;
                    if (info.getStartDate() != null && (newDate = MiscUtil.clearTime((Date)info.getStartDate())).getTime() != info.getStartDate().getTime()) {
                        info.setStartDate(newDate);
                        updated = true;
                    }
                    if (info.getEndDate() == null || (newDate = MiscUtil.setDayEndTime((Date)info.getEndDate())).getTime() == info.getEndDate().getTime()) continue;
                    info.setEndDate(newDate);
                    updated = true;
                }
                if (!updated) continue;
                ctr.getVersionInfo().setDataSource("update-task");
                ctr.getVersionInfo().setVersionNotes("this version is created auromatically by procedure of update of open and close date");
                es.save(ctr, true);
            }
            catch (Throwable e) {
                this.log.error("unable to update contract " + index.getSource(), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.OpenCloseDatesUpdateTask_cantUpdateContract, (Throwable)e, (Object[])new Object[]{index.getSource().toString()}));
            }
        }
    }

    private void updatePersons(LongRunningTask.EventsCallback callback) throws Exception {
        EntityStorage es = EntityStorage.get();
        for (PersonIndex index : es.search(PersonIndex.class, new SearchQuery()).getData()) {
            try {
                Date newDate;
                EntityContainer ctr = es.resolve(index.getSource());
                boolean updated = false;
                for (PersonEmployment empl : ((Person)ctr.getEntity()).getEmployments()) {
                    if (empl.getOpened() != null && (newDate = MiscUtil.clearTime((Date)empl.getOpened())).getTime() != empl.getOpened().getTime()) {
                        empl.setOpened(newDate);
                        updated = true;
                    }
                    if (empl.getClosed() == null || (newDate = MiscUtil.setDayEndTime((Date)empl.getClosed())).getTime() == empl.getClosed().getTime()) continue;
                    empl.setClosed(newDate);
                    updated = true;
                }
                for (PlaceOfSales place : ((Person)ctr.getEntity()).getSalesPoints()) {
                    if (place.getOpened() != null && (newDate = MiscUtil.clearTime((Date)place.getOpened())).getTime() != place.getOpened().getTime()) {
                        place.setOpened(newDate);
                        updated = true;
                    }
                    if (place.getClosed() == null || (newDate = MiscUtil.setDayEndTime((Date)place.getClosed())).getTime() == place.getClosed().getTime()) continue;
                    place.setClosed(newDate);
                    updated = true;
                }
                for (PlaceOfSales place : ((Person)ctr.getEntity()).getGdsReferences()) {
                    if (place.getOpened() != null && (newDate = MiscUtil.clearTime((Date)place.getOpened())).getTime() != place.getOpened().getTime()) {
                        place.setOpened(newDate);
                        updated = true;
                    }
                    if (place.getClosed() == null || (newDate = MiscUtil.setDayEndTime((Date)place.getClosed())).getTime() == place.getClosed().getTime()) continue;
                    place.setClosed(newDate);
                    updated = true;
                }
                if (!updated) continue;
                ctr.getVersionInfo().setDataSource("update-task");
                ctr.getVersionInfo().setVersionNotes("this version is created auromatically by procedure of update of open and close date");
                es.save(ctr, true);
            }
            catch (Throwable e) {
                this.log.error("unable to update contract " + index.getSource(), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.OpenCloseDatesUpdateTask_cantUpdateDataIndividual, (Throwable)e, (Object[])new Object[]{index.getSource().toString()}));
            }
        }
    }

    private void updateSalesPoints(LongRunningTask.EventsCallback callback) throws Exception {
        EntityStorage es = EntityStorage.get();
        for (SalesPointIndex index : es.search(SalesPointIndex.class, new SearchQuery()).getData()) {
            try {
                Date newDate;
                EntityContainer ctr = es.resolve(index.getSource());
                boolean updated = false;
                for (Pcc pcc : ((SalesPoint)ctr.getEntity()).getPccs()) {
                    if (pcc.getOpened() != null && (newDate = MiscUtil.clearTime((Date)pcc.getOpened())).getTime() != pcc.getOpened().getTime()) {
                        pcc.setOpened(newDate);
                        updated = true;
                    }
                    if (pcc.getClosed() == null || (newDate = MiscUtil.setDayEndTime((Date)pcc.getClosed())).getTime() == pcc.getClosed().getTime()) continue;
                    pcc.setClosed(newDate);
                    updated = true;
                }
                for (Validator place : ((SalesPoint)ctr.getEntity()).getValidators()) {
                    if (place.getOpened() != null && (newDate = MiscUtil.clearTime((Date)place.getOpened())).getTime() != place.getOpened().getTime()) {
                        place.setOpened(newDate);
                        updated = true;
                    }
                    if (place.getClosed() == null || (newDate = MiscUtil.setDayEndTime((Date)place.getClosed())).getTime() == place.getClosed().getTime()) continue;
                    place.setClosed(newDate);
                    updated = true;
                }
                if (!updated) continue;
                ctr.getVersionInfo().setDataSource("update-task");
                ctr.getVersionInfo().setVersionNotes("this version is created auromatically by procedure of update of open and close date");
                es.save(ctr, true);
            }
            catch (Throwable e) {
                this.log.error("unable to update contract " + index.getSource(), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.OpenCloseDatesUpdateTask_cantUpdateDataSalePoint, (Throwable)e, (Object[])new Object[]{index.getSource().toString()}));
            }
        }
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }
}

