/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ExternalSystemReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.ExternalSystem;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCode;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCodeV2;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class OrganizationMigrateExternalCodesToV2Task
extends BaseLongRunningTask<Serializable> {
    private final Logger logger = LoggerFactory.getLogger(OrganizationMigrateExternalCodesToV2Task.class);

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.logger.debug("Start executing OrganizationMigrateExternalCodesToV2Task");
        OrganizationMigrateExternalCodesToV2Task.findOrganizationsWithExternalCodes().getData().forEach(this::tryMigrateExternalSystemCodes);
        callback.taskFinished();
        this.logger.debug("Finish executing OrganizationMigrateExternalCodesToV2Task");
    }

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.OrganizationMigrateExternalCodesToV2Task, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    private void tryMigrateExternalSystemCodes(OrganizationIndex organizationIndex) {
        EntityContainer organizationContainer = EntityStorage.get().resolve(organizationIndex.getSource());
        if (organizationContainer == null) {
            return;
        }
        Organization organization = (Organization)organizationContainer.getEntity();
        List oldVersionSystemCodes = organization.getExternalCodes();
        if (oldVersionSystemCodes.isEmpty()) {
            return;
        }
        List newVersionSystemCodes = organization.getExternalCodesV2();
        ArrayList<ExternalSystemCode> systemCodesToRemove = new ArrayList<ExternalSystemCode>();
        for (ExternalSystemCode oldSystemCode : oldVersionSystemCodes) {
            ExternalSystemCodeV2 externalSystemCodeV2 = this.migrateExternalSystemCode(oldSystemCode);
            if (externalSystemCodeV2 == null) continue;
            newVersionSystemCodes.add(externalSystemCodeV2);
            systemCodesToRemove.add(oldSystemCode);
        }
        oldVersionSystemCodes.removeAll(systemCodesToRemove);
        try {
            EntityStorage.get().save(organizationContainer, false);
            this.logger.info(String.format("Migrated codes %s for organization %s", OrganizationMigrateExternalCodesToV2Task.mergeCodesToString(systemCodesToRemove), organization.getCode()));
        }
        catch (Exception ex) {
            this.logger.warn(String.format("Unable to migrate codes for  organization %s", organization.getCode()));
        }
        if (!oldVersionSystemCodes.isEmpty()) {
            this.logger.warn(String.format("Unable to migrate codes %s for organization %s", OrganizationMigrateExternalCodesToV2Task.mergeCodesToString(oldVersionSystemCodes), organization.getCode()));
        }
    }

    private static String getSystemName(ExternalSystemCode externalSystemCode) {
        ExternalSystem externalSystem = externalSystemCode.getSystem();
        if (externalSystem == null) {
            return null;
        }
        return externalSystem.name();
    }

    private static String mergeCodesToString(List<ExternalSystemCode> codes) {
        return codes.stream().map(code -> String.join((CharSequence)": ", OrganizationMigrateExternalCodesToV2Task.getSystemName(code), code.getCode())).collect(Collectors.joining(", "));
    }

    private ExternalSystemCodeV2 migrateExternalSystemCode(ExternalSystemCode oldSystemCode) {
        DictionaryReference<com.gridnine.xtrip.common.model.dict.ExternalSystem> externalSystemReference = OrganizationMigrateExternalCodesToV2Task.convertEnumToDictionaryReference(oldSystemCode.getSystem());
        if (externalSystemReference == null) {
            return null;
        }
        ExternalSystemCodeV2 newSystemCode = new ExternalSystemCodeV2();
        newSystemCode.setSystem(externalSystemReference);
        newSystemCode.setCode(oldSystemCode.getCode());
        return newSystemCode;
    }

    private static DictionaryReference<com.gridnine.xtrip.common.model.dict.ExternalSystem> convertEnumToDictionaryReference(ExternalSystem externalSystem) {
        com.gridnine.xtrip.common.model.dict.ExternalSystem cacheMatch = (com.gridnine.xtrip.common.model.dict.ExternalSystem)DictionaryCache.get().findByCode(com.gridnine.xtrip.common.model.dict.ExternalSystem.class, externalSystem.name());
        if (cacheMatch == null) {
            return null;
        }
        return new ExternalSystemReference(cacheMatch);
    }

    private static SearchResult<OrganizationIndex> findOrganizationsWithExternalCodes() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.isNotEmpty((String)OrganizationIndex.Property.externalCodes.name()));
        return EntityStorage.get().search(OrganizationIndex.class, query);
    }
}

