/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class PersonAuthorityLettersUpdateTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.PersonAuthorityLettersUpdateTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("person authority letters update started");
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.AGENT), SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.MANAGER), SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.CASHIER_ACCOUNTANT), SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.CASHIER_CLERK)}));
        Set personReferences = EntityStorage.get().search(PersonIndex.class, query).getData().stream().map(item -> item.getSource()).collect(Collectors.toSet());
        int count = personReferences.size();
        int n = 0;
        for (EntityReference personReference : personReferences) {
            EntityContainer personContainer;
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            byte progress = (byte)(100 * n / count);
            this.log.debug(String.format("processing person %s, %s of %s (%s%%)", personReference, String.valueOf(n), String.valueOf(count), String.valueOf(progress)));
            if (n % 10 == 0) {
                callback.updateProgress(progress);
            }
            if ((personContainer = EntityStorage.get().resolve(personReference)) == null) continue;
            Person person = (Person)personContainer.getEntity();
            boolean save = false;
            if (person.getAuthorityLetter() != null && person.getAuthorityLetters().size() == 0) {
                person.getAuthorityLetters().add(person.getAuthorityLetter());
                save = true;
            }
            if (!save) continue;
            personContainer.getVersionInfo().setDataSource("person-authority-letters-update-task");
            EntityStorage.get().save(personContainer, true);
        }
        callback.taskFinished();
        this.log.debug("person authority letters update finished");
    }
}

