/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCodeV2;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import org.w3c.dom.Element;

public class PersonExternalCodeUpdateTask
extends BaseLongRunningTask<Serializable> {
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.isNotEmpty((String)PersonIndex.Property.externalCode.name()));
        SearchResult searchResult = EntityStorage.get().search(PersonIndex.class, query);
        for (PersonIndex personIndex : searchResult.getData()) {
            Person person;
            EntityContainer personCtr = EntityStorage.get().resolve(personIndex.getSource());
            if (personCtr == null || !(person = (Person)personCtr.getEntity()).getExternalCodesV2().isEmpty()) continue;
            ExternalSystemCodeV2 externalCode = new ExternalSystemCodeV2();
            externalCode.setCode(person.getExternalCode());
            person.getExternalCodesV2().add(externalCode);
            personCtr.getVersionInfo().setDataSource("person-external-code-update-task");
            EntityStorage.get().save(personCtr, true);
        }
    }

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.PersonExternalCodeUpdateTask_description, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }
}

