/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.ProfileLocalizationTaskConfiguration;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Element;

public class PersonLocalizationUpdateTask
extends BaseLongRunningTask<ProfileLocalizationTaskConfiguration> {
    private ProfileLocalizationTaskConfiguration configuration;
    private final Set<String> toProceed = new LinkedHashSet<String>();

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.PersonLocalizationUpdateTask_updateLocalization, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        this.configuration = new ProfileLocalizationTaskConfiguration();
        this.configuration.fromXML(elm);
        for (Element element : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(element.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        this.configuration.toXML(elm);
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    @Override
    public void configure(ProfileLocalizationTaskConfiguration value) throws Exception {
        this.configuration = value;
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("person localization update started");
        Locale locale = this.configuration.getLocale();
        if (locale == null) {
            throw new IllegalStateException("Locale not defined");
        }
        this.updateUids();
        int count = this.toProceed.size();
        this.log.debug(String.format("uids updated, remains " + count, new Object[0]));
        int n = 0;
        Iterator<String> iterator = this.toProceed.iterator();
        while (iterator.hasNext()) {
            String item = iterator.next();
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            ++n;
            String personTitle = item;
            try {
                EntityContainer personContainer = EntityStorage.get().load(Person.class, item);
                if (personContainer != null) {
                    String middleNameValue;
                    String firstNameValue;
                    Person person = (Person)personContainer.getEntity();
                    personTitle = person.toString();
                    byte progress = (byte)(100 * n / count);
                    this.log.debug(String.format("processing person %s, %s of %s (%s%%)", personTitle, String.valueOf(n), String.valueOf(count), String.valueOf(progress)));
                    if (n % 10 == 0) {
                        callback.updateProgress(progress);
                    }
                    boolean save = false;
                    String lastNameValue = (String)person.getLastName().getValues().remove(Locale.ROOT);
                    if (lastNameValue != null) {
                        person.getLastName().getValues().put(locale, lastNameValue);
                        save = true;
                    }
                    if ((firstNameValue = (String)person.getFirstName().getValues().remove(Locale.ROOT)) != null) {
                        person.getFirstName().getValues().put(locale, firstNameValue);
                        save = true;
                    }
                    if ((middleNameValue = (String)person.getMiddleName().getValues().remove(Locale.ROOT)) != null) {
                        person.getMiddleName().getValues().put(locale, middleNameValue);
                        save = true;
                    }
                    for (Address address : person.getAddresses()) {
                        String flatValue;
                        String officeValue;
                        String pavilionValue;
                        String buildingValue;
                        String housingValue;
                        String houseValue;
                        String townValue;
                        String districtValue;
                        String addressValue = (String)address.getAddress().getValues().remove(Locale.ROOT);
                        if (addressValue != null) {
                            address.getAddress().getValues().put(locale, addressValue);
                            save = true;
                        }
                        if ((districtValue = (String)address.getDistrict().getValues().remove(Locale.ROOT)) != null) {
                            address.getDistrict().getValues().put(locale, districtValue);
                            save = true;
                        }
                        if ((townValue = (String)address.getTown().getValues().remove(Locale.ROOT)) != null) {
                            address.getTown().getValues().put(locale, townValue);
                            save = true;
                        }
                        if ((houseValue = (String)address.getHouse().getValues().remove(Locale.ROOT)) != null) {
                            address.getHouse().getValues().put(locale, houseValue);
                            save = true;
                        }
                        if ((housingValue = (String)address.getHousing().getValues().remove(Locale.ROOT)) != null) {
                            address.getHousing().getValues().put(locale, housingValue);
                            save = true;
                        }
                        if ((buildingValue = (String)address.getBuilding().getValues().remove(Locale.ROOT)) != null) {
                            address.getBuilding().getValues().put(locale, buildingValue);
                            save = true;
                        }
                        if ((pavilionValue = (String)address.getPavilion().getValues().remove(Locale.ROOT)) != null) {
                            address.getPavilion().getValues().put(locale, pavilionValue);
                            save = true;
                        }
                        if ((officeValue = (String)address.getOffice().getValues().remove(Locale.ROOT)) != null) {
                            address.getOffice().getValues().put(locale, officeValue);
                            save = true;
                        }
                        if ((flatValue = (String)address.getFlat().getValues().remove(Locale.ROOT)) == null) continue;
                        address.getFlat().getValues().put(locale, flatValue);
                        save = true;
                    }
                    if (save) {
                        personContainer.getVersionInfo().setDataSource("person-localization-update-task");
                        EntityStorage.get().save(personContainer, true);
                    }
                }
            }
            catch (Throwable e) {
                this.log.error(String.format("unable to update person localization %s", personTitle), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u043b\u043e\u043a\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043b\u0438\u0446\u0430 {0}", (Throwable)e, (Object[])new Object[]{personTitle}));
            }
            iterator.remove();
        }
        callback.taskFinished();
        this.log.debug("person localization update finished");
    }

    private void updateUids() throws Exception {
        if (!this.toProceed.isEmpty()) {
            return;
        }
        LogicalStorage storage = LogicalStorage.get();
        LogicalEntityStorage entityStorage = storage.getEntityStorage();
        List uids = entityStorage.getEntityUids(Person.class, null, null, true, true, SortOrder.DESC, null);
        this.toProceed.addAll(uids);
    }
}

