/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ExternalSystemReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.ExternalSystem;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCode;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCodeV2;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PersonMigrateExternalCodesToV2Task
extends BaseLongRunningTask<Serializable> {
    private final Logger logger = LoggerFactory.getLogger(PersonMigrateExternalCodesToV2Task.class);

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.logger.debug("Start executing PersonMigrateExternalCodesToV2Task");
        List<EntityContainer<Person>> persons = this.getPersonsWithExternalCodes();
        for (EntityContainer<Person> personCtr : persons) {
            Person person = (Person)personCtr.getEntity();
            this.logger.info(String.format("executing migration external system codes for person %s (%s)", personCtr.getUid(), person.getCode()));
            List externalCodes = person.getExternalCodes();
            List externalCodesV2 = person.getExternalCodesV2();
            ArrayList<ExternalSystemCodeV2> externalSystemCodeV2ToAdd = new ArrayList<ExternalSystemCodeV2>();
            for (ExternalSystemCode externalSystemCode : externalCodes) {
                ExternalSystemCodeV2 externalSystemCodeV2;
                ExternalSystemCodeV2 externalSystemCodeV22;
                if (TextUtil.isBlank((String)externalSystemCode.getCode()) || externalSystemCode.getSystem() == null && (externalSystemCodeV22 = (ExternalSystemCodeV2)externalCodesV2.stream().filter(item -> item.getSystem() == null && MiscUtil.equals((Object)item.getCode(), (Object)externalSystemCode.getCode())).findFirst().orElse(null)) != null) continue;
                DictionaryReference<com.gridnine.xtrip.common.model.dict.ExternalSystem> externalSystemReference = null;
                if (externalSystemCode.getSystem() != null) {
                    externalSystemCodeV2 = externalCodesV2.stream().filter(item -> item.getSystem() != null && MiscUtil.equals((Object)item.getSystem().getCode(), (Object)externalSystemCode.getSystem().name()) && MiscUtil.equals((Object)item.getCode(), (Object)externalSystemCode.getCode())).findFirst().orElse(null);
                    if (externalSystemCodeV2 != null) continue;
                    externalSystemReference = this.getExternalSystemReference(externalSystemCode.getSystem());
                }
                externalSystemCodeV2 = new ExternalSystemCodeV2();
                externalSystemCodeV2.setSystem(externalSystemReference);
                externalSystemCodeV2.setCode(externalSystemCode.getCode());
                externalSystemCodeV2ToAdd.add(externalSystemCodeV2);
            }
            externalCodesV2.addAll(externalSystemCodeV2ToAdd);
            try {
                if (externalSystemCodeV2ToAdd.isEmpty()) continue;
                personCtr.getVersionInfo().setDataSource("personMigrateExternalCodesToV2Task");
                EntityStorage.get().save(personCtr, true);
                this.logger.info(String.format("Migrated external system codes %s for person %s", externalSystemCodeV2ToAdd.stream().map(item -> String.format("%s (%s)", item.getCode(), item.getSystem())).collect(Collectors.joining(", ")), String.format("%s (%s)", person.getCode(), person.getUid())));
            }
            catch (Exception ex) {
                this.logger.warn(String.format("Unable to migrate external system codes for person %s", person.getCode()));
            }
        }
        callback.taskFinished();
        this.logger.debug("Finish executing PersonMigrateExternalCodesToV2Task");
    }

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.PersonMigrateExternalCodesToV2Task, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    private DictionaryReference<com.gridnine.xtrip.common.model.dict.ExternalSystem> getExternalSystemReference(ExternalSystem externalSystem) {
        com.gridnine.xtrip.common.model.dict.ExternalSystem externalSystemDict = (com.gridnine.xtrip.common.model.dict.ExternalSystem)DictionaryCache.get().findByCode(com.gridnine.xtrip.common.model.dict.ExternalSystem.class, externalSystem.name());
        if (externalSystemDict != null) {
            return new ExternalSystemReference(externalSystemDict);
        }
        try {
            com.gridnine.xtrip.common.model.dict.ExternalSystem newExternalSystemDict = new com.gridnine.xtrip.common.model.dict.ExternalSystem();
            newExternalSystemDict.setCode(externalSystem.name());
            newExternalSystemDict.setDataSource("PersonMigrateExternalCodesToV2Task");
            DictionaryStorage.get().save((BaseDictionary)newExternalSystemDict);
            return new ExternalSystemReference(newExternalSystemDict);
        }
        catch (Exception e) {
            this.logger.warn(String.format("Unable to save dictionary element ExternalSystem with code %s", externalSystem.name()));
            return null;
        }
    }

    private List<EntityContainer<Person>> getPersonsWithExternalCodes() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.isNotEmpty((String)PersonIndex.Property.externalCodes.name()));
        return EntityStorage.get().search(PersonIndex.class, query).getData().stream().map(index -> EntityStorage.get().resolve(index.getSource())).filter(Objects::nonNull).filter(person -> ((Person)person.getEntity()).getExternalCodes().stream().anyMatch(item -> TextUtil.nonBlank((String)item.getCode()))).collect(Collectors.toList());
    }
}

