/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.gracefulstop.ShutdownStatus;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.PersonalDataOrganizationSearchData;
import com.gridnine.xtrip.common.model.PersonalDataPersonSearchData;
import com.gridnine.xtrip.common.model.PersonalDataSearchResult;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataOrganizationRequest;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRequestStatus;
import com.gridnine.xtrip.common.model.personal.data.helper.PersonalDataHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;

public class PersonalDataErasureOrganizationSearchTask
extends BaseLongRunningTask<Serializable> {
    private EntityReference<PersonalDataOrganizationRequest> requestReference;

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.PersonalDataErasureOrganizationSearchTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element element) throws Exception {
        this.requestReference = (EntityReference)XHelper.readObject((Element)element, (String)"requestReference");
    }

    public void toXML(Element element) throws Exception {
        XHelper.writeObject((Element)element, (String)"requestReference", this.requestReference);
    }

    @Override
    public void configure(Serializable value) throws Exception {
        this.requestReference = (EntityReference)value;
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("personal data erasure organization search started");
        this.log.debug(String.format("request -> %s", this.requestReference));
        if (this.requestReference == null) {
            this.log.error("personal data erasure organization search failed -> request value missing");
            callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataErasureOrganizationSearchTask_searchFailed").details(L10nResourcesManager.getStr((String)"PersonalDataErasureOrganizationSearchTask_requestValueMissing", (Object[])new Object[0])).build());
            throw new Exception("request value missing");
        }
        callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataErasureOrganizationSearchTask_request").parameters(new Object[]{this.requestReference}).build());
        EntityContainer requestContainer = EntityStorage.get().resolve(this.requestReference);
        if (requestContainer == null) {
            this.log.error("personal data erasure organization search failed -> request load failed");
            callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataErasureOrganizationSearchTask_searchFailed").details(L10nResourcesManager.getStr((String)"PersonalDataErasureOrganizationSearchTask_requestLoadFailed", (Object[])new Object[0])).build());
            throw new Exception("request load failed");
        }
        PersonalDataOrganizationRequest request = (PersonalDataOrganizationRequest)requestContainer.getEntity();
        try {
            request.getSearchResults().clear();
            List<PersonalDataPersonSearchData> personSearchDatas = this.getPersonSearchDatas((EntityContainer<PersonalDataOrganizationRequest>)requestContainer, callback, 0, 5);
            this.searchPersons((EntityContainer<PersonalDataOrganizationRequest>)requestContainer, personSearchDatas, callback, 5, 10);
            this.searchBookingFiles((EntityContainer<PersonalDataOrganizationRequest>)requestContainer, personSearchDatas, callback, 10, 100);
            if (!this.isToBeStopped()) {
                this.handleDone((EntityContainer<PersonalDataOrganizationRequest>)requestContainer, callback);
                callback.taskFinished();
            }
        }
        catch (Exception e) {
            this.handleError((EntityContainer<PersonalDataOrganizationRequest>)requestContainer, callback, e);
            throw new Exception("search failed");
        }
        this.log.debug("personal data erasure organization search finished");
    }

    private List<PersonalDataPersonSearchData> getPersonSearchDatas(EntityContainer<PersonalDataOrganizationRequest> requestContainer, LongRunningTask.EventsCallback callback, int progressStart, int progressEnd) throws Exception {
        PersonalDataOrganizationRequest request = (PersonalDataOrganizationRequest)requestContainer.getEntity();
        ArrayList<PersonalDataPersonSearchData> personSearchDatas = new ArrayList<PersonalDataPersonSearchData>();
        List personReferences = request.getSearchData().getPersons().stream().filter(item -> item.isSearch()).map(item -> item.getPerson()).collect(Collectors.toList());
        this.log.debug("personal data erasure organization search person references -> " + personReferences.size());
        int count = 0;
        for (EntityReference personReference : personReferences) {
            PersonalDataPersonSearchData personSearchData;
            if (this.isToBeStopped()) {
                this.handleInterrupt(requestContainer, callback);
                return personSearchDatas;
            }
            this.handleProgress(callback, progressStart, progressEnd, count, personReferences.size());
            Person person = Optional.ofNullable(EntityStorage.get().resolve(personReference)).map(item -> (Person)item.getEntity()).orElse(null);
            if (person != null && (personSearchData = PersonalDataHelper.getPersonSearchData((EntityReference)personReference, (Person)person)).getNames().size() != 0 && personSearchData.getPassports().size() != 0) {
                personSearchDatas.add(personSearchData);
            }
            ++count;
        }
        this.log.debug("personal data erasure organization search person search datas -> " + personSearchDatas.size());
        return personSearchDatas;
    }

    private void searchPersons(EntityContainer<PersonalDataOrganizationRequest> requestContainer, List<PersonalDataPersonSearchData> personSearchDatas, LongRunningTask.EventsCallback callback, int progressStart, int progressEnd) throws Exception {
        int count = 0;
        for (PersonalDataPersonSearchData personSearchData : personSearchDatas) {
            if (this.isToBeStopped()) {
                this.handleInterrupt(requestContainer, callback);
                return;
            }
            this.handleProgress(callback, progressStart, progressEnd, count, personSearchDatas.size());
            SearchQuery query = new SearchQuery();
            if (personSearchData.getPerson() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)personSearchData.getPerson().getUid()));
            } else {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])personSearchData.getNames().stream().flatMap(item -> Stream.of(item.getFirstName(), item.getLastName())).map(item -> SearchCriterion.ilike((String)PersonIndex.Property.name.name(), (String)String.format("%%%s%%", item))).toArray(SearchCriterion[]::new))));
            }
            Set personReferences = EntityStorage.get().search(PersonIndex.class, query).getData().stream().map(item -> item.getSource()).collect(Collectors.toSet());
            this.log.debug("personal data erasure organization search persons found -> " + personReferences.size());
            for (EntityReference personReference : personReferences) {
                EntityContainer personContainer = EntityStorage.get().resolve(personReference);
                if (personContainer != null) {
                    this.searchPerson(requestContainer, (EntityContainer<Person>)personContainer, personSearchData);
                }
                ++count;
            }
        }
    }

    private void searchBookingFiles(EntityContainer<PersonalDataOrganizationRequest> requestContainer, List<PersonalDataPersonSearchData> personSearchDatas, LongRunningTask.EventsCallback callback, int progressStart, int progressEnd) throws Exception {
        EntityReference retailClient;
        PersonalDataOrganizationRequest request = (PersonalDataOrganizationRequest)requestContainer.getEntity();
        PersonalDataOrganizationSearchData organizationSearchData = request.getSearchData();
        SearchQuery query = new SearchQuery();
        ArrayList<EntityReference> clients = new ArrayList<EntityReference>();
        clients.clear();
        if (organizationSearchData.getOrganization() != null) {
            clients.add(organizationSearchData.getOrganization());
        }
        if ((retailClient = (EntityReference)Optional.ofNullable(ProfileHelper.getRetailProfileContainer()).map(item -> item.toReference()).orElse(null)) != null) {
            clients.add(retailClient);
        }
        clients.add(null);
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])clients.stream().map(item -> SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), (Object)item)).toArray(SearchCriterion[]::new))));
        Set bookingFileReferences = EntityStorage.get().search(BookingFileIndex.class, query).getData().stream().map(item -> item.getSource()).collect(Collectors.toSet());
        this.log.debug("personal data erasure organization search booking files found -> " + bookingFileReferences.size());
        int count = 0;
        for (EntityReference bookingFileReference : bookingFileReferences) {
            if (this.isToBeStopped()) {
                this.handleInterrupt(requestContainer, callback);
                return;
            }
            this.handleProgress(callback, progressStart, progressEnd, count, bookingFileReferences.size());
            EntityContainer bookingFileContainer = EntityStorage.get().resolve(bookingFileReference);
            if (bookingFileContainer != null) {
                for (PersonalDataPersonSearchData personSearchData : personSearchDatas) {
                    this.searchBookingFile(requestContainer, (EntityContainer<BookingFile>)bookingFileContainer, personSearchData);
                }
            }
            ++count;
        }
    }

    private void searchPerson(EntityContainer<PersonalDataOrganizationRequest> requestContainer, EntityContainer<Person> personContainer, PersonalDataPersonSearchData personSearchData) {
        PersonalDataOrganizationRequest request = (PersonalDataOrganizationRequest)requestContainer.getEntity();
        Person person = (Person)personContainer.getEntity();
        List searchResultItems = PersonalDataHelper.getPersonSearchResultItems((PersonalDataPersonSearchData)personSearchData, (Person)person);
        if (searchResultItems.stream().anyMatch(item -> item.getExpected() != null && item.getActual() != null)) {
            PersonalDataSearchResult searchResult = new PersonalDataSearchResult();
            searchResult.setEntity(personContainer.toReference());
            searchResult.setProcess(true);
            searchResult.getItems().clear();
            searchResult.getItems().addAll(searchResultItems);
            request.getSearchResults().add(searchResult);
        }
    }

    private void searchBookingFile(EntityContainer<PersonalDataOrganizationRequest> requestContainer, EntityContainer<BookingFile> bookingFileContainer, PersonalDataPersonSearchData personSearchData) {
        List searchResultItems;
        PersonalDataOrganizationRequest request = (PersonalDataOrganizationRequest)requestContainer.getEntity();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        for (Traveller traveller : bookingFile.getTravellers()) {
            List searchResultItems2 = PersonalDataHelper.getTravellerSearchResultItems((PersonalDataPersonSearchData)personSearchData, (Traveller)traveller);
            if (!searchResultItems2.stream().anyMatch(item -> item.getExpected() != null && item.getActual() != null)) continue;
            PersonalDataSearchResult searchResult = new PersonalDataSearchResult();
            searchResult.setEntity((EntityReference)new NestedEntityReference(bookingFileContainer, (BaseEntity)traveller, String.format("%s / %s", bookingFile.getNumber(), traveller.getName())));
            searchResult.setProcess(true);
            searchResult.getItems().clear();
            searchResult.getItems().addAll(searchResultItems2);
            request.getSearchResults().add(searchResult);
        }
        Customer customer = bookingFile.getCustomer();
        if (customer != null && (searchResultItems = PersonalDataHelper.getCustomerSearchResultItems((PersonalDataPersonSearchData)personSearchData, (Customer)customer)).stream().anyMatch(item -> item.getExpected() != null && item.getActual() != null)) {
            PersonalDataSearchResult searchResult = new PersonalDataSearchResult();
            searchResult.setEntity((EntityReference)new NestedEntityReference(bookingFileContainer, (BaseEntity)customer, String.format("%s / %s", bookingFile.getNumber(), customer.getName())));
            searchResult.setProcess(true);
            searchResult.getItems().clear();
            searchResult.getItems().addAll(searchResultItems);
            request.getSearchResults().add(searchResult);
        }
    }

    private void handleInterrupt(EntityContainer<PersonalDataOrganizationRequest> requestContainer, LongRunningTask.EventsCallback callback) throws Exception {
        boolean shutdown = ShutdownStatus.isShutdown();
        if (!shutdown) {
            PersonalDataOrganizationRequest request = (PersonalDataOrganizationRequest)requestContainer.getEntity();
            LockUtil.lock((EntityReference)requestContainer.toReference(), updatedRequestContainer -> {
                if (updatedRequestContainer != null) {
                    PersonalDataOrganizationRequest updatedRequest = (PersonalDataOrganizationRequest)updatedRequestContainer.getEntity();
                    updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                    updatedRequest.setStatus(PersonalDataRequestStatus.SEARCH_INTERRUPTED);
                    updatedRequestContainer.getVersionInfo().setDataSource("search-interrupted");
                    EntityStorage.get().save(updatedRequestContainer, true);
                    this.log.debug("personal data erasure organization search interrupted -> " + shutdown);
                    callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataErasureOrganizationSearchTask_searchInterrupted").build());
                }
            });
        }
    }

    private void handleError(EntityContainer<PersonalDataOrganizationRequest> requestContainer, LongRunningTask.EventsCallback callback, Exception e) throws Exception {
        PersonalDataOrganizationRequest request = (PersonalDataOrganizationRequest)requestContainer.getEntity();
        LockUtil.lock((EntityReference)requestContainer.toReference(), updatedRequestContainer -> {
            if (updatedRequestContainer != null) {
                PersonalDataOrganizationRequest updatedRequest = (PersonalDataOrganizationRequest)updatedRequestContainer.getEntity();
                updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                updatedRequest.setStatus(PersonalDataRequestStatus.SEARCH_FAILED);
                updatedRequestContainer.getVersionInfo().setDataSource("search-failed");
                EntityStorage.get().save(updatedRequestContainer, true);
                this.log.error("personal data erasure organization search failed", (Throwable)e);
                callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataErasureOrganizationSearchTask_searchFailed").error((Throwable)e).build());
            }
        });
    }

    private void handleDone(EntityContainer<PersonalDataOrganizationRequest> requestContainer, LongRunningTask.EventsCallback callback) throws Exception {
        PersonalDataOrganizationRequest request = (PersonalDataOrganizationRequest)requestContainer.getEntity();
        LockUtil.lock(this.requestReference, updatedRequestContainer -> {
            if (updatedRequestContainer != null) {
                PersonalDataOrganizationRequest updatedRequest = (PersonalDataOrganizationRequest)updatedRequestContainer.getEntity();
                updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                updatedRequest.setStatus(PersonalDataRequestStatus.SEARCH_DONE);
                updatedRequestContainer.getVersionInfo().setDataSource("search-done");
                EntityStorage.get().save(updatedRequestContainer, true);
                this.log.debug("personal data erasure organization search done");
                callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataErasureOrganizationSearchTask_searchDone").build());
            }
        });
    }

    private void handleProgress(LongRunningTask.EventsCallback callback, int progressStart, int progressEnd, int count, int total) {
        byte progress = (byte)(progressStart + (progressEnd - progressStart) * count / total);
        this.log.debug("personal data erasure organization search progress -> " + progress);
        callback.updateProgress(progress);
    }
}

