/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.gracefulstop.ShutdownStatus;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.PersonalDataSearchResult;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.AnonymizationHandler;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataPersonRequest;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRequestStatus;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;

public class PersonalDataErasurePersonProcessTask
extends BaseLongRunningTask<Serializable> {
    private EntityReference<PersonalDataPersonRequest> requestReference;

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.PersonalDataErasurePersonProcessTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element element) throws Exception {
        this.requestReference = (EntityReference)XHelper.readObject((Element)element, (String)"requestReference");
    }

    public void toXML(Element element) throws Exception {
        XHelper.writeObject((Element)element, (String)"requestReference", this.requestReference);
    }

    @Override
    public void configure(Serializable value) throws Exception {
        this.requestReference = (EntityReference)value;
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("personal data erasure person process started");
        this.log.debug(String.format("request -> %s", this.requestReference));
        if (this.requestReference == null) {
            this.log.error("personal data erasure person process failed -> request value missing");
            callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataErasurePersonProcessTask_processFailed").details(L10nResourcesManager.getStr((String)"PersonalDataErasurePersonProcessTask_requestValueMissing", (Object[])new Object[0])).build());
            throw new Exception("request value missing");
        }
        callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataErasurePersonProcessTask_request").parameters(new Object[]{this.requestReference}).build());
        EntityContainer requestContainer = EntityStorage.get().resolve(this.requestReference);
        if (requestContainer == null) {
            this.log.error("personal data erasure person process failed -> request load failed");
            callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataErasurePersonProcessTask_processFailed").details(L10nResourcesManager.getStr((String)"PersonalDataErasurePersonProcessTask_requestLoadFailed", (Object[])new Object[0])).build());
            throw new Exception("request load failed");
        }
        try {
            this.process((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback, 0, 100);
            if (!this.isToBeStopped()) {
                this.handleDone((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback);
                callback.taskFinished();
            }
        }
        catch (Exception e) {
            this.handleError((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback, e);
            throw new Exception("process failed");
        }
        this.log.debug("personal data erasure person process finished");
    }

    private void process(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback, int progressStart, int progressEnd) throws Exception {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        LinkedHashMap totalEntityReferencesBatches = request.getSearchResults().stream().filter(item -> item.isProcess()).collect(Collectors.groupingBy(item -> new EntityReference(item.getEntity().getUid(), item.getEntity().getType(), null), () -> new LinkedHashMap(), Collectors.toList()));
        LinkedHashMap entityReferencesBatches = request.getSearchResults().stream().filter(item -> item.isProcess() && !item.isProcessed()).collect(Collectors.groupingBy(item -> new EntityReference(item.getEntity().getUid(), item.getEntity().getType(), null), () -> new LinkedHashMap(), Collectors.toList()));
        int totalCount = totalEntityReferencesBatches.size();
        int count = totalCount - entityReferencesBatches.size();
        this.log.debug("personal data erasure person process entities -> " + entityReferencesBatches.size());
        Iterator iterator = entityReferencesBatches.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entityReferencesBatch = iterator.next();
            EntityReference ownerReference = (EntityReference)entityReferencesBatch.getKey();
            List searchResults = (List)entityReferencesBatch.getValue();
            if (this.isToBeStopped()) {
                this.handleInterrupt(requestContainer, callback);
                return;
            }
            this.log.debug("personal data erasure person process entity -> " + count + " of " + totalCount);
            this.handleProgress(callback, progressStart, progressEnd, count, totalCount);
            LockUtil.lock((String)LockUtil.getLockKey((EntityReference)ownerReference), () -> {
                List versionNumbers = LogicalStorage.get().getEntityStorage().getVersionInfos(ownerReference).stream().map(item -> item.getVersionNumber()).collect(Collectors.toList());
                for (Integer versionNumber : versionNumbers) {
                    EntityContainer ownerContainer = EntityStorage.get().load(ownerReference.getType(), ownerReference.getUid(), versionNumber);
                    if (ownerContainer == null) continue;
                    BaseEntity owner = ownerContainer.getEntity();
                    for (PersonalDataSearchResult searchResult : searchResults) {
                        EntityReference entityReference = searchResult.getEntity();
                        if (entityReference instanceof NestedEntityReference) {
                            BaseEntity entity = EntityStorageHelper.findNestedEntity((BaseEntity)ownerContainer.getEntity(), (NestedEntityReference)((NestedEntityReference)entityReference));
                            if (entity == null) continue;
                            AnonymizationHandler.of((BaseEntity)entity).anonymize(entity);
                            continue;
                        }
                        AnonymizationHandler.of((BaseEntity)owner).anonymize(owner);
                    }
                    ownerContainer.getVersionInfo().setVersionNotes(Stream.of(ownerContainer.getVersionInfo().getVersionNotes(), String.format("gdpr-request-%s-%s", request.getType().name().toLowerCase().replace("_", "-"), request.getNumber())).filter(item -> !TextUtil.isBlank((String)item)).collect(Collectors.joining(" + ")));
                    EntityStorage.get().save(ownerContainer, false);
                }
                searchResults.stream().forEach(item -> item.setProcessed(true));
            });
            iterator.remove();
            ++count;
        }
    }

    private void handleInterrupt(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback) throws Exception {
        boolean shutdown = ShutdownStatus.isShutdown();
        if (!shutdown) {
            PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
            LockUtil.lock((EntityReference)requestContainer.toReference(), updatedRequestContainer -> {
                if (updatedRequestContainer != null) {
                    PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                    updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                    updatedRequest.setStatus(PersonalDataRequestStatus.PROCESS_INTERRUPTED);
                    updatedRequestContainer.getVersionInfo().setDataSource("process-interrupted");
                    EntityStorage.get().save(updatedRequestContainer, true);
                    this.log.debug("personal data erasure person process interrupted -> " + shutdown);
                    callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataErasurePersonProcessTask_processInterrupted").build());
                }
            });
        }
    }

    private void handleError(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback, Exception e) throws Exception {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        LockUtil.lock((EntityReference)requestContainer.toReference(), updatedRequestContainer -> {
            if (updatedRequestContainer != null) {
                PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                updatedRequest.setStatus(PersonalDataRequestStatus.PROCESS_FAILED);
                updatedRequestContainer.getVersionInfo().setDataSource("process-failed");
                EntityStorage.get().save(updatedRequestContainer, true);
                this.log.error("personal data erasure person process failed", (Throwable)e);
                callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataErasurePersonProcessTask_processFailed").error((Throwable)e).build());
            }
        });
    }

    private void handleDone(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback) throws Exception {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        LockUtil.lock(this.requestReference, updatedRequestContainer -> {
            if (updatedRequestContainer != null) {
                PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                updatedRequest.setStatus(PersonalDataRequestStatus.PROCESS_DONE);
                updatedRequestContainer.getVersionInfo().setDataSource("process-done");
                EntityStorage.get().save(updatedRequestContainer, true);
                this.log.debug("personal data erasure person process done");
                callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataErasurePersonProcessTask_processDone").build());
            }
        });
    }

    private void handleProgress(LongRunningTask.EventsCallback callback, int progressStart, int progressEnd, int count, int total) {
        byte progress = (byte)(progressStart + (progressEnd - progressStart) * count / total);
        this.log.debug("personal data erasure person process progress -> " + progress);
        callback.updateProgress(progress);
    }
}

