/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.gracefulstop.ShutdownStatus;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.PersonalDataPersonSearchData;
import com.gridnine.xtrip.common.model.PersonalDataSearchResult;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataPersonRequest;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRequestStatus;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRestrictedEntityData;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRestrictedEntityDataIndex;
import com.gridnine.xtrip.common.model.personal.data.helper.PersonalDataHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;

public class PersonalDataErasurePersonSearchTask
extends BaseLongRunningTask<Serializable> {
    private EntityReference<PersonalDataPersonRequest> requestReference;

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.PersonalDataErasurePersonSearchTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element element) throws Exception {
        this.requestReference = (EntityReference)XHelper.readObject((Element)element, (String)"requestReference");
    }

    public void toXML(Element element) throws Exception {
        XHelper.writeObject((Element)element, (String)"requestReference", this.requestReference);
    }

    @Override
    public void configure(Serializable value) throws Exception {
        this.requestReference = (EntityReference)value;
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("personal data erasure person search started");
        this.log.debug(String.format("request -> %s", this.requestReference));
        if (this.requestReference == null) {
            this.log.error("personal data erasure person search failed -> request value missing");
            callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataErasurePersonSearchTask_searchFailed").details(L10nResourcesManager.getStr((String)"PersonalDataErasurePersonSearchTask_requestValueMissing", (Object[])new Object[0])).build());
            throw new Exception("request value missing");
        }
        callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataErasurePersonSearchTask_request").parameters(new Object[]{this.requestReference}).build());
        EntityContainer requestContainer = EntityStorage.get().resolve(this.requestReference);
        if (requestContainer == null) {
            this.log.error("personal data erasure person search failed -> request load failed");
            callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataErasurePersonSearchTask_searchFailed").details(L10nResourcesManager.getStr((String)"PersonalDataErasurePersonSearchTask_requestLoadFailed", (Object[])new Object[0])).build());
            throw new Exception("request load failed");
        }
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        try {
            request.getSearchResults().clear();
            this.searchPersons((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback, 0, 5);
            this.searchRestricted((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback, 5, 10);
            this.searchBookingFiles((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback, 10, 100);
            if (!this.isToBeStopped()) {
                this.handleDone((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback);
                callback.taskFinished();
            }
        }
        catch (Exception e) {
            this.handleError((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback, e);
            throw new Exception("search failed");
        }
        this.log.debug("personal data erasure person search finished");
    }

    private void searchPersons(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback, int progressStart, int progressEnd) throws Exception {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        PersonalDataPersonSearchData searchData = request.getSearchData();
        SearchQuery query = new SearchQuery();
        if (searchData.getPerson() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)searchData.getPerson().getUid()));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])searchData.getNames().stream().flatMap(item -> Stream.of(item.getFirstName(), item.getLastName())).map(item -> SearchCriterion.ilike((String)PersonIndex.Property.name.name(), (String)String.format("%%%s%%", item))).toArray(SearchCriterion[]::new))));
        }
        Set personReferences = EntityStorage.get().search(PersonIndex.class, query).getData().stream().map(item -> item.getSource()).collect(Collectors.toSet());
        this.log.debug("personal data erasure person search persons found -> " + personReferences.size());
        int count = 0;
        for (EntityReference personReference : personReferences) {
            if (this.isToBeStopped()) {
                this.handleInterrupt(requestContainer, callback);
                return;
            }
            this.handleProgress(callback, progressStart, progressEnd, count, personReferences.size());
            EntityContainer personContainer = EntityStorage.get().resolve(personReference);
            if (personContainer != null) {
                this.searchPerson(requestContainer, (EntityContainer<Person>)personContainer);
            }
            ++count;
        }
    }

    private void searchBookingFiles(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback, int progressStart, int progressEnd) throws Exception {
        EntityReference retailClient;
        EntityContainer personContainer;
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        PersonalDataPersonSearchData searchData = request.getSearchData();
        SearchQuery query = new SearchQuery();
        ArrayList<EntityReference> clients = new ArrayList<EntityReference>();
        clients.clear();
        if (searchData.getPerson() != null && (personContainer = EntityStorage.get().resolve(searchData.getPerson())) != null) {
            Person person = (Person)personContainer.getEntity();
            clients.addAll(person.getEmployments().stream().map(item -> item.getOrganization()).filter(item -> item != null).collect(Collectors.toSet()));
        }
        if ((retailClient = (EntityReference)Optional.ofNullable(ProfileHelper.getRetailProfileContainer()).map(item -> item.toReference()).orElse(null)) != null) {
            clients.add(retailClient);
        }
        clients.add(null);
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])clients.stream().map(item -> SearchCriterion.eq((String)BookingFileIndex.Property.client.name(), (Object)item)).toArray(SearchCriterion[]::new))));
        Set bookingFileReferences = EntityStorage.get().search(BookingFileIndex.class, query).getData().stream().map(item -> item.getSource()).collect(Collectors.toSet());
        this.log.debug("personal data erasure person search booking files found -> " + bookingFileReferences.size());
        int count = 0;
        for (EntityReference bookingFileReference : bookingFileReferences) {
            if (this.isToBeStopped()) {
                this.handleInterrupt(requestContainer, callback);
                return;
            }
            this.handleProgress(callback, progressStart, progressEnd, count, bookingFileReferences.size());
            EntityContainer bookingFileContainer = EntityStorage.get().resolve(bookingFileReference);
            if (bookingFileContainer != null) {
                this.searchBookingFile(requestContainer, (EntityContainer<BookingFile>)bookingFileContainer);
            }
            ++count;
        }
    }

    private void searchRestricted(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback, int progressStart, int progressEnd) throws Exception {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        PersonalDataPersonSearchData searchData = request.getSearchData();
        SearchQuery query = new SearchQuery();
        if (searchData.getPerson() != null) {
            EntityContainer etc = EntityStorage.get().resolve(searchData.getPerson());
            if (etc != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonalDataRestrictedEntityDataIndex.Property.origin.name(), (Object)new NestedEntityReference(etc, etc.getEntity())));
            }
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])searchData.getNames().stream().flatMap(item -> Stream.of(item.getFirstName(), item.getLastName())).map(item -> SearchCriterion.ilike((String)PersonalDataRestrictedEntityDataIndex.Property.name.name(), (String)String.format("%%%s%%", item))).toArray(SearchCriterion[]::new))));
        }
        Set restrictedDataReferences = EntityStorage.get().search(PersonalDataRestrictedEntityDataIndex.class, query).getData().stream().map(PersonalDataRestrictedEntityDataIndex::getSource).collect(Collectors.toSet());
        this.log.debug("personal data erasure restricted data found -> " + restrictedDataReferences.size());
        int count = 0;
        for (EntityReference ref : restrictedDataReferences) {
            if (this.isToBeStopped()) {
                this.handleInterrupt(requestContainer, callback);
                return;
            }
            this.handleProgress(callback, progressStart, progressEnd, count, restrictedDataReferences.size());
            EntityContainer etc = EntityStorage.get().resolve(ref);
            if (etc != null) {
                this.searchRestricted(requestContainer, (EntityContainer<PersonalDataRestrictedEntityData>)etc);
            }
            ++count;
        }
    }

    private void searchPerson(EntityContainer<PersonalDataPersonRequest> requestContainer, EntityContainer<Person> personContainer) {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        Person person = (Person)personContainer.getEntity();
        PersonalDataPersonSearchData searchData = request.getSearchData();
        List searchResultItems = PersonalDataHelper.getPersonSearchResultItems((PersonalDataPersonSearchData)searchData, (Person)person);
        if (searchResultItems.stream().anyMatch(item -> item.getExpected() != null && item.getActual() != null)) {
            PersonalDataSearchResult searchResult = new PersonalDataSearchResult();
            searchResult.setEntity(personContainer.toReference());
            searchResult.setProcess(true);
            searchResult.getItems().clear();
            searchResult.getItems().addAll(searchResultItems);
            request.getSearchResults().add(searchResult);
        }
    }

    private void searchBookingFile(EntityContainer<PersonalDataPersonRequest> requestContainer, EntityContainer<BookingFile> bookingFileContainer) {
        List searchResultItems;
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        PersonalDataPersonSearchData searchData = request.getSearchData();
        for (Traveller traveller : bookingFile.getTravellers()) {
            List searchResultItems2 = PersonalDataHelper.getTravellerSearchResultItems((PersonalDataPersonSearchData)searchData, (Traveller)traveller);
            if (!searchResultItems2.stream().anyMatch(item -> item.getExpected() != null && item.getActual() != null)) continue;
            PersonalDataSearchResult searchResult = new PersonalDataSearchResult();
            searchResult.setEntity((EntityReference)new NestedEntityReference(bookingFileContainer, (BaseEntity)traveller, String.format("%s / %s", bookingFile.getNumber(), traveller.getName())));
            searchResult.setProcess(true);
            searchResult.getItems().clear();
            searchResult.getItems().addAll(searchResultItems2);
            request.getSearchResults().add(searchResult);
        }
        Customer customer = bookingFile.getCustomer();
        if (customer != null && (searchResultItems = PersonalDataHelper.getCustomerSearchResultItems((PersonalDataPersonSearchData)searchData, (Customer)customer)).stream().anyMatch(item -> item.getExpected() != null && item.getActual() != null)) {
            PersonalDataSearchResult searchResult = new PersonalDataSearchResult();
            searchResult.setEntity((EntityReference)new NestedEntityReference(bookingFileContainer, (BaseEntity)customer, String.format("%s / %s", bookingFile.getNumber(), customer.getName())));
            searchResult.setProcess(true);
            searchResult.getItems().clear();
            searchResult.getItems().addAll(searchResultItems);
            request.getSearchResults().add(searchResult);
        }
    }

    private void searchRestricted(EntityContainer<PersonalDataPersonRequest> requestContainer, EntityContainer<PersonalDataRestrictedEntityData> restrictedContainer) throws Exception {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        PersonalDataRestrictedEntityData restricted = (PersonalDataRestrictedEntityData)restrictedContainer.getEntity();
        BaseEntity restrictedEntity = restricted.getEntity();
        PersonalDataPersonSearchData searchData = request.getSearchData();
        List searchResultItems = new ArrayList();
        if (restrictedEntity instanceof Person) {
            searchResultItems = PersonalDataHelper.getPersonSearchResultItems((PersonalDataPersonSearchData)searchData, (Person)((Person)restrictedEntity));
        } else if (restrictedEntity instanceof Traveller) {
            searchResultItems = PersonalDataHelper.getTravellerSearchResultItems((PersonalDataPersonSearchData)searchData, (Traveller)((Traveller)restrictedEntity));
        } else if (restrictedEntity instanceof Customer) {
            searchResultItems = PersonalDataHelper.getCustomerSearchResultItems((PersonalDataPersonSearchData)searchData, (Customer)((Customer)restrictedEntity));
        } else {
            throw new IllegalAccessException("Type not supported: " + restrictedEntity.getClass().getName());
        }
        if (searchResultItems.stream().anyMatch(item -> item.getExpected() != null && item.getActual() != null)) {
            PersonalDataSearchResult searchResult = new PersonalDataSearchResult();
            searchResult.setEntity(restrictedContainer.toReference());
            searchResult.setProcess(true);
            searchResult.getItems().clear();
            searchResult.getItems().addAll(searchResultItems);
            request.getSearchResults().add(searchResult);
        }
    }

    private void handleInterrupt(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback) throws Exception {
        boolean shutdown = ShutdownStatus.isShutdown();
        if (!shutdown) {
            PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
            LockUtil.lock((EntityReference)requestContainer.toReference(), updatedRequestContainer -> {
                if (updatedRequestContainer != null) {
                    PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                    updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                    updatedRequest.setStatus(PersonalDataRequestStatus.SEARCH_INTERRUPTED);
                    updatedRequestContainer.getVersionInfo().setDataSource("search-interrupted");
                    EntityStorage.get().save(updatedRequestContainer, true);
                    this.log.debug("personal data erasure person search interrupted -> " + shutdown);
                    callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataErasurePersonSearchTask_searchInterrupted").build());
                }
            });
        }
    }

    private void handleError(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback, Exception e) throws Exception {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        LockUtil.lock((EntityReference)requestContainer.toReference(), updatedRequestContainer -> {
            if (updatedRequestContainer != null) {
                PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                updatedRequest.setStatus(PersonalDataRequestStatus.SEARCH_FAILED);
                updatedRequestContainer.getVersionInfo().setDataSource("search-failed");
                EntityStorage.get().save(updatedRequestContainer, true);
                this.log.error("personal data erasure person search failed", (Throwable)e);
                callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataErasurePersonSearchTask_searchFailed").error((Throwable)e).build());
            }
        });
    }

    private void handleDone(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback) throws Exception {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        LockUtil.lock(this.requestReference, updatedRequestContainer -> {
            if (updatedRequestContainer != null) {
                PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                updatedRequest.setStatus(PersonalDataRequestStatus.SEARCH_DONE);
                updatedRequestContainer.getVersionInfo().setDataSource("search-done");
                EntityStorage.get().save(updatedRequestContainer, true);
                this.log.debug("personal data erasure person search done");
                callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataErasurePersonSearchTask_searchDone").build());
            }
        });
    }

    private void handleProgress(LongRunningTask.EventsCallback callback, int progressStart, int progressEnd, int count, int total) {
        byte progress = (byte)(progressStart + (progressEnd - progressStart) * count / total);
        this.log.debug("personal data erasure person search progress -> " + progress);
        callback.updateProgress(progress);
    }
}

