/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.gracefulstop.ShutdownStatus;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.AnonymizationHandler;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataPersonRequest;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRequestStatus;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRestrictedEntityData;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRestrictedEntityDataIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;

public class PersonalDataRestrictionPersonRestoreTask
extends BaseLongRunningTask<Serializable> {
    private EntityReference<PersonalDataPersonRequest> requestReference;

    public void fromXML(Element element) throws Exception {
        this.requestReference = (EntityReference)XHelper.readObject((Element)element, (String)"requestReference");
    }

    public void toXML(Element element) throws Exception {
        XHelper.writeObject((Element)element, (String)"requestReference", this.requestReference);
    }

    @Override
    public void configure(Serializable value) throws Exception {
        this.requestReference = (EntityReference)value;
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    public L10nMessage getDescription() {
        return null;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("personal data restriction person restoration started");
        this.log.debug(String.format("request -> %s", this.requestReference));
        if (this.requestReference == null) {
            this.log.error("personal data restriction person restoration failed -> request value missing");
            callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataRestrictionPersonRestoreTask_restoreFailed").details(L10nResourcesManager.getStr((String)"PersonalDataRestrictionPersonProcessTask_requestValueMissing", (Object[])new Object[0])).build());
            throw new Exception("request value missing");
        }
        callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataRestrictionPersonProcessTask_request").parameters(new Object[]{this.requestReference}).build());
        EntityContainer requestContainer = EntityStorage.get().resolve(this.requestReference);
        if (requestContainer == null) {
            this.log.error("personal data restriction person restoration failed -> request load failed");
            callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataRestrictionPersonRestoreTask_restoreFailed").details(L10nResourcesManager.getStr((String)"PersonalDataRestrictionPersonProcessTask_requestLoadFailed", (Object[])new Object[0])).build());
            throw new Exception("request load failed");
        }
        try {
            this.process((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback, 0, 10);
            if (!this.isToBeStopped()) {
                this.handleDone((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback);
                callback.taskFinished();
            }
        }
        catch (Exception e) {
            this.handleError((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback, e);
            throw new Exception("process failed");
        }
        this.log.debug("personal data restriction person process finished");
    }

    private void process(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback, int progressStart, int progressEnd) throws Exception {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        LinkedHashMap totalEntityReferencesBatches = request.getSearchResults().stream().filter(item -> item.isProcess()).collect(Collectors.groupingBy(item -> new EntityReference(item.getEntity().getUid(), item.getEntity().getType(), null), () -> new LinkedHashMap(), Collectors.toList()));
        LinkedHashMap entityReferencesBatches = request.getSearchResults().stream().filter(item -> item.isProcess() && item.isProcessed()).collect(Collectors.groupingBy(item -> new EntityReference(item.getEntity().getUid(), item.getEntity().getType(), null), () -> new LinkedHashMap(), Collectors.toList()));
        int totalCount = totalEntityReferencesBatches.size();
        int count = totalCount - entityReferencesBatches.size();
        this.log.debug("personal data restriction person restore entities -> " + entityReferencesBatches.size());
        Iterator iterator = entityReferencesBatches.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entityReferencesBatch = iterator.next();
            EntityReference ownerReference = (EntityReference)entityReferencesBatch.getKey();
            if (this.isToBeStopped()) {
                this.handleInterrupt(requestContainer, callback);
                return;
            }
            this.log.debug("personal data restriction person process entity -> " + count + " of " + totalCount);
            this.handleProgress(callback, progressStart, progressEnd, count, totalCount);
            LockUtil.lock((String)LockUtil.getLockKey((EntityReference)ownerReference), () -> {
                EntityContainer restrictedDataCtr;
                EntityContainer ownerContainer = EntityStorage.get().resolve(ownerReference);
                if (ownerContainer == null) {
                    throw new Exception("restricted profile can not be loaded");
                }
                BaseEntity owner = ownerContainer.getEntity();
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonalDataRestrictedEntityDataIndex.Property.origin.name(), (Object)new NestedEntityReference(ownerContainer, owner)));
                List restrictedDataSearchResult = EntityStorage.get().search(PersonalDataRestrictedEntityDataIndex.class, query).getData();
                if (!restrictedDataSearchResult.isEmpty() && (restrictedDataCtr = EntityStorage.get().resolve(((PersonalDataRestrictedEntityDataIndex)restrictedDataSearchResult.get(0)).getSource())) != null) {
                    AnonymizationHandler.of((BaseEntity)owner).copy(((PersonalDataRestrictedEntityData)restrictedDataCtr.getEntity()).getEntity(), owner);
                    ownerContainer.getVersionInfo().setDataSource("restriction-person-restore-task");
                    ownerContainer.getVersionInfo().setVersionNotes(Stream.of(ownerContainer.getVersionInfo().getVersionNotes(), String.format("gdpr-request-%s-%s", request.getType().name().toLowerCase().replace("_", "-"), request.getNumber())).filter(item -> !TextUtil.isBlank((String)item)).collect(Collectors.joining(" + ")));
                    EntityStorage.get().save(ownerContainer, true);
                    EntityStorage.get().delete(restrictedDataCtr);
                }
            });
            iterator.remove();
            ++count;
        }
    }

    private void handleInterrupt(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback) throws Exception {
        boolean shutdown = ShutdownStatus.isShutdown();
        if (!shutdown) {
            PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
            LockUtil.lock((EntityReference)requestContainer.toReference(), updatedRequestContainer -> {
                if (updatedRequestContainer != null) {
                    PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                    updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                    updatedRequest.setStatus(PersonalDataRequestStatus.RESTORE_INTERRUPTED);
                    updatedRequestContainer.getVersionInfo().setDataSource("restore-interrupted");
                    EntityStorage.get().save(updatedRequestContainer, true);
                    this.log.debug("personal data restriction person restoration interrupted -> " + shutdown);
                    callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataRestrictionPersonRestoreTask_restoreInterrupted").build());
                }
            });
        }
    }

    private void handleError(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback, Exception e) throws Exception {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        LockUtil.lock((EntityReference)requestContainer.toReference(), updatedRequestContainer -> {
            if (updatedRequestContainer != null) {
                PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                updatedRequest.setStatus(PersonalDataRequestStatus.RESTORE_FAILED);
                updatedRequestContainer.getVersionInfo().setDataSource("restore-failed");
                EntityStorage.get().save(updatedRequestContainer, true);
                this.log.error("personal data restriction person process failed", (Throwable)e);
                callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataRestrictionPersonRestoreTask_restoreFailed").error((Throwable)e).build());
            }
        });
    }

    private void handleDone(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback) throws Exception {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        LockUtil.lock(this.requestReference, updatedRequestContainer -> {
            if (updatedRequestContainer != null) {
                PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                updatedRequest.setStatus(PersonalDataRequestStatus.RESTORE_DONE);
                updatedRequestContainer.getVersionInfo().setDataSource("restoration-done");
                EntityStorage.get().save(updatedRequestContainer, true);
                this.log.debug("personal data restriction person restoration done");
                callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataRestrictionPersonRestoreTask_restoreDone").build());
            }
        });
    }

    private void handleProgress(LongRunningTask.EventsCallback callback, int progressStart, int progressEnd, int count, int total) {
        byte progress = (byte)(progressStart + (progressEnd - progressStart) * count / total);
        this.log.debug("personal data restriction person restoration progress -> " + progress);
        callback.updateProgress(progress);
    }
}

