/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.gracefulstop.ShutdownStatus;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.PersonalDataPersonSearchData;
import com.gridnine.xtrip.common.model.PersonalDataSearchResult;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataPersonRequest;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRequestStatus;
import com.gridnine.xtrip.common.model.personal.data.helper.PersonalDataHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Element;

public class PersonalDataRestrictionPersonSearchTask
extends BaseLongRunningTask<Serializable> {
    private EntityReference<PersonalDataPersonRequest> requestReference;

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.PersonalDataRestrictionPersonSearchTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element element) throws Exception {
        this.requestReference = (EntityReference)XHelper.readObject((Element)element, (String)"requestReference");
    }

    public void toXML(Element element) throws Exception {
        XHelper.writeObject((Element)element, (String)"requestReference", this.requestReference);
    }

    @Override
    public void configure(Serializable value) throws Exception {
        this.requestReference = (EntityReference)value;
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("personal data restriction person search started");
        this.log.debug(String.format("request -> %s", this.requestReference));
        if (this.requestReference == null) {
            this.log.error("personal data restriction person search failed -> request value missing");
            callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataRestrictionPersonSearchTask_searchFailed").details(L10nResourcesManager.getStr((String)"PersonalDataRestrictionPersonSearchTask_requestValueMissing", (Object[])new Object[0])).build());
            throw new Exception("request value missing");
        }
        callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataRestrictionPersonSearchTask_request").parameters(new Object[]{this.requestReference}).build());
        EntityContainer requestContainer = EntityStorage.get().resolve(this.requestReference);
        if (requestContainer == null) {
            this.log.error("personal data restriction person search failed -> request load failed");
            callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataRestrictionPersonSearchTask_searchFailed").details(L10nResourcesManager.getStr((String)"PersonalDataRestrictionPersonSearchTask_requestLoadFailed", (Object[])new Object[0])).build());
            throw new Exception("request load failed");
        }
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        try {
            request.getSearchResults().clear();
            this.searchPersons((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback, 0, 10);
            this.searchFake((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback, 10, 100);
            if (!this.isToBeStopped()) {
                this.handleDone((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback);
                callback.taskFinished();
            }
        }
        catch (Exception e) {
            this.handleError((EntityContainer<PersonalDataPersonRequest>)requestContainer, callback, e);
            throw new Exception("search failed");
        }
        this.log.debug("personal data restriction person search finished");
    }

    private void searchPersons(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback, int progressStart, int progressEnd) throws Exception {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        PersonalDataPersonSearchData searchData = request.getSearchData();
        SearchQuery query = new SearchQuery();
        if (searchData.getPerson() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)searchData.getPerson().getUid()));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])searchData.getNames().stream().flatMap(item -> Stream.of(item.getFirstName(), item.getLastName())).map(item -> SearchCriterion.ilike((String)PersonIndex.Property.name.name(), (String)String.format("%%%s%%", item))).toArray(SearchCriterion[]::new))));
        }
        Set personReferences = EntityStorage.get().search(PersonIndex.class, query).getData().stream().map(item -> item.getSource()).collect(Collectors.toSet());
        this.log.debug("personal data restriction person search persons found -> " + personReferences.size());
        int count = 0;
        for (EntityReference personReference : personReferences) {
            if (this.isToBeStopped()) {
                this.handleInterrupt(requestContainer, callback);
                return;
            }
            this.handleProgress(callback, progressStart, progressEnd, count, personReferences.size());
            EntityContainer personContainer = EntityStorage.get().resolve(personReference);
            if (personContainer != null) {
                this.searchPerson(requestContainer, (EntityContainer<Person>)personContainer);
            }
            ++count;
        }
    }

    private void searchFake(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback, int progressStart, int progressEnd) throws Exception {
        int total = 60;
        for (int i = 0; i < total; ++i) {
            if (this.isToBeStopped()) {
                this.handleInterrupt(requestContainer, callback);
                return;
            }
            this.handleProgress(callback, progressStart, progressEnd, i, total);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void searchPerson(EntityContainer<PersonalDataPersonRequest> requestContainer, EntityContainer<Person> personContainer) {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        Person person = (Person)personContainer.getEntity();
        PersonalDataPersonSearchData searchData = request.getSearchData();
        List searchResultItems = PersonalDataHelper.getPersonSearchResultItems((PersonalDataPersonSearchData)searchData, (Person)person);
        if (searchResultItems.stream().anyMatch(item -> item.getExpected() != null && item.getActual() != null)) {
            PersonalDataSearchResult searchResult = new PersonalDataSearchResult();
            searchResult.setEntity(personContainer.toReference());
            searchResult.setProcess(true);
            searchResult.getItems().clear();
            searchResult.getItems().addAll(searchResultItems);
            request.getSearchResults().add(searchResult);
        }
    }

    private void handleInterrupt(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback) throws Exception {
        boolean shutdown = ShutdownStatus.isShutdown();
        if (!shutdown) {
            PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
            LockUtil.lock((EntityReference)requestContainer.toReference(), updatedRequestContainer -> {
                if (updatedRequestContainer != null) {
                    PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                    updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                    updatedRequest.setStatus(PersonalDataRequestStatus.SEARCH_INTERRUPTED);
                    updatedRequestContainer.getVersionInfo().setDataSource("search-interrupted");
                    EntityStorage.get().save(updatedRequestContainer, true);
                    this.log.debug("personal data restriction person search interrupted -> " + shutdown);
                    callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataRestrictionPersonSearchTask_searchInterrupted").build());
                }
            });
        }
    }

    private void handleError(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback, Exception e) throws Exception {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        LockUtil.lock((EntityReference)requestContainer.toReference(), updatedRequestContainer -> {
            if (updatedRequestContainer != null) {
                PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                updatedRequest.setStatus(PersonalDataRequestStatus.SEARCH_FAILED);
                updatedRequestContainer.getVersionInfo().setDataSource("search-failed");
                EntityStorage.get().save(updatedRequestContainer, true);
                this.log.error("personal data restriction person search failed", (Throwable)e);
                callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key("PersonalDataRestrictionPersonSearchTask_searchFailed").error((Throwable)e).build());
            }
        });
    }

    private void handleDone(EntityContainer<PersonalDataPersonRequest> requestContainer, LongRunningTask.EventsCallback callback) throws Exception {
        PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
        LockUtil.lock(this.requestReference, updatedRequestContainer -> {
            if (updatedRequestContainer != null) {
                PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                updatedRequest.copyFrom((BaseEntity)request, false, new HashMap());
                updatedRequest.setStatus(PersonalDataRequestStatus.SEARCH_DONE);
                updatedRequestContainer.getVersionInfo().setDataSource("search-done");
                EntityStorage.get().save(updatedRequestContainer, true);
                this.log.debug("personal data restriction person search done");
                callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("PersonalDataRestrictionPersonSearchTask_searchDone").build());
            }
        });
    }

    private void handleProgress(LongRunningTask.EventsCallback callback, int progressStart, int progressEnd, int count, int total) {
        byte progress = (byte)(progressStart + (progressEnd - progressStart) * count / total);
        this.log.debug("personal data restriction person search progress -> " + progress);
        callback.updateProgress(progress);
    }
}

