/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.PhoneCorrectionTaskConfiguration;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PhoneHelper;
import com.gridnine.xtrip.common.util.PhoneNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseEntityUpdateTask;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Element;

public class PhoneCorrectionTask
extends BaseEntityUpdateTask<PhoneCorrectionTaskConfiguration> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.PhoneCorrectionTask_description, (Object[])new Object[0]);
    }

    @Override
    protected Class<PhoneCorrectionTaskConfiguration> getConfigurationClass() {
        return PhoneCorrectionTaskConfiguration.class;
    }

    @Override
    protected void printParameters(LongRunningTask.EventsCallback callback) {
        super.printParameters(callback);
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("  \u0420\u0435\u0436\u0438\u043c \u0440\u0430\u0431\u043e\u0442\u044b: " + (((PhoneCorrectionTaskConfiguration)this.config).isDryRun() ? "  \u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0431\u043e\u0440 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438" : "  \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u043a\u0430")), (Object[])new Object[0]));
    }

    @Override
    protected Object createData() {
        return new Data();
    }

    @Override
    protected <E extends BaseEntity> void processContainer(EntityContainer<E> ctr, LogicalEntityStorage storage, Object param) throws Exception {
        try {
            BaseEntity entity = ctr.getEntity();
            if (entity instanceof Person) {
                Person person = (Person)entity;
                boolean neededSave = false;
                for (PersonCommunication communication : person.getCommunications()) {
                    if (!this.acceptCommunication(communication.getType())) continue;
                    PhoneNumber correctNumber = PhoneHelper.getCorrectNumber((String)communication.getCountryCode(), (String)communication.getCityCode(), (String)communication.getSense(), (String)communication.getInternalNumber());
                    Data data = (Data)param;
                    data.getTotalCount().incrementAndGet();
                    if (correctNumber != null) {
                        if (!(MiscUtil.equals((Object)communication.getCountryCode(), (Object)correctNumber.getCountryCode()) && MiscUtil.equals((Object)communication.getCityCode(), (Object)correctNumber.getCityCode()) && MiscUtil.equals((Object)communication.getSense(), (Object)correctNumber.getNumber()) && MiscUtil.equals((Object)communication.getInternalNumber(), (Object)correctNumber.getExtension()))) {
                            data.getResult().add(this.report(person, communication, correctNumber, true));
                            data.getCorrectedCount().incrementAndGet();
                            if (((PhoneCorrectionTaskConfiguration)this.config).isDryRun()) continue;
                            communication.setCountryCode(correctNumber.getCountryCode());
                            communication.setCityCode(correctNumber.getCityCode());
                            communication.setSense(correctNumber.getNumber());
                            communication.setInternalNumber(correctNumber.getExtension());
                            neededSave = true;
                            continue;
                        }
                        data.getResult().add(this.report(person, communication, null, true));
                        continue;
                    }
                    if (TextUtil.isBlank((String)communication.getCountryCode()) && TextUtil.isBlank((String)communication.getCityCode()) && TextUtil.isBlank((String)communication.getSense()) && TextUtil.isBlank((String)communication.getInternalNumber())) continue;
                    data.getResult().add(this.report(person, communication, null, false));
                    data.getIncorrectCount().incrementAndGet();
                }
                if (neededSave) {
                    storage.save(ctr, true);
                }
                return;
            }
            if (entity instanceof Organization) {
                Organization organization = (Organization)entity;
                boolean neededSave = false;
                for (Communication communication : organization.getCommunications()) {
                    if (!this.acceptCommunication(communication.getType())) continue;
                    PhoneNumber correctNumber = PhoneHelper.getCorrectNumber((String)communication.getCountryCode(), (String)communication.getCityCode(), (String)communication.getSense(), (String)communication.getInternalNumber());
                    Data data = (Data)param;
                    data.getTotalCount().incrementAndGet();
                    if (correctNumber != null) {
                        if (!(MiscUtil.equals((Object)communication.getCountryCode(), (Object)correctNumber.getCountryCode()) && MiscUtil.equals((Object)communication.getCityCode(), (Object)correctNumber.getCityCode()) && MiscUtil.equals((Object)communication.getSense(), (Object)correctNumber.getNumber()) && MiscUtil.equals((Object)communication.getInternalNumber(), (Object)correctNumber.getExtension()))) {
                            data.getResult().add(this.report(organization, communication, correctNumber, true));
                            data.getCorrectedCount().incrementAndGet();
                            if (((PhoneCorrectionTaskConfiguration)this.config).isDryRun()) continue;
                            communication.setCountryCode(correctNumber.getCountryCode());
                            communication.setCityCode(correctNumber.getCityCode());
                            communication.setSense(correctNumber.getNumber());
                            communication.setInternalNumber(correctNumber.getExtension());
                            neededSave = true;
                            continue;
                        }
                        data.getResult().add(this.report(organization, communication, null, true));
                        continue;
                    }
                    if (TextUtil.isBlank((String)communication.getCountryCode()) && TextUtil.isBlank((String)communication.getCityCode()) && TextUtil.isBlank((String)communication.getSense()) && TextUtil.isBlank((String)communication.getInternalNumber())) continue;
                    data.getResult().add(this.report(organization, communication, null, false));
                    data.getIncorrectCount().incrementAndGet();
                }
                if (neededSave) {
                    storage.save(ctr, true);
                }
                return;
            }
            throw new Exception("Unsupported type " + entity.getClass().getName());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void makeResult(LongRunningTask.EventsCallback callback) {
        ArrayList<String> messages = new ArrayList<String>();
        int totalCount = 0;
        int correctedCount = 0;
        int incorrectCount = 0;
        for (Object item : this.getDataList()) {
            Data data = (Data)item;
            messages.addAll(data.getResult());
            totalCount += data.getTotalCount().get();
            correctedCount += data.getCorrectedCount().get();
            incorrectCount += data.getIncorrectCount().get();
        }
        int goodCount = totalCount - correctedCount - incorrectCount;
        Document doc = new Document();
        doc.setType(DocumentType.OTHER);
        doc.setName("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043e\u0432.csv");
        doc.setTitle("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043e\u0432");
        doc.setContentType(ContentType.TEXT);
        doc.setCreated(new Date());
        StringBuilder sb = new StringBuilder();
        sb.append("\u0412\u0441\u0435\u0433\u043e: ").append(totalCount).append("\n");
        sb.append("\u0422\u0440\u0435\u0431\u0443\u044e\u0442 \u0440\u0443\u0447\u043d\u043e\u0439 \u043f\u0440\u0430\u0432\u043a\u0438: ").append(incorrectCount).append("\n");
        sb.append("\n");
        sb.append("\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e: ").append(correctedCount).append("\n");
        sb.append("\u041d\u0435 \u0442\u0440\u0435\u0431\u0443\u044e\u0442 \u043f\u0440\u0430\u0432\u043a\u0438: ").append(goodCount).append("\n");
        doc.setDescription(sb.toString());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));){
            pw.println("Type,StringID,Rule#,OrigCountryCode,OrigCityCode,OrigNumber,OrigExtension,NewCountryCode,NewCityCode,NewNumber,NewExtension,WasChanged");
            Collections.sort(messages);
            for (String message : messages) {
                pw.println(message);
            }
            doc.setContent(baos.toByteArray());
        }
        EntityContainer docCtr = EntityContainer.create((BaseEntity)doc);
        EntityStorage.get().save(docCtr, true);
    }

    private String report(Person person, PersonCommunication communication, PhoneNumber correctNumber, boolean corrected) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("\u0427\u0435\u043b\u043e\u0432\u0435\u043a");
        sb.append(',');
        sb.append(PhoneCorrectionTask.getCSVString(PhoneCorrectionTask.createStringId(person)));
        sb.append(',');
        sb.append(',');
        if (communication.getCountryCode() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(communication.getCountryCode()));
        }
        sb.append(',');
        if (communication.getCityCode() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(communication.getCityCode()));
        }
        sb.append(',');
        if (communication.getSense() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(communication.getSense()));
        }
        sb.append(',');
        if (communication.getInternalNumber() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(communication.getInternalNumber()));
        }
        sb.append(',');
        if (correctNumber != null && correctNumber.getCountryCode() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(correctNumber.getCountryCode()));
        }
        sb.append(',');
        if (correctNumber != null && correctNumber.getCityCode() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(correctNumber.getCityCode()));
        }
        sb.append(',');
        if (correctNumber != null && correctNumber.getNumber() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(correctNumber.getNumber()));
        }
        sb.append(',');
        if (correctNumber != null && correctNumber.getExtension() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(correctNumber.getExtension()));
        }
        sb.append(',');
        if (correctNumber == null) {
            if (!corrected) {
                sb.append("manual");
            } else {
                sb.append("correct");
            }
        } else {
            sb.append("converted");
        }
        return sb.toString();
    }

    private String report(Organization organization, Communication communication, PhoneNumber correctNumber, boolean corrected) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f");
        sb.append(',');
        sb.append(PhoneCorrectionTask.getCSVString(PhoneCorrectionTask.createStringId(organization)));
        sb.append(',');
        sb.append(',');
        if (communication.getCountryCode() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(communication.getCountryCode()));
        }
        sb.append(',');
        if (communication.getCityCode() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(communication.getCityCode()));
        }
        sb.append(',');
        if (communication.getSense() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(communication.getSense()));
        }
        sb.append(',');
        if (communication.getInternalNumber() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(communication.getInternalNumber()));
        }
        sb.append(',');
        if (correctNumber != null && correctNumber.getCountryCode() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(correctNumber.getCountryCode()));
        }
        sb.append(',');
        if (correctNumber != null && correctNumber.getCityCode() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(correctNumber.getCityCode()));
        }
        sb.append(',');
        if (correctNumber != null && correctNumber.getNumber() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(correctNumber.getNumber()));
        }
        sb.append(',');
        if (correctNumber != null && correctNumber.getExtension() != null) {
            sb.append(PhoneCorrectionTask.getCSVString(correctNumber.getExtension()));
        }
        sb.append(',');
        if (correctNumber == null) {
            if (!corrected) {
                sb.append("manual");
            } else {
                sb.append("correct");
            }
        } else {
            sb.append("converted");
        }
        return sb.toString();
    }

    private static String getCSVString(String str) {
        if (str == null) {
            return null;
        }
        if (str.contains("\"")) {
            return "\"" + str.replace("\"", "\"\"") + "\"";
        }
        if (str.contains(",") || str.startsWith("0")) {
            return "\"" + str + "\"";
        }
        return str;
    }

    private static String createStringId(Person person) {
        StringBuilder sb = new StringBuilder();
        String firstName = PhoneCorrectionTask.getString(person.getFirstName());
        String middleName = PhoneCorrectionTask.getString(person.getMiddleName());
        String surname = PhoneCorrectionTask.getString(person.getLastName());
        if (firstName != null) {
            sb.append(firstName);
            sb.append(' ');
        }
        if (middleName != null) {
            sb.append(middleName);
            sb.append(' ');
        }
        if (surname != null) {
            sb.append(surname);
            sb.append(' ');
        }
        for (Communication emailComm : person.getCommunications()) {
            if (emailComm == null || !CommunicationType.EMAIL.equals((Object)emailComm.getType())) continue;
            sb.append(emailComm.getSense());
            sb.append(' ');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private boolean acceptCommunication(CommunicationType communicationType) {
        return communicationType == CommunicationType.WORK_PHONE || communicationType == CommunicationType.HOME_PHONE || communicationType == CommunicationType.FAX || communicationType == CommunicationType.MOBILE;
    }

    private static String createStringId(Organization organization) {
        StringBuilder sb = new StringBuilder();
        String name = organization.toString();
        if (name != null) {
            sb.append(name).append(' ');
        }
        for (Communication emailComm : organization.getCommunications()) {
            if (emailComm == null || !CommunicationType.EMAIL.equals((Object)emailComm.getType())) continue;
            sb.append(emailComm.getSense());
            sb.append(' ');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static String getString(L10nString name) {
        return name != null ? name.toString() : null;
    }

    private static class Data
    implements XSerializable {
        private final List<String> result = Collections.synchronizedList(new ArrayList());
        private final AtomicInteger totalCount = new AtomicInteger();
        private final AtomicInteger correctedCount = new AtomicInteger();
        private final AtomicInteger incorrectCount = new AtomicInteger();

        public List<String> getResult() {
            return this.result;
        }

        public AtomicInteger getTotalCount() {
            return this.totalCount;
        }

        public AtomicInteger getCorrectedCount() {
            return this.correctedCount;
        }

        public AtomicInteger getIncorrectCount() {
            return this.incorrectCount;
        }

        public void toXML(Element elm) throws Exception {
            for (String item : this.result) {
                XHelper.writeString((Element)elm, (String)"result/item", (String)item);
            }
        }

        public void fromXML(Element elm) throws Exception {
            this.result.clear();
            for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"result/item")) {
                String item = XHelper.readString((Element)itemElm, (String)".");
                this.result.add(item);
            }
        }
    }
}

