/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Element;

public class PopulateUserAccountEmailFromLinkedProfileTask
extends BaseLongRunningTask<Serializable> {
    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.PopulateDefaultUserAccountEmailAddressTask_Description, (Object[])new Object[0]);
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        List<UserAccount> accounts = PopulateUserAccountEmailFromLinkedProfileTask.getUserAccountsWithoutEmails();
        int processedAccounts = 0;
        int totalAccounts = accounts.size();
        for (UserAccount account : accounts) {
            Message message = PopulateUserAccountEmailFromLinkedProfileTask.tryUpdateUserAccount(account);
            if (message != null) {
                callback.addEvent(null, message);
            }
            callback.updateProgress(PopulateUserAccountEmailFromLinkedProfileTask.calculatePercentage(++processedAccounts, totalAccounts));
        }
        callback.taskFinished();
    }

    private static Message tryUpdateUserAccount(UserAccount account) {
        String loginName = account.getLoginName();
        if (loginName == null) {
            return PopulateUserAccountEmailFromLinkedProfileTask.getLoginNameIsNullMessage(account);
        }
        List<PersonIndex> personIndices = PopulateUserAccountEmailFromLinkedProfileTask.getPersonsByLoginName(loginName);
        if (personIndices.isEmpty()) {
            return PopulateUserAccountEmailFromLinkedProfileTask.getPersonNotFoundMessage(account);
        }
        if (personIndices.size() > 1) {
            return PopulateUserAccountEmailFromLinkedProfileTask.getAmbiguousPersonMessage(account);
        }
        Person person = PopulateUserAccountEmailFromLinkedProfileTask.getPersonByIndex(personIndices.get(0));
        if (person == null) {
            return PopulateUserAccountEmailFromLinkedProfileTask.getPersonNotFoundMessage(account);
        }
        String email = PopulateUserAccountEmailFromLinkedProfileTask.getPersonEmail(person);
        if (email == null) {
            return PopulateUserAccountEmailFromLinkedProfileTask.getEmailNotFoundMessage(account);
        }
        PopulateUserAccountEmailFromLinkedProfileTask.updateEmail(account, email);
        return null;
    }

    private static String getPersonEmail(Person person) {
        return person.getCommunications().stream().filter(communication -> CommunicationType.EMAIL.equals((Object)communication.getType()) && !TextUtil.isBlank((String)communication.getSense())).findFirst().map(Communication::getSense).orElse(null);
    }

    private static void updateEmail(UserAccount userAccount, String email) {
        userAccount.setEmail(email);
        AssetsStorage.get().save((BaseAsset)userAccount);
    }

    private static byte calculatePercentage(int processed, int total) {
        return (byte)(processed * 100 / total);
    }

    private static Person getPersonByIndex(PersonIndex personIndex) {
        EntityContainer personContainer = EntityStorage.get().resolve(personIndex.getSource());
        if (personContainer == null) {
            return null;
        }
        return (Person)personContainer.getEntity();
    }

    private static List<PersonIndex> getPersonsByLoginName(String loginName) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)loginName));
        query.setLimit(2);
        return EntityStorage.get().search(PersonIndex.class, query).getData();
    }

    private static List<UserAccount> getUserAccountsWithoutEmails() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.isEmpty((String)UserAccount.Property.email.name()));
        return AssetsStorage.get().search(UserAccount.class, query).getData();
    }

    private static Message getAmbiguousPersonMessage(UserAccount account) {
        return MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.PopulateUserAccountEmailFromLinkedProfileTask_AmbiguousPersonMessage, (Object[])new Object[]{account.getLoginName()});
    }

    private static Message getPersonNotFoundMessage(UserAccount account) {
        return MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.PopulateUserAccountEmailFromLinkedProfileTask_PersonNotFoundMessage, (Object[])new Object[]{account.getLoginName()});
    }

    private static Message getEmailNotFoundMessage(UserAccount account) {
        return MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.PopulateUserAccountEmailFromLinkedProfileTask_EmailNotFoundMessage, (Object[])new Object[]{account.getLoginName()});
    }

    private static Message getLoginNameIsNullMessage(UserAccount account) {
        return MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.PopulateUserAccountEmailFromLinkedProfileTask_LoginIsEmptyMessage, (Object[])new Object[]{account.getUid()});
    }
}

