/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductDateData;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.model.system.ProductPeriodData;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ProductDateDataUpdateTask
extends BaseLongRunningTask<Serializable> {
    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.ProductDateDataUpdateTask_description, (Object[])new Object[0]);
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("productDateData update started");
        SearchQuery query = new SearchQuery();
        Set modelContractReferences = EntityStorage.get().search(ModelContractIndex.class, query).getData().stream().map(ModelContractIndex::getSource).filter(Objects::nonNull).collect(Collectors.toSet());
        int count = modelContractReferences.size();
        int n = 0;
        for (EntityReference modelContractRef : modelContractReferences) {
            RuleSet ruleSet;
            ModelContract modelContract;
            EntityContainer modelContractCtr;
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            byte progress = (byte)(100 * n / count);
            this.log.debug(String.format("processing %s, %s of %s", modelContractRef, n, count));
            if (n % 10 == 0) {
                callback.updateProgress(progress);
            }
            if ((modelContractCtr = EntityStorage.get().resolve(modelContractRef)) == null || (modelContract = (ModelContract)modelContractCtr.getEntity()) == null || (ruleSet = modelContract.getRuleSet()) == null) continue;
            boolean save = false;
            for (RuleSettings ruleSettings : ruleSet.getRules()) {
                for (RuleResult ruleResult : ruleSettings.getResults()) {
                    if (!(ruleResult.getValue() instanceof ProductDateData)) continue;
                    ProductDateData productDateData = (ProductDateData)ruleResult.getValue();
                    this.log.debug(String.format("processing %s", productDateData));
                    if (productDateData.getProductPeriodType() == null || productDateData.getProductPeriodData() != null) continue;
                    ProductPeriodData productPeriodData = new ProductPeriodData();
                    productPeriodData.setProductPeriodType(productDateData.getProductPeriodType());
                    productDateData.setProductPeriodData(productPeriodData);
                    save = true;
                }
            }
            if (save) {
                try {
                    modelContractCtr.getVersionInfo().setDataSource("product-date-data-update-task");
                    EntityStorage.get().save(modelContractCtr, true);
                }
                catch (Exception e) {
                    this.log.debug(String.format("unable to save %s", modelContractCtr));
                }
            }
            ++n;
        }
        callback.taskFinished();
        this.log.debug("productDateData update finished");
    }
}

