/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class ProfileContactTypeUpdateTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.PersonContactUpdateTask_startUpdateContacts, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("Begin profile updating task");
        try {
            ArrayList<EntityContainer> persons = new ArrayList<EntityContainer>();
            LogicalSession managedSession = null;
            try {
                managedSession = LogicalStorage.get().beginUnitOfWork();
                List personIndexes = EntityStorage.get().search(PersonIndex.class, new SearchQuery()).getData();
                for (PersonIndex persIndex : personIndexes) {
                    EntityContainer orgCont = EntityStorage.get().resolve(persIndex.getSource());
                    if (orgCont == null) continue;
                    persons.add(orgCont);
                }
            }
            finally {
                if (managedSession != null) {
                    LogicalStorage.get().cancelUnitOfWork(managedSession);
                }
            }
            for (EntityContainer profile : persons) {
                Person personEntity = (Person)profile.getEntity();
                if (personEntity == null) continue;
                boolean hasChanges = false;
                for (PersonCommunication persCom : personEntity.getCommunications()) {
                    if (persCom.getType() == CommunicationType.MOBILE) {
                        persCom.setType(CommunicationType.HOME_PHONE);
                        hasChanges = true;
                    }
                    if (TextUtil.isBlank((String)persCom.getInternalNumber()) || !TextUtil.isBlank((String)persCom.getSense())) continue;
                    persCom.setSense(persCom.getInternalNumber());
                    persCom.setInternalNumber(null);
                    hasChanges = true;
                }
                if (!hasChanges) continue;
                EntityStorage.get().save(profile, false);
            }
        }
        catch (Exception e) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.PersonContactUpdateTask_errorUpdateContacts, (Throwable)e, (Object[])new Object[0]));
        }
        finally {
            this.log.debug("End profile comminucation updating task");
            callback.updateProgress((byte)100);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.PersonContactUpdateTask_successUpdateContacts, (Object[])new Object[0]));
            callback.taskFinished();
        }
    }
}

