/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityActualizer;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.QueryBasedReindexTaskConfiguration;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseQueryObjectsTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class QueryBasedReindexLongRunningTask
extends BaseQueryObjectsTask<QueryBasedReindexTaskConfiguration> {
    private int threadCount;

    @Override
    public void configure(QueryBasedReindexTaskConfiguration configuration) throws Exception {
        super.configure(configuration);
        this.threadCount = Math.max(configuration.getThreadCount(), 1);
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)MetaRegistryHelper.getDisplayName(QueryBasedReindexTaskConfiguration.class), (Object[])new Object[0]);
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        Class idxClass = XHelper.getClass((String)((QueryBasedReindexTaskConfiguration)this.config).getIndexType());
        int totalCount = this.count(this.createCallback(0, callback), idxClass);
        this.processObjects(idxClass.getName(), callback, this.createCallback(totalCount, callback));
        callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043f\u0435\u0440\u0435\u0438\u043d\u0434\u0435\u043a\u0441\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430, \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432", (Object[])new Object[]{totalCount}));
        callback.taskFinished();
    }

    private BaseQueryObjectsTask.ProcessCallback createCallback(final int count, final LongRunningTask.EventsCallback callback) {
        return new BaseQueryObjectsTask.ProcessCallback(){
            private static final String UID_ALLIAS = "uidAllias";
            private static final String ENTITY_TYPE_ALLIAS = "entityTypeAllias";

            @Override
            public int getThreadsCount() {
                return QueryBasedReindexLongRunningTask.this.threadCount;
            }

            @Override
            public int getTotalCount() {
                return count;
            }

            @Override
            public void processObject(Class<?> objectClass, Map<String, String> obj) throws Exception {
                String uid = obj.get(UID_ALLIAS);
                String entityType = obj.get(ENTITY_TYPE_ALLIAS);
                EntityContainer ctr = LogicalStorage.get().getEntityStorage().load(XHelper.getClass((String)entityType), uid, new EntityStorageLoadParameters());
                try {
                    if (ctr == null) {
                        QueryBasedReindexLongRunningTask.this.log.warn(String.format("unable to load container of type %s with uid %s", entityType, uid));
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442 \u0442\u0438\u043f\u0430 {0} \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c {1}", (Object[])new Object[]{entityType, uid}));
                        return;
                    }
                    EntityActualizer actualizer = EntityActualizer.newInstance();
                    actualizer.getEntityStorageActualizeParameters().processedUncachedEntity(false).useRemoteCallIfNecessary(true);
                    actualizer.actualize((Object)ctr.getEntity());
                    LogicalStorage.get().getEntityStorage().updateIndexes(ctr, ctr, false);
                    QueryBasedReindexLongRunningTask.this.log.debug(String.format("processed %s", ctr.getEntity().toString()));
                }
                catch (Exception e) {
                    QueryBasedReindexLongRunningTask.this.log.error(String.format("unable to process %s", ctr.getEntity().toString()));
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442 {0}", (Object[])new Object[]{ctr.getEntity().toString()}));
                }
            }

            @Override
            public String getUid(Map<String, String> obj) {
                return obj.get(UID_ALLIAS);
            }

            @Override
            public Collection<? extends Projection> getProjections(Class<?> cls) {
                ArrayList<Projection> result = new ArrayList<Projection>(2);
                result.add(Projection.property((String)"containerUid", (String)UID_ALLIAS));
                result.add(Projection.property((String)"entityType", (String)ENTITY_TYPE_ALLIAS));
                return result;
            }

            @Override
            public String getThreadPrefix() {
                return "reindex";
            }

            @Override
            public List<SearchCriterion> getCriterions(Class<?> cls) {
                return ((QueryBasedReindexTaskConfiguration)QueryBasedReindexLongRunningTask.this.config).getCriterions();
            }
        };
    }
}

