/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.QuestionRecord;
import com.gridnine.xtrip.common.model.questionnaire.GetQuestionsSyncRequest;
import com.gridnine.xtrip.common.model.questionnaire.GetQuestionsSyncResponse;
import com.gridnine.xtrip.common.model.questionnaire.QuestionData;
import com.gridnine.xtrip.common.model.questionnaire.RegisterAnswerSyncRequest;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.LicenceHelper;
import com.gridnine.xtrip.server.licence.Address;
import com.gridnine.xtrip.server.model.questionnaire.QuestionHandler;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class QuestionnaireSyncTask
extends BaseScheduledTask {
    private static final String SYNC_USER = "sync-questions-task";
    private static final int MAX_ANSWER_ATTEMPTS = 1;

    protected void doJob() throws Exception {
        this.log.debug("starting QuestionnaireSyncTask");
        Date lastQuestionDate = this.getLastQuestionDate();
        this.log.debug("last question date is " + lastQuestionDate);
        List<QuestionData> questions = this.requestQuestions(lastQuestionDate);
        this.updateLocalData(questions);
        this.answerQuestions();
    }

    private void answerQuestions() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().addAll(Arrays.asList(SearchCriterion.eq((String)QuestionRecord.Property.answered.name(), (Object)Boolean.FALSE), SearchCriterion.lt((String)QuestionRecord.Property.answerAttempts.name(), (Object)1)));
        String ip = LicenceHelper.getIpAddressStr();
        this.log.debug("calculated ip address " + ip);
        for (QuestionRecord record : AssetsStorage.get().search(QuestionRecord.class, query).getData()) {
            try {
                QuestionHandler handler;
                QuestionData question = new QuestionData();
                XUtil.fromBytes((byte[])record.getQuestionData(), (XSerializable)question);
                this.log.debug("analyzing question with uid " + question.getId());
                try {
                    handler = (QuestionHandler)XSHelper.getClass((String)question.getHandlerClassName()).newInstance();
                }
                catch (Exception e) {
                    this.log.warn("question handler not found " + question.getHandlerClassName());
                    continue;
                }
                RegisterAnswerSyncRequest answer = new RegisterAnswerSyncRequest();
                answer.setInstallationId(Environment.getApplicationId());
                answer.setQuestionId(question.getId());
                answer.setIpAddress(ip);
                this.log.debug("answering question");
                record.setAnswerAttempts(record.getAnswerAttempts() + 1);
                AssetsStorage.get().save((BaseAsset)record);
                handler.answer(answer, question.getData());
                this.log.debug("question was answered");
                SynchronizationRequest<RegisterAnswerSyncRequest> request = new SynchronizationRequest<RegisterAnswerSyncRequest>();
                request.setClientId(Environment.getApplicationId());
                request.setData(answer);
                request.setOperationId(RegisterAnswerSyncRequest.class.getSimpleName());
                request.setUser(SYNC_USER);
                ValueHolder trace = new ValueHolder();
                this.log.debug("registering answer");
                SynchronizationResponse response = SynchronizationHelper.execute(request, Address.getSync(), (ValueHolder<String>)trace);
                Message msg = response.getMessages().stream().filter(m -> m.getType() == MessageType.ERROR).findFirst().orElse(null);
                if (msg != null) {
                    this.log.warn("failed registering answer " + msg.getMessage().toString());
                    throw Xeption.forDeveloper((String)String.format("unable to answer question: %s, details = %s", msg.getMessage().toString(), msg.getDetails()), (Object[])new Object[0]);
                }
                this.log.debug("answer was registered");
                record.setAnswered(true);
                AssetsStorage.get().save((BaseAsset)record);
            }
            catch (Exception e) {
                this.log.error("unable to answer question " + record.getQuestionId(), (Throwable)e);
            }
        }
    }

    private void updateLocalData(List<QuestionData> questions) throws Exception {
        this.log.debug("updating local data");
        ArrayList<QuestionRecord> questionRecords = new ArrayList<QuestionRecord>();
        for (QuestionData question : questions) {
            QuestionRecord record = (QuestionRecord)AssetsStorage.get().find(QuestionRecord.class, QuestionRecord.Property.questionId.name(), (Object)question.getId());
            if (record != null) {
                if (record.isAnswered() || MiscUtil.equals((Object)record.getQuestionDate(), (Object)question.getDate()) && MiscUtil.equals((Object)record.getQuestionData(), (Object)XSUtil.toByteArray((XSSerializable)question))) continue;
                record.setQuestionData(XSUtil.toByteArray((XSSerializable)question));
                questionRecords.add(record);
                continue;
            }
            record = new QuestionRecord();
            record.setQuestionDate(question.getDate());
            record.setQuestionId(question.getId());
            record.setQuestionData(XSUtil.toByteArray((XSSerializable)question));
            questionRecords.add(record);
            this.log.debug("added question with uid " + question.getUid());
        }
        AssetsStorage.get().save(questionRecords);
        this.log.debug("local data updated");
    }

    private List<QuestionData> requestQuestions(Date lastQuestionDate) {
        this.log.debug("requesting questions");
        GetQuestionsSyncRequest data = new GetQuestionsSyncRequest();
        data.setSinceDate(lastQuestionDate);
        SynchronizationRequest<GetQuestionsSyncRequest> request = new SynchronizationRequest<GetQuestionsSyncRequest>();
        request.setClientId(Environment.getApplicationId());
        request.setData(data);
        request.setOperationId(GetQuestionsSyncRequest.class.getSimpleName());
        request.setUser(SYNC_USER);
        ValueHolder trace = new ValueHolder();
        SynchronizationResponse response = SynchronizationHelper.execute(request, Address.getSync(), (ValueHolder<String>)trace);
        Message msg = response.getMessages().stream().filter(m -> m.getType() == MessageType.ERROR).findFirst().orElse(null);
        if (msg != null) {
            this.log.debug("response has error message " + msg.getMessage().toString());
            throw Xeption.forDeveloper((String)String.format("unable to synchronize questions: %s, details = %s", msg.getMessage().toString(), msg.getDetails()), (Object[])new Object[0]);
        }
        return ((GetQuestionsSyncResponse)response.getData()).getQuestions();
    }

    private Date getLastQuestionDate() {
        this.log.debug("computing last question date");
        ProjectionQuery query = new ProjectionQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)QuestionRecord.Property.answered.name(), (Object)Boolean.FALSE));
        query.getProjections().add(Projection.min((String)QuestionRecord.Property.questionDate.name(), (String)QuestionRecord.Property.questionDate.name()));
        List data = AssetsStorage.get().search(QuestionRecord.class, query).getData();
        if (!data.isEmpty() && ((Map)data.get(0)).get(QuestionRecord.Property.questionDate.name()) != null) {
            Date lastQuestionDate = (Date)((Map)data.get(0)).get(QuestionRecord.Property.questionDate.name());
            lastQuestionDate = new Date(lastQuestionDate.getTime() - TimeUnit.DAYS.toMillis(1L));
            return lastQuestionDate;
        }
        query = new ProjectionQuery();
        query.getProjections().add(Projection.max((String)QuestionRecord.Property.questionDate.name(), (String)QuestionRecord.Property.questionDate.name()));
        data = AssetsStorage.get().search(QuestionRecord.class, query).getData();
        if (!data.isEmpty()) {
            return (Date)((Map)data.get(0)).get(QuestionRecord.Property.questionDate.name());
        }
        return null;
    }
}

