/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.ReferenceSubstitutionTaskConfiguration;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReferenceSubstitutionTask
extends BaseLongRunningTask<ReferenceSubstitutionTaskConfiguration> {
    private final Map<String, List<String>> toProceed = new HashMap<String, List<String>>();
    private ReferenceSubstitutionTaskConfiguration configuration;

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.ReferenceSubstitutionTask_replaceRef, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        this.configuration = (ReferenceSubstitutionTaskConfiguration)XHelper.readObject((Element)elm, (String)"configuration");
        for (Element item : XmlUtil.getElements((Element)elm, (String)"classes")) {
            List<String> lst = this.toProceed.get(item.getAttribute("className"));
            if (lst == null) {
                lst = new ArrayList<String>();
                this.toProceed.put(item.getAttribute("className"), lst);
            }
            for (Element uidElm : XmlUtil.getElements((Element)item, (String)"uid")) {
                lst.add(XHelper.readString((Element)uidElm, (String)"."));
            }
        }
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeObject((Element)elm, (String)"configuration", (Object)this.configuration);
        for (Map.Entry<String, List<String>> entry : this.toProceed.entrySet()) {
            Element item = XmlUtil.addElement((Element)elm, (String)"classes");
            item.setAttribute("className", entry.getKey());
            for (String uid : entry.getValue()) {
                Element uidElm = XmlUtil.addElement((Element)item, (String)"uid");
                XmlUtil.setValue((Element)uidElm, (String)uid);
            }
        }
    }

    @Override
    public void configure(ReferenceSubstitutionTaskConfiguration value) throws Exception {
        this.configuration = value;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        if (this.configuration == null || this.configuration.getReplaceWhat() == null || this.configuration.getReplaceWith() == null) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ReferenceSubstitutionTask_notDefineParametersTask, (Object[])new Object[0]));
            callback.taskFinished();
            this.log.debug("wrong task configuration");
            return;
        }
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        try {
            this.updateUids();
        }
        catch (Throwable e) {
            this.log.error("unable to update uids", e);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ReferenceSubstitutionTask_cantGetListObject, (Throwable)e, (Object[])new Object[0]));
            callback.updateProgress((byte)100);
            callback.taskFinished();
            return;
        }
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        long totalCount = 0L;
        for (String key : this.toProceed.keySet()) {
            totalCount += (long)this.toProceed.get(key).size();
        }
        long index = 0L;
        EntityStorage es = EntityStorage.get();
        Iterator<String> it = this.toProceed.keySet().iterator();
        while (it.hasNext()) {
            if (this.isToBeStopped()) {
                this.log.debug("task is interupted");
                return;
            }
            String className = it.next();
            EntityType entityType = (EntityType)MetaRegistry.get().getEntities().get(className);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.ReferenceSubstitutionTask_startUpdateObject, (Object[])new Object[]{entityType != null ? entityType.getDisplayName() : className}));
            this.log.debug("starting update of entities " + className);
            Iterator<String> it2 = this.toProceed.get(className).iterator();
            while (it2.hasNext()) {
                String uid = it2.next();
                EntityReference ref = null;
                ++index;
                try {
                    EntityContainer ctr = es.load(XHelper.getClass((String)className), uid);
                    ref = ctr.toReference();
                    this.log.debug("starting update of " + ref);
                    Document doc = DocumentBuilderHelper.newDocument();
                    Element root = doc.createElement("object");
                    root.setAttribute("class", className);
                    ctr.toXML(root);
                    doc.appendChild(root);
                    if (this.substituteUid(root)) {
                        ctr.fromXML(root);
                        ctr.getVersionInfo().setDataSource("server");
                        ctr.getVersionInfo().setVersionNotes("created by " + MiscUtil.getSimpleClassName(this.getClass()));
                        es.save(ctr, true);
                    }
                }
                catch (Throwable e) {
                    this.log.error("unable to update " + ref, e);
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ReferenceSubstitutionTask_cantUpdateObject, (Throwable)e, (Object[])new Object[]{ref}));
                }
                it2.remove();
                if (index % 100L != 0L) continue;
                callback.updateProgress((byte)(100.0 * (double)index / (double)totalCount));
                this.log.debug(String.format("update progress %s: %s from %s", Double.toString(100.0 * (double)index / (double)totalCount), Long.toString(index), Long.toString(totalCount)));
            }
            it.remove();
        }
        callback.taskFinished();
    }

    private boolean substituteUid(Element elm) {
        boolean result = false;
        NodeList children = elm.getChildNodes();
        block3: for (int i = 0; i < children.getLength(); ++i) {
            Node node = XmlUtil.safeGetNode((NodeList)children, (int)i);
            switch (node.getNodeType()) {
                case 1: {
                    Element child = (Element)node;
                    if ("com.gridnine.xtrip.common.model.EntityReference".equals(child.getAttribute("class"))) {
                        if (!XHelper.readString((Element)child, (String)"uid").equals(this.configuration.getReplaceWhat().getUid())) continue block3;
                        this.updateValue(child, "uid", this.configuration.getReplaceWith().getUid(), false);
                        this.updateValue(child, "type", this.configuration.getReplaceWith().getType().getName(), false);
                        this.updateValue(child, "caption", this.configuration.getReplaceWith().getCaption(), true);
                        result = true;
                        continue block3;
                    }
                    result |= this.substituteUid(child);
                    continue block3;
                }
            }
        }
        return result;
    }

    private void updateValue(Element child, String name, String value, boolean asCData) {
        Element elm = XmlUtil.getElement((Element)child, (String)name);
        if (elm != null) {
            XmlUtil.setValue((Element)elm, (String)value, (boolean)asCData);
            return;
        }
        XHelper.writeString((Element)child, (String)name, (String)value);
    }

    private void updateUids() throws Exception {
        if (this.toProceed.isEmpty()) {
            for (EntityType item : MetaRegistry.get().getEntities().values()) {
                List entityUids;
                if (!item.isRoot() || item.isAbstract() || (entityUids = LogicalStorage.get().getEntityStorage().getEntityUids(XHelper.getClass((String)item.getId()), null, null, true, true, SortOrder.ASC, null)).isEmpty()) continue;
                this.toProceed.put(item.getId(), entityUids);
            }
        }
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }
}

