/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.TimeService;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityStatus;
import com.gridnine.xtrip.common.model.cache.asset.ModifiedObjectReference;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.ReindexIndexStorageTaskConfiguration;
import com.gridnine.xtrip.common.model.tasks.RepairSecondaryStorageTaskConfiguration;
import com.gridnine.xtrip.common.model.tasks.standard.DeletedObjectReference;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Element;

public class ReindexIndexStorageTask
extends BaseLongRunningTask<ReindexIndexStorageTaskConfiguration> {
    protected volatile ReindexIndexStorageTaskConfiguration config;
    private List<Part> partList = null;
    private int totalCount = -1;
    private int doneCount = 0;
    private Date doneTo = null;
    private final Set<Class<?>> deletedIndexesClasses = new HashSet();

    public void test(LongRunningTask.EventsCallback callback) throws Exception {
        this.doJob(callback);
    }

    @Override
    public void configure(ReindexIndexStorageTaskConfiguration configuration) throws Exception {
        this.config = configuration;
    }

    protected PhysicalStorage getStorage() {
        LogicalStorageRegistry registry = LogicalStorageRegistry.get();
        String uid = this.config.getStorageUid();
        if (uid == null) {
            throw new IllegalStateException("Storage not defined");
        }
        PhysicalStorage storage = registry.getStorage(uid);
        if (storage == null) {
            throw new IllegalStateException("Storage not found: " + uid);
        }
        return storage;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.ReindexIndexSorageTask_description, (Object[])new Object[0]);
    }

    protected List<Part> getPartList(Date configDate, Date date) throws Exception {
        ArrayList<Part> result = new ArrayList<Part>();
        if (configDate == null) {
            return result;
        }
        int hours = this.config.getHours() > 0 ? this.config.getHours() : 24;
        Calendar current = Calendar.getInstance();
        if (date != null) {
            current.setTime(date);
        }
        Calendar next = Calendar.getInstance();
        while (current.getTimeInMillis() > configDate.getTime()) {
            next.setTimeInMillis(current.getTimeInMillis());
            next.add(10, -hours);
            if (next.getTimeInMillis() < configDate.getTime()) {
                next.setTimeInMillis(configDate.getTime());
            }
            result.add(new Part(next.getTime(), current.getTime()));
            current.add(10, -hours);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getDate(final boolean isUsedCreateDate, final LongRunningTask.EventsCallback callback) throws Exception {
        Collection<Class<?>> entityTypeList = this.getEntityTypeList();
        entityTypeList.remove(PhysicalBulkDictionaryData.class);
        entityTypeList.remove(RepairSecondaryStorageTaskConfiguration.DBPropertiesType.class);
        final PhysicalStorage storage = this.getStorage();
        Date result = null;
        final LinkedBlockingDeque dateList = new LinkedBlockingDeque();
        ExecutorServiceFacade service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool(this.getClass().getName(), this.config.getThreadCount() > 0 ? this.config.getThreadCount() : 1);
        final CountDownLatch countDown = new CountDownLatch(entityTypeList.size());
        try {
            for (final Class<?> entityType : entityTypeList) {
                service.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block13: {
                            block12: {
                                if (!ReindexIndexStorageTask.this.isToBeStopped()) break block12;
                                countDown.countDown();
                                return;
                            }
                            try {
                                try (PhysicalStorageSession session = storage.createSession(null);){
                                    Date typeDate = ReindexIndexStorageTask.this.getEntityTypeDate(storage, session, entityType, isUsedCreateDate);
                                    if (typeDate != null) {
                                        dateList.add(typeDate);
                                    }
                                }
                                catch (Throwable t) {
                                    ReindexIndexStorageTask.this.log.error("error in task", t);
                                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}: {1}", (Object[])new Object[]{entityType.getName(), t.toString()}));
                                    if (!ReindexIndexStorageTask.this.config.isStopOnError() || ReindexIndexStorageTask.this.isToBeStopped()) break block13;
                                    ReindexIndexStorageTask.this.log.debug("stop task");
                                    try {
                                        ReindexIndexStorageTask.this.stop();
                                    }
                                    catch (Exception e) {
                                        ReindexIndexStorageTask.this.log.error("unable to stop task", (Throwable)e);
                                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Object[])new Object[0]));
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                countDown.countDown();
                            }
                        }
                    }
                });
            }
            countDown.await();
        }
        finally {
            service.dispose();
        }
        for (Date typeDate : dateList) {
            if (typeDate == null || result != null && !result.after(typeDate)) continue;
            result = typeDate;
        }
        return result;
    }

    protected Date getEntityTypeDate(PhysicalStorage storage, PhysicalStorageSession session, Class<?> clazz, boolean isUsedCreateDate) throws Exception {
        if (BaseEntity.class.isAssignableFrom(clazz)) {
            return this.getEntityStorageDate(storage, session, clazz, isUsedCreateDate);
        }
        if (BaseAsset.class.isAssignableFrom(clazz)) {
            return this.getAssetStorageDate(storage, session, clazz);
        }
        throw new IllegalArgumentException("Wrong class for reindex task: " + String.valueOf(clazz));
    }

    protected <T extends BaseEntity> Date getEntityStorageDate(PhysicalStorage storage, PhysicalStorageSession session, Class<T> clazz, boolean isUsedCreateDate) throws Exception {
        EntityPhysicalStorage entityPhysicalStorage = storage.getEntityStorage();
        List uidList1 = entityPhysicalStorage.getEntityUids(clazz, null, null, this.config.isUsedCreateDate(), false, SortOrder.DESC, Integer.valueOf(1), session);
        Date date1 = null;
        if (uidList1.size() >= 1) {
            PhysicalEntityData entity1 = entityPhysicalStorage.loadEntity(clazz, (String)uidList1.get(0), null, session);
            date1 = entity1 != null ? (isUsedCreateDate ? entity1.getCreated() : entity1.getModified()) : null;
        }
        return date1;
    }

    protected <A extends BaseAsset> Date getAssetStorageDate(PhysicalStorage storage, PhysicalStorageSession session, Class<A> clazz) throws Exception {
        AssetPhysicalStorage primaryAssetPhysicalStorage = storage.getAssetStorage();
        List uidList1 = primaryAssetPhysicalStorage.getAssetUids(clazz, null, null, SortOrder.DESC, Integer.valueOf(1), session);
        Date date1 = null;
        if (uidList1.size() >= 1) {
            PhysicalAssetData asset1 = primaryAssetPhysicalStorage.loadAsset(clazz, (String)uidList1.get(0), session);
            date1 = asset1.getAsset().getModified();
        }
        return date1;
    }

    protected Collection<Class<?>> getEntityTypeList() throws Exception {
        Set typeList;
        HashSet result = new HashSet();
        MetaRegistry metaRegistry = MetaRegistry.get();
        for (Object value : metaRegistry.getEntities().values()) {
            result.add(Class.forName(value.getId()));
        }
        HibernatePhysicalStorageRegistry hpsr = null;
        try {
            hpsr = (HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class);
        }
        catch (IllegalArgumentException value) {
            // empty catch block
        }
        if (hpsr != null) {
            for (Class assetClass : hpsr.getAssetDataClasses().keySet()) {
                result.add(assetClass);
            }
        }
        if ((typeList = this.config.getTypeList()) != null && typeList.size() > 0) {
            for (Class type : new ArrayList(result)) {
                if (typeList.contains(type.getName())) continue;
                result.remove(type);
            }
        }
        result.remove(ModifiedObjectReference.class);
        result.remove(DeletedObjectReference.class);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E extends BaseEntity> void deleteAllEntityIndexes(PhysicalStorage storage, Class<E> entityClass, LongRunningTask.EventsCallback callback) throws Throwable {
        EntityPhysicalStorage entityPhysicalStorage = storage.getEntityStorage();
        LogicalStorageRegistry storageRegistry = LogicalStorageRegistry.get();
        Collection handlers = storageRegistry.getIndexHandlers(entityClass);
        for (IndexHandler handler : handlers) {
            Class indexClass = handler.getIndexClass();
            if (indexClass == null) {
                throw new Exception(String.format("Internal error: No index class defined in handler %s for entity %s", handler.getClass().getName(), entityClass.getName()));
            }
            try {
                Set<Class<?>> set = this.deletedIndexesClasses;
                synchronized (set) {
                    if (this.deletedIndexesClasses.contains(indexClass)) {
                        continue;
                    }
                    this.deletedIndexesClasses.add(indexClass);
                }
                PhysicalStorageSession session = storage.createSession(null);
                boolean commited = false;
                try {
                    session.begin();
                    entityPhysicalStorage.deleteAllIndexes(indexClass, session);
                    session.commit();
                    commited = true;
                }
                finally {
                    if (!commited) {
                        session.rollback();
                    }
                    session.close();
                }
            }
            catch (Throwable t) {
                if (this.config.isStopOnError()) {
                    throw t;
                }
                this.log.error(String.format("error in task (class %s, index %s): %s", entityClass.getName(), indexClass.getName(), t.toString()), t);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, index {1}: {3}", (Object[])new Object[]{entityClass.getName(), indexClass.getName(), t.toString()}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E extends BaseEntity> boolean processEntityStorage(PhysicalStorage storage, Part part, Class<E> entityClass, LongRunningTask.EventsCallback callback) throws Throwable {
        List uidList;
        if (this.config.isDeleteAllIndexes()) {
            this.deleteAllEntityIndexes(storage, entityClass, callback);
        }
        EntityPhysicalStorage entityPhysicalStorage = storage.getEntityStorage();
        LogicalStorageRegistry storageRegistry = LogicalStorageRegistry.get();
        try (PhysicalStorageSession uidsSession = storage.createSession(null);){
            uidList = entityPhysicalStorage.getEntityUids(entityClass, part.getFrom(), part.getTo(), this.config.isUsedCreateDate(), false, SortOrder.DESC, null, uidsSession);
        }
        for (String uid : uidList) {
            try {
                if (this.isToBeStopped()) {
                    return false;
                }
                Collection handlers = storageRegistry.getIndexHandlers(entityClass);
                for (IndexHandler handler : handlers) {
                    Class indexClass = handler.getIndexClass();
                    if (indexClass == null) {
                        throw new Exception(String.format("Internal error: No index class defined in handler %s for entity %s", handler.getClass().getName(), entityClass.getName()));
                    }
                    try {
                        PhysicalStorageSession session = storage.createSession(null);
                        boolean commited = false;
                        try {
                            session.begin();
                            this.processEntityIndexStorage(storage, session, part, handler, indexClass, uid);
                            session.commit();
                            commited = true;
                        }
                        finally {
                            if (!commited) {
                                session.rollback();
                            }
                            session.close();
                        }
                    }
                    catch (Throwable t) {
                        if (this.config.isStopOnError()) {
                            throw t;
                        }
                        this.log.error(String.format("error in task (class %s, index %s, uid %s): %s", entityClass.getName(), indexClass.getName(), uid, t.toString()), t);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, index {1}, uid {2}: {3}", (Object[])new Object[]{entityClass.getName(), indexClass.getName(), uid, t.toString()}));
                    }
                }
            }
            catch (Throwable t) {
                if (this.config.isStopOnError()) {
                    throw t;
                }
                this.log.error(String.format("error in task (class %s, uid %s): %s", entityClass.getName(), uid, t.toString()), t);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, uid {1}: {2}", (Object[])new Object[]{entityClass.getName(), uid, t.toString()}));
            }
        }
        return true;
    }

    protected <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void processEntityIndexStorage(PhysicalStorage storage, PhysicalStorageSession session, Part part, IndexHandler<E, I> handler, Class<I> indexClass, String uid) throws Throwable {
        Date now = ((TimeService)Environment.getPublished(TimeService.class)).currentDate();
        EntityPhysicalStorage entityPhysicalStorage = storage.getEntityStorage();
        PhysicalEntityData physicalEntityData = entityPhysicalStorage.loadEntity(handler.getEntityType(), uid, null, session);
        List<BaseIndexData> indexes1 = null;
        if (physicalEntityData == null || physicalEntityData.getStatus() == EntityStatus.VOID) {
            indexes1 = Collections.emptyList();
        } else {
            EntityContainer etc = LogicalEntityStorage.toEntityContainer((PhysicalEntityData)physicalEntityData, (int)(physicalEntityData.getVersionsCount() - 1), (PhysicalStorage)storage, (PhysicalStorageSession)session);
            indexes1 = new ArrayList<BaseIndexData>();
            handler.create(etc, indexes1);
            for (BaseIndexData indexData : indexes1) {
                indexData.setUid(UUIDGenerator.generate((boolean)true).toString());
                indexData.setContainerUid(etc.getUid());
                indexData.setEntityType(etc.getEntityType().getName());
                indexData.setReferenceCaption(etc.getEntity().toString());
                indexData.setModified(now);
            }
        }
        Map indexes2 = entityPhysicalStorage.getIndexes(indexClass, uid, session);
        entityPhysicalStorage.deleteIndexes(indexClass, uid, indexes2, session);
        entityPhysicalStorage.saveIndexes(indexClass, Collections.singletonMap(null, indexes1), uid, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <A extends BaseAsset> boolean processAssetStorage(PhysicalStorage storage, Part part, Class<A> assetClass, LongRunningTask.EventsCallback callback) throws Throwable {
        List uidList;
        AssetPhysicalStorage assetPhysicalStorage = storage.getAssetStorage();
        try (PhysicalStorageSession uidsSession = storage.createSession(null);){
            uidList = assetPhysicalStorage.getAssetUids(assetClass, part.getFrom(), part.getTo(), SortOrder.DESC, null, uidsSession);
        }
        for (String uid : uidList) {
            try {
                if (this.isToBeStopped()) {
                    return false;
                }
                try (PhysicalStorageSession session = storage.createSession(null);){
                    PhysicalAssetData asset1 = assetPhysicalStorage.loadAsset(assetClass, uid, session);
                    if (asset1 != null && asset1.getAsset() == null) {
                        throw new Exception(String.format("Internal error: PhysicalAssetData<%s>.getAsset() == null, uid = %s", assetClass.getName(), uid));
                    }
                    if (asset1 == null) {
                        this.log.warn(String.format("asset not found: class %s, uid %s", assetClass.getName(), uid));
                        continue;
                    }
                    boolean commited = false;
                    try {
                        session.begin();
                        assetPhysicalStorage.saveAsset(asset1, asset1, session);
                        session.commit();
                        commited = true;
                    }
                    finally {
                        if (commited) continue;
                        session.rollback();
                    }
                }
            }
            catch (Throwable t) {
                if (this.config.isStopOnError()) {
                    throw t;
                }
                this.log.error(String.format("error in task (class %s, uid %s): %s", assetClass.getName(), uid, t.toString()), t);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, uid {1}: {2}", (Object[])new Object[]{assetClass.getName(), uid, t.toString()}));
            }
        }
        return true;
    }

    protected boolean processEntityType(PhysicalStorage storage, Class<?> clazz, Part part, LongRunningTask.EventsCallback callback) throws Throwable {
        if (BaseEntity.class.isAssignableFrom(clazz)) {
            return this.processEntityStorage(storage, part, clazz, callback);
        }
        if (BaseAsset.class.isAssignableFrom(clazz)) {
            return this.processAssetStorage(storage, part, clazz, callback);
        }
        throw new IllegalArgumentException("Wrong class for reindex task: " + String.valueOf(clazz));
    }

    private static DateFormat createDateTimeFormat() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(final LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("task started");
        final PhysicalStorage storage = this.getStorage();
        Date configDate = this.config.getDate();
        Date startDate = configDate != null ? configDate : this.getDate(this.config.isUsedCreateDate(), callback);
        Date finishDate = this.doneTo != null ? this.doneTo : new Date();
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0443\u0441\u043a\u0430:", (Object[])new Object[0]));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430: {0}", (Object[])new Object[]{startDate != null ? ReindexIndexStorageTask.createDateTimeFormat().format(startDate) + (configDate != null ? "" : " (\u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0430)") : "(\u0432\u044b\u0447\u0438\u0441\u043b\u0438\u0442\u044c \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c)"}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430: {0}", (Object[])new Object[]{ReindexIndexStorageTask.createDateTimeFormat().format(finishDate)}));
        if (this.doneTo != null) {
            this.partList = this.getPartList(startDate, this.doneTo);
        }
        if (this.partList == null) {
            this.partList = this.getPartList(startDate, finishDate);
        }
        Collection<Class<?>> entityTypeList = this.getEntityTypeList();
        int typeCount = entityTypeList.size();
        ExecutorServiceFacade service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool(this.getClass().getName(), this.config.getThreadCount() > 0 ? this.config.getThreadCount() : 1);
        try {
            final int maxCount = this.partList.size() * typeCount;
            if (this.totalCount == -1 || this.totalCount < maxCount) {
                this.totalCount = maxCount;
            }
            final int resumeDelta = this.doneCount = this.totalCount - maxCount;
            final CountDownLatch countDown = new CountDownLatch(maxCount);
            final int pd = Math.max(maxCount / 20, 1);
            for (final Part part : this.partList) {
                part.getDownCount().set(typeCount);
                for (final Class<?> entityType : entityTypeList) {
                    service.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block12: {
                                block11: {
                                    block10: {
                                        if (!ReindexIndexStorageTask.this.isToBeStopped()) break block10;
                                        countDown.countDown();
                                        return;
                                    }
                                    if (ReindexIndexStorageTask.this.processEntityType(storage, entityType, part, callback)) break block11;
                                    countDown.countDown();
                                    return;
                                }
                                try {
                                    try {
                                        part.getDownCount().decrementAndGet();
                                        long current = (long)maxCount - countDown.getCount() + 1L;
                                        byte progress = (byte)(100L * (current + (long)resumeDelta) / (long)(maxCount + resumeDelta));
                                        if ((current + (long)resumeDelta) % (long)pd == 0L || progress >= 100 || ReindexIndexStorageTask.this.isToBeStopped()) {
                                            callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u0438\u0437 {1}", (Object[])new Object[]{current + (long)resumeDelta, maxCount + resumeDelta}));
                                            callback.updateProgress(progress);
                                        }
                                    }
                                    catch (Throwable t) {
                                        ReindexIndexStorageTask.this.log.error("error in task", t);
                                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}: {1}", (Object[])new Object[]{entityType.getName(), t.toString()}));
                                        if (!ReindexIndexStorageTask.this.config.isStopOnError() || ReindexIndexStorageTask.this.isToBeStopped()) break block12;
                                        ReindexIndexStorageTask.this.log.debug("stop task");
                                        try {
                                            ReindexIndexStorageTask.this.stop();
                                        }
                                        catch (Exception e) {
                                            ReindexIndexStorageTask.this.log.error("unable to stop task", (Throwable)e);
                                            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Object[])new Object[0]));
                                        }
                                    }
                                }
                                finally {
                                    countDown.countDown();
                                }
                            }
                        }
                    });
                }
            }
            countDown.await();
        }
        finally {
            service.dispose();
        }
        callback.taskFinished();
        this.log.debug("task finished");
    }

    public void toXML(Element elm) throws Exception {
        this.config.toXML(elm);
        XHelper.writeInt((Element)elm, (String)"totalCount", (int)this.totalCount);
        if (this.partList != null) {
            Date date = null;
            for (Part part : this.partList) {
                if (part.getDownCount().get() != 0) break;
                date = part.getFrom();
                ++this.doneCount;
            }
            if (date != null) {
                XHelper.writeDate((Element)elm, (String)"doneTo", date);
            }
        }
        XHelper.writeInt((Element)elm, (String)"doneCount", (int)this.doneCount);
        for (Class<?> clazz : this.deletedIndexesClasses) {
            XHelper.writeString((Element)elm, (String)"deletedIndexesClasses/item", (String)clazz.getName());
        }
    }

    public void fromXML(Element elm) throws Exception {
        this.config = new ReindexIndexStorageTaskConfiguration();
        this.config.fromXML(elm);
        this.totalCount = XHelper.readInt((Element)elm, (String)"totalCount", (int)-1);
        this.doneCount = XHelper.readInt((Element)elm, (String)"doneCount", (int)0);
        this.doneTo = XHelper.readDate((Element)elm, (String)"doneTo");
        this.deletedIndexesClasses.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"deletedIndexesClasses/item")) {
            String className = XHelper.readString((Element)itemElm, (String)".");
            Class clazz = XHelper.getClass((String)className);
            this.deletedIndexesClasses.add(clazz);
        }
    }

    protected static class Part {
        private final Date from;
        private final Date to;
        private final AtomicInteger downCount = new AtomicInteger(-1);

        public Part(Date from, Date to) {
            this.from = from;
            this.to = to;
        }

        public Date getFrom() {
            return this.from;
        }

        public Date getTo() {
            return this.to;
        }

        public AtomicInteger getDownCount() {
            return this.downCount;
        }
    }
}

