/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityActualizer;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.ReindexLogicalStorageTaskConfiguration;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseEntityUpdateTask;
import java.util.Collection;
import org.w3c.dom.Element;

public class ReindexLogicalStorageTask
extends BaseEntityUpdateTask<ReindexLogicalStorageTaskConfiguration> {
    private IndexHandler<?, ?> handler = null;

    @Override
    public void configure(ReindexLogicalStorageTaskConfiguration configuration) throws Exception {
        super.configure(configuration);
        this.updateHandler();
    }

    protected void updateHandler() throws Exception {
        String singleIndex = ((ReindexLogicalStorageTaskConfiguration)this.config).getSingleIndex();
        if (!TextUtil.isBlank((String)singleIndex)) {
            Class indexClass = XHelper.getClass((String)singleIndex);
            Collection<Class<?>> types = this.getEntityTypeList();
            if (types.size() != 1) {
                throw Xeption.forDeveloper((String)"Invalid types size (have got {0}, but must be 1)", (Object[])new Object[]{types.size()});
            }
            Class<?> entityClass = types.iterator().next();
            Collection handlers = LogicalStorageRegistry.get().getIndexHandlers(entityClass);
            for (IndexHandler indexHandler : handlers) {
                if (!indexClass.equals(indexHandler.getIndexClass())) continue;
                this.handler = indexHandler;
                break;
            }
            if (null == this.handler) {
                throw Xeption.forDeveloper((String)"No handler found (entity {0}, index {1})", (Object[])new Object[]{entityClass.getName(), singleIndex});
            }
        }
    }

    @Override
    protected void printParameters(LongRunningTask.EventsCallback callback) {
        String singleIndex = ((ReindexLogicalStorageTaskConfiguration)this.config).getSingleIndex();
        if (!TextUtil.isBlank((String)singleIndex)) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  single index: {1} ({0})", (Object[])new Object[]{((ReindexLogicalStorageTaskConfiguration)this.config).getSingleIndex(), ((IndexType)MetaRegistry.get().getIndexes().get(singleIndex)).getDisplayName()}));
        }
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.ReindexLogicalStorageTask_description, (Object[])new Object[0]);
    }

    @Override
    protected <E extends BaseEntity> void processContainer(EntityContainer<E> ctr, LogicalEntityStorage storage, Object data) {
        EntityActualizer actualizer = EntityActualizer.newInstance();
        actualizer.getEntityStorageActualizeParameters().processedUncachedEntity(false).useRemoteCallIfNecessary(true);
        actualizer.actualize((Object)ctr.getEntity());
        if (this.handler != null) {
            storage.updateIndex(ctr, ctr, this.handler, false);
            return;
        }
        storage.updateIndexes(ctr, ctr, false);
    }

    @Override
    protected Class<ReindexLogicalStorageTaskConfiguration> getConfigurationClass() {
        return ReindexLogicalStorageTaskConfiguration.class;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.updateHandler();
    }
}

