/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class ReindexProductsDuplicatesTask
extends BaseScheduledTask {
    private final String DB_PROPERTY_NAME = "reindex-products-duplicates-timestamp";
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-sss");
    private final Integer limit = 100000;

    protected void doJob() throws Exception {
        Date fromDate;
        String timeStampStr = LogicalStorage.get().getDbPropertiesStorage().getValue("reindex-products-duplicates-timestamp");
        this.log.debug("current timestamp = " + timeStampStr);
        Date currentDate = new Date();
        if (this.log.isDebugEnabled()) {
            this.log.debug("current date is " + this.sdf.format(currentDate));
        }
        if (TextUtil.isBlank((String)timeStampStr)) {
            LogicalStorage.get().getDbPropertiesStorage().putValue("reindex-products-duplicates-timestamp", this.sdf.format(currentDate));
            this.log.debug("set timestamp to current date");
            return;
        }
        try {
            fromDate = this.sdf.parse(timeStampStr);
        }
        catch (Exception e) {
            this.log.error("unable to parse timestamp, setting it to current date", (Throwable)e);
            LogicalStorage.get().getDbPropertiesStorage().putValue("reindex-products-duplicates-timestamp", this.sdf.format(currentDate));
            return;
        }
        List uids = LogicalStorage.get().getEntityStorage().getEntityUids(BookingFile.class, fromDate, null, false, true, SortOrder.ASC, this.limit);
        int size = uids.size();
        this.log.debug("received uids from db, size =" + size);
        if (size == this.limit) {
            LogicalStorage.get().getDbPropertiesStorage().putValue("reindex-products-duplicates-timestamp", this.sdf.format(currentDate));
            this.log.debug("size is equal limit, settings to current date");
            return;
        }
        for (String uid : uids) {
            this.log.debug("processing booking with uid " + uid);
            if (!this.hasNavigationKeyDuplicates(uid, CommonProductIndex.class)) continue;
            this.log.debug("commonproduct indexes have duplicated navigation keys, reindexind");
            EntityContainer bookingCtr = EntityStorage.get().load(BookingFile.class, uid);
            if (bookingCtr == null) continue;
            LogicalStorage.get().getEntityStorage().updateIndexes(bookingCtr, bookingCtr, true);
            this.log.debug("commonproduct indexes have duplicated navigation keys, reindexind");
            this.log.debug("booking indexes were rebuilt");
        }
        LogicalStorage.get().getDbPropertiesStorage().putValue("reindex-products-duplicates-timestamp", this.sdf.format(currentDate));
        this.log.debug("setting timestamp to current date");
    }

    private boolean hasNavigationKeyDuplicates(String uid, Class<CommonProductIndex> commonProductIndexClass) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)uid));
        query.getPreferredProperties().add("navigationKey");
        List navigationKeys = EntityStorage.get().search(commonProductIndexClass, query).getData().stream().map(idx -> idx.getNavigationKey()).collect(Collectors.toList());
        return navigationKeys.size() > new HashSet(navigationKeys).size();
    }
}

