/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.cache.asset.ModifiedObjectReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.export.ExportDocument;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.RepairSecondaryStorageTaskConfiguration;
import com.gridnine.xtrip.common.model.tasks.standard.DeletedObjectReference;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryMetadata;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionMetadataData;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.exception.ConstraintViolationException;
import org.w3c.dom.Element;

public class RepairSecondaryStorageTask
extends BaseLongRunningTask<RepairSecondaryStorageTaskConfiguration> {
    protected volatile RepairSecondaryStorageTaskConfiguration config;
    private volatile List<Part> partList = null;
    private volatile int totalCount = -1;
    private volatile AtomicInteger doneCount = new AtomicInteger(0);
    protected volatile boolean isDBPropertiesStorageProcessed = false;
    protected volatile boolean isBulkDictionaryStorageProcessed = false;
    protected AtomicInteger errorCount = new AtomicInteger();
    protected Date doneTo;

    @Override
    public void configure(RepairSecondaryStorageTaskConfiguration configuration) throws Exception {
        this.config = configuration;
    }

    protected PhysicalStorage getPrimaryStorage() {
        LogicalStorageRegistry registry = LogicalStorageRegistry.get();
        String uid = this.config.getPrimaryStorageUid();
        if (uid == null) {
            throw new IllegalStateException("Primary storage isn't defined");
        }
        PhysicalStorage storage = registry.getStorage(uid);
        if (storage == null) {
            throw new IllegalStateException("Primary storage isn't found: " + uid);
        }
        return storage;
    }

    protected PhysicalStorage getSecondaryStorage() {
        LogicalStorageRegistry registry = LogicalStorageRegistry.get();
        String uid = this.config.getSecondaryStorageUid();
        if (uid == null) {
            throw new IllegalStateException("Secondary storage isn't defined");
        }
        PhysicalStorage storage = registry.getStorage(uid);
        if (storage == null) {
            throw new IllegalStateException("Secondary storage isn't found: " + uid);
        }
        return storage;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.RepairSecondaryStorageTask_description, (Object[])new Object[0]);
    }

    protected List<Part> getPartList(Date configDate, Date date) throws Exception {
        ArrayList<Part> result = new ArrayList<Part>();
        if (configDate == null) {
            return result;
        }
        int ch = this.config.getHours();
        int hours = ch > 0 ? ch : (ch != -1 ? 24 : Integer.MAX_VALUE);
        Calendar current = Calendar.getInstance();
        if (date != null) {
            current.setTime(date);
        }
        Calendar next = Calendar.getInstance();
        while (current.getTimeInMillis() > configDate.getTime()) {
            next.setTimeInMillis(current.getTimeInMillis());
            next.add(10, -hours);
            if (next.getTimeInMillis() < configDate.getTime()) {
                next.setTimeInMillis(configDate.getTime());
            }
            result.add(new Part(next.getTime(), current.getTime()));
            current.add(10, -hours);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getDate(final boolean isUsedCreateDate, final LongRunningTask.EventsCallback callback) throws Exception {
        Collection<Class<?>> entityTypeList = this.getEntityTypeList();
        entityTypeList.remove(PhysicalBulkDictionaryData.class);
        entityTypeList.remove(RepairSecondaryStorageTaskConfiguration.DBPropertiesType.class);
        final PhysicalStorage primaryPhysicalStorage = this.getPrimaryStorage();
        final PhysicalStorage secondaryPhysicalStorage = this.getSecondaryStorage();
        Date result = null;
        final LinkedBlockingDeque dateList = new LinkedBlockingDeque();
        ExecutorServiceFacade service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool(this.getClass().getName(), this.config.getThreadCount() > 0 ? this.config.getThreadCount() : 1);
        final CountDownLatch countDown = new CountDownLatch(entityTypeList.size());
        try {
            for (final Class<?> entityType : entityTypeList) {
                service.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block16: {
                            block15: {
                                if (!RepairSecondaryStorageTask.this.isToBeStopped()) break block15;
                                countDown.countDown();
                                return;
                            }
                            try {
                                try (PhysicalStorageSession primarySession = primaryPhysicalStorage.createSession(null);
                                     PhysicalStorageSession secondarySession = secondaryPhysicalStorage.createSession(null);){
                                    Date typeDate = RepairSecondaryStorageTask.this.getEntityTypeDate(primaryPhysicalStorage, primarySession, secondaryPhysicalStorage, secondarySession, entityType, isUsedCreateDate);
                                    if (typeDate != null) {
                                        dateList.add(typeDate);
                                    }
                                }
                                catch (Throwable t) {
                                    RepairSecondaryStorageTask.this.errorCount.incrementAndGet();
                                    RepairSecondaryStorageTask.this.log.error("error in task", t);
                                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}: {1}", (Object[])new Object[]{entityType.getName(), ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                                    if (!RepairSecondaryStorageTask.this.config.isStopOnError() || RepairSecondaryStorageTask.this.isToBeStopped()) break block16;
                                    RepairSecondaryStorageTask.this.log.debug("stop task");
                                    try {
                                        RepairSecondaryStorageTask.this.stop();
                                    }
                                    catch (Exception e) {
                                        RepairSecondaryStorageTask.this.log.error("unable to stop task", (Throwable)e);
                                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Object[])new Object[0]));
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                countDown.countDown();
                            }
                        }
                    }
                });
            }
            countDown.await();
        }
        finally {
            service.dispose();
        }
        for (Date typeDate : dateList) {
            if (typeDate == null || result != null && !result.after(typeDate)) continue;
            result = typeDate;
        }
        return result;
    }

    protected Date getEntityTypeDate(PhysicalStorage primaryPhysicalStorage, PhysicalStorageSession primarySession, PhysicalStorage secondaryPhysicalStorage, PhysicalStorageSession secondarySession, Class<?> clazz, boolean isUsedCreateDate) throws Exception {
        if (BaseDictionary.class.isAssignableFrom(clazz)) {
            return this.getDictionaryStorageDate(primaryPhysicalStorage, primarySession, secondaryPhysicalStorage, secondarySession, clazz, isUsedCreateDate);
        }
        if (BaseEntity.class.isAssignableFrom(clazz)) {
            return this.getEntityStorageDate(primaryPhysicalStorage, primarySession, secondaryPhysicalStorage, secondarySession, clazz, isUsedCreateDate);
        }
        if (BaseAsset.class.isAssignableFrom(clazz)) {
            return this.getAssetStorageDate(primaryPhysicalStorage, primarySession, secondaryPhysicalStorage, secondarySession, clazz);
        }
        throw new IllegalArgumentException("Wrong class for repair task: " + String.valueOf(clazz));
    }

    protected <T extends BaseEntity> Date getEntityStorageDate(PhysicalStorage primaryPhysicalStorage, PhysicalStorageSession primarySession, PhysicalStorage secondaryPhysicalStorage, PhysicalStorageSession secondarySession, Class<T> clazz, boolean isUsedCreateDate) throws Exception {
        EntityPhysicalStorage primaryEntityPhysicalStorage = primaryPhysicalStorage.getEntityStorage();
        List<String> uidList1 = this.getEntityUids(primaryEntityPhysicalStorage, clazz, null, null, this.config.isUsedCreateDate(), false, SortOrder.DESC, 1, primarySession);
        Date date1 = null;
        if (uidList1.size() >= 1) {
            PhysicalEntityData entity1 = primaryEntityPhysicalStorage.loadEntity(clazz, uidList1.get(0), null, primarySession);
            date1 = entity1 != null ? (isUsedCreateDate ? entity1.getCreated() : entity1.getModified()) : null;
        }
        EntityPhysicalStorage secondaryEntityPhysicalStorage = secondaryPhysicalStorage.getEntityStorage();
        List<String> uidList2 = this.getEntityUids(secondaryEntityPhysicalStorage, clazz, null, null, this.config.isUsedCreateDate(), false, SortOrder.DESC, 1, secondarySession);
        Date date2 = null;
        if (uidList2.size() >= 1) {
            PhysicalEntityData entity2 = secondaryEntityPhysicalStorage.loadEntity(clazz, uidList2.get(0), null, secondarySession);
            Date date = entity2 != null ? (isUsedCreateDate ? entity2.getCreated() : entity2.getModified()) : (date2 = null);
        }
        return date1 == null ? date2 : (date2 == null ? date1 : (date1.before(date2) ? date1 : date2));
    }

    protected <D extends BaseDictionary> Date getDictionaryStorageDate(PhysicalStorage primaryPhysicalStorage, PhysicalStorageSession primarySession, PhysicalStorage secondaryPhysicalStorage, PhysicalStorageSession secondarySession, Class<D> clazz, boolean isUsedCreateDate) throws Exception {
        DictionaryPhysicalStorage primaryDictionaryPhysicalStorage = primaryPhysicalStorage.getDictionaryStorage();
        List uidList1 = primaryDictionaryPhysicalStorage.getDictionaryUids(clazz, null, null, this.config.isUsedCreateDate(), false, SortOrder.DESC, Integer.valueOf(1), primarySession);
        Date date1 = null;
        if (uidList1.size() >= 1) {
            PhysicalDictionaryData dictionary1 = primaryDictionaryPhysicalStorage.findDictionaryByUid(clazz, (String)uidList1.get(0), false, primarySession);
            date1 = dictionary1 != null ? (isUsedCreateDate ? dictionary1.getCreated() : dictionary1.getModified()) : null;
        }
        DictionaryPhysicalStorage secondaryDictionaryPhysicalStorage = secondaryPhysicalStorage.getDictionaryStorage();
        List uidList2 = secondaryDictionaryPhysicalStorage.getDictionaryUids(clazz, null, null, this.config.isUsedCreateDate(), false, SortOrder.DESC, Integer.valueOf(1), secondarySession);
        Date date2 = null;
        if (uidList2.size() >= 1) {
            PhysicalDictionaryData dictionary2 = secondaryDictionaryPhysicalStorage.findDictionaryByUid(clazz, (String)uidList2.get(0), false, secondarySession);
            Date date = dictionary2 != null ? (isUsedCreateDate ? dictionary2.getCreated() : dictionary2.getModified()) : (date2 = null);
        }
        return date1 == null ? date2 : (date2 == null ? date1 : (date1.before(date2) ? date1 : date2));
    }

    protected <A extends BaseAsset> Date getAssetStorageDate(PhysicalStorage primaryPhysicalStorage, PhysicalStorageSession primarySession, PhysicalStorage secondaryPhysicalStorage, PhysicalStorageSession secondarySession, Class<A> clazz) throws Exception {
        AssetPhysicalStorage primaryAssetPhysicalStorage = primaryPhysicalStorage.getAssetStorage();
        List uidList1 = primaryAssetPhysicalStorage.getAssetUids(clazz, null, null, SortOrder.DESC, Integer.valueOf(1), primarySession);
        Date date1 = null;
        if (uidList1.size() >= 1) {
            PhysicalAssetData asset1 = primaryAssetPhysicalStorage.loadAsset(clazz, (String)uidList1.get(0), primarySession);
            date1 = asset1.getAsset().getModified();
        }
        AssetPhysicalStorage secondaryAssetPhysicalStorage = secondaryPhysicalStorage.getAssetStorage();
        List uidList2 = secondaryAssetPhysicalStorage.getAssetUids(clazz, null, null, SortOrder.DESC, Integer.valueOf(1), secondarySession);
        Date date2 = null;
        if (uidList2.size() >= 1) {
            PhysicalAssetData asset2 = secondaryAssetPhysicalStorage.loadAsset(clazz, (String)uidList2.get(0), secondarySession);
            date2 = asset2.getAsset().getModified();
        }
        return date1 == null ? date2 : (date2 == null ? date1 : (date1.before(date2) ? date1 : date2));
    }

    protected Collection<Class<?>> getEntityTypeList() throws Exception {
        Set typeList;
        HashSet result = new HashSet();
        result.add(PhysicalBulkDictionaryData.class);
        result.add(RepairSecondaryStorageTaskConfiguration.DBPropertiesType.class);
        MetaRegistry metaRegistry = MetaRegistry.get();
        for (Object value : metaRegistry.getEntities().values()) {
            if (!MetaRegistryHelper.isRoot((EntityType)value) || value.isAbstract()) continue;
            result.add(Class.forName(value.getId()));
        }
        for (IndexType indexType : metaRegistry.getIndexes().values()) {
            Class<?> entityClazz = Class.forName(indexType.getEntityId());
            for (EntityType value : metaRegistry.getEntities().values()) {
                Class<?> clazz;
                if (value.isAbstract() || result.contains(clazz = Class.forName(value.getId())) || !entityClazz.isAssignableFrom(clazz)) continue;
                result.add(clazz);
            }
        }
        for (Object value : metaRegistry.getDictionaries().values()) {
            if (value.isAbstract()) continue;
            result.add(Class.forName(value.getId()));
        }
        HibernatePhysicalStorageRegistry hpsr = null;
        try {
            hpsr = (HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class);
        }
        catch (IllegalArgumentException value) {
            // empty catch block
        }
        if (hpsr != null) {
            for (Class assetClass : hpsr.getAssetDataClasses().keySet()) {
                result.add(assetClass);
            }
        }
        if ((typeList = this.config.getTypeList()) != null && typeList.size() > 0) {
            for (Class type : new ArrayList(result)) {
                if (typeList.contains(type.getName())) continue;
                result.remove(type);
            }
        }
        result.remove(ModifiedObjectReference.class);
        result.remove(DeletedObjectReference.class);
        return result;
    }

    protected <E extends BaseEntity> List<String> getEntityUids(EntityPhysicalStorage entityPhysicalStorage, Class<E> cls, Date startDate, Date endDate, boolean useCreateDate, boolean ignoreVoid, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        return entityPhysicalStorage.getEntityUids(cls, startDate, endDate, useCreateDate, ignoreVoid, sortOrder, limit, session);
    }

    /*
     * Exception decompiling
     */
    protected <T extends BaseEntity> boolean processEntityStorage(PhysicalStorage primaryPhysicalStorage, PhysicalStorage secondaryPhysicalStorage, Part part, Class<T> entityClass, LongRunningTask.EventsCallback callback) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void deleteEntityIndex(EntityPhysicalStorage secondaryEntityPhysicalStorage, PhysicalStorageSession secondarySession, Class<I> indexClass, String uid) throws Exception {
        Map indexes2 = secondaryEntityPhysicalStorage.getIndexes(indexClass, uid, secondarySession);
        secondaryEntityPhysicalStorage.deleteIndexes(indexClass, uid, indexes2, secondarySession);
    }

    protected <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void saveEntityIndexStorage(EntityPhysicalStorage primaryEntityPhysicalStorage, PhysicalStorageSession primarySession, EntityPhysicalStorage secondaryEntityPhysicalStorage, PhysicalStorageSession secondarySession, Class<I> indexClass, String uid) throws Exception {
        Map indexes1 = primaryEntityPhysicalStorage.getIndexes(indexClass, uid, primarySession);
        Map.Entry first = indexes1.entrySet().iterator().next();
        if (first != null) {
            secondaryEntityPhysicalStorage.saveIndexes(indexClass, Collections.singletonMap(null, first.getValue()), uid, secondarySession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <D extends BaseDictionary> boolean processDictionaryStorage(PhysicalStorage primaryPhysicalStorage, PhysicalStorage secondaryPhysicalStorage, Part part, Class<D> dictionaryClass, LongRunningTask.EventsCallback callback) throws Throwable {
        block62: {
            PhysicalStorageSession secondarySession;
            PhysicalDictionaryData dictionary1;
            PhysicalStorageSession primarySession;
            DictionaryPhysicalStorage primaryDictionaryPhysicalStorage = primaryPhysicalStorage.getDictionaryStorage();
            DictionaryPhysicalStorage secondaryDictionaryPhysicalStorage = secondaryPhysicalStorage.getDictionaryStorage();
            if (this.config.isFirstPass()) {
                List uidList;
                try (PhysicalStorageSession primaryUidsSession = primaryPhysicalStorage.createSession(null);){
                    uidList = primaryDictionaryPhysicalStorage.getDictionaryUids(dictionaryClass, part.getFrom(), part.getTo(), this.config.isUsedCreateDate(), false, SortOrder.DESC, null, primaryUidsSession);
                }
                block42: for (String uid : uidList) {
                    if (this.isToBeStopped()) {
                        return false;
                    }
                    try {
                        primarySession = primaryPhysicalStorage.createSession(null);
                        try {
                            dictionary1 = primaryDictionaryPhysicalStorage.findDictionaryByUid(dictionaryClass, uid, false, primarySession);
                            if (dictionary1 == null) {
                                this.log.warn(String.format("dictionary isn't found: class %s, uid %s", dictionaryClass.getName(), uid));
                                continue;
                            }
                            secondarySession = secondaryPhysicalStorage.createSession(null);
                            try {
                                PhysicalDictionaryData dictionary2;
                                boolean constraintCaught = false;
                                while (!this.isDictionariesEqual(dictionary1, dictionary2 = secondaryDictionaryPhysicalStorage.findDictionaryByUid(dictionaryClass, uid, false, secondarySession))) {
                                    dictionary1.getContext().clear();
                                    try {
                                        boolean commited = false;
                                        try {
                                            secondarySession.begin();
                                            secondaryDictionaryPhysicalStorage.saveDictionary(dictionary1, dictionary2, secondarySession);
                                            secondarySession.commit();
                                            commited = true;
                                        }
                                        finally {
                                            if (!commited) {
                                                secondarySession.rollback();
                                            }
                                        }
                                    }
                                    catch (ConstraintViolationException e) {
                                        if (dictionary2 != null || constraintCaught) {
                                            throw e;
                                        }
                                        constraintCaught = true;
                                        continue;
                                    }
                                    dictionary1.getContext().clear();
                                    continue block42;
                                }
                            }
                            finally {
                                secondarySession.close();
                            }
                        }
                        finally {
                            primarySession.close();
                        }
                    }
                    catch (Throwable t) {
                        if (this.config.isStopOnError()) {
                            throw t;
                        }
                        this.errorCount.incrementAndGet();
                        this.log.error(String.format("error in task (class %s, uid %s): %s", dictionaryClass.getName(), uid, t.toString()), t);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, uid {1}: {2}", (Object[])new Object[]{dictionaryClass.getName(), uid, ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                    }
                }
            }
            if (!this.config.isSecondPass()) break block62;
            if (this.config.isRightSecondPass()) {
                List uidList2;
                try (PhysicalStorageSession secondaryUidsSession = secondaryPhysicalStorage.createSession(null);){
                    uidList2 = secondaryDictionaryPhysicalStorage.getDictionaryUids(dictionaryClass, part.getFrom(), part.getTo(), this.config.isUsedCreateDate(), false, SortOrder.DESC, null, secondaryUidsSession);
                }
                for (String uid : uidList2) {
                    if (this.isToBeStopped()) {
                        return false;
                    }
                    try {
                        primarySession = primaryPhysicalStorage.createSession(null);
                        try {
                            dictionary1 = primaryDictionaryPhysicalStorage.findDictionaryByUid(dictionaryClass, uid, false, primarySession);
                            if (dictionary1 != null) continue;
                            secondarySession = secondaryPhysicalStorage.createSession(null);
                            try {
                                PhysicalDictionaryData dictionary2 = secondaryDictionaryPhysicalStorage.findDictionaryByUid(dictionaryClass, uid, false, secondarySession);
                                if (dictionary2 == null) continue;
                                boolean commited = false;
                                try {
                                    secondarySession.begin();
                                    secondaryDictionaryPhysicalStorage.deleteDictionary(dictionary2, secondarySession);
                                    secondarySession.commit();
                                    commited = true;
                                }
                                finally {
                                    if (commited) continue;
                                    secondarySession.rollback();
                                }
                            }
                            finally {
                                secondarySession.close();
                            }
                        }
                        finally {
                            primarySession.close();
                        }
                    }
                    catch (Throwable t) {
                        if (this.config.isStopOnError()) {
                            throw t;
                        }
                        this.errorCount.incrementAndGet();
                        this.log.error(String.format("error in task (class %s, uid %s): %s", dictionaryClass.getName(), uid, t.toString()), t);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, uid {1}: {2}", (Object[])new Object[]{dictionaryClass.getName(), uid, ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                    }
                }
            } else {
                List deletedList;
                try (PhysicalStorageSession primaryUidsSession2 = primaryPhysicalStorage.createSession(null);){
                    SearchQuery searchQuery = new SearchQuery();
                    searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)DeletedObjectReference.Property.refType.name(), (Object)dictionaryClass.getName()));
                    searchQuery.getCriteria().getCriterions().add(SearchCriterion.ge((String)DeletedObjectReference.Property.refDeleted.name(), (Object)part.getFrom()));
                    searchQuery.getCriteria().getCriterions().add(SearchCriterion.le((String)DeletedObjectReference.Property.refDeleted.name(), (Object)part.getTo()));
                    SearchResult searchResult = primaryPhysicalStorage.getAssetStorage().searchAssets(DeletedObjectReference.class, searchQuery, primaryUidsSession2);
                    deletedList = searchResult.getData();
                }
                for (DeletedObjectReference data : deletedList) {
                    if (this.isToBeStopped()) {
                        return false;
                    }
                    try (PhysicalStorageSession secondarySession2 = secondaryPhysicalStorage.createSession(null);){
                        PhysicalDictionaryData dictionary2 = secondaryDictionaryPhysicalStorage.findDictionaryByUid(dictionaryClass, data.getRefUid(), false, secondarySession2);
                        if (dictionary2 == null) continue;
                        boolean commited = false;
                        try {
                            secondarySession2.begin();
                            secondaryDictionaryPhysicalStorage.deleteDictionary(dictionary2, secondarySession2);
                            secondarySession2.commit();
                            commited = true;
                        }
                        finally {
                            if (commited) continue;
                            secondarySession2.rollback();
                        }
                    }
                    catch (Throwable t) {
                        if (this.config.isStopOnError()) {
                            throw t;
                        }
                        this.errorCount.incrementAndGet();
                        this.log.error(String.format("error in task (class %s, uid %s): %s", dictionaryClass.getName(), data.getRefUid(), t.toString()), t);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, uid {1}: {2}", (Object[])new Object[]{dictionaryClass.getName(), data.getRefUid(), ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected <A extends BaseAsset> boolean processAssetStorage(PhysicalStorage primaryPhysicalStorage, PhysicalStorage secondaryPhysicalStorage, Part part, Class<A> assetClass, LongRunningTask.EventsCallback callback) throws Throwable {
        block87: {
            AssetPhysicalStorage primaryAssetPhysicalStorage = primaryPhysicalStorage.getAssetStorage();
            AssetPhysicalStorage secondaryAssetPhysicalStorage = secondaryPhysicalStorage.getAssetStorage();
            this.log.debug(String.format("starting first pass for asset %s, startDate = %s, endDate = %s", MiscUtil.getSimpleClassName(assetClass), part.getFrom(), part.getTo()));
            if (this.config.isFirstPass()) {
                List uidList;
                try (PhysicalStorageSession primaryUidsSession = primaryPhysicalStorage.createSession(null);){
                    uidList = primaryAssetPhysicalStorage.getAssetUids(assetClass, part.getFrom(), part.getTo(), SortOrder.DESC, null, primaryUidsSession);
                }
                int size = uidList.size();
                int idx = 0;
                this.log.debug(String.format("got %s uids of asset %s to proceed", MiscUtil.getSimpleClassName(assetClass), Integer.toString(size)));
                LockManager lm = LockUtil.getLockManager();
                block62: for (String uid : uidList) {
                    NamedLock lock = lm.getLock((Object)LockUtil.getLockKey((String)uid, assetClass));
                    Throwable throwable = null;
                    try {
                        PhysicalAssetData asset1;
                        PhysicalStorageSession primarySession;
                        block84: {
                            block83: {
                                lock.lock();
                                this.log.debug(String.format("processing asset %s whith uid %s, progress = %s from %s %s%%", MiscUtil.getSimpleClassName(assetClass), uid, Integer.toString(idx), Integer.toString(size), Math.round((double)idx * 100.0 / (double)size)));
                                ++idx;
                                if (!this.isToBeStopped()) break block83;
                                boolean bl = false;
                                lock.unlock();
                                return bl;
                            }
                            primarySession = primaryPhysicalStorage.createSession(null);
                            asset1 = primaryAssetPhysicalStorage.loadAsset(assetClass, uid, primarySession);
                            if (asset1 != null && asset1.getAsset() == null) {
                                throw new Exception(String.format("Internal error: PhysicalAssetData<%s>.getAsset() == null, uid = %s", assetClass.getName(), uid));
                            }
                            if (asset1 != null) break block84;
                            this.log.warn(String.format("asset isn't found: class %s, uid %s", assetClass.getName(), uid));
                            primarySession.close();
                            lock.unlock();
                            continue;
                        }
                        try {
                            try {
                                PhysicalStorageSession secondarySession = secondaryPhysicalStorage.createSession(null);
                                try {
                                    boolean constraintCaught = false;
                                    while (true) {
                                        PhysicalAssetData asset2;
                                        if ((asset2 = secondaryAssetPhysicalStorage.loadAsset(assetClass, uid, secondarySession)) != null && asset2.getAsset() == null) {
                                            throw new Exception(String.format("Internal error: PhysicalAssetData<%s>.getAsset() == null, uid = %s", assetClass.getName(), uid));
                                        }
                                        if (this.isAssetsEquals(asset1, asset2)) continue block62;
                                        asset1.getContext().clear();
                                        if (asset1.getAsset().getModified() == null) {
                                            asset1.getAsset().setModified(new Date());
                                        }
                                        try {
                                            boolean commited = false;
                                            try {
                                                secondarySession.begin();
                                                secondaryAssetPhysicalStorage.saveAsset(asset1, asset2, secondarySession);
                                                secondarySession.commit();
                                                commited = true;
                                            }
                                            finally {
                                                if (!commited) {
                                                    secondarySession.rollback();
                                                }
                                            }
                                        }
                                        catch (ConstraintViolationException e) {
                                            if (asset2 != null || constraintCaught) {
                                                throw e;
                                            }
                                            constraintCaught = true;
                                            continue;
                                        }
                                        break;
                                    }
                                    asset1.getContext().clear();
                                    continue;
                                }
                                finally {
                                    secondarySession.close();
                                    continue;
                                }
                                {
                                    catch (Throwable throwable2) {
                                        throw throwable2;
                                    }
                                }
                                finally {
                                    primarySession.close();
                                }
                            }
                            catch (Throwable t) {
                                if (this.config.isStopOnError()) {
                                    throw t;
                                }
                                this.errorCount.incrementAndGet();
                                this.log.error(String.format("error in task (class %s, uid %s): %s", assetClass.getName(), uid, t.toString()), t);
                                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, uid {1}: {2}", (Object[])new Object[]{assetClass.getName(), uid, ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                            }
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    catch (Throwable t) {
                        throwable = t;
                        throw t;
                    }
                    finally {
                        if (lock == null) continue;
                        if (throwable != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        lock.close();
                    }
                }
            }
            if (!this.config.isSecondPass()) break block87;
            this.log.debug(String.format("starting second pass for asset %s, startDate = %s, endDate = %s", MiscUtil.getSimpleClassName(assetClass), part.getFrom(), part.getTo()));
            if (this.config.isRightSecondPass()) {
                List uidList2;
                try (PhysicalStorageSession secondaryUidsSession = secondaryPhysicalStorage.createSession(null);){
                    uidList2 = secondaryAssetPhysicalStorage.getAssetUids(assetClass, part.getFrom(), part.getTo(), SortOrder.DESC, null, secondaryUidsSession);
                }
                int idx = 0;
                int size = uidList2.size();
                this.log.debug(String.format("got %s uids of asset %s to proceed", MiscUtil.getSimpleClassName(assetClass), Integer.toString(size)));
                for (String uid : uidList2) {
                    try {
                        this.log.debug(String.format("processing asset %s whith uid %s, progress = %s from %s %s%%", MiscUtil.getSimpleClassName(assetClass), uid, Integer.toString(idx), Integer.toString(size), Math.round((double)idx * 100.0 / (double)size)));
                        ++idx;
                        if (this.isToBeStopped()) {
                            return false;
                        }
                        try (PhysicalStorageSession primarySession = primaryPhysicalStorage.createSession(null);){
                            boolean exists = primaryAssetPhysicalStorage.isAssetExist(assetClass, uid, primarySession);
                            if (exists) continue;
                            try (PhysicalStorageSession secondarySession = secondaryPhysicalStorage.createSession(null);){
                                PhysicalAssetData asset2 = secondaryAssetPhysicalStorage.loadAsset(assetClass, uid, secondarySession);
                                if (asset2 != null && asset2.getAsset() == null) {
                                    throw new Exception(String.format("Internal error: PhysicalAssetData<%s>.getAsset() == null, uid = %s", assetClass.getName(), uid));
                                }
                                if (asset2 == null) continue;
                                boolean commited = false;
                                try {
                                    secondarySession.begin();
                                    secondaryAssetPhysicalStorage.deleteAsset(asset2, secondarySession);
                                    secondarySession.commit();
                                    commited = true;
                                }
                                finally {
                                    if (commited) continue;
                                    secondarySession.rollback();
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (this.config.isStopOnError()) {
                            throw t;
                        }
                        this.errorCount.incrementAndGet();
                        this.log.error(String.format("error in task (class %s, uid %s): %s", assetClass.getName(), uid, t.toString()), t);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, uid {1}: {2}", (Object[])new Object[]{assetClass.getName(), uid, ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                    }
                }
            } else {
                List deletedList;
                try (PhysicalStorageSession primaryUidsSession2 = primaryPhysicalStorage.createSession(null);){
                    SearchQuery searchQuery = new SearchQuery();
                    searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)DeletedObjectReference.Property.refType.name(), (Object)assetClass.getName()));
                    searchQuery.getCriteria().getCriterions().add(SearchCriterion.ge((String)DeletedObjectReference.Property.refDeleted.name(), (Object)part.getFrom()));
                    searchQuery.getCriteria().getCriterions().add(SearchCriterion.le((String)DeletedObjectReference.Property.refDeleted.name(), (Object)part.getTo()));
                    SearchResult searchResult = primaryPhysicalStorage.getAssetStorage().searchAssets(DeletedObjectReference.class, searchQuery, primaryUidsSession2);
                    deletedList = searchResult.getData();
                }
                int idx = 0;
                int size = deletedList.size();
                this.log.debug(String.format("got %s uids of asset %s to proceed", MiscUtil.getSimpleClassName(assetClass), Integer.toString(size)));
                for (DeletedObjectReference data : deletedList) {
                    try {
                        this.log.debug(String.format("processing asset %s whith uid %s, progress = %s from %s %s%%", MiscUtil.getSimpleClassName(assetClass), data.getRefUid(), Integer.toString(idx), Integer.toString(size), Math.round((double)idx * 100.0 / (double)size)));
                        ++idx;
                        if (this.isToBeStopped()) {
                            return false;
                        }
                        try (PhysicalStorageSession secondarySession = secondaryPhysicalStorage.createSession(null);){
                            PhysicalAssetData asset2 = secondaryAssetPhysicalStorage.loadAsset(assetClass, data.getRefUid(), secondarySession);
                            if (asset2 != null && asset2.getAsset() == null) {
                                throw new Exception(String.format("Internal error: PhysicalAssetData<%s>.getAsset() == null, uid = %s", assetClass.getName(), data.getRefUid()));
                            }
                            if (asset2 == null) continue;
                            boolean commited = false;
                            try {
                                secondarySession.begin();
                                secondaryAssetPhysicalStorage.deleteAsset(asset2, secondarySession);
                                secondarySession.commit();
                                commited = true;
                            }
                            finally {
                                if (commited) continue;
                                secondarySession.rollback();
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (this.config.isStopOnError()) {
                            throw t;
                        }
                        this.errorCount.incrementAndGet();
                        this.log.error(String.format("error in task (class %s, uid %s): %s", assetClass.getName(), data.getRefUid(), t.toString()), t);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, uid {1}: {2}", (Object[])new Object[]{assetClass.getName(), data.getRefUid(), ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processBulkDictionaryStorage(PhysicalStorage primaryPhysicalStorage, PhysicalStorage secondaryPhysicalStorage, LongRunningTask.EventsCallback callback) throws Throwable {
        boolean commited;
        PhysicalBulkDictionaryData data2;
        PhysicalStorageSession secondarySession;
        PhysicalBulkDictionaryData data1;
        PhysicalStorageSession primarySession;
        BulkDictionaryPhysicalStorage primaryBulkDictionaryPhysicalStorage = primaryPhysicalStorage.getBulkDictionaryStorage();
        BulkDictionaryPhysicalStorage secondaryBulkDictionaryPhysicalStorage = secondaryPhysicalStorage.getBulkDictionaryStorage();
        if (this.config.isFirstPass()) {
            List metadataList1;
            try (PhysicalStorageSession primaryUidsSession = primaryPhysicalStorage.createSession(null);){
                metadataList1 = primaryBulkDictionaryPhysicalStorage.loadMetadata(primaryUidsSession);
            }
            for (PhysicalBulkDictionaryMetadata metadata1 : metadataList1) {
                try {
                    if (this.isToBeStopped()) {
                        return false;
                    }
                    primarySession = primaryPhysicalStorage.createSession(null);
                    try {
                        data1 = primaryBulkDictionaryPhysicalStorage.loadData(metadata1.getDictionaryType(), primarySession);
                        secondarySession = secondaryPhysicalStorage.createSession(null);
                        try {
                            data2 = secondaryBulkDictionaryPhysicalStorage.loadData(metadata1.getDictionaryType(), secondarySession);
                            if (this.isBulkDictionariesEquals(data1, data2)) continue;
                            data1.getContext().clear();
                            commited = false;
                            try {
                                secondarySession.begin();
                                secondaryBulkDictionaryPhysicalStorage.updateData(data1, data2, secondarySession);
                                secondarySession.commit();
                                commited = true;
                            }
                            finally {
                                if (!commited) {
                                    secondarySession.rollback();
                                }
                            }
                            data1.getContext().clear();
                        }
                        finally {
                            secondarySession.close();
                        }
                    }
                    finally {
                        primarySession.close();
                    }
                }
                catch (Throwable t) {
                    if (this.config.isStopOnError()) {
                        throw t;
                    }
                    this.errorCount.incrementAndGet();
                    this.log.error(String.format("error in task (class %s, dictType %s): %s", "PhysicalBulkDictionaryMetadata", metadata1.getDictionaryType() != null ? metadata1.getDictionaryType().getName() : "null", t.toString()), t);
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, dictType {1}: {2}", (Object[])new Object[]{"PhysicalBulkDictionaryMetadata", metadata1.getDictionaryType() != null ? metadata1.getDictionaryType().getName() : "null", ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                }
            }
        }
        if (this.config.isSecondPass()) {
            List metadataList2;
            try (PhysicalStorageSession secondaryUidsSession = secondaryPhysicalStorage.createSession(null);){
                metadataList2 = secondaryBulkDictionaryPhysicalStorage.loadMetadata(secondaryUidsSession);
            }
            for (PhysicalBulkDictionaryMetadata metadata2 : metadataList2) {
                try {
                    if (this.isToBeStopped()) {
                        return false;
                    }
                    primarySession = primaryPhysicalStorage.createSession(null);
                    try {
                        data1 = primaryBulkDictionaryPhysicalStorage.loadData(metadata2.getDictionaryType(), primarySession);
                        if (data1 != null) continue;
                        secondarySession = secondaryPhysicalStorage.createSession(null);
                        try {
                            data2 = secondaryBulkDictionaryPhysicalStorage.loadData(metadata2.getDictionaryType(), secondarySession);
                            if (data2 == null) continue;
                            commited = false;
                            try {
                                secondarySession.begin();
                                secondaryBulkDictionaryPhysicalStorage.deleteData(data2, secondarySession);
                                secondarySession.commit();
                                commited = true;
                            }
                            finally {
                                if (commited) continue;
                                secondarySession.rollback();
                            }
                        }
                        finally {
                            secondarySession.close();
                        }
                    }
                    finally {
                        primarySession.close();
                    }
                }
                catch (Throwable t) {
                    if (this.config.isStopOnError()) {
                        throw t;
                    }
                    this.errorCount.incrementAndGet();
                    this.log.error(String.format("error in task (class %s, dictType %s): %s", "PhysicalBulkDictionaryMetadata", metadata2.getDictionaryType() != null ? metadata2.getDictionaryType().getName() : "null", t.toString()), t);
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, dictType {1}: {2}", (Object[])new Object[]{"PhysicalBulkDictionaryMetadata", metadata2.getDictionaryType() != null ? metadata2.getDictionaryType().getName() : "null", ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                }
            }
        }
        return false;
    }

    protected <D extends BaseDictionary> boolean processDBPropertiesStorage(PhysicalStorage primaryPhysicalStorage, PhysicalStorage secondaryPhysicalStorage, LongRunningTask.EventsCallback callback) throws Throwable {
        String key;
        DBPropertiesPhysicalStorage primaryDBPropertiesPhysicalStorage = primaryPhysicalStorage.getDBPropertiesStorage();
        DBPropertiesPhysicalStorage secondaryDBPropertiesPhysicalStorage = secondaryPhysicalStorage.getDBPropertiesStorage();
        Map keys1 = primaryDBPropertiesPhysicalStorage.getAllKeys();
        Map keys2 = secondaryDBPropertiesPhysicalStorage.getAllKeys();
        if (this.config.isFirstPass()) {
            for (Map.Entry entity : keys1.entrySet()) {
                if (this.isToBeStopped()) {
                    return false;
                }
                key = (String)entity.getKey();
                String value1 = (String)entity.getValue();
                try {
                    String value2 = (String)keys2.get(key);
                    if (this.isObjectsEquals(value1, value2)) continue;
                    secondaryDBPropertiesPhysicalStorage.putDbProperty(key, value1, value2);
                }
                catch (Throwable t) {
                    if (this.config.isStopOnError()) {
                        throw t;
                    }
                    this.errorCount.incrementAndGet();
                    this.log.error(String.format("error in task (class %s, key %s, value %s): %s", "DBProperties", String.valueOf(key), String.valueOf(value1), String.valueOf(t)), t);
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, key {1}, value {2}: {3}", (Object[])new Object[]{"DbProperties", String.valueOf(key), String.valueOf(value1), ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                }
            }
        }
        if (this.config.isSecondPass()) {
            for (Map.Entry entity : new ArrayList(keys2.entrySet())) {
                if (this.isToBeStopped()) {
                    return false;
                }
                key = (String)entity.getKey();
                try {
                    if (keys1.containsKey(key)) continue;
                    secondaryDBPropertiesPhysicalStorage.putDbProperty(key, null, (String)entity.getValue());
                }
                catch (Throwable t) {
                    if (this.config.isStopOnError()) {
                        throw t;
                    }
                    this.errorCount.incrementAndGet();
                    this.log.error(String.format("error in task (class %s, key %s): %s", "DBProperties", String.valueOf(key), String.valueOf(t)), t);
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, key {1}: {2}", (Object[])new Object[]{"PhysicalBulkDictionaryMetadata", String.valueOf(key), ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                }
            }
        }
        return true;
    }

    protected boolean processEntityType(PhysicalStorage primaryStorage, PhysicalStorage secondaryStorage, Class<?> clazz, Part part, LongRunningTask.EventsCallback callback) throws Throwable {
        if (BaseDictionary.class.isAssignableFrom(clazz)) {
            return this.processDictionaryStorage(primaryStorage, secondaryStorage, part, clazz, callback);
        }
        if (BaseEntity.class.isAssignableFrom(clazz)) {
            return this.processEntityStorage(primaryStorage, secondaryStorage, part, clazz, callback);
        }
        if (BaseAsset.class.isAssignableFrom(clazz)) {
            return this.processAssetStorage(primaryStorage, secondaryStorage, part, clazz, callback);
        }
        throw new IllegalArgumentException("Wrong class for repair task: " + String.valueOf(clazz));
    }

    private void moveIdfsIndex(ExecutorServiceFacade service, PhysicalStorage primaryStorage, PhysicalStorage secondaryStorage, LongRunningTask.EventsCallback callback) throws ClassNotFoundException, InterruptedException {
        callback.updateProgress((byte)90);
        Collection<Class<?>> indexTypeList = this.getIdfsIndexTypeList();
        CountDownLatch countDown = new CountDownLatch(this.partList.size());
        for (Part part : this.partList) {
            service.submit(() -> {
                try {
                    this.processDeletedIndexType(primaryStorage, secondaryStorage, part, indexTypeList, callback);
                }
                catch (Throwable t) {
                    this.errorCount.incrementAndGet();
                    this.log.error("error in task", t);
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430: {1}", (Object[])new Object[]{ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                    if (this.config.isStopOnError() && !this.isToBeStopped()) {
                        this.log.debug("stop task");
                        try {
                            this.stop();
                        }
                        catch (Exception e) {
                            this.log.error("unable to stop task", (Throwable)e);
                            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Object[])new Object[0]));
                        }
                    }
                }
                finally {
                    countDown.countDown();
                }
            });
        }
        countDown.await();
        callback.updateProgress((byte)95);
        CountDownLatch countDown2 = new CountDownLatch(this.partList.size() * indexTypeList.size());
        for (Class<?> indexType : indexTypeList) {
            for (Part part : this.partList) {
                service.submit(() -> {
                    try {
                        this.processIndexType(primaryStorage, secondaryStorage, part, indexType, callback);
                    }
                    catch (Throwable t) {
                        this.errorCount.incrementAndGet();
                        this.log.error("error in task", t);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}: {1}", (Object[])new Object[]{indexType.getName(), ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                        if (this.config.isStopOnError() && !this.isToBeStopped()) {
                            this.log.debug("stop task");
                            try {
                                this.stop();
                            }
                            catch (Exception e) {
                                this.log.error("unable to stop task", (Throwable)e);
                                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Object[])new Object[0]));
                            }
                        }
                    }
                    finally {
                        countDown2.countDown();
                    }
                });
            }
        }
        countDown2.await();
        callback.updateProgress((byte)100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends BaseEntity, I extends EntityIndex<E>> void processIndexType(PhysicalStorage primaryPhysicalStorage, PhysicalStorage secondaryPhysicalStorage, Part part, Class<I> indexClass, LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug(String.format("starting move index for %s, startDate = %s, endDate = %s", MiscUtil.getSimpleClassName(indexClass), part.getFrom(), part.getTo()));
        EntityPhysicalStorage primaryEntityPhysicalStorage = primaryPhysicalStorage.getEntityStorage();
        EntityPhysicalStorage secondaryEntityPhysicalStorage = secondaryPhysicalStorage.getEntityStorage();
        HashSet refList = new HashSet();
        try (PhysicalStorageSession primaryUidsSession = primaryPhysicalStorage.createSession(null);){
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.between((String)"modified", (Object)part.getFrom(), (Object)part.getTo()));
            SearchResult result = primaryEntityPhysicalStorage.searchEntity(indexClass, query, primaryUidsSession);
            result.getData().stream().map(EntityIndex::getSource).forEach(refList::add);
        }
        int idx = 0;
        int size = refList.size();
        this.log.debug(String.format("got %s uids of index %s to proceed", Integer.toString(size), MiscUtil.getSimpleClassName(indexClass)));
        LockManager lm = LockUtil.getLockManager();
        for (EntityReference ref : refList) {
            String uid = ref.getUid();
            NamedLock lock = lm.getLock((Object)LockUtil.getLockKey((EntityReference)ref));
            Throwable throwable = null;
            try {
                lock.lock();
                try {
                    this.log.debug(String.format("processing move index %s whith uid %s, progress = %s from %s %s%%", MiscUtil.getSimpleClassName(indexClass), uid, Integer.toString(idx), Integer.toString(size), Math.round((double)idx * 100.0 / (double)size)));
                    ++idx;
                    try (PhysicalStorageSession primarySession = primaryPhysicalStorage.createSession(null);
                         PhysicalStorageSession secondarySession = secondaryPhysicalStorage.createSession(null);){
                        boolean commited = false;
                        try {
                            secondarySession.begin();
                            this.deleteEntityIndex(secondaryEntityPhysicalStorage, secondarySession, indexClass, uid);
                            this.saveEntityIndexStorage(primaryEntityPhysicalStorage, primarySession, secondaryEntityPhysicalStorage, secondarySession, indexClass, uid);
                            secondarySession.commit();
                            commited = true;
                        }
                        finally {
                            if (commited) continue;
                            secondarySession.rollback();
                        }
                    }
                    catch (Throwable t) {
                        if (this.config.isStopOnError()) {
                            throw t;
                        }
                        this.errorCount.incrementAndGet();
                        this.log.error(String.format("error in task (class %s, index %s, uid %s): %s", ref.getType().getName(), indexClass.getName(), uid, t.toString()), t);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, index {1}, uid {2}: {3}", (Object[])new Object[]{ref.getType().getName(), indexClass.getName(), uid, ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (lock == null) continue;
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                lock.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends BaseEntity> void processDeletedIndexType(PhysicalStorage primaryPhysicalStorage, PhysicalStorage secondaryPhysicalStorage, Part part, Collection<Class<?>> indexTypeList, LongRunningTask.EventsCallback callback) throws Exception {
        List refDeletedList;
        this.log.debug(String.format("starting delete indexes, startDate = %s, endDate = %s", part.getFrom(), part.getTo()));
        EntityPhysicalStorage secondaryEntityPhysicalStorage = secondaryPhysicalStorage.getEntityStorage();
        AssetPhysicalStorage primaryAssetPhysicalStorage = primaryPhysicalStorage.getAssetStorage();
        try (PhysicalStorageSession primaryDeletedUidsSession = primaryPhysicalStorage.createSession(null);){
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.between((String)"refDeleted", (Object)part.getFrom(), (Object)part.getTo()));
            SearchResult result = primaryAssetPhysicalStorage.searchAssets(DeletedObjectReference.class, query, primaryDeletedUidsSession);
            refDeletedList = result.getData();
        }
        int idx = 0;
        int size = refDeletedList.size();
        this.log.debug(String.format("got %s uids of objects to proceed", Integer.toString(size)));
        LogicalStorageRegistry storageRegistry = LogicalStorageRegistry.get();
        for (DeletedObjectReference ref : refDeletedList) {
            Class entityClass = ref.getRefType();
            String uid = ref.getRefUid();
            this.log.debug(String.format("processing delete indexes for %s whith uid %s, progress = %s from %s %s%%", MiscUtil.getSimpleClassName((Class)entityClass), uid, Integer.toString(idx), Integer.toString(size), Math.round((double)idx * 100.0 / (double)size)));
            ++idx;
            Collection handlers = storageRegistry.getIndexHandlers(entityClass);
            try (PhysicalStorageSession secondarySession = secondaryPhysicalStorage.createSession(null);){
                boolean commited = false;
                try {
                    secondarySession.begin();
                    for (IndexHandler handler : handlers) {
                        Class indexClass = handler.getIndexClass();
                        if (!indexTypeList.contains(indexClass)) continue;
                        if (indexClass == null) {
                            throw new Exception(String.format("Internal error: No index class defined in handler %s for entity %s", handler.getClass().getName(), entityClass.getName()));
                        }
                        try {
                            this.log.debug(String.format("processing delete index %s whith uid %s", MiscUtil.getSimpleClassName((Class)indexClass), uid));
                            this.deleteEntityIndex(secondaryEntityPhysicalStorage, secondarySession, indexClass, uid);
                        }
                        catch (Throwable t) {
                            if (this.config.isStopOnError()) {
                                throw t;
                            }
                            this.errorCount.incrementAndGet();
                            this.log.error(String.format("error in task (class %s, index %s, uid %s): %s", entityClass.getName(), indexClass.getName(), uid, t.toString()), t);
                            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}, index {1}, uid {2}: {3}", (Object[])new Object[]{entityClass.getName(), indexClass.getName(), uid, ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                        }
                    }
                    secondarySession.commit();
                    commited = true;
                }
                finally {
                    if (commited) continue;
                    secondarySession.rollback();
                }
            }
        }
    }

    private Collection<Class<?>> getIdfsIndexTypeList() throws ClassNotFoundException {
        HashSet result = new HashSet();
        MetaRegistry metaRegistry = MetaRegistry.get();
        for (IndexType indexType : metaRegistry.getIndexes().values()) {
            Class<?> entityClazz = Class.forName(indexType.getEntityId());
            if (!ExportDocument.class.isAssignableFrom(entityClazz) && !ArchivedBooking.class.isAssignableFrom(entityClazz) && !BaseFileDocument.class.isAssignableFrom(entityClazz)) continue;
            result.add(Class.forName(indexType.getId()));
        }
        return result;
    }

    private static DateFormat createDateTimeFormat() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(final LongRunningTask.EventsCallback callback) throws Exception {
        Collection<Class<?>> entityTypeList;
        this.log.debug("task started");
        this.log.info("Repair procedure started ---------------------------------------------------------------");
        final PhysicalStorage primaryStorage = this.getPrimaryStorage();
        final PhysicalStorage secondaryStorage = this.getSecondaryStorage();
        Date configDate = this.config.getDate();
        Date startDate = configDate != null ? configDate : this.getDate(this.config.isUsedCreateDate(), callback);
        Date finishDate = this.doneTo != null ? this.doneTo : new Date();
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0443\u0441\u043a\u0430:", (Object[])new Object[0]));
        DateFormat dateTimeFormat = RepairSecondaryStorageTask.createDateTimeFormat();
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435: {0}", (Object[])new Object[]{this.config.getPrimaryStorageUid()}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0412\u0442\u043e\u0440\u0438\u0447\u043d\u043e\u0435 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435: {0}", (Object[])new Object[]{this.config.getSecondaryStorageUid()}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430: {0}", (Object[])new Object[]{startDate != null ? dateTimeFormat.format(startDate) + (configDate != null ? "" : " (\u0432\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0430)") : "(\u0432\u044b\u0447\u0438\u0441\u043b\u0438\u0442\u044c \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c)"}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430: {0}", (Object[])new Object[]{dateTimeFormat.format(finishDate)}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u041f\u0435\u0440\u0432\u044b\u0439 \u043f\u0440\u043e\u0445\u043e\u0434: {0}", (Object[])new Object[]{this.config.isFirstPass() ? "\u0434\u0430" : "\u043d\u0435\u0442"}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0412\u0442\u043e\u0440\u043e\u0439 \u043f\u0440\u043e\u0445\u043e\u0434: {0}", (Object[])new Object[]{this.config.isSecondPass() ? "\u0434\u0430" : "\u043d\u0435\u0442"}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u041f\u043e\u043b\u043d\u044b\u0439 \u0432\u0442\u043e\u0440\u043e\u0439 \u043f\u0440\u043e\u0445\u043e\u0434: {0}", (Object[])new Object[]{this.config.isRightSecondPass() ? "\u0434\u0430" : "\u043d\u0435\u0442"}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0418\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u043d\u0434\u0435\u043a\u0441\u044b: {0}", (Object[])new Object[]{this.config.isIgnoreIndex() ? "\u0434\u0430" : "\u043d\u0435\u0442"}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u0430\u0442\u0443 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f: {0}", (Object[])new Object[]{this.config.isUsedCreateDate() ? "\u0434\u0430" : "\u043d\u0435\u0442"}));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"  \u0418\u043d\u0434\u0435\u043a\u0441\u044b \u0434\u043b\u044f idfs: {0}", (Object[])new Object[]{this.config.isMoveIdfsIndexes() ? "\u0434\u0430" : "\u043d\u0435\u0442"}));
        if (this.doneTo != null) {
            this.partList = this.getPartList(startDate, this.doneTo);
        }
        if (this.partList == null) {
            this.partList = this.getPartList(startDate, finishDate);
        }
        boolean isDbPropertiesProcess = (entityTypeList = this.getEntityTypeList()).contains(RepairSecondaryStorageTaskConfiguration.DBPropertiesType.class) && !this.isDBPropertiesStorageProcessed;
        entityTypeList.remove(RepairSecondaryStorageTaskConfiguration.DBPropertiesType.class);
        boolean isBulkDictionaryProcess = entityTypeList.contains(PhysicalBulkDictionaryData.class) && !this.isBulkDictionaryStorageProcessed;
        entityTypeList.remove(PhysicalBulkDictionaryData.class);
        int typeCount = entityTypeList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("part count %d, type count %d", this.partList.size(), typeCount));
        }
        ExecutorServiceFacade service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool(this.getClass().getName(), this.config.getThreadCount() > 0 ? this.config.getThreadCount() : 1);
        try {
            int maxCountWithoutIndex = this.partList.size() * typeCount + (isDbPropertiesProcess ? 1 : 0) + (isBulkDictionaryProcess ? 1 : 0);
            final int maxCount = (int)((double)maxCountWithoutIndex * 1.11);
            if (this.totalCount == -1 || this.totalCount < maxCount) {
                this.totalCount = maxCount;
            }
            this.doneCount.set(this.totalCount - maxCount);
            final int resumeDelta = this.doneCount.get();
            final CountDownLatch countDown = new CountDownLatch(maxCountWithoutIndex);
            if (isDbPropertiesProcess) {
                service.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block11: {
                            block10: {
                                block9: {
                                    if (!RepairSecondaryStorageTask.this.isToBeStopped()) break block9;
                                    countDown.countDown();
                                    return;
                                }
                                if (RepairSecondaryStorageTask.this.processDBPropertiesStorage(primaryStorage, secondaryStorage, callback)) break block10;
                                countDown.countDown();
                                return;
                            }
                            try {
                                try {
                                    RepairSecondaryStorageTask.this.isDBPropertiesStorageProcessed = true;
                                    long current = (long)maxCount - countDown.getCount() + 1L;
                                    byte progress = (byte)(100L * (current + (long)resumeDelta) / (long)(maxCount + resumeDelta));
                                    callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u0438\u0437 {1}", (Object[])new Object[]{current + (long)resumeDelta, maxCount + resumeDelta}));
                                    callback.updateProgress(progress);
                                }
                                catch (Throwable t) {
                                    RepairSecondaryStorageTask.this.errorCount.incrementAndGet();
                                    RepairSecondaryStorageTask.this.log.error("error in task", t);
                                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}: {1}", (Object[])new Object[]{"DBProperties", ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                                    if (!RepairSecondaryStorageTask.this.config.isStopOnError() || RepairSecondaryStorageTask.this.isToBeStopped()) break block11;
                                    RepairSecondaryStorageTask.this.log.debug("stop task");
                                    try {
                                        RepairSecondaryStorageTask.this.stop();
                                    }
                                    catch (Exception e) {
                                        RepairSecondaryStorageTask.this.log.error("unable to stop task", (Throwable)e);
                                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Object[])new Object[0]));
                                    }
                                }
                            }
                            finally {
                                countDown.countDown();
                            }
                        }
                    }
                });
            }
            if (isBulkDictionaryProcess) {
                service.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block11: {
                            block10: {
                                block9: {
                                    if (!RepairSecondaryStorageTask.this.isToBeStopped()) break block9;
                                    countDown.countDown();
                                    return;
                                }
                                if (RepairSecondaryStorageTask.this.processBulkDictionaryStorage(primaryStorage, secondaryStorage, callback)) break block10;
                                countDown.countDown();
                                return;
                            }
                            try {
                                try {
                                    RepairSecondaryStorageTask.this.isBulkDictionaryStorageProcessed = true;
                                    long current = (long)maxCount - countDown.getCount() + 1L;
                                    byte progress = (byte)(100L * (current + (long)resumeDelta) / (long)(maxCount + resumeDelta));
                                    callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u0438\u0437 {1}", (Object[])new Object[]{current + (long)resumeDelta, maxCount + resumeDelta}));
                                    callback.updateProgress(progress);
                                }
                                catch (Throwable t) {
                                    RepairSecondaryStorageTask.this.errorCount.incrementAndGet();
                                    RepairSecondaryStorageTask.this.log.error("error in task", t);
                                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}: {1}", (Object[])new Object[]{"PhysicalBulkDictionaryData", ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                                    if (!RepairSecondaryStorageTask.this.config.isStopOnError() || RepairSecondaryStorageTask.this.isToBeStopped()) break block11;
                                    RepairSecondaryStorageTask.this.log.debug("stop task");
                                    try {
                                        RepairSecondaryStorageTask.this.stop();
                                    }
                                    catch (Exception e) {
                                        RepairSecondaryStorageTask.this.log.error("unable to stop task", (Throwable)e);
                                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Object[])new Object[0]));
                                    }
                                }
                            }
                            finally {
                                countDown.countDown();
                            }
                        }
                    }
                });
            }
            final int pd = Math.max(maxCount / 20, 1);
            final AtomicLong lastUpdate = new AtomicLong(System.currentTimeMillis());
            for (final Part part : this.partList) {
                part.getDownCount().set(typeCount);
                for (final Class<?> entityType : entityTypeList) {
                    service.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block12: {
                                block11: {
                                    block10: {
                                        if (!RepairSecondaryStorageTask.this.isToBeStopped()) break block10;
                                        countDown.countDown();
                                        return;
                                    }
                                    if (RepairSecondaryStorageTask.this.processEntityType(primaryStorage, secondaryStorage, entityType, part, callback)) break block11;
                                    countDown.countDown();
                                    return;
                                }
                                try {
                                    try {
                                        part.getDownCount().decrementAndGet();
                                        long current = (long)maxCount - countDown.getCount() + 1L;
                                        byte progress = (byte)(100L * (current + (long)resumeDelta) / (long)(maxCount + resumeDelta));
                                        if ((current + (long)resumeDelta) % (long)pd == 0L || progress >= 100 || RepairSecondaryStorageTask.this.isToBeStopped() || System.currentTimeMillis() - lastUpdate.get() > 300000L) {
                                            lastUpdate.set(System.currentTimeMillis());
                                            callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e {0} \u0438\u0437 {1}", (Object[])new Object[]{current + (long)resumeDelta, maxCount + resumeDelta}));
                                            callback.updateProgress(progress);
                                        }
                                    }
                                    catch (Throwable t) {
                                        RepairSecondaryStorageTask.this.errorCount.incrementAndGet();
                                        RepairSecondaryStorageTask.this.log.error("error in task", t);
                                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}: {1}", (Object[])new Object[]{entityType.getName(), ExceptionUtil.getExceptionStackTrace((Throwable)t)}));
                                        if (!RepairSecondaryStorageTask.this.config.isStopOnError() || RepairSecondaryStorageTask.this.isToBeStopped()) break block12;
                                        RepairSecondaryStorageTask.this.log.debug("stop task");
                                        try {
                                            RepairSecondaryStorageTask.this.stop();
                                        }
                                        catch (Exception e) {
                                            RepairSecondaryStorageTask.this.log.error("unable to stop task", (Throwable)e);
                                            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Object[])new Object[0]));
                                        }
                                    }
                                }
                                finally {
                                    countDown.countDown();
                                }
                            }
                        }
                    });
                }
            }
            countDown.await();
            if (this.config.isMoveIdfsIndexes()) {
                this.moveIdfsIndex(service, primaryStorage, secondaryStorage, callback);
            }
        }
        finally {
            service.dispose();
        }
        callback.taskFinished();
        this.log.info("Repair procedure finished ---------------------------------------------------------------");
        this.log.debug("task finished");
    }

    public void toXML(Element elm) throws Exception {
        this.config.toXML(elm);
        XHelper.writeInt((Element)elm, (String)"totalCount", (int)this.totalCount);
        XHelper.writeBoolean((Element)elm, (String)"isDBPropertiesStorageProcessed", (boolean)this.isDBPropertiesStorageProcessed);
        XHelper.writeBoolean((Element)elm, (String)"isBulkDictionaryStorageProcessed", (boolean)this.isBulkDictionaryStorageProcessed);
        if (this.partList != null) {
            Date date = null;
            for (Part part : this.partList) {
                if (part.getDownCount().get() != 0) break;
                date = part.getFrom();
                this.doneCount.getAndIncrement();
            }
            if (date != null) {
                XHelper.writeDate((Element)elm, (String)"doneTo", date);
            }
        }
        XHelper.writeInt((Element)elm, (String)"doneCount", (int)this.doneCount.get());
    }

    public void fromXML(Element elm) throws Exception {
        this.config = new RepairSecondaryStorageTaskConfiguration();
        this.config.fromXML(elm);
        this.totalCount = XHelper.readInt((Element)elm, (String)"totalCount", (int)-1);
        this.doneCount.set(XHelper.readInt((Element)elm, (String)"doneCount", (int)0));
        this.isDBPropertiesStorageProcessed = XHelper.readBoolean((Element)elm, (String)"isDBPropertiesStorageProcessed", (boolean)false);
        this.isBulkDictionaryStorageProcessed = XHelper.readBoolean((Element)elm, (String)"isBulkDictionaryStorageProcessed", (boolean)false);
        this.doneTo = XHelper.readDate((Element)elm, (String)"doneTo");
    }

    protected <D extends BaseDictionary> boolean isBulkDictionariesEquals(PhysicalBulkDictionaryData<D> first, PhysicalBulkDictionaryData<D> second) throws Exception {
        if (first == null) {
            return second == null;
        }
        return second != null && this.isObjectsEquals(first.getModified(), second.getModified());
    }

    protected <A extends BaseAsset> boolean isAssetsEquals(PhysicalAssetData<A> first, PhysicalAssetData<A> second) throws Exception {
        return first != null ? second != null && this.isObjectsEquals(first.getAsset().getModified(), second.getAsset().getModified()) : second == null;
    }

    protected <D extends BaseDictionary> boolean isDictionariesEqual(PhysicalDictionaryData<D> first, PhysicalDictionaryData<D> second) throws Exception {
        if (first == null) {
            return second == null;
        }
        return second != null && this.isObjectsEquals(first.getUid(), second.getUid()) && this.isObjectsEquals(first.getCreated(), second.getCreated()) && this.isObjectsEquals(first.getModified(), second.getModified()) && this.isObjectsEquals(first.getDictionaryType(), second.getDictionaryType()) && this.isObjectsEquals(first.getCode(), second.getCode()) && this.isObjectsEquals(first.isDeleted(), second.isDeleted()) && this.isObjectsEquals(first.getData(), second.getData());
    }

    protected boolean isVersionsEquals(PhysicalVersionMetadataData first, PhysicalVersionMetadataData second) throws Exception {
        if (first == null) {
            return second == null;
        }
        return second != null && this.isObjectsEquals(first.getModified(), second.getModified());
    }

    protected boolean isObjectsEquals(Object first, Object second) {
        if (first == null) {
            return second == null;
        }
        Class<?> firstClass = first.getClass();
        if (second == null || !firstClass.equals(second.getClass())) {
            return false;
        }
        if (firstClass.getComponentType() != null) {
            return this.isArraysEquals(first, second);
        }
        if (Collection.class.isAssignableFrom(firstClass)) {
            return this.isCollectionsEquals((Collection)first, (Collection)second);
        }
        return first.equals(second);
    }

    protected boolean isArraysEquals(Object first, Object second) {
        if (first == null) {
            return second == null;
        }
        if (second == null || !first.getClass().equals(second.getClass())) {
            return false;
        }
        int firstLength = Array.getLength(first);
        if (firstLength != Array.getLength(second)) {
            return false;
        }
        for (int i = 0; i < firstLength; ++i) {
            if (this.isObjectsEquals(Array.get(first, i), Array.get(second, i))) continue;
            return false;
        }
        return true;
    }

    protected boolean isCollectionsEquals(Collection<?> first, Collection<?> second) {
        if (first == null) {
            return second == null;
        }
        if (second == null || !first.getClass().equals(second.getClass())) {
            return false;
        }
        int firstLength = first.size();
        if (firstLength != second.size()) {
            return false;
        }
        for (Object element : first) {
            boolean f = false;
            for (Object element2 : second) {
                if (!this.isObjectsEquals(element, element2)) continue;
                f = true;
                break;
            }
            if (f) continue;
            return false;
        }
        return true;
    }

    private List<PhysicalVersionMetadataData> getVersions(PhysicalEntityData<?> data) {
        ArrayList<PhysicalVersionMetadataData> result = new ArrayList<PhysicalVersionMetadataData>();
        result.add((PhysicalVersionMetadataData)data.getVersions().get(0));
        return result;
    }

    protected static class Part {
        private final Date from;
        private final Date to;
        private final AtomicInteger downCount = new AtomicInteger(-1);

        public Part(Date src, Date target) {
            this.from = src;
            this.to = target;
        }

        public Date getFrom() {
            return this.from;
        }

        public Date getTo() {
            return this.to;
        }

        public AtomicInteger getDownCount() {
            return this.downCount;
        }
    }
}

