/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.RequestForHotelbookOrdersTaskConfiguration;
import com.gridnine.xtrip.server.ibus.IntegrationBusAdapter;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class RequestForHotelbookOrdersTask
extends BaseLongRunningTask<RequestForHotelbookOrdersTaskConfiguration> {
    private volatile RequestForHotelbookOrdersTaskConfiguration config;

    @Override
    public void configure(RequestForHotelbookOrdersTaskConfiguration configuration) throws Exception {
        this.config = configuration;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.RequestForHotelbookOrdersTask_description, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        this.config.toXML(elm);
    }

    public void fromXML(Element elm) throws Exception {
        this.config = new RequestForHotelbookOrdersTaskConfiguration();
        this.config.fromXML(elm);
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        try {
            if (this.config.getStartDate() != null && this.config.getEndDate() != null) {
                HashMap<String, Date> data = new HashMap<String, Date>();
                data.put("HOTELBOOK_DATE_FROM", this.config.getStartDate());
                data.put("HOTELBOOK_DATE_TO", this.config.getEndDate());
                RequestForHotelbookOrdersTask.getAdapter("parsers-hotelbook:manualHotelbookTaskAdapter").processSync(data);
                if (data.get("messages") != null) {
                    Collection iBusMessages = ((Map)data.get("messages")).values();
                    for (Message msg : iBusMessages) {
                        callback.addEvent(null, msg);
                    }
                }
            }
        }
        catch (Throwable t) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error with processing Hotelbook orders", (Throwable)t, (Object[])new Object[0]));
        }
        callback.taskFinished();
    }

    private static IntegrationBusAdapter getAdapter(String adapterId) throws Exception {
        IntegrationBusAdapter adapter = IntegrationBusFacade.get().getRequestReplyAdapter(adapterId);
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("no adapter with id '%s' found", adapterId));
        }
        return adapter;
    }
}

