/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ExpiryWarningTime;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ReservationTimeLimitExpiryWarningTimeUpdateTask
extends BaseLongRunningTask<Serializable> {
    private static final List<ProductStatus> PRODUCT_STATUSES = Arrays.asList(ProductStatus.BOOKING);

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.ReservationTimeLimitExpiryWarningTimeUpdateTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("reservation timelimit expiryWarningTime update started");
        Date passedWarningDate = MiscUtil.clearTime((Date)new Date());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.lt((String)ProductIndex.Property.warningAboutExpiring.name(), (Object)passedWarningDate));
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)ProductIndex.Property.status.name(), (Object[])PRODUCT_STATUSES.toArray()));
        Set refs = EntityStorage.get().search(ProductIndex.class, query).getData().stream().map(ProductIndex::getSource).collect(Collectors.toSet());
        int count = refs.size();
        callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u0437\u0430\u043a\u0430\u0437\u043e\u0432: {0}", (Object[])new Object[]{count}));
        int n = 0;
        ArrayList<String> updatedBookings = new ArrayList<String>();
        for (EntityReference ref : refs) {
            EntityContainer bookingCtr;
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            byte progress = (byte)(100 * n / count);
            this.log.debug(String.format("processing booking %s, %s of %s (%s%%)", ref, String.valueOf(n), String.valueOf(count), String.valueOf(progress)));
            if (n % 100 == 0) {
                callback.updateProgress(progress);
            }
            if ((bookingCtr = EntityStorage.get().resolve(ref)) != null) {
                BookingFile booking = (BookingFile)bookingCtr.getEntity();
                boolean save = false;
                ArrayList<Reservation> processed = new ArrayList<Reservation>();
                for (Product product : BookingHelper.getProductsList((BookingFile)booking, Product.class)) {
                    Reservation reservation;
                    if (!PRODUCT_STATUSES.contains(product.getStatus()) || processed.contains(reservation = product.getReservation())) continue;
                    for (ExpiryWarningTime expiryWarningTime : reservation.getTimeLimitExpiryWarningTime()) {
                        if (expiryWarningTime.isPassed() || expiryWarningTime.getTimeLimitExpiryWarningTime() == null || !expiryWarningTime.getTimeLimitExpiryWarningTime().before(passedWarningDate)) continue;
                        expiryWarningTime.setPassed(true);
                        save = true;
                    }
                    processed.add(reservation);
                }
                if (save) {
                    bookingCtr.getVersionInfo().setDataSource("IBECORP-7469");
                    bookingCtr.getVersionInfo().setVersionNotes("reservation-timelimit-expiryWarningTime-update-task");
                    EntityStorage.get().save(bookingCtr, true);
                    updatedBookings.add(booking.getNumber());
                    this.log.debug(String.format("update booking %s", ref));
                }
            }
            ++n;
        }
        callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0437\u0430\u043a\u0430\u0437\u043e\u0432: {0}", (Object[])new Object[]{updatedBookings.size()}));
        callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)String.join((CharSequence)",", updatedBookings), (Object[])new Object[0]));
        callback.taskFinished();
        this.log.debug("reservation timelimit expiryWarningTime update finished");
    }
}

