/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.xtriphotels.SabreRoomSize;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.RoomSizeDict;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.w3c.dom.Element;

public class RoomSizeDictionaryUpdateTask
extends BaseLongRunningTask<Serializable> {
    private final Set<String> toProceed = new LinkedHashSet<String>();
    private final Map<String, SabreRoomSize> availMessages = new HashMap<String, SabreRoomSize>();
    private final Set<String> existMessages = new LinkedHashSet<String>();
    volatile AtomicInteger n = new AtomicInteger();

    @Override
    public void configure(Serializable configuration) throws Exception {
        for (SabreRoomSize size : SabreRoomSize.values()) {
            this.toProceed.add(size.name());
        }
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.RoomSizeDictionaryUpdateTask_loadValidationtMassage, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        for (Element element : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(element.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        for (SabreRoomSize size : SabreRoomSize.values()) {
            this.availMessages.put(size.name(), size);
        }
        for (RoomSizeDict dict : DictionaryCache.get().getAll(RoomSizeDict.class).values()) {
            this.existMessages.add(dict.getCode());
        }
        this.log.debug("room size dictionary update started");
        int count = this.toProceed.size();
        this.log.debug(String.format("uids updated, remains " + count, new Object[0]));
        this.n.set(0);
        Iterator<String> entryIter = this.toProceed.iterator();
        while (entryIter.hasNext()) {
            if (this.isToBeStopped()) {
                this.log.debug("task is interupted");
                return;
            }
            this.n.incrementAndGet();
            String item = entryIter.next();
            try {
                this.log.debug(String.format("processing room size %s, %s from %s (%s%%)", item, Integer.toString(this.n.get()), Integer.toString(count), Integer.toString(100 * this.n.get() / count)));
                if (this.n.get() % 100 == 0) {
                    callback.updateProgress((byte)(100 * this.n.get() / count));
                }
                RoomSizeDict dict = null;
                if (this.existMessages.contains(item)) {
                    dict = (RoomSizeDict)DictionaryStorage.get().load(RoomSizeDict.class, item);
                } else {
                    dict = new RoomSizeDict();
                    dict.setCode(item);
                }
                if (dict != null) {
                    dict.setImportedFromSabre(true);
                    dict.getTranslations().put(Locale.ENGLISH, this.availMessages.get(item).toString());
                }
                dict.setDataSource("RoomSizeDictionaryUpdateTask");
                DictionaryStorage.get().save((BaseDictionary)dict);
            }
            catch (Throwable e) {
                this.log.error("unable to update dictionary item " + item, e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.RoomSizeDictionaryUpdateTask_onAddMessageHasError, (Throwable)e, (Object[])new Object[]{item}));
            }
            entryIter.remove();
        }
        callback.taskFinished();
        this.log.debug("update finished");
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }
}

