/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfilesConnectionSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SabreProfileLoadProfilesTaskConfiguration;
import com.gridnine.xtrip.common.model.profile.SabreProfilesLoadResult;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesProfileInfo;
import com.gridnine.xtrip.common.model.profile.SabreProfilesProfileType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class SabreProfileLoadProfilesTask
extends BaseLongRunningTask<SabreProfileLoadProfilesTaskConfiguration> {
    private final List<SabreProfilesProfileInfo> unprocessedProfiles = new ArrayList<SabreProfilesProfileInfo>();
    private boolean updateExistProfiles;
    private int totalProfilesCount = 0;
    private int loadedProfilesCount = 0;
    private int updatedProfilesCount = 0;
    private Map<String, SabreProfilesPccSettings> pccSettings;

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"SabreProfileLoadProfilesTask_description", (Object[])new Object[0]);
    }

    @Override
    public void configure(SabreProfileLoadProfilesTaskConfiguration configuration) throws Exception {
        this.unprocessedProfiles.clear();
        this.unprocessedProfiles.addAll(configuration.getProfiles());
        this.totalProfilesCount = this.unprocessedProfiles.size();
        this.updateExistProfiles = configuration.isUpdateExistProfiles();
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) {
        if (!this.isLoadingProfilesActive(callback)) {
            callback.taskFinished();
            return;
        }
        if (!this.validateProfilesCount(callback)) {
            callback.taskFinished();
            return;
        }
        if (!this.loadPccSettings(callback)) {
            callback.taskFinished();
            return;
        }
        Iterator<SabreProfilesProfileInfo> profilesIterator = this.unprocessedProfiles.iterator();
        while (profilesIterator.hasNext()) {
            if (this.isToBeStopped()) {
                this.info(callback, "SabreProfileLoadProfilesTask_wasStopped", new Object[0]);
                break;
            }
            SabreProfilesProfileInfo profile = profilesIterator.next();
            this.loadProfile(profile, callback);
            profilesIterator.remove();
            callback.updateProgress((byte)(100 * (this.totalProfilesCount - this.unprocessedProfiles.size()) / this.totalProfilesCount));
        }
        this.info(callback, "SabreProfileLoadProfilesTask_profilesLoaded", this.loadedProfilesCount, this.updatedProfilesCount);
        callback.taskFinished();
    }

    private boolean validateProfilesCount(LongRunningTask.EventsCallback callback) {
        if (this.totalProfilesCount == 0) {
            this.info(callback, "SabreProfileLoadProfilesTask_profilesNotFound", new Object[0]);
            return false;
        }
        if (this.unprocessedProfiles.isEmpty()) {
            this.info(callback, "SabreProfileLoadProfilesTask_allProfilesWereAlreadyProcessed", new Object[0]);
            return false;
        }
        if (this.unprocessedProfiles.size() == this.totalProfilesCount) {
            this.info(callback, "SabreProfileLoadProfilesTask_profilesToLoad", this.totalProfilesCount);
        } else {
            this.info(callback, "SabreProfileLoadProfilesTask_profilesToLoad2", this.totalProfilesCount, this.unprocessedProfiles.size());
        }
        return true;
    }

    private void loadProfile(SabreProfilesProfileInfo profile, LongRunningTask.EventsCallback callback) {
        if (profile.getType() == SabreProfilesProfileType.TVL) {
            this.loadTraveller(profile, callback);
        } else {
            this.warn(callback, "SabreProfiles_UnsupportedProfileType", profile.getName(), profile.getUniqueId(), profile.getType());
        }
    }

    private void loadTraveller(SabreProfilesProfileInfo profile, LongRunningTask.EventsCallback callback) {
        try {
            if (!this.validateTraveller(profile, callback)) {
                return;
            }
            SabreProfilesPccSettings pccAndPassword = this.pccSettings.get(profile.getPcc());
            if (pccAndPassword == null) {
                this.warn(callback, "SabreProfileLoadProfilesTask_pccNotFound", profile.getPcc(), profile.getName(), profile.getUniqueId());
                return;
            }
            EntityReference<Person> existTraveller = this.searchAlreadyExistTraveller(profile);
            if (existTraveller == null) {
                this.loadNewTraveller(profile, pccAndPassword, callback);
            } else if (this.updateExistProfiles) {
                this.updateExistTraveller(existTraveller, profile, pccAndPassword, callback);
            } else {
                this.info(callback, "SabreProfileLoadProfilesTask_profileAlreadyExist", profile.getName(), profile.getUniqueId(), profile.getPcc(), existTraveller, existTraveller.getUid());
            }
        }
        catch (Throwable t) {
            if (this.isProfileNotFoundException(t)) {
                this.error(callback, t, "SabreProfileLoadProfilesTask_profileNotFoundInSabre", profile.getName(), profile.getUniqueId());
            }
            this.error(callback, t, "SabreProfileLoadProfilesTask_profileLoadError", profile.getName(), profile.getUniqueId());
        }
    }

    private boolean validateTraveller(SabreProfilesProfileInfo profile, LongRunningTask.EventsCallback callback) {
        if (TextUtil.isBlank((String)profile.getUniqueId())) {
            this.info(callback, "SabreProfileLoadProfilesTask_idAbsent", profile.getName());
            return false;
        }
        if (TextUtil.isBlank((String)profile.getPcc())) {
            this.info(callback, "SabreProfileLoadProfilesTask_pccAbsent", profile.getName(), profile.getUniqueId());
            return false;
        }
        return true;
    }

    private void loadNewTraveller(SabreProfilesProfileInfo profile, SabreProfilesPccSettings pccAndPassword, LongRunningTask.EventsCallback callback) throws ServiceException {
        ArrayList<Message> messages = new ArrayList<Message>();
        ValueHolder profileHolder = new ValueHolder();
        SabreProfilesLoadResult result = SabreProfilesSynchronizationHelper.loadNewPerson(profile.getUniqueId(), pccAndPassword, (ValueHolder<EntityReference<Person>>)profileHolder, messages);
        EntityReference loadedProfile = (EntityReference)profileHolder.getValue();
        for (Message message : messages) {
            callback.addEvent(null, message);
        }
        switch (result) {
            case OK: {
                this.info(callback, "SabreProfileLoadProfilesTask_profileWasLoaded", profile.getName(), profile.getUniqueId(), loadedProfile, loadedProfile.getUid());
                ++this.loadedProfilesCount;
                break;
            }
            case EMPLOYMENTS_NOT_FOUND: {
                this.warn(callback, "SabreProfileLoadProfilesTask_employmentsNotFound", profile.getName(), profile.getUniqueId());
                break;
            }
            case LOAD_NOT_ALLOWED: {
                this.warn(callback, "SabreProfileLoadProfilesTask_profileLoadingNotAllowed", profile.getName(), profile.getUniqueId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported result: " + result);
            }
        }
    }

    private void updateExistTraveller(EntityReference<Person> person, SabreProfilesProfileInfo profile, SabreProfilesPccSettings pccAndPassword, LongRunningTask.EventsCallback callback) throws ServiceException {
        ArrayList<Message> messages = new ArrayList<Message>();
        SabreProfilesLoadResult result = SabreProfilesSynchronizationHelper.loadExistPerson(person, pccAndPassword, false, true, messages);
        for (Message message : messages) {
            callback.addEvent(null, message);
        }
        switch (result) {
            case OK: {
                this.info(callback, "SabreProfileLoadProfilesTask_profileWasUpdated", profile.getName(), profile.getUniqueId(), person, person.getUid());
                ++this.updatedProfilesCount;
                break;
            }
            case LOAD_ERROR: {
                this.warn(callback, "SabreProfileLoadProfilesTask_profileWasNotLoaded", profile.getName(), profile.getUniqueId());
                break;
            }
            case LOAD_NOT_ALLOWED: {
                this.warn(callback, "SabreProfileLoadProfilesTask_profileLoadingNotAllowed", profile.getName(), profile.getUniqueId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported result: " + result);
            }
        }
    }

    private boolean isProfileNotFoundException(Throwable t) {
        return t instanceof ServiceException && TextUtil.contains((String)t.getMessage(), (String)"No profile is found which match your selection criteria");
    }

    private EntityReference<Person> searchAlreadyExistTraveller(SabreProfilesProfileInfo profile) {
        return SabreProfilesSynchronizationUtil.searchPersonByPccAndUniqueId(profile.getPcc(), profile.getUniqueId());
    }

    private boolean isLoadingProfilesActive(LongRunningTask.EventsCallback callback) {
        SabreProfilesConnectionSettings settings = ProfileSynchronizationUtil.getSabreProfilesConnectionSettings();
        if (settings == null || !settings.isLoadActive()) {
            this.warn(callback, "SabreProfiles_ReturnSynchronizationIsInactive", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean loadPccSettings(LongRunningTask.EventsCallback callback) {
        this.pccSettings = Collections.unmodifiableMap(ProfileSynchronizationUtil.getSabreProfilesPccConnectionSettings().stream().filter(Objects::nonNull).filter(settings -> TextUtil.nonBlank((String)settings.getPcc())).collect(Collectors.toMap(SabreProfilesPccSettings::getPcc, Function.identity(), (first, second) -> first)));
        if (this.pccSettings.isEmpty()) {
            this.warn(callback, "SabreProfileLoadProfilesTask_pccSettingsNotFound", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeCollection((Element)elm, (String)"unprocessedProfiles", this.unprocessedProfiles);
        XHelper.writeInt((Element)elm, (String)"totalProfilesCount", (int)this.totalProfilesCount);
        XHelper.writeInt((Element)elm, (String)"loadedProfilesCount", (int)this.loadedProfilesCount);
        XHelper.writeInt((Element)elm, (String)"updatedProfilesCount", (int)this.updatedProfilesCount);
        XHelper.writeBoolean((Element)elm, (String)"updateExistProfiles", (boolean)this.updateExistProfiles);
    }

    public void fromXML(Element elm) throws Exception {
        this.unprocessedProfiles.clear();
        this.unprocessedProfiles.addAll(XHelper.readCollection((Element)elm, (String)"unprocessedProfiles"));
        this.totalProfilesCount = XHelper.readInt((Element)elm, (String)"totalProfilesCount");
        this.loadedProfilesCount = XHelper.readInt((Element)elm, (String)"loadedProfilesCount");
        this.updatedProfilesCount = XHelper.readInt((Element)elm, (String)"updatedProfilesCount");
        this.updateExistProfiles = XHelper.readBoolean((Element)elm, (String)"updateExistProfiles");
    }
}

