/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ScheduledTaskSettingsDeleteTaskConfiguration;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettingsIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ScheduledTaskSettingsDeleteTask
extends BaseLongRunningTask<ScheduledTaskSettingsDeleteTaskConfiguration> {
    private ScheduledTaskSettingsDeleteTaskConfiguration configuration;

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.ScheduledTaskSettingsDeleteTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        this.configuration = (ScheduledTaskSettingsDeleteTaskConfiguration)XHelper.readObject((Element)elm, (String)"configuration");
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeObject((Element)elm, (String)"configuration", (Object)this.configuration);
    }

    @Override
    public void configure(ScheduledTaskSettingsDeleteTaskConfiguration configuration) throws Exception {
        this.configuration = configuration;
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("scheduled task settings delete started");
        String jobClass = this.configuration.getJobClass();
        this.log.debug(String.format("jobClass -> %s", jobClass));
        callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key(Messages.ScheduledTaskSettingsDeleteTask_jobClass).parameters(new Object[]{jobClass}).build());
        if (TextUtil.isBlank((String)jobClass)) {
            this.log.error("unable to delete scheduled task settings -> job class value missing");
            callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.ERROR).key(Messages.ScheduledTaskSettingsDeleteTask_scheduledTaskSettingsDeleteFailed).details(L10nResourcesManager.getStr((String)Messages.ScheduledTaskSettingsDeleteTask_jobClassValueMissing, (Object[])new Object[0])).build());
            throw new Exception("job class value missing");
        }
        int progressStart = 0;
        int progressEnd = 100;
        SearchQuery query = new SearchQuery();
        List scheduledTaskSettingsReferences = EntityStorage.get().search(ScheduledTaskSettingsIndex.class, query).getData().stream().map(item -> item.getSource()).collect(Collectors.toList());
        this.log.debug(String.format("scheduled task settings found -> %s", String.valueOf(scheduledTaskSettingsReferences.size())));
        callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key(Messages.ScheduledTaskSettingsDeleteTask_scheduledTaskSettingsFound).parameters(new Object[]{String.valueOf(scheduledTaskSettingsReferences.size())}).build());
        int count = 0;
        int totalCount = scheduledTaskSettingsReferences.size();
        int deleteCount = 0;
        for (EntityReference scheduledTaskSettingsReference : scheduledTaskSettingsReferences) {
            ScheduledTaskSettings scheduledTaskSettings;
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            this.handleProgress(callback, progressStart, progressEnd, count, totalCount);
            EntityContainer scheduledTaskSettingsContainer = EntityStorage.get().resolve(scheduledTaskSettingsReference);
            if (scheduledTaskSettingsContainer != null && MiscUtil.equals((Object)jobClass, (Object)(scheduledTaskSettings = (ScheduledTaskSettings)scheduledTaskSettingsContainer.getEntity()).getJobClass())) {
                EntityStorage.get().delete(scheduledTaskSettingsContainer);
                this.log.debug(String.format("scheduled task settings delete -> %s (%s)", scheduledTaskSettingsReference, scheduledTaskSettingsReference.getUid()));
                ++deleteCount;
            }
            ++count;
        }
        this.log.debug(String.format("scheduled task settings deleted -> %s", String.valueOf(deleteCount)));
        callback.addEvent(null, MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key(Messages.ScheduledTaskSettingsDeleteTask_scheduledTaskSettingsDeleted).parameters(new Object[]{String.valueOf(deleteCount)}).build());
        callback.taskFinished();
        this.log.debug("scheduled task settings delete finished");
    }

    private void handleProgress(LongRunningTask.EventsCallback callback, int progressStart, int progressEnd, int count, int total) {
        byte progress = (byte)(progressStart + (progressEnd - progressStart) * count / total);
        this.log.debug("scheduled task settings task delete progress -> " + progress);
        callback.updateProgress(progress);
    }
}

