/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberCategory;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumbers;
import com.gridnine.xtrip.server.model.cn.ConsecutiveNumber;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Element;

public class SequenceNumberMigrationTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.SequenceNumberMigrationTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("sequence number migration started");
        List sequenceNumbers = AssetsStorage.get().search(SequenceNumbers.class, new SearchQuery()).getData();
        List consecutiveNumbers = AssetsStorage.get().search(ConsecutiveNumber.class, new SearchQuery()).getData();
        long maxLastNumber = 0L;
        int n = 0;
        try {
            for (SequenceNumbers sequenceNumber : sequenceNumbers) {
                byte progress = (byte)(100 * ++n / sequenceNumbers.size());
                this.log.debug(String.format("processing, %s of %s (%s%%)", String.valueOf(n), String.valueOf(sequenceNumbers.size()), String.valueOf(progress)));
                if (n % 10 == 0) {
                    callback.updateProgress(progress);
                }
                long lastNumber = Long.parseLong(sequenceNumber.getLastNumber());
                ConsecutiveNumberCategory category = this.getConsecutiveNumberCategory(sequenceNumber.getDesignator());
                if (this.isFinanceDocumentCategory(category)) {
                    maxLastNumber = Math.max(lastNumber, maxLastNumber);
                }
                if (category == null) continue;
                ConsecutiveNumber consecutiveNumber = consecutiveNumbers.stream().filter(item -> item.getCategory() == category && item.getAgencyUid() == null && item.getContractUid() == null && item.getCashUid() == null && item.getStartDate() == null && item.getEndDate() == null).findFirst().orElse(null);
                if (consecutiveNumber == null) {
                    consecutiveNumber = new ConsecutiveNumber();
                }
                consecutiveNumber.setCategory(category);
                consecutiveNumber.setNumber(lastNumber);
                AssetsStorage.get().save((BaseAsset)consecutiveNumber);
            }
            if (maxLastNumber > 0L) {
                ConsecutiveNumber consecutiveNumber = new ConsecutiveNumber();
                consecutiveNumber.setCategory(ConsecutiveNumberCategory.FINANCE_DOCUMENT_ALL);
                consecutiveNumber.setNumber(maxLastNumber);
                AssetsStorage.get().save((BaseAsset)consecutiveNumber);
            }
        }
        catch (Throwable e) {
            this.log.error("unable to migrate sequence number", e);
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SequenceNumberMigrationTask_sequenceNumberMigrationFailed, (Throwable)e, (Object[])new Object[0]));
        }
        callback.taskFinished();
        this.log.debug("sequence number migration finished");
    }

    private ConsecutiveNumberCategory getConsecutiveNumberCategory(String designator) {
        if (designator != null) {
            if (designator.equals(Shipment.class.getName())) {
                return ConsecutiveNumberCategory.SHIPMENT;
            }
            if (designator.equals(FinanceDocumentType.INTERNAL_BILL.name())) {
                return ConsecutiveNumberCategory.FINANCE_DOCUMENT_INTERNAL_BILL;
            }
            if (designator.equals(FinanceDocumentType.STANDARD_BILL.name())) {
                return ConsecutiveNumberCategory.FINANCE_DOCUMENT_STANDARD_BILL;
            }
            if (designator.equals(FinanceDocumentType.INVOICE.name())) {
                return ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE;
            }
            if (designator.equals(FinanceDocumentType.INVOICE_CONSOLIDATED.name())) {
                return ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE_CONSOLIDATED;
            }
            if (designator.equals(FinanceDocumentType.INVOICE_PREPAYMENT.name())) {
                return ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE_PREPAYMENT;
            }
            if (designator.equals(FinanceDocumentType.CORRECTION_DOCUMENT.name())) {
                return ConsecutiveNumberCategory.FINANCE_DOCUMENT_CORRECTION_DOCUMENT;
            }
            if (designator.equals(FinanceDocumentType.INVOICE_FACTURA.name())) {
                return ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE_FACTURA;
            }
            if (designator.equals(FinanceDocumentType.CASH_ORDER.name())) {
                return ConsecutiveNumberCategory.PAYMENT_DOCUMENT_CREDIT_SLIP;
            }
            if (designator.equals(FinanceDocumentType.RECEIPT.name())) {
                return ConsecutiveNumberCategory.PAYMENT_DOCUMENT_DEBIT_SLIP;
            }
            if (designator.equals(FinanceDocumentType.ACCEPTANCE_CERTIFICATE.name())) {
                return ConsecutiveNumberCategory.FINANCE_DOCUMENT_ACCEPTANCE_CERTIFICATE;
            }
            if (designator.equals(FinanceDocumentType.INVOICE_DETAILED.name())) {
                return ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE_DETAILED;
            }
            if (designator.equals(FinanceDocumentType.INVOICE_FACTURA_FEES.name())) {
                return ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE_FACTURA_FEES;
            }
            if (designator.equals(FinanceDocumentType.UNIVERSAL_DOCUMENT.name())) {
                return ConsecutiveNumberCategory.FINANCE_DOCUMENT_UNIVERSAL_DOCUMENT;
            }
        }
        return null;
    }

    private boolean isFinanceDocumentCategory(ConsecutiveNumberCategory category) {
        return category == ConsecutiveNumberCategory.FINANCE_DOCUMENT_INTERNAL_BILL || category == ConsecutiveNumberCategory.FINANCE_DOCUMENT_STANDARD_BILL || category == ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE || category == ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE_FACTURA || category == ConsecutiveNumberCategory.FINANCE_DOCUMENT_ACCEPTANCE_CERTIFICATE || category == ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE_DETAILED || category == ConsecutiveNumberCategory.FINANCE_DOCUMENT_INVOICE_FACTURA_FEES;
    }
}

