/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentAppliedRulesMigrateTaskConfiguration;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.finance.ShipmentProductAppliedRules;
import com.gridnine.xtrip.common.model.finance.ShipmentProductAppliedRulesIndex;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ShipmentAppliedRulesMigrateTask
extends BaseLongRunningTask<ShipmentAppliedRulesMigrateTaskConfiguration> {
    private ShipmentAppliedRulesMigrateTaskConfiguration configuration;
    final Set<String> toProceed = new LinkedHashSet<String>();
    private int count = -1;

    public void toXML(Element elm) throws Exception {
        XHelper.writeObject((Element)elm, (String)"configuration", (Object)this.configuration);
        Element countElement = XmlUtil.addElement((Element)elm, (String)"count");
        countElement.setAttribute("value", String.valueOf(this.count));
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    public void fromXML(Element elm) throws Exception {
        this.configuration = (ShipmentAppliedRulesMigrateTaskConfiguration)XHelper.readObject((Element)elm, (String)"configuration");
        Element countElement = XmlUtil.getElement((Element)elm, (String)"count");
        if (countElement != null) {
            this.count = Integer.parseInt(countElement.getAttribute("value"));
        }
        for (Element element : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(element.getAttribute("uid"));
        }
    }

    @Override
    public void configure(ShipmentAppliedRulesMigrateTaskConfiguration configuration) throws Exception {
        this.configuration = configuration;
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.ShipmentAppliedRulesMigrateTask_description, (Object[])new Object[0]);
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        Date endDate;
        this.log.debug("shipment applied rules migration started");
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm");
        Date startDate = this.configuration.getStartDate();
        if (startDate == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(2022, 9, 10, 0, 0, 0);
            startDate = calendar.getTime();
        }
        if ((endDate = this.configuration.getEndDate()) == null) {
            endDate = new Date();
        }
        this.updateUids(startDate, endDate);
        if (this.count == -1) {
            this.count = this.toProceed.size();
        }
        int n = this.count - this.toProceed.size();
        this.log.debug(String.format("%s shipments found for period %s - %s", this.count, format.format(startDate), format.format(endDate)));
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0439 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 {0} - {1}: {2}", (Object[])new Object[]{format.format(startDate), format.format(endDate), this.count}));
        Iterator<String> iterator = this.toProceed.iterator();
        while (iterator.hasNext()) {
            EntityContainer shipmentContainer;
            ++n;
            String uid = iterator.next();
            if (this.isToBeStopped()) {
                this.log.debug(String.format("task is interrupted while processing shipmentContainer %s", uid));
                return;
            }
            this.log.debug(String.format("processing shipmentContainer %s", uid));
            byte progress = (byte)(100 * n / this.count);
            if (n % 10 == 0) {
                callback.updateProgress(progress);
            }
            if ((shipmentContainer = EntityStorage.get().load(Shipment.class, uid)) != null) {
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0420\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f: {0} \u043e\u0442 {1}", (Object[])new Object[]{((Shipment)shipmentContainer.getEntity()).getNumber(), ((Shipment)shipmentContainer.getEntity()).getDate()}));
                EntityReference shipmentReference = shipmentContainer.toReference();
                if (this.isAppliedRulesExists((EntityReference<Shipment>)shipmentReference)) {
                    this.log.debug(String.format("ShipmentProductAppliedRules for shipment %s already exist", uid));
                    continue;
                }
                List versionInfos = LogicalStorage.get().getEntityStorage().getVersionInfos(shipmentReference);
                HashMap<String, EntityContainer> resultAppliedRules = new HashMap<String, EntityContainer>();
                for (VersionInfo versionInfo : versionInfos) {
                    EntityContainer ctr = null;
                    try {
                        ctr = EntityStorage.get().load(shipmentContainer.getEntityType(), shipmentContainer.getUid(), Integer.valueOf(versionInfo.getVersionNumber()));
                    }
                    catch (Exception e) {
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438: {0} {1}", (Object[])new Object[]{shipmentReference.toString(), e.toString()}));
                    }
                    if (ctr == null) continue;
                    this.log.debug(String.format("processing shipmentCtr %s version number %s", ctr.getUid(), versionInfo.getVersionNumber()));
                    Map<String, List<AppliedRule>> appliedRulesMap = ((Shipment)ctr.getEntity()).getAppliedRules().stream().collect(Collectors.groupingBy(AppliedRule::getProductUid));
                    for (Map.Entry<String, List<AppliedRule>> entry : appliedRulesMap.entrySet()) {
                        if (!this.isProductFound(entry.getKey())) continue;
                        this.log.debug(String.format("%s appliedRules found for product %s", entry.getValue().size(), entry.getKey()));
                        EntityContainer existCtr = (EntityContainer)resultAppliedRules.get(entry.getKey());
                        if (existCtr == null) {
                            ShipmentProductAppliedRules shipmentProductAppliedRules = new ShipmentProductAppliedRules();
                            shipmentProductAppliedRules.getAppliedRules().addAll((Collection)entry.getValue());
                            shipmentProductAppliedRules.setShipment(shipmentReference);
                            existCtr = EntityContainer.create((BaseEntity)shipmentProductAppliedRules);
                            resultAppliedRules.put(entry.getKey(), existCtr);
                        } else {
                            List existAppliedRules = ((ShipmentProductAppliedRules)existCtr.getEntity()).getAppliedRules();
                            existAppliedRules.removeIf(existRule -> ((List)entry.getValue()).stream().noneMatch(rule -> MiscUtil.equals((Object)existRule.getRuleUid(), (Object)rule.getRuleUid())));
                            for (AppliedRule appliedRule : entry.getValue()) {
                                AppliedRule existAppliedRule = existAppliedRules.stream().filter(item -> MiscUtil.equals((Object)item.getRuleUid(), (Object)appliedRule.getRuleUid())).findFirst().orElse(null);
                                if (existAppliedRule != null) {
                                    Date calculationDate = existAppliedRule.getCalculationDate();
                                    String ruleUid = existAppliedRule.getUid();
                                    appliedRule.setCalculationDate(calculationDate);
                                    appliedRule.setUid(ruleUid);
                                    existAppliedRules.remove(existAppliedRule);
                                }
                                existAppliedRules.add(appliedRule);
                            }
                        }
                        existCtr.getVersionInfo().setDataSource("ShipmentAppliedRulesMigrateTask");
                        EntityStorage.get().save(existCtr, true);
                    }
                }
            }
            iterator.remove();
        }
        this.log.debug("shipment applied rules migration finished");
        callback.taskFinished();
    }

    private boolean isProductFound(String productUid) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)productUid));
        return EntityStorage.get().search(CommonProductIndex.class, query).getData().size() != 0;
    }

    private boolean isAppliedRulesExists(EntityReference<Shipment> shipment) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentProductAppliedRulesIndex.Property.shipment.name(), shipment));
        return !EntityStorage.get().search(ShipmentProductAppliedRulesIndex.class, query).getData().isEmpty();
    }

    private void updateUids(Date startDate, Date endDate) {
        if (!this.toProceed.isEmpty()) {
            return;
        }
        EntityStorage entityStorage = EntityStorage.get();
        EntityReference customer = this.configuration.getCustomer();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ShipmentIndex.Property.date.name(), (Object)startDate));
        query.getCriteria().getCriterions().add(SearchCriterion.le((String)ShipmentIndex.Property.date.name(), (Object)endDate));
        if (customer != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentIndex.Property.customer.name(), (Object)customer));
        }
        Set uids = entityStorage.search(ShipmentIndex.class, query).getData().stream().map(item -> entityStorage.resolve(item.getSource())).filter(Objects::nonNull).map(BaseIdentity::getUid).collect(Collectors.toSet());
        this.toProceed.addAll(uids);
    }
}

