/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptorReference;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Element;

public class SuAgencyCodesUpdate1Jan2013Task
extends BaseLongRunningTask<Serializable> {
    private final Set<String> toProceed = new LinkedHashSet<String>();

    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.SuAgencyCodesUpdate1Jan2013Task_updateCodeForAgency, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        for (Element element : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(element.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    @Override
    public void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        String fileName = "SU_codes.csv";
        Map<String, String> oldNewCodes = this.getOldNewCodes(fileName);
        this.log.debug("agency SU codes update started");
        this.updateUids();
        int count = this.toProceed.size();
        this.log.debug(String.format("uids updated, remains " + count, new Object[0]));
        int n = 0;
        for (String item : this.toProceed) {
            if (this.isToBeStopped()) {
                this.log.debug("task is interupted");
                return;
            }
            ++n;
            String orgTitle = item;
            try {
                EntityContainer ctr = EntityStorage.get().find(OrganizationIndex.class, "uid", (Object)item);
                orgTitle = ((Organization)ctr.getEntity()).toString();
                this.log.debug(String.format("processing organization %s, %s from %s (%s%%)", orgTitle, Integer.toString(n), Integer.toString(count), Integer.toString(100 * n / count)));
                if (n % 100 == 0) {
                    callback.updateProgress((byte)(100 * n / count));
                }
                boolean changed = false;
                Organization org = (Organization)ctr.getEntity();
                Metadata removeMd = null;
                Metadata newMd = new Metadata();
                newMd.setKey((DictionaryReference)new MetadataKeyDescriptorReference(MetadataKey.KEY_SU_2013_AGENCY_CODE.name()));
                for (Metadata md : org.getMetadata()) {
                    String oldCode;
                    String newCode;
                    if (md.getKey().getCode().equals(MetadataKey.KEY_SU_AGENCY_CODE.name()) && (newCode = oldNewCodes.get(oldCode = (String)md.getValue())) != null) {
                        newMd.setValue((Object)newCode);
                    }
                    if (!md.getKey().getCode().equals(MetadataKey.KEY_SU_2013_AGENCY_CODE.name())) continue;
                    removeMd = md;
                }
                if (removeMd != null) {
                    org.getMetadata().remove(removeMd);
                }
                if (!TextUtil.isBlank((String)((String)newMd.getValue()))) {
                    org.getMetadata().add(newMd);
                    changed = true;
                }
                if (!changed) continue;
                ctr.getVersionInfo().setDataSource("update-task");
                EntityStorage.get().save(ctr, true);
            }
            catch (Throwable e) {
                this.log.error("unable to update agency " + orgTitle, e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.SuAgencyCodesUpdate1Jan2013Task_onUpdateAgencyHasError, (Throwable)e, (Object[])new Object[]{orgTitle}));
            }
        }
        callback.taskFinished();
        this.log.debug("supplier and agency update finished");
    }

    private void updateUids() throws Exception {
        if (!this.toProceed.isEmpty()) {
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY.name()));
        SearchResult result = EntityStorage.get().search(OrganizationIndex.class, query);
        for (OrganizationIndex index : result.getData()) {
            this.toProceed.add(index.getUid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getOldNewCodes(String fileName) throws IOException {
        BufferedReader reader;
        HashMap<String, String> oldNewCodes;
        block6: {
            oldNewCodes = new HashMap<String, String>();
            if (TextUtil.isBlank((String)fileName)) {
                this.log.warn("file name aren't specified.");
                return oldNewCodes;
            }
            URL url = this.getCodesUrl(fileName);
            if (!IoUtil.isResourceExists((URL)url)) {
                this.log.debug(String.format("resource with URL \"%s\" does not exist", url));
                return oldNewCodes;
            }
            reader = null;
            reader = new BufferedReader(new InputStreamReader(IoUtil.getResourceInputStream((URL)url)));
            if (reader.readLine() != null) break block6;
            this.log.warn("data file was empty");
            HashMap<String, String> hashMap = oldNewCodes;
            IOUtils.closeQuietly((Reader)reader);
            return hashMap;
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] pair = line.split(";");
                if (pair.length < 2 || pair[0].trim().isEmpty()) continue;
                oldNewCodes.put(pair[0].trim(), pair[1].trim());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return oldNewCodes;
    }

    protected URL getCodesUrl(String fileName) throws MalformedURLException, IOException {
        return new URL(String.format("file:///%s/setup/entity/codes/%s", Environment.getConfigurationFolder().getCanonicalPath(), fileName));
    }
}

