/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.TchRouteRestrictions;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import org.w3c.dom.Element;

public class TCHCommissionsUpdateTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.TCHCommissionsUpdateTask_updataTKP, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        for (EntityReference ctrRef : StorageHelper.getEntityReferences((SearchQuery)new SearchQuery(), ContractIndex.class)) {
            if (this.isToBeStopped()) {
                this.log.debug("task is interupted");
                return;
            }
            this.log.debug("updating contract " + ctrRef);
            try {
                EntityContainer ctr = EntityStorage.get().resolve(ctrRef);
                RuleSet ruleSet = ((Contract)ctr.getEntity()).getRuleSet();
                if (ruleSet == null) {
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.TCHCommissionsUpdateTask_onContractNoRule, (Object[])new Object[]{ctrRef}));
                    continue;
                }
                boolean changed = false;
                for (RuleSettings settings : ruleSet.getRules()) {
                    for (RuleRestriction restriction : settings.getRestrictions()) {
                        if (restriction.getProperty() == null || !Properties.TCH_ROUTE.getId().equals(restriction.getProperty().getId()) || !(restriction.getValue() instanceof TchRouteRestrictions)) continue;
                        TchRouteRestrictions routeRestr = (TchRouteRestrictions)restriction.getValue();
                        if (restriction.getCondition() == null || Conditions.TCH_ROUTE_SEGMENT.getId().equals(restriction.getCondition().getId()) != routeRestr.isAppliedToSegment()) {
                            restriction.setCondition((RuleCondition)(routeRestr.isAppliedToSegment() ? Conditions.TCH_ROUTE_SEGMENT : Conditions.TCH_ROUTE_ALL));
                        }
                        changed = true;
                    }
                }
                if (!changed) continue;
                ctr.getVersionInfo().setDataSource("server-task");
                ctr.getVersionInfo().setVersionNotes("modified by task " + MiscUtil.getSimpleClassName(this.getClass()));
                EntityStorage.get().save(ctr, true);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.TCHCommissionsUpdateTask_processedContract, (Object[])new Object[]{ctrRef}));
            }
            catch (Throwable e) {
                this.log.error("unable to update contract " + ctrRef, e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.TCHCommissionsUpdateTask_errorProcessingContract, (Throwable)e, (Object[])new Object[]{ctrRef}));
            }
        }
        callback.taskFinished();
    }

    @Override
    public boolean isIndefinite() {
        return true;
    }
}

