/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.helper.SearchHelper;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.AgreementType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Contract2ModelContract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContract2Organization;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PaymentConditions;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.tasks.TransformContractsTaskConfiguration;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class TransformContractsTask
extends BaseLongRunningTask<TransformContractsTaskConfiguration> {
    public TransformContractsTaskConfiguration config;

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)MetaRegistryHelper.getDisplayName(TransformContractsTaskConfiguration.class), (Object[])new Object[0]);
    }

    @Override
    public void configure(TransformContractsTaskConfiguration configuration) throws Exception {
        this.config = configuration;
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeObject((Element)elm, (String)"config", (Object)this.config);
    }

    public void fromXML(Element elm) throws Exception {
        this.config = (TransformContractsTaskConfiguration)XHelper.readObject((Element)elm, (String)"config");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        EntityReference allClientsProfile = ProfileDao.findAllClientsProfile();
        EntityStorage.get().actualize(allAgenciesProfile);
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041f\u0440\u043e\u0444\u0438\u043b\u044c \u0432\u0441\u0435 \u0430\u0433\u0435\u043d\u0441\u0442\u0432\u0430: {0}", (Object[])new Object[]{allAgenciesProfile != null ? allAgenciesProfile.toString() : "\u043d\u0435\u0442"}));
        EntityStorage.get().actualize(allClientsProfile);
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041f\u0440\u043e\u0444\u0438\u043b\u044c \u0432\u0441\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u044b: {0}", (Object[])new Object[]{allClientsProfile != null ? allClientsProfile.toString() : "\u043d\u0435\u0442"}));
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), (Object)false), SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), null)}));
        if (this.config.getCriterions() != null) {
            query.getCriteria().getCriterions().addAll(this.config.getCriterions());
        }
        List data = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432: {0}", (Object[])new Object[]{data.size()}));
        int i = 0;
        int p = 0;
        for (Map.Entry entry : data.stream().collect(Collectors.groupingBy(ContractCustomerIndex::getSource, Collectors.toList())).entrySet()) {
            EntityContainer oldContractCtr = EntityStorage.get().resolve(entry.getKey());
            if (null == oldContractCtr) continue;
            ArrayList<ContractCustomerInfo> converted = new ArrayList<ContractCustomerInfo>();
            try {
                Contract oldContract = (Contract)oldContractCtr.getEntity();
                EntityReference<ModelContract> modelContractRef = null;
                for (ContractCustomerIndex index : entry.getValue()) {
                    block26: {
                        if (!this.isToBeStopped()) break block26;
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0437\u0430\u0434\u0430\u0447\u0430 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430", (Object[])new Object[0]));
                        return;
                    }
                    try {
                        ContractCustomerInfo customerInfo;
                        int p2 = 100 * i++ / data.size();
                        if (p2 - p >= 5) {
                            p = p2;
                            callback.updateProgress((byte)p);
                        }
                        if (TextUtil.isBlank((String)index.getNavigationKey()) || index.getSupplier() == null && index.getContractType() != ContractType.VENDOR || index.getCustomer() == null || null == (customerInfo = (ContractCustomerInfo)oldContract.getCustomers().stream().filter(ci -> Objects.equals(ci.getUid(), index.getNavigationKey())).findFirst().orElse(null)) || customerInfo.getCustomer() == null) continue;
                        if (this.isContractExists(index)) {
                            this.log.info("\u0434\u043e\u0433\u043e\u0432\u043e\u0440 \"" + index.getNumber() + "\" (" + index.getSupplier() + ", " + index.getCustomer() + ") \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442, \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c. " + index.getSource().getUid() + "/" + index.getNavigationKey());
                            if (data.size() < 20) {
                                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)("\u0434\u043e\u0433\u043e\u0432\u043e\u0440 \"" + index.getNumber() + "\" (" + index.getSupplier() + ", " + index.getCustomer() + ") \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442, \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c. " + index.getSource().getUid() + "/" + index.getNavigationKey()), (Object[])new Object[0]));
                            }
                            converted.add(customerInfo);
                            continue;
                        }
                        this.log.info("\u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \"" + index.getNumber() + "\" (" + index.getSupplier() + ", " + index.getCustomer() + "). " + index.getSource().getUid() + "/" + index.getNavigationKey());
                        if (null == modelContractRef) {
                            modelContractRef = this.createOrGetModelContract((EntityContainer<Contract>)oldContractCtr);
                        }
                        EntityReference allSupplierRef = null;
                        EntityReference allClientRef = null;
                        ContractType contractType = oldContract.getContractType();
                        if (contractType != null) {
                            switch (contractType) {
                                case VENDOR: {
                                    allClientRef = allAgenciesProfile;
                                    break;
                                }
                                case SUBAGENCY: {
                                    allSupplierRef = allAgenciesProfile;
                                    allClientRef = allAgenciesProfile;
                                    break;
                                }
                                case CLIENT: {
                                    allSupplierRef = allAgenciesProfile;
                                    allClientRef = allClientsProfile;
                                }
                            }
                        }
                        if (allSupplierRef != null && Objects.equals(index.getSupplier(), allSupplierRef)) {
                            if (allClientRef != null && Objects.equals(index.getCustomer(), allClientRef)) {
                                LockUtil.lock(modelContractRef, modelContractCtr -> {
                                    ModelContract modalContract = (ModelContract)modelContractCtr.getEntity();
                                    if (modalContract.getContractType() == contractType) {
                                        return;
                                    }
                                    modalContract.setContractType(contractType);
                                    modelContractCtr.getVersionInfo().setVersionNotes("attach to all contracts");
                                    modelContractCtr.getVersionInfo().setDataSource("transform-contracts-task");
                                    EntityStorage.get().save(modelContractCtr, true);
                                });
                                converted.add(customerInfo);
                                continue;
                            }
                            LockUtil.lock(modelContractRef, modelContractCtr -> {
                                ModelContract modalContract = (ModelContract)modelContractCtr.getEntity();
                                if (modalContract.getCustomers().stream().anyMatch(mc2o -> Objects.equals(mc2o.getOrganization(), index.getCustomer()) && Objects.equals(mc2o.getStartDate(), index.getStartDate()) && Objects.equals(mc2o.getEndDate(), index.getEndDate()))) {
                                    return;
                                }
                                ModelContract2Organization mc2o2 = new ModelContract2Organization();
                                mc2o2.setOrganization(index.getCustomer());
                                mc2o2.setStartDate(index.getStartDate());
                                mc2o2.setEndDate(index.getEndDate());
                                modalContract.getCustomers().add(mc2o2);
                                modelContractCtr.getVersionInfo().setVersionNotes("add customer " + index.getCustomer().getCaption() + "/" + index.getCustomer().getUid());
                                modelContractCtr.getVersionInfo().setDataSource("transform-contracts-task");
                                EntityStorage.get().save(modelContractCtr, true);
                            });
                            converted.add(customerInfo);
                            continue;
                        }
                        if (allClientRef != null && Objects.equals(index.getCustomer(), allClientRef)) {
                            LockUtil.lock(modelContractRef, modelContractCtr -> {
                                ModelContract modalContract = (ModelContract)modelContractCtr.getEntity();
                                if (modalContract.getSuppliers().stream().anyMatch(mc2o -> Objects.equals(mc2o.getOrganization(), index.getCustomer()) && Objects.equals(mc2o.getStartDate(), index.getStartDate()) && Objects.equals(mc2o.getEndDate(), index.getEndDate()))) {
                                    return;
                                }
                                ModelContract2Organization mc2o2 = new ModelContract2Organization();
                                mc2o2.setOrganization(index.getSupplier());
                                mc2o2.setStartDate(index.getStartDate());
                                mc2o2.setEndDate(index.getEndDate());
                                modalContract.getSuppliers().add(mc2o2);
                                modelContractCtr.getVersionInfo().setVersionNotes("add supplier " + index.getSupplier().getCaption() + "/" + index.getSupplier().getUid());
                                modelContractCtr.getVersionInfo().setDataSource("transform-contracts-task");
                                EntityStorage.get().save(modelContractCtr, true);
                            });
                            converted.add(customerInfo);
                            continue;
                        }
                        if (EntityStorage.get().resolve(customerInfo.getCustomer()) == null) {
                            this.log.info("\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u043d\u0435 \u0432\u0430\u043b\u0438\u0434\u043d\u044b\u0439 \u043a\u043b\u0438\u0435\u043d\u0442 \"" + index.getNumber() + "\" (" + index.getSupplier() + ", " + index.getCustomer() + ") \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442, \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c. " + index.getSource().getUid() + "/" + index.getNavigationKey());
                            continue;
                        }
                        EntityContainer newContractCtr = new EntityContainer(Contract.class);
                        Contract newContract = (Contract)newContractCtr.getEntity();
                        newContract.setNewModel(true);
                        newContract.setDisabled(oldContract.isDisabled());
                        newContract.setName(this.generateContractName(oldContract, customerInfo, (EntityReference<Organization>)allAgenciesProfile, (EntityReference<Organization>)allClientsProfile));
                        newContract.setNotes(oldContract.getNotes());
                        newContract.setVendor(oldContract.getVendor());
                        newContract.setSupplier(oldContract.getSupplier());
                        newContract.setProvider(oldContract.getProvider());
                        newContract.setContractType(oldContract.getContractType());
                        newContract.setVATExemption(oldContract.isVATExemption());
                        newContract.setAgreementType(AgreementType.AGENCY_CONTRACT);
                        newContract.setNumber(customerInfo.getNumber());
                        newContract.setCustomer(customerInfo.getCustomer());
                        newContract.setIssueDate(customerInfo.getIssueDate());
                        MiscUtil.Pair<Date, Date> dates = this.getContractDates(oldContract, customerInfo);
                        newContract.setStartDate((Date)dates.getFirst());
                        newContract.setEndDate((Date)dates.getSecond());
                        newContract.setTourCode(customerInfo.getTourCode());
                        newContract.setVendorContractType(customerInfo.getVendorContractType());
                        newContract.getAppendices().addAll(customerInfo.getAppendices());
                        newContract.setPaymentCurrency(customerInfo.getPaymentCurrency());
                        PaymentConditions newPaymentConditions = newContract.getPaymentConditions();
                        PaymentConditions oldPaymentConditions = customerInfo.getPaymentConditions();
                        newPaymentConditions.setDeposite(oldPaymentConditions.isDeposite());
                        newPaymentConditions.setDepositeAmount(oldPaymentConditions.getDepositeAmount());
                        newPaymentConditions.getPaymentItems().addAll(oldPaymentConditions.getPaymentItems());
                        newContract.getTchDirectContracts().addAll(customerInfo.getTchDirectContracts());
                        newContract.getExchangeRateConditions().addAll(customerInfo.getExchangeRateConditions());
                        newContract.setUseSeparateBSPContract(customerInfo.isUseSeparateBSPContract());
                        newContract.getFopSettings().addAll(customerInfo.getFopSettings());
                        this.addModelContracts(newContract);
                        if (newContract.getEndDate() == null || newContract.getEndDate().after(new Date())) {
                            newContract.setDefaultContract(newContract.getVendor() == null && !this.hasDefaultContract(index));
                        }
                        newContractCtr.getVersionInfo().setVersionNotes("create");
                        newContractCtr.getVersionInfo().setDataSource("transform-contracts-task");
                        EntityStorage.get().save(newContractCtr, true);
                        converted.add(customerInfo);
                    }
                    catch (InterruptedException e) {
                        this.log.error("interrupted", (Throwable)e);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0437\u0430\u0434\u0430\u0447\u0430 \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u0430", (Throwable)e, (Object[])new Object[]{e.getMessage()}));
                        throw e;
                    }
                    catch (Throwable t) {
                        this.log.error("\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + index.getName() + "/" + (index.getSource() != null ? index.getSource().getUid() : null) + "), customer=" + (index.getCustomer() != null ? index.getCustomer().getCaption() + "/" + index.getCustomer().getUid() : null), t);
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 {0}", (Throwable)t, (Object[])new Object[]{t.getMessage()}));
                    }
                }
            }
            finally {
                this.markConverted((EntityContainer<Contract>)oldContractCtr, converted);
            }
        }
        callback.updateProgress((byte)100);
        callback.addEvent("progress", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e", (Object[])new Object[0]));
        callback.taskFinished();
    }

    protected String generateContractName(Contract oldContract, ContractCustomerInfo customerInfo, EntityReference<Organization> allAgenciesProfile, EntityReference<Organization> allClientsProfile) {
        String name = oldContract.getCustomers().stream().filter(c -> c.getCustomer() != null && !Objects.equals(customerInfo.getCustomer(), allClientsProfile) && !Objects.equals(customerInfo.getCustomer(), allAgenciesProfile)).count() == 1L ? oldContract.getName() : String.join((CharSequence)" ", oldContract.getName(), MiscUtil.guarded((String)customerInfo.getNumber()).trim(), this.getCustomerName((EntityReference<Organization>)customerInfo.getCustomer()));
        return name + " (\u043d\u043e\u0432\u044b\u0439)";
    }

    protected String getCustomerName(EntityReference<Organization> customerRef) {
        if (null == customerRef) {
            return "(\u043a\u043b\u0438\u0435\u043d\u0442 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442)";
        }
        EntityContainer customerCtr = EntityStorage.get().resolve(customerRef);
        if (null == customerCtr) {
            String name = customerRef.toString().trim();
            return TextUtil.nonBlank((String)name) ? name : "(\u043a\u043b\u0438\u0435\u043d\u0442 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442)";
        }
        String name = ((Organization)customerCtr.getEntity()).getShortName().toString();
        if (TextUtil.nonBlank((String)name)) {
            return name;
        }
        name = ((Organization)customerCtr.getEntity()).getFullName().toString();
        if (TextUtil.nonBlank((String)name)) {
            return name;
        }
        return customerRef.toString().trim();
    }

    private void markConverted(EntityContainer<Contract> oldContractCtr, List<ContractCustomerInfo> customerInfoList) throws TimeoutException, InterruptedException {
        if (customerInfoList.isEmpty()) {
            return;
        }
        LockUtil.lock(oldContractCtr, ctr -> {
            boolean modified = false;
            for (ContractCustomerInfo customerInfo : customerInfoList) {
                ContractCustomerInfo ci = ((Contract)ctr.getEntity()).getCustomers().stream().filter(c -> Objects.equals(c.getUid(), customerInfo.getUid())).findFirst().orElse(null);
                if (ci == null || ci.isConvertedToNewModel()) continue;
                ci.setConvertedToNewModel(true);
                modified = true;
            }
            if (modified) {
                ctr.getVersionInfo().setVersionNotes("mark converted customers");
                ctr.getVersionInfo().setDataSource("transform-contracts-task");
                EntityStorage.get().save(ctr, true);
            }
        });
    }

    private MiscUtil.Pair<Date, Date> getContractDates(Contract oldContract, ContractCustomerInfo customerInfo) {
        List contracts = SearchHelper.searchEntity(ContractCustomerIndex.class, (SearchCriterion[])new SearchCriterion[]{SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), null), SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), (Object)false)}), SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)oldContract.getSupplier()), SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)customerInfo.getCustomer()), SearchCriterion.eq((String)ContractCustomerIndex.Property.number.name(), (Object)customerInfo.getNumber()), SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), (Object)oldContract.getVendor()), SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)oldContract.getContractType())});
        MiscUtil.Pair result = new MiscUtil.Pair();
        boolean first = true;
        for (ContractCustomerIndex index : contracts) {
            if (first) {
                result.setFirst((Object)index.getStartDate());
                result.setSecond((Object)index.getEndDate());
                first = false;
                continue;
            }
            if (index.getStartDate() == null || result.getFirst() != null && ((Date)result.getFirst()).after(index.getStartDate())) {
                result.setFirst((Object)index.getStartDate());
            }
            if (index.getEndDate() != null && (result.getSecond() == null || !((Date)result.getSecond()).before(index.getEndDate()))) continue;
            result.setSecond((Object)index.getEndDate());
        }
        return result;
    }

    private boolean hasDefaultContract(ContractCustomerIndex index) {
        return SearchHelper.hasEntity(ContractIndex.class, (SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true), SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)index.getSupplier()), SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)index.getCustomer()), SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)index.getContractType()), SearchCriterion.eq((String)ContractIndex.Property.defaultContract.name(), (Object)true)});
    }

    private void addModelContracts(Contract newContract) {
        List contracts = SearchHelper.searchEntity(ContractCustomerIndex.class, (SearchCriterion[])new SearchCriterion[]{SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), null), SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), (Object)false)}), SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)newContract.getSupplier()), SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)newContract.getCustomer()), SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)newContract.getContractType())});
        for (ContractCustomerIndex index : contracts) {
            EntityContainer oldContractCtr = EntityStorage.get().resolve(index.getSource());
            EntityReference<ModelContract> modelContractRef = this.createOrGetModelContract((EntityContainer<Contract>)oldContractCtr);
            Contract2ModelContract c2mc = new Contract2ModelContract();
            c2mc.setModelContract(modelContractRef);
            c2mc.setStartDate(index.getStartDate());
            c2mc.setEndDate(index.getEndDate());
            ContractCustomerInfo customerInfo = (ContractCustomerInfo)CollectionUtil.find((Iterable)((Contract)oldContractCtr.getEntity()).getCustomers(), (String)index.getNavigationKey());
            c2mc.setTranslateSupplierFees(null == customerInfo || customerInfo.isTranslateSupplierFees());
            newContract.getModelContracts().add(c2mc);
        }
    }

    private boolean isContractExists(ContractCustomerIndex index) {
        return SearchHelper.hasEntity(ContractIndex.class, (SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true), SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)index.getSupplier()), SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)index.getCustomer()), SearchCriterion.eq((String)ContractIndex.Property.number.name(), (Object)index.getNumber()), SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), (Object)index.getVendor()), SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)index.getContractType())});
    }

    private EntityReference<ModelContract> createOrGetModelContract(EntityContainer<Contract> oldContractCtr) {
        EntityReference oldContractRef = oldContractCtr.toReference();
        EntityContainer modelContractCtr = SearchHelper.searchEntity(ModelContractIndex.class, (SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ModelContractIndex.Property.sourceContract.name(), (Object)oldContractRef)}).stream().map(i -> EntityStorage.get().resolve(i.getSource())).filter(Objects::nonNull).findFirst().orElse(null);
        if (modelContractCtr != null) {
            return modelContractCtr.toReference();
        }
        Contract oldContract = (Contract)oldContractCtr.getEntity();
        modelContractCtr = new EntityContainer(ModelContract.class);
        ModelContract modelContract = (ModelContract)modelContractCtr.getEntity();
        modelContract.setDisabled(oldContract.isDisabled());
        modelContract.setPriority(oldContract.getPriority());
        modelContract.setName(oldContract.getName());
        modelContract.setNotes(oldContract.getNotes());
        modelContract.setRuleSet(oldContract.getRuleSet());
        try {
            modelContract.setValue("agentClient", oldContract.getValue("agentClient"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        modelContract.setLastTchNotificationDate((Date)oldContract.getCustomers().stream().map(ContractCustomerInfo::getLastTchNotificationDate).filter(Objects::nonNull).findFirst().orElse(null));
        modelContract.setSourceContract(oldContractRef);
        modelContractCtr.getVersionInfo().setVersionNotes("create");
        modelContractCtr.getVersionInfo().setDataSource("transform-contracts-task");
        EntityStorage.get().save(modelContractCtr, true);
        return modelContractCtr.toReference();
    }
}

