/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.profile.TripartiteContractInfo;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.licence.Address;
import com.gridnine.xtrip.server.model.licence.TripartiteContractUsageRequest;
import com.gridnine.xtrip.server.model.licence.TripartiteContractUsageResponse;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.PluginDescriptor;
import org.w3c.dom.Element;

public class TripartiteContractUsageTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public void configure(Serializable configuration) throws Exception {
    }

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.TripartiteContractUsageTask_title, (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        if (!this.isTripartiteContractCheckNeeded()) {
            return;
        }
        this.log.debug("tripartite contract usage task started");
        try {
            List<TripartiteContractInfo> contracts = this.collectTripartiteContractUsageInfo(callback);
            this.sendTripartiteContractUsageInfo(contracts);
        }
        catch (InterruptedException ex) {
            this.log.debug("task was interrupted while sending tripartite contract usage info", (Throwable)ex);
        }
        catch (Exception ex) {
            this.log.debug("exception while sending tripartite contract usage info", (Throwable)ex);
        }
        this.log.debug("tripartite contract usage task  finished");
        callback.taskFinished();
    }

    private List<TripartiteContractInfo> collectTripartiteContractUsageInfo(LongRunningTask.EventsCallback callback) throws InterruptedException {
        ArrayList<TripartiteContractInfo> res = new ArrayList<TripartiteContractInfo>();
        EntityReference anyClientProfile = ProfileDao.findAllClientsProfile();
        for (EntityReference ctrRef : StorageHelper.getEntityReferences((SearchQuery)new SearchQuery(), TripartiteContractIndex.class)) {
            if (this.isToBeStopped()) {
                this.log.debug("task is interupted");
                throw new InterruptedException();
            }
            try {
                TripartiteContract ctr;
                EntityContainer ctrCont = EntityStorage.get().resolve(ctrRef);
                if (ctrCont == null || ctrCont.getEntity() == null || (ctr = (TripartiteContract)ctrCont.getEntity()).getAgency() == null || ctr.getCustomers().isEmpty() || (ctr.getAviaVendorData() == null || ctr.getAviaVendorData().getAirlines().isEmpty() && ctr.getAviaVendorData().getAlliances().isEmpty()) && (ctr.getHotelVendorData() == null || ctr.getHotelVendorData().getBrands().isEmpty()) && (ctr.getCarVendorData() == null || ctr.getCarVendorData().getSuppliers().isEmpty())) continue;
                TripartiteContractInfo info = new TripartiteContractInfo();
                info.setName(ctr.getName());
                info.setType(ctr.getType());
                info.setAgency(ctr.getAgency().getCaption());
                for (TripartiteContractCustomerInfo client : ctr.getCustomers()) {
                    if (client.getCustomer() == null || !client.getCustomer().equals((Object)anyClientProfile)) continue;
                    info.setHasAnyClientSetting(Boolean.TRUE.booleanValue());
                }
                res.add(info);
            }
            catch (Throwable e) {
                this.log.error("unable to update contract " + ctrRef, e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ContractMigrationTask_errorProcessingContract, (Throwable)e, (Object[])new Object[]{ctrRef}));
            }
        }
        return res;
    }

    private boolean isTripartiteContractCheckNeeded() {
        return !TripartiteContractUsageTask.hasExtensionEndsWith("NoLicenceChecker");
    }

    public static boolean hasExtensionEndsWith(String suffix) {
        for (PluginDescriptor descr : PluginManager.lookup(JpfUtil.class).getRegistry().getPluginDescriptors()) {
            for (Extension ext : descr.getExtensions()) {
                if (ext.getId() == null || !ext.getId().endsWith(suffix)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TripartiteContractUsageResponse sendTripartiteContractUsageInfo(List<TripartiteContractInfo> contracts) {
        TripartiteContractUsageRequest data = new TripartiteContractUsageRequest();
        data.setAppId(Environment.getApplicationId());
        data.setIpAddress(this.getIpAddressStr());
        data.getContracts().addAll(contracts);
        StringBuilder traceString = new StringBuilder();
        SynchronizationResponse<TripartiteContractUsageResponse> response = this.processRequest(data);
        TripartiteContractUsageResponse tripCtrUsageResponse = null;
        try {
            for (Message msg : response.getMessages()) {
                if (msg.getType() != MessageType.ERROR) continue;
                this.log.warn("Request to LicenceServer for tripartite contract usage had errors: " + msg.getMessage());
                traceString.append("\r\nError while sending tripartite contract usage: " + msg.getMessage());
                TripartiteContractUsageResponse tripartiteContractUsageResponse = null;
                return tripartiteContractUsageResponse;
            }
            tripCtrUsageResponse = response.getData();
        }
        catch (Exception e) {
            this.log.error("Unable to send tripartite contract usage to licence server", (Throwable)e);
            traceString.append(String.format("\r\nUnable to send tripartite contract usage to licence server:\n %s", TextUtil.getExceptionStackTrace((Throwable)e)));
        }
        finally {
            SynchronizationHelper.log(traceString.toString(), "tripartite-contract-usage");
        }
        return tripCtrUsageResponse;
    }

    private SynchronizationResponse<TripartiteContractUsageResponse> processRequest(TripartiteContractUsageRequest data) {
        SynchronizationRequest<TripartiteContractUsageRequest> request = new SynchronizationRequest<TripartiteContractUsageRequest>();
        request.setClientId(Environment.getApplicationId());
        request.setData(data);
        request.setOperationId("tripartite-contract-usage");
        request.setUser("TripartiteContractUsageTaskUser");
        ValueHolder trace = new ValueHolder();
        SynchronizationResponse<TripartiteContractUsageResponse> response = SynchronizationHelper.execute(request, Address.getSync(), (ValueHolder<String>)trace);
        return response;
    }

    private String getIpAddressStr() {
        InetAddress ip = this.getIpAddress();
        return ip != null ? ip.getHostAddress() : "";
    }

    private InetAddress getIpAddress() {
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ip;
    }
}

