/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.List;
import org.w3c.dom.Element;

public class UserAccountsDeleteTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439", (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("user accounts delete started");
        if (this.isToBeStopped()) {
            this.log.debug("task is interupted");
            return;
        }
        try {
            int n = 0;
            SearchQuery query = new SearchQuery();
            query.setResultMode(ResultMode.COUNT_ONLY);
            int total = AssetsStorage.get().search(UserAccount.class, query).getTotalCount();
            query.getPreferredProperties().add(UserAccount.Property.loginName.name());
            query.getCriteria().getOrders().put(UserAccount.Property.loginName.name(), SortOrder.ASC);
            query.setResultMode(ResultMode.DATA_ONLY);
            int offset = 0;
            int limit = 10;
            while (true) {
                query.setOffset(offset);
                query.setLimit(limit);
                List userAccounts = AssetsStorage.get().search(UserAccount.class, query).getData();
                for (UserAccount userAccount : userAccounts) {
                    EntityContainer person;
                    if (this.isToBeStopped()) {
                        this.log.debug("task is interupted");
                        return;
                    }
                    byte progress = (byte)(100 * ++n / total);
                    this.log.debug(String.format("processing user account %s of %s (%s%%)", String.valueOf(n), String.valueOf(total), String.valueOf(progress)));
                    if (n % 20 == 0) {
                        callback.updateProgress(progress);
                    }
                    if (userAccount.getLoginName().equals(AclHelper.system.getId()) || userAccount.getLoginName().equals(AclHelper.admin.getId()) || (person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userAccount.getLoginName())) != null) continue;
                    AssetsStorage.get().delete((BaseAsset)userAccount);
                    AclUser user = com.gridnine.xtrip.server.security.acl.helper.AclHelper.getUser((String)userAccount.getLoginName());
                    if (user != null) {
                        AssetsStorage.get().delete((BaseAsset)user);
                    }
                    for (AclEntry entry : com.gridnine.xtrip.server.security.acl.helper.AclHelper.getEntries((String)userAccount.getLoginName())) {
                        AssetsStorage.get().delete((BaseAsset)entry);
                    }
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0423\u0447\u0435\u0442\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c {0} \u0443\u0434\u0430\u043b\u0435\u043d\u0430", (Object[])new Object[]{userAccount.getLoginName()}));
                }
                if (userAccounts.size() >= limit) {
                    offset += limit;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439", (Object[])new Object[0]));
            this.log.error(String.format("error occured during user accounts delete", new Object[0]), (Throwable)e);
        }
        callback.taskFinished();
        this.log.debug("user accounts delete finished");
    }
}

