/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Element;

public class ValidatorUpdateTask
extends BaseLongRunningTask<Serializable> {
    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.ValidatorUpdateTask_replaceAirlineBlankOwner, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
    }

    public void toXML(Element elm) throws Exception {
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("update started");
        try {
            HashSet<EntityReference> processed = new HashSet<EntityReference>();
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.blankOwner.name(), null));
            List data = EntityStorage.get().search(ValidatorIndex.class, query).getData();
            this.log.debug(String.format("got %s validators to update", Integer.toString(data.size())));
            for (ValidatorIndex index : data) {
                this.log.debug(String.format("processing validator %s of sales point %s", index.getNumber(), index.getSource()));
                if (processed.contains(index.getSource())) {
                    this.log.debug(String.format("sales point %s was already processed", index.getSource()));
                    continue;
                }
                processed.add(index.getSource());
                EntityContainer ctr = EntityStorage.get().resolve(index.getSource());
                boolean changed = false;
                for (Validator val : ((SalesPoint)ctr.getEntity()).getValidators()) {
                    this.log.debug("processing validator " + val.getNumber());
                    if (val.getAirline() == null) {
                        this.log.debug(String.format("there is no airline in validator %s", val.getNumber()));
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ValidatorUpdateTask_validatorNotDefineAirline, (Object[])new Object[]{val.getNumber()}));
                        continue;
                    }
                    List<EntityContainer<Organization>> lst = ProfileDao.getBlankOwnersByAirline((DictionaryReference<Airline>)val.getAirline());
                    if (lst.isEmpty()) {
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ValidatorUpdateTask_errorUpdatingValidator, (Object[])new Object[]{val.getNumber(), val.getAirline().toString()}));
                        this.log.debug(String.format("unable to find blankowner for airline %s", val.getAirline()));
                        continue;
                    }
                    EntityReference blankOwner = lst.get(0).toReference();
                    if (lst.size() > 1) {
                        callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.ValidatorUpdateTask_errorUpdateValidator, (Object[])new Object[]{index.getNumber(), val.getAirline().toString(), blankOwner.toString()}));
                        this.log.debug(String.format("found few blankowner for airline %s, %s will be used", val.getAirline(), blankOwner));
                    }
                    val.setBlankOwner(blankOwner);
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.ValidatorUpdateTask_validatorUpdated, (Object[])new Object[]{val.getAirline().toString(), blankOwner.toString()}));
                    this.log.debug("validator was updated");
                    changed = true;
                }
                if (!changed) continue;
                ctr.getVersionInfo().setDataSource("validator update task");
                EntityStorage.get().save(ctr, true);
            }
        }
        finally {
            this.log.debug("update finished");
            callback.taskFinished();
        }
    }

    @Override
    public boolean isIndefinite() {
        return true;
    }
}

