/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard;

import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class WorklogsUpdateTask
extends BaseLongRunningTask<Serializable> {
    private int count = -1;
    private final Set<String> toProceed = new LinkedHashSet<String>();

    @Override
    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)Messages.WorklogsUpdateTask_description, (Object[])new Object[0]);
    }

    public void fromXML(Element elm) throws Exception {
        Element countElement = XmlUtil.getElement((Element)elm, (String)"count");
        if (countElement != null) {
            this.count = Integer.parseInt(countElement.getAttribute("value"));
        }
        for (Element itemElement : XmlUtil.getElements((Element)elm, (String)"item")) {
            this.toProceed.add(itemElement.getAttribute("uid"));
        }
    }

    public void toXML(Element elm) throws Exception {
        Element countElement = XmlUtil.addElement((Element)elm, (String)"count");
        countElement.setAttribute("value", String.valueOf(this.count));
        for (String item : this.toProceed) {
            Element itemElement = XmlUtil.addElement((Element)elm, (String)"item");
            itemElement.setAttribute("uid", item.trim());
        }
    }

    @Override
    public void configure(Serializable value) throws Exception {
    }

    @Override
    public boolean isIndefinite() {
        return false;
    }

    @Override
    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.debug("worklogs update started");
        this.updateUids();
        if (this.count == -1) {
            this.count = this.toProceed.size();
        }
        int n = this.count - this.toProceed.size();
        this.log.debug(String.format(String.format("uids updated, processed: %s, total: %s", String.valueOf(n), String.valueOf(this.count)), new Object[0]));
        Iterator<String> uidIterator = this.toProceed.iterator();
        while (uidIterator.hasNext()) {
            String uid = uidIterator.next();
            if (this.isToBeStopped()) {
                this.log.debug("task is interrupted");
                return;
            }
            ++n;
            String worklogTitle = uid;
            try {
                SalesPoint salesPoint;
                EntityContainer salesPointContainer;
                EntityContainer worklogContainer = EntityStorage.get().load(Worklog.class, uid);
                if (worklogContainer == null) continue;
                Worklog worklog = (Worklog)worklogContainer.getEntity();
                worklogTitle = worklog.toString();
                byte progress = (byte)(100 * n / this.count);
                this.log.debug(String.format("processing worklog %s, %s of %s (%s%%)", worklogTitle, String.valueOf(n), String.valueOf(this.count), String.valueOf(progress)));
                if (n % 10 == 0) {
                    callback.updateProgress(progress);
                }
                boolean save = false;
                if (worklog.getTypes().size() == 0) {
                    if (worklog.getType() != null) {
                        worklog.getTypes().add(worklog.getType());
                        save = true;
                    }
                    if (worklog.isCashier()) {
                        worklog.getTypes().add(PersonType.CASHIER_CLERK);
                        save = true;
                    }
                }
                if (worklog.getAgency() == null && (salesPointContainer = EntityStorage.get().resolve(worklog.getSalesPoint())) != null && (salesPoint = (SalesPoint)salesPointContainer.getEntity()).getAgency() != null) {
                    worklog.setAgency(salesPoint.getAgency());
                    save = true;
                }
                if (save) {
                    EntityStorage.get().save(worklogContainer, true);
                }
            }
            catch (Throwable e) {
                this.log.error(String.format("unable to update worklog %s", worklogTitle), e);
                callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.WorklogsUpdateTask_worklogUpdateFailed, (Throwable)e, (Object[])new Object[]{worklogTitle}));
            }
            uidIterator.remove();
        }
        callback.taskFinished();
        this.log.debug("worklogs update finished");
    }

    private void updateUids() throws Exception {
        if (this.count != -1 && !this.toProceed.isEmpty()) {
            return;
        }
        LogicalStorage storage = LogicalStorage.get();
        LogicalEntityStorage entityStorage = storage.getEntityStorage();
        List uids = entityStorage.getEntityUids(Worklog.class, null, null, true, true, SortOrder.DESC, null);
        this.toProceed.addAll(uids);
    }
}

