/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tasks.standard.handlers;

import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.BillingItemSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.server.model.tasks.TaskProcessHandler;
import java.util.Arrays;
import java.util.List;

public class FinanceDocumentSettingsBillingItemsSettingsUpdateTaskProcessHandler
implements TaskProcessHandler<FinanceDocumentSettings> {
    @Override
    public String getId() {
        return "finance-document-settings-billing-items-settings-update-task-process-handler";
    }

    @Override
    public boolean process(FinanceDocumentSettings entity) {
        if (entity.getType() == FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.FEE));
        }
        if (entity.getType() == FinanceDocumentType.CASH_ORDER) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.TICKET, ServiceType.FEE, ServiceType.PENALTY));
        }
        if (entity.getType() == FinanceDocumentType.INTERNAL_BILL) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.TICKET, ServiceType.FEE, ServiceType.DISCOUNT, ServiceType.PENALTY));
        }
        if (entity.getType() == FinanceDocumentType.INVOICE_DETAILED) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.TICKET, ServiceType.FEE, ServiceType.DISCOUNT, ServiceType.PENALTY));
        }
        if (entity.getType() == FinanceDocumentType.INVOICE_FACTURA_FEES) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.FEE));
        }
        if (entity.getType() == FinanceDocumentType.INVOICE_FACTURA) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.TICKET, ServiceType.FEE, ServiceType.DISCOUNT, ServiceType.PENALTY));
        }
        if (entity.getType() == FinanceDocumentType.INVOICE) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.TICKET, ServiceType.FEE, ServiceType.DISCOUNT, ServiceType.PENALTY));
        }
        if (entity.getType() == FinanceDocumentType.INVOICE_CONSOLIDATED) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.TICKET, ServiceType.FEE, ServiceType.DISCOUNT, ServiceType.PENALTY));
        }
        if (entity.getType() == FinanceDocumentType.INVOICE_PREPAYMENT) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.TICKET, ServiceType.FEE, ServiceType.DISCOUNT, ServiceType.PENALTY));
        }
        if (entity.getType() == FinanceDocumentType.CORRECTION_DOCUMENT) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.TICKET, ServiceType.FEE, ServiceType.DISCOUNT, ServiceType.PENALTY));
        }
        if (entity.getType() == FinanceDocumentType.RECEIPT) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.TICKET, ServiceType.FEE, ServiceType.DISCOUNT, ServiceType.PENALTY));
        }
        if (entity.getType() == FinanceDocumentType.STANDARD_BILL) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.TICKET, ServiceType.FEE, ServiceType.DISCOUNT, ServiceType.PENALTY));
        }
        if (entity.getType() == FinanceDocumentType.UNIVERSAL_DOCUMENT) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.TICKET, ServiceType.FEE, ServiceType.DISCOUNT, ServiceType.PENALTY));
        }
        return false;
    }

    private boolean updateBillingItemsSettings(FinanceDocumentSettings financeDocumentSettings, List<ServiceType> serviceTypes) {
        if (!financeDocumentSettings.isUseSettings()) {
            return false;
        }
        boolean processed = false;
        for (ServiceType serviceType : ServiceType.values()) {
            boolean includeVat;
            boolean useBillingItem;
            BillingItemSettings billingItemSettings = FinanceDocumentsHelper.getBillingItemSettings((List)financeDocumentSettings.getBillingItemsSettings(), (ServiceType)serviceType);
            if (billingItemSettings == null) {
                billingItemSettings = new BillingItemSettings();
                billingItemSettings.setType(serviceType);
                financeDocumentSettings.getBillingItemsSettings().add(billingItemSettings);
                processed = true;
            }
            if ((useBillingItem = serviceTypes.contains(serviceType)) != billingItemSettings.isUseBillingItem()) {
                billingItemSettings.setUseBillingItem(useBillingItem);
                processed = true;
            }
            if (!useBillingItem || (includeVat = financeDocumentSettings.isIncludeVat()) == billingItemSettings.isIncludeVat()) continue;
            billingItemSettings.setIncludeVat(includeVat);
            processed = true;
        }
        return processed;
    }
}

