/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.tchcommissions;

import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.rules.standard.TchXmlCommissionsImportHelper;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class TchCommissionsTestHelper {
    private static final Logger log = LoggerFactory.getLogger(TchCommissionsTestHelper.class);
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    TchCommissionsTestHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RuleSet parseRulesFromCommissionsFile(URL url) throws Exception {
        try (InputStream is = url.openStream();){
            ZipInputStream zis = new ZipInputStream(is);
            zis.getNextEntry();
            RuleSet ruleSet = TchXmlCommissionsImportHelper.parseRules((Document)DocumentBuilderHelper.parse((InputStream)zis), new ArrayList());
            return ruleSet;
        }
    }

    static boolean equals(RuleSet expected, RuleSet actual) {
        if (expected.getRules().size() != actual.getRules().size()) {
            return false;
        }
        boolean equals = true;
        for (int n = 0; n < actual.getRules().size(); ++n) {
            RuleSettings actualRule = (RuleSettings)actual.getRules().get(n);
            RuleSettings expectedRule = (RuleSettings)expected.getRules().get(n);
            if (!MiscUtil.equals((Object)MiscUtil.clearTime((Date)actualRule.getPeriodBegin()), (Object)MiscUtil.clearTime((Date)expectedRule.getPeriodBegin()))) {
                log.error(String.format("rule %s(%s) actual begin period %s is not equal expected begin period %s", Integer.toString(n), actualRule.getName(), TchCommissionsTestHelper.formatDate(actualRule.getPeriodBegin()), TchCommissionsTestHelper.formatDate(expectedRule.getPeriodBegin())));
                equals = false;
                continue;
            }
            if (!MiscUtil.equals((Object)MiscUtil.setDayEndTime((Date)actualRule.getPeriodEnd()), (Object)MiscUtil.setDayEndTime((Date)expectedRule.getPeriodEnd()))) {
                log.error(String.format("rule %s(%s) actual end period %s is not equal expected end period %s", Integer.toString(n), actualRule.getName(), TchCommissionsTestHelper.formatDate(actualRule.getPeriodEnd()), TchCommissionsTestHelper.formatDate(expectedRule.getPeriodEnd())));
                equals = false;
                continue;
            }
            if (!CollectionUtil.equals((Collection)actualRule.getRestrictions(), (Collection)expectedRule.getRestrictions(), (boolean)true)) {
                log.error(String.format("rule %s(%s) actual restrictions\r %s are not equal expected restrictions\n %s", Integer.toString(n), actualRule.getName(), TchCommissionsTestHelper.formatRestrictions(actualRule.getRestrictions()), TchCommissionsTestHelper.formatRestrictions(expectedRule.getRestrictions())));
                equals = false;
                continue;
            }
            if (CollectionUtil.equals((Collection)actualRule.getResults(), (Collection)expectedRule.getResults(), (boolean)true)) continue;
            log.error(String.format("rule %s(%s) actual results\r %s are not equal expected results\n %s", Integer.toString(n), actualRule.getName(), TchCommissionsTestHelper.formatResults(actualRule.getResults()), TchCommissionsTestHelper.formatResults(expectedRule.getResults())));
            equals = false;
        }
        return equals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RuleSet getRulesFromContract(URL url) throws Exception {
        try (InputStream is = url.openStream();){
            ZipInputStream zis = new ZipInputStream(is);
            zis.getNextEntry();
            RuleSet result = new RuleSet();
            result.fromXML(XmlUtil.getElement((Element)DocumentBuilderHelper.parse((InputStream)zis).getDocumentElement(), (String)"rulesData"));
            RuleSet ruleSet = result;
            return ruleSet;
        }
    }

    static RuleSettings findRuleByName(RuleSet rs, String ruleName) {
        return (RuleSettings)CollectionUtil.find((Collection)rs.getRules(), (Object)ruleName, (CollectionUtil.Equator)new CollectionUtil.Equator<RuleSettings, String>(){

            public boolean equal(RuleSettings o1, String o2) {
                return o1.getName() != null && o1.getName().equals(o2);
            }
        });
    }

    static RuleRestriction findRestriction(RuleSettings rs, RuleProperty prop) {
        return (RuleRestriction)CollectionUtil.find((Collection)rs.getRestrictions(), (Object)prop, (CollectionUtil.Equator)new CollectionUtil.Equator<RuleRestriction, RuleProperty>(){

            public boolean equal(RuleRestriction o1, RuleProperty o2) {
                return o1.getProperty() == o2;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveRulesToFile(RuleSet ruleSet, File file) throws Exception {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (ZipOutputStream os = new ZipOutputStream(file);){
            os.putNextEntry(new ZipEntry("rules.xml"));
            Document doc = DocumentBuilderHelper.newDocument();
            Element root = doc.createElement("rules");
            doc.appendChild(root);
            Element nestedElm = XmlUtil.addElement((Element)root, (String)"rulesData");
            ruleSet.toXML(nestedElm);
            XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult((OutputStream)os));
        }
    }

    static void cleanupCurrencyRates() throws Exception {
        for (CurrencyRate cr : DictionaryCache.get().getAll(CurrencyRate.class).values()) {
            LogicalStorage.get().getStandardDictionaryStorage().delete((BaseDictionary)cr);
        }
        DictionaryCache.get().check();
    }

    private static String formatDate(Date date) {
        return date == null ? null : sdf.format(date);
    }

    private static String formatRestrictions(List<RuleRestriction> restrictions) {
        StringBuilder sb = new StringBuilder();
        for (RuleRestriction rr : restrictions) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            RulesEnvironment.get().findProperty(rr.getProperty().getId()).buildInfo(sb, rr.getCondition(), rr.getValue());
        }
        return sb.toString();
    }

    private static String formatResults(List<RuleResult> results) {
        StringBuilder sb = new StringBuilder();
        for (RuleResult rr : results) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            RulesEnvironment.get().findAction(rr.getAction().getId()).buildInfo(sb, rr.getValue());
        }
        return sb.toString();
    }
}

