/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.templates.jr;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverter;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverterRegistry;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.OBFee;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectContractProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectOrganizationProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjectTravellerProperties;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ItineraryReceiptHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.CommunicationFormat;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ItineraryReceiptHelper;
import com.gridnine.xtrip.common.model.helpers.OrganizationLogotypeHelper;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.model.helpers.PersonalNameFormat;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.ImageUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.QRCodeUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.format.object.Format;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.IIOException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItineraryReceiptRender {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String KEY_AGENCY_NAME = "AGENCY_NAME";
    private static final String KEY_AGENCY_TCH_CODE = "AGENCY_TCH_CODE";
    private static final String KEY_SALES_POINT_ADDRESS = "SALES_POINT_ADDRESS";
    private static final String KEY_SALES_POINT_PHONE = "SALES_POINT_PHONE";
    private static final String KEY_SALES_POINT_CITY = "SALES_POINT_CITY";
    private static final String KEY_SALES_POINT_COUNTRY = "SALES_POINT_COUNTRY";
    private static final String KEY_SALES_POINT_LOCATION = "SALES_POINT_LOCATION";
    private static final String KEY_PNR = "PNR";
    private static final String KEY_BOOKING_NUMBER = "BOOKING_NUMBER";
    private static final String KEY_SYSTEM_NUMBER = "SYSTEM_NUMBER";
    private static final String KEY_ISSUE_DATE = "ISSUE_DATE";
    private static final String KEY_VALIDATING_CARRIER_NAME = "VALIDATING_CARRIER_NAME";
    private static final String KEY_VALIDATING_CARRIER_OFFICIAL_NAME = "VALIDATING_CARRIER_OFFICIAL_NAME";
    private static final String KEY_VALIDATING_CARRIER_CODE = "VALIDATING_CARRIER_CODE";
    private static final String KEY_VALIDATING_CARRIER_REGISTRATION_ID = "VALIDATING_CARRIER_REGISTRATION_ID";
    private static final String KEY_VALIDATING_CARRIER_KPP = "VALIDATING_CARRIER_KPP";
    private static final String KEY_VALIDATING_CARRIER_BIN = "VALIDATING_CARRIER_BIN";
    private static final String KEY_VALIDATING_CARRIER_VAT_SERIES_NUMBER = "VALIDATING_CARRIER_VAT_SERIES_NUMBER";
    private static final String KEY_VALIDATING_CARRIER_VAT_SERIES_DATE = "VALIDATING_CARRIER_VAT_SERIES_DATE";
    private static final String KEY_TCH_NAME = "TCH_NAME";
    private static final String KEY_TCH_OFFICIAL_NAME = "TCH_OFFICIAL_NAME";
    private static final String KEY_TCH_REGISTRATION_ID = "TCH_REGISTRATION_ID";
    private static final String KEY_TCH_KPP = "TCH_KPP";
    private static final String KEY_TCH_BIN = "TCH_BIN";
    private static final String KEY_TCH_VAT_SERIES_NUMBER = "TCH_VAT_SERIES_NUMBER";
    private static final String KEY_TCH_VAT_SERIES_DATE = "TCH_VAT_SERIES_DATE";
    private static final String KEY_VALIDATOR_AGENCY_NAME = "VALIDATOR_AGENCY_NAME";
    private static final String KEY_VALIDATOR_SALES_POINT_CITY = "VALIDATOR_SALES_POINT_CITY";
    private static final String KEY_VALIDATOR_SALES_POINT_COUNTRY = "VALIDATOR_SALES_POINT_COUNTRY";
    private static final String KEY_VALIDATOR = "VALIDATOR";
    private static final String KEY_AGENT_CODE = "AGENT_CODE";
    private static final String KEY_AGENT_SHORT_NAME = "AGENT_SHORT_NAME";
    private static final String KEY_TRAVELLER_NAME = "TRAVELLER_NAME";
    private static final String KEY_TRAVELLER_NAME_PR = "TRAVELLER_NAME_PR";
    private static final String KEY_TRAVELLER_PASSPORT_NUMBER = "TRAVELLER_PASSPORT_NUMBER";
    private static final String KEY_TRAVELLER_PASSPORT_TYPE = "TRAVELLER_PASSPORT_TYPE";
    private static final String KEY_TRAVELLER_CHILD_BIRTHDAY_DATE = "TRAVELLER_CHILD_BIRTHDAY_DATE";
    private static final String KEY_ENDORSEMENT = "ENDORSEMENT";
    private static final String KEY_ENDORSEMENT_INCLUDING_VAT = "ENDORSEMENT_INCLUDING_VAT";
    private static final String KEY_FARE_CALCULATION_DATA = "FARE_CALCULATION_DATA";
    private static final String KEY_USE_VAT = "USE_VAT";
    private static final String KEY_USE_FEES = "USE_FEES";
    private static final String KEY_USE_AGENCY_FEES = "USE_AGENCY_FEES";
    private static final String KEY_USE_VENDOR_FEES = "USE_VENDOR_FEES";
    private static final String KEY_LOGOTYPE = "LOGOTYPE";
    private static final String KEY_USE_FEES_AS_TAXES = "USE_FEES_AS_TAXES";
    private static final String KEY_USE_AGENCY_FEES_AS_TAXES = "USE_AGENCY_FEES_AS_TAXES";
    private static final String KEY_USE_VENDOR_FEES_AS_TAXES = "USE_VENDOR_FEES_AS_TAXES";
    private static final String KEY_SHOW_TAXES_SUM = "SHOW_TAXES_SUM";
    private static final String KEY_TAXES_SUM = "TAXES_SUM";
    private static final String KEY_VAT_DETALIZATION = "USE_VAT_DETALIZATION";
    private static final String KEY_PAYMENTS_EQUIVALENT_AMOUNT = "PAYMENTS_EQUIVALENT_AMOUNT";
    private static final String KEY_PAYMENTS_PRODUCT_EQUIVALENT_AMOUNT = "PAYMENTS_PRODUCT_EQUIVALENT_AMOUNT";
    private static final String KEY_PAYMENTS_FEES_EQUIVALENT_AMOUNT = "PAYMENTS_FEES_EQUIVALENT_AMOUNT";
    private static final String KEY_TARIFF_BASE_AMOUNT = "TARIFF_BASE_AMOUNT";
    private static final String KEY_TARIFF_EQUIVALENT_AMOUNT = "TARIFF_EQUIVALENT_AMOUNT";
    private static final String KEY_TARIFF_VAT_RATE = "TARIFF_VAT_RATE";
    private static final String KEY_TAXES_AND_FEES_EQUIVALENT_AMOUNT = "TAXES_AND_FEES_EQUIVALENT_AMOUNT";
    private static final String KEY_TAXES_AND_FEES_EQUIVALENT_AMOUNT_BIGDECIMAL = "TAXES_AND_FEES_EQUIVALENT_AMOUNT_BIGDECIMAL";
    private static final String KEY_TAXES_AND_FEES_EQUIVALENT_AMOUNT_WITH_VAT_RATE = "TAXES_AND_FEES_EQUIVALENT_AMOUNT_WITH_VAT_RATE";
    private static final String KEY_TAXES_EQUIVALENT_AMOUNT = "TAXES_EQUIVALENT_AMOUNT";
    private static final String KEY_TAXES_EQUIVALENT_AMOUNT_BIGDECIMAL = "TAXES_EQUIVALENT_AMOUNT_BIGDECIMAL";
    private static final String KEY_TAXES_EQUIVALENT_AMOUNT_WITH_VAT_RATE = "TAXES_EQUIVALENT_AMOUNT_WITH_VAT_RATE";
    private static final String KEY_PENALTY_EQUIVALENT_AMOUNT = "PENALTY_EQUIVALENT_AMOUNT";
    private static final String KEY_TARIFF_PENALTY_EQUIVALENT_AMOUNT = "TARIFF_PENALTY_EQUIVALENT_AMOUNT";
    private static final String KEY_PREVIOUS_TICKET_NUMBER = "PREVIOUS_TICKET_NUMBER";
    private static final String KEY_SUPPLIER_FEES_EQUIVALENT_AMOUNT = "SUPPLIER_FEES_EQUIVALENT_AMOUNT";
    private static final String KEY_SUPPLIER_FEES_EQUIVALENT_AMOUNT_BIGDECIMAL = "SUPPLIER_FEES_EQUIVALENT_AMOUNT_BIGDECIMAL";
    private static final String KEY_SUPPLIER_FEES_EQUIVALENT_VAT = "SUPPLIER_FEES_EQUIVALENT_VAT";
    private static final String KEY_AGENCY_FEES_EQUIVALENT_AMOUNT = "AGENCY_FEES_EQUIVALENT_AMOUNT";
    private static final String KEY_AGENCY_FEES_EQUIVALENT_AMOUNT_BIGDECIMAL = "AGENCY_FEES_EQUIVALENT_AMOUNT_BIGDECIMAL";
    private static final String KEY_AGENCY_FEES_EQUIVALENT_AMOUNT_DETALIZATION = "AGENCY_FEES_EQUIVALENT_AMOUNT_DETALIZATION";
    private static final String KEY_AGENCY_FEES_EQUIVALENT_VAT = "AGENCY_FEES_EQUIVALENT_VAT";
    private static final String KEY_AGENCY_FEES_EQUIVALENT_VAT_BIGDECIMAL = "AGENCY_FEES_EQUIVALENT_VAT_BIGDECIMAL";
    private static final String KEY_AGENCY_FEES_EQUIVALENT_VAT_DETALIZATION = "AGENCY_FEES_EQUIVALENT_VAT_DETALIZATION";
    private static final String KEY_AGENCY_FEES_EQUIVALENT_RATE = "AGENCY_FEES_EQUIVALENT_RATE";
    private static final String KEY_FEES_DETAILING = "FEES_DETAILING";
    private static final String KEY_TOTAL_EQUIVALENT_AMOUNT = "TOTAL_EQUIVALENT_AMOUNT";
    private static final String KEY_TOTAL_EQUIVALENT_AMOUNT_BIGDECIMAL = "TOTAL_EQUIVALENT_AMOUNT_BIGDECIMAL";
    private static final String KEY_TOTAL_EQUIVALENT_VAT = "TOTAL_EQUIVALENT_VAT";
    private static final String KEY_TOTAL_EQUIVALENT_VAT_BIGDECIMAL = "TOTAL_EQUIVALENT_VAT_BIGDECIMAL";
    private static final String KEY_TOTAL_EQUIVALENT_AMOUNT_INCLUDING_SUPPLIER_FEES = "TOTAL_EQUIVALENT_AMOUNT_INCLUDING_SUPPLIER_FEES";
    private static final String KEY_TOTAL_EQUIVALENT_AMOUNT_INCLUDING_SUPPLIER_FEES_BIGDECIMAL = "TOTAL_EQUIVALENT_AMOUNT_INCLUDING_SUPPLIER_FEES_BIGDECIMAL";
    private static final String KEY_TOTAL_EQUIVALENT_VAT_INCLUDING_SUPPLIER_FEES = "TOTAL_EQUIVALENT_VAT_INCLUDING_SUPPLIER_FEES";
    private static final String KEY_TOTAL_EQUIVALENT_VAT_INCLUDING_SUPPLIER_FEES_BIGDECIMAL = "TOTAL_EQUIVALENT_VAT_INCLUDING_SUPPLIER_FEES_BIGDECIMAL";
    private static final String KEY_TOTAL_EQUIVALENT_AMOUNT_INCLUDING_AGENCY_FEES = "TOTAL_EQUIVALENT_AMOUNT_INCLUDING_AGENCY_FEES";
    private static final String KEY_TOTAL_EQUIVALENT_AMOUNT_INCLUDING_AGENCY_FEES_BIGDECIMAL = "TOTAL_EQUIVALENT_AMOUNT_INCLUDING_AGENCY_FEES_BIGDECIMAL";
    private static final String KEY_TOTAL_EQUIVALENT_VAT_INCLUDING_AGENCY_FEES = "TOTAL_EQUIVALENT_VAT_INCLUDING_AGENCY_FEES";
    private static final String KEY_TOTAL_EQUIVALENT_VAT_INCLUDING_AGENCY_FEES_BIGDECIMAL = "TOTAL_EQUIVALENT_VAT_INCLUDING_AGENCY_FEES_BIGDECIMAL";
    private static final String KEY_TOTAL_EQUIVALENT_AMOUNT_INCLUDING_ALL_FEES = "TOTAL_EQUIVALENT_AMOUNT_INCLUDING_ALL_FEES";
    private static final String KEY_TOTAL_EQUIVALENT_AMOUNT_INCLUDING_ALL_FEES_BIGDECIMAL = "TOTAL_EQUIVALENT_AMOUNT_INCLUDING_ALL_FEES_BIGDECIMAL";
    private static final String KEY_TOTAL_EQUIVALENT_VAT_INCLUDING_ALL_FEES = "TOTAL_EQUIVALENT_VAT_INCLUDING_ALL_FEES";
    private static final String KEY_TOTAL_EQUIVALENT_VAT_INCLUDING_ALL_FEES_BIGDECIMAL = "TOTAL_EQUIVALENT_VAT_INCLUDING_ALL_FEES_BIGDECIMAL";
    private static final String KEY_VAT_SUM = "VAT_SUM";
    private static final String KEY_VAT_RATE = "VAT_RATE";
    private static final String KEY_VAT_BASIS = "VAT_BASIS";
    private static final String KEY_VAT_TCH_BASIS = "VAT_TCH_BASIS";
    private static final String KEY_VAT_TCH_RATE = "VAT_TCH_RATE";
    private static final String KEY_VAT_TCH_SUM = "VAT_TCH_SUM";
    private static final String KEY_INFORMATION_NOTES = "INFORMATION_NOTES";
    private static final String KEY_ITINERARY = "ITINERARY";
    private static final String KEY_AGENCY_SHORT_NAME = "AGENCY_SHORT_NAME";
    private static final String KEY_AGENCY = "AGENCY";
    private static final String KEY_AGENCY_BIN = "AGENCY_BIN";
    private static final String KEY_AGENCY_VAT_SERIES_NUMBER = "AGENCY_VAT_SERIES_NUMBER";
    private static final String KEY_AGENCY_VAT_SERIES_DATE = "AGENCY_VAT_SERIES_DATE";
    private static final String KEY_HIDE_PASSPORT = "HIDE_PASSPORT";
    private static final String KEY_QR_CODE = "QR_CODE";
    private static final String KEY_QR_CODE_WIDTH = "QR_CODE_WIDTH";
    private static final String KEY_QR_CODE_HEIGHT = "QR_CODE_HEIGHT";
    private static final String KEY_DOWNLOAD_QR_CODE = "DOWNLOAD_QR_CODE";
    private static final String KEY_EQUIVALENT_CURRENCY_STRING = "EQUIVALENT_CURRENCY_STRING";
    private static final String KEY_EQUIVALENT_CURRENCY = "EQUIVALENT_CURRENCY";
    private static final String FIELD_DEPARTURE_DATE = "DEPARTURE_DATE";
    private static final String FIELD_DEPARTURE_CITY = "DEPARTURE_CITY";
    private static final String FIELD_DEPARTURE_CITY_TUI = "DEPARTURE_CITY_TUI";
    private static final String FIELD_ARRIVE_CITY_TUI = "ARRIVE_CITY_TUI";
    private static final String FIELD_DEPARTURE_CITY_EN = "DEPARTURE_CITY_EN";
    private static final String FIELD_DEPARTURE_AIRPORT = "DEPARTURE_AIRPORT";
    private static final String FIELD_DEPARTURE_TERMINAL = "DEPARTURE_TERMINAL";
    private static final String FIELD_ARRIVE_DATE = "ARRIVE_DATE";
    private static final String FIELD_ARRIVE_CITY = "ARRIVE_CITY";
    private static final String FIELD_ARRIVE_CITY_EN = "ARRIVE_CITY_EN";
    private static final String FIELD_ARRIVE_AIRPORT = "ARRIVE_AIRPORT";
    private static final String FIELD_ARRIVE_TERMINAL = "ARRIVE_TERMINAL";
    private static final String FIELD_MARKETING_CARRIER_NAME = "MARKETING_CARRIER_NAME";
    private static final String FIELD_MARKETING_CARRIER_CODE = "MARKETING_CARRIER_CODE";
    private static final String FIELD_OPERATING_CARRIER_NAME = "OPERATING_CARRIER_NAME";
    private static final String FIELD_OPERATING_CARRIER_CODE = "OPERATING_CARRIER_CODE";
    private static final String FIELD_FLIGHT_NUMBER = "FLIGHT_NUMBER";
    private static final String FIELD_AIRLINE_LOCATOR = "AIRLINE_LOCATOR";
    private static final String FIELD_SERVICE_CLASS = "SERVICE_CLASS";
    private static final String FIELD_SERVICE_CLASS_CODE = "SERVICE_CLASS_CODE";
    private static final String FIELD_SEAT_NUMBER = "SEAT_NUMBER";
    private static final String FIELD_BAGGAGE_ALLOWANCE = "BAGGAGE_ALLOWANCE";
    private static final String FIELD_CABIN_LUGGAGE_INFO = "CABIN_LUGGAGE_INFO";
    private static final String FIELD_FARE_BASIS = "FARE_BASIS";
    private static final String FIELD_BRAND_NAME = "BRAND_NAME";
    private static final String AIR_BONUS_CARDS = "AIR_BONUS_CARDS";
    private static final String DEPARTURE_AIRPORT_CODE = "DEPARTURE_AIRPORT_CODE";
    private static final String ARRIVE_AIRPORT_CODE = "ARRIVE_AIRPORT_CODE";
    private static final String BOARD = "BOARD";
    private static final String AGENCY_ADDRESS = "AGENCY_ADDRESS";
    private static final String AGENCY_PHONE = "AGENCY_PHONE";
    private static final String AGENCY_EMAIL = "AGENCY_EMAIL";
    private static final String MEAL = "MEAL";
    private static final String AGENCY_FULLNAME = "AGENCY_FULLNAME";
    private static final String VAT_SUM_IN_LINE = "VAT_SUM_IN_LINE";
    private static final String TOUR_CODE = "TOUR_CODE";
    private static final String PAYMENT_TYPE = "PAYMENT_TYPE";
    private static final String PAYMENT_TYPE_LOCALIZED = "PAYMENT_TYPE_LOCALIZED";
    private static final String KEY_TAX_FEE = "TAX_FEE";
    private static final String IS_EXCHANGE = "IS_EXCHANGE";
    private static final String EXCHANGE_TOTAL = "EXCHANGE_TOTAL";
    private static final String EXCHANGE_PENALTY = "EXCHANGE_PENALTY";
    private static final String FIELD_ARRIVE_AIRPORT_TUI = "ARRIVE_AIRPORT_TUI";
    private static final String FIELD_DEPARTURE_AIRPORT_TUI = "DEPARTURE_AIRPORT_TUI";
    private static final String EMD_TYPE = "EMD_TYPE";
    private static final String TOTAL_PRICE_STRING = "TOTAL_PRICE_STRING";
    private static final String RELATED_NUMBERS = "RELATED_NUMBERS";
    private static final String IS_EMPTY_SIGMENTS = "IS_EMPTY_SIGMENTS";
    private static final String TOTAL_EQ_AMMOUNT = "TOTAL_EQ_AMMOUNT";
    private static final String MAIN_PRODUCT_NUMBER = "MAIN_PRODUCT_NUMBER";
    private static final String FIELD_NOT_VALID_BEFORE_DATE = "NOT_VALID_BEFORE_DATE";
    private static final String FIELD_NOT_VALID_AFTER_DATE = "NOT_VALID_AFTER_DATE";
    private static final String KEY_SUPPLIER_FEES_EQUIVALENT_AMOUNT_SURCHARGE = "SUPPLIER_FEES_EQUIVALENT_AMOUNT_SURCHARGE";
    private static final String KEY_AGENCY_FEES_EQUIVALENT_AMOUNT_SURCHARGE = "AGENCY_FEES_EQUIVALENT_AMOUNT_SURCHARGE";
    private static final String KEY_AGENCY_FEES_EQUIVALENT_AMOUNT_SURCHARGE_DETALIZATION = "AGENCY_FEES_EQUIVALENT_AMOUNT_SURCHARGE_DETALIZATION";
    private static final String KEY_AGENCY_FEES_EQUIVALENT_VAT_SURCHARGE = "AGENCY_FEES_EQUIVALENT_VAT_SURCHARGE";
    private static final String KEY_AGENCY_FEES_EQUIVALENT_VAT_SURCHARGE_DETALIZATION = "AGENCY_FEES_EQUIVALENT_VAT_SURCHARGE_DETALIZATION";
    private static final String KEY_AGENCY_FEES_EQUIVALENT_RATE_SURCHARGE = "AGENCY_FEES_EQUIVALENT_RATE_SURCHARGE";
    private static final String KEY_TARIFF_BASE_AMOUNT_SURCHARGE = "TARIFF_BASE_AMOUNT_SURCHARGE";
    private static final String KEY_TARIFF_EQUIVALENT_AMOUNT_SURCHARGE = "TARIFF_EQUIVALENT_AMOUNT_SURCHARGE";
    private static final String KEY_TOTAL_EQUIVALENT_AMOUNT_SURCHARGE = "TOTAL_EQUIVALENT_AMOUNT_SURCHARGE";
    private static final String KEY_TOTAL_EQUIVALENT_VAT_SURCHARGE = "TOTAL_EQUIVALENT_VAT_SURCHARGE";
    private static final String KEY_TOTAL_EQUIVALENT_AMOUNT_SURCHARGE_INCLUDING_SUPPLIER_FEES = "TOTAL_EQUIVALENT_AMOUNT_SURCHARGE_INCLUDING_SUPPLIER_FEES";
    private static final String KEY_TOTAL_EQUIVALENT_VAT_SURCHARGE_INCLUDING_SUPPLIER_FEES = "TOTAL_EQUIVALENT_VAT_SURCHARGE_INCLUDING_SUPPLIER_FEES";
    private static final String KEY_TOTAL_EQUIVALENT_AMOUNT_SURCHARGE_INCLUDING_AGENCY_FEES = "TOTAL_EQUIVALENT_AMOUNT_SURCHARGE_INCLUDING_AGENCY_FEES";
    private static final String KEY_TOTAL_EQUIVALENT_VAT_SURCHARGE_INCLUDING_AGENCY_FEES = "TOTAL_EQUIVALENT_VAT_SURCHARGE_INCLUDING_AGENCY_FEES";
    private static final String KEY_TOTAL_EQUIVALENT_AMOUNT_SURCHARGE_INCLUDING_ALL_FEES = "TOTAL_EQUIVALENT_AMOUNT_SURCHARGE_INCLUDING_ALL_FEES";
    private static final String KEY_TOTAL_EQUIVALENT_VAT_SURCHARGE_INCLUDING_ALL_FEES = "TOTAL_EQUIVALENT_VAT_SURCHARGE_INCLUDING_ALL_FEES";
    private static final String KEY_PAYMENTS_FEES_EQUIVALENT_AMOUNT_SURCHARGE = "PAYMENTS_FEES_EQUIVALENT_AMOUNT_SURCHARGE";
    private static final String KEY_TAXES_EQUIVALENT_AMOUNT_SURCHARGE = "TAXES_EQUIVALENT_AMOUNT_SURCHARGE";
    private static final String KEY_TAXES_AND_FEES_EQUIVALENT_AMOUNT_SURCHARGE = "TAXES_AND_FEES_EQUIVALENT_AMOUNT_SURCHARGE";
    private static final String KEY_TAXES_SUM_SURCHARGE = "TAXES_SUM_SURCHARGE";
    private static final String KEY_PAYMENTS_EQUIVALENT_AMOUNT_SURCHARGE = "PAYMENTS_EQUIVALENT_AMOUNT_SURCHARGE";
    private static final String KEY_PAYMENTS_PRODUCT_EQUIVALENT_AMOUNT_SURCHARGE = "PAYMENTS_PRODUCT_EQUIVALENT_AMOUNT_SURCHARGE";
    private static final String KEY_VAT_SUM_SURCHARGE = "VAT_SUM_SURCHARGE";
    private static final String KEY_VAT_RATE_SURCHARGE = "VAT_RATE_SURCHARGE";
    private static final String KEY_VAT_BASIS_SURCHARGE = "VAT_BASIS_SURCHARGE";
    private static final String KEY_VAT_TCH_BASIS_SURCHARGE = "VAT_TCH_BASIS_SURCHARGE";
    private static final String KEY_VAT_TCH_RATE_SURCHARGE = "VAT_TCH_RATE_SURCHARGE";
    private static final String KEY_VAT_TCH_SUM_SURCHARGE = "VAT_TCH_SUM_SURCHARGE";
    private static final String VAT_SUM_IN_LINE_SURCHARGE = "VAT_SUM_IN_LINE_SURCHARGE";
    private static final String KEY_ITINERARY_PARAMETERS = "ITINERARY_PARAMETERS";
    private static final String KEY_TOTAL_ROWS_COUNT = "TOTAL_ROWS_COUNT";
    private static final Map<Locale, Map<PaymentType, String>> localizedPaymentTypeNames = new HashMap<Locale, Map<PaymentType, String>>();
    private static final Map<Locale, Map<String, String>> localizedCurrencyNames = new HashMap<Locale, Map<String, String>>();
    private static final Map<Locale, Map<String, String>> localizedEndorsementVatEntries = new HashMap<Locale, Map<String, String>>();
    private static final Map<Locale, String> localizedTerminalEntries = new HashMap<Locale, String>();
    private static final List<String> terminalKeys = Arrays.asList("term", "\u0442\u0435\u0440\u043c");
    private static final Set<FopType> fopTypes = new HashSet<FopType>();

    public FilledTemplateDocument renderReport(EntityContainer<BookingFile> bookingFile, Product product, EntityContainer<TemplateDocument> template, List<InformationNote> notes, boolean itTariff, boolean useCyrillicName, boolean usePayer, boolean useVat, boolean useLogo, boolean useAgencyFees, boolean includeAgencyFeesIntoTaxes, boolean useVendorFees, boolean includeVendorFeesIntoTaxes, boolean showTaxesSum, boolean useVatDetalization, boolean hidePassport) throws Exception {
        LinkedHashSet messages = new LinkedHashSet();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ArrayList<ItineraryData> itineraryDataList = new ArrayList<ItineraryData>();
        JasperReport jasperReport = JasperUtil.getReport((byte[])((TemplateDocument)template.getEntity()).getContent());
        Locale locale = this.getLocale((TemplateDocument)template.getEntity());
        JRDataSource dataSource = this.getDataSource(product, locale, notes, itTariff, useCyrillicName, usePayer, useVat, useLogo, showTaxesSum, useVatDetalization, hidePassport, itineraryDataList, parameters);
        this.fillParameters(product, locale, notes, itTariff, useCyrillicName, usePayer, useVat, useLogo, useAgencyFees, includeAgencyFeesIntoTaxes, useVendorFees, includeVendorFeesIntoTaxes, showTaxesSum, useVatDetalization, hidePassport, itineraryDataList, parameters, bookingFile.getUid(), Boolean.TRUE.equals(SystemHelper.getMetadataAsBoolean((Collection)((TemplateDocument)template.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_HAS_DOWNLOAD_QR_CODE)));
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dataSource, null);
        if (content == null) {
            return null;
        }
        Date date = new Date();
        FilledTemplateDocument file = new FilledTemplateDocument();
        file.setTitle(this.getReportTitle(product, (TemplateDocument)template.getEntity()));
        file.setContentType(ContentType.JASPERPRINT);
        file.setContent(content);
        file.setName(this.getFileName(product, (TemplateDocument)template.getEntity()));
        file.setType(ItineraryReceiptRender.getDocumentType());
        file.setCreated(date);
        file.setNavigationKey(product.getUid());
        file.setOwner(bookingFile.toReference());
        file.setCheckSum(MiscUtil.getCheckSum((byte[])file.getContent()));
        file.setTemplate(template.toReference());
        file.getMessages().clear();
        file.getMessages().addAll(messages);
        return file;
    }

    private void fillParameters(Product product, Locale locale, List<InformationNote> notes, boolean itTariff, boolean useCyrillicName, boolean usePayer, boolean useVat, boolean useLogo, boolean useAgencyFees, boolean includeAgencyFeesIntoTaxes, boolean useVendorFees, boolean includeVendorFeesIntoTaxes, boolean showTaxesSum, boolean useVatDetalization, boolean hidePassport, List<ItineraryData> itineraryDataList, Map<String, Object> parameters, String bookingFileUid, boolean showDownloadQrCode) throws Exception {
        String url;
        String itineraryInfo;
        BigDecimal totalEquivalentAmountIncludingSupplierFees;
        BigDecimal totalEquivalentAmountIncludingAllFees;
        BigDecimal totalEquivalentAmountIncludingFees;
        boolean isZeroVatRate;
        BigDecimal supplierFeesEquivalentAmount;
        BigDecimal tariffWithPenaltyEquivalentAmount;
        BigDecimal tariffEquivalentAmount;
        PaymentType paymentType;
        Map<String, String> currencyNames;
        String equivalentCurrency;
        Traveller traveller;
        String agentShortName;
        Address address;
        BinaryData logo;
        boolean exchange = product.getPreviousProduct() != null && ProductStatus.EXCHANGE == product.getPreviousProduct().getStatus();
        parameters.put("REPORT_LOCALE", locale);
        JRBeanCollectionDataSource itineraryParameters = new JRBeanCollectionDataSource(itineraryDataList);
        parameters.put(KEY_ITINERARY_PARAMETERS, itineraryParameters);
        EntityReference agencyRef = AirProductHelper.getAgency((Product)product);
        EntityReference subagencyRef = AirProductHelper.getSubagency((Product)product);
        String addr = null;
        String phone = null;
        String email = null;
        String afn = null;
        Organization agcy = (Organization)ProfileHelper.resolveReference((EntityReference)agencyRef);
        if (agcy != null) {
            for (Address a : ProfileHelper.getOrganizationAddresses((Organization)agcy, (Date)product.getIssueDate())) {
                if (!AddressType.BUSINESS.equals((Object)a.getAddressType()) && !AddressType.LEGAL.equals((Object)a.getAddressType()) && !AddressType.FACTUAL.equals((Object)a.getAddressType())) continue;
                addr = this.getFullAddress(a, locale);
                break;
            }
            phone = this.buildPhoneString(agcy.getCommunications(), Arrays.asList(CommunicationType.WORK_PHONE), locale);
            afn = agcy.getFullName() != null && !agcy.getFullName().getValues().isEmpty() ? (agcy.getFullName().getValues().get(locale) != null ? (String)agcy.getFullName().getValues().get(locale) : (String)agcy.getFullName().getValues().values().stream().filter(Objects::nonNull).findFirst().orElse(null)) : null;
            email = agcy.getCommunications().stream().filter(c -> c.getType() == CommunicationType.EMAIL).map(Communication::getSense).filter(TextUtil::nonBlank).findFirst().orElse(null);
        }
        parameters.put(AGENCY_ADDRESS, addr);
        parameters.put(AGENCY_PHONE, phone);
        parameters.put(AGENCY_EMAIL, email);
        parameters.put(AGENCY_FULLNAME, afn);
        parameters.put(TOUR_CODE, product.getTourCode());
        Organization agency = (Organization)ProfileHelper.resolveReference((EntityReference)subagencyRef);
        SalesPoint salesPoint = (SalesPoint)ProfileHelper.resolveReference((EntityReference)product.getSalesPoint());
        SalesPoint validatorSalesPoint = ItineraryReceiptRender.getSalesPointsByValidatorAndPcc(product.getValidatorCode(), product.getPcc()).stream().map(EntityContainer::getEntity).filter(sp -> sp.getAgency().equals((Object)agencyRef) || sp.getAgency().equals((Object)subagencyRef)).findFirst().orElse(EntityStorage.get().resolve(product.getSalesPoint()) != null ? (SalesPoint)EntityStorage.get().resolve(product.getSalesPoint()).getEntity() : null);
        if (useLogo && (logo = OrganizationLogotypeHelper.getLogotype((BaseProduct)product, parameters)) != null && logo.getData() != null) {
            parameters.put(KEY_LOGOTYPE, new ByteArrayInputStream(logo.getData()));
        }
        if (agency != null) {
            String agencyName = L10nStringHelper.getValue((L10nString)agency.getFullName(), (Locale)locale, (boolean)true);
            parameters.put(KEY_AGENCY_NAME, agencyName);
            parameters.put(KEY_AGENCY, ProfileHelper.getFullName((String)agency.getCode(), (L10nString)agency.getShortName(), (L10nString)agency.getFullName(), (DictionaryReference)agency.getLegalForm(), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
            parameters.put(KEY_AGENCY_SHORT_NAME, L10nStringHelper.getValue((L10nString)agency.getShortName(), (Locale)locale, (boolean)false));
            parameters.put(KEY_AGENCY_BIN, HistoricalValueHelper.getValue((List)agency.getBinHistory(), (Date)product.getIssueDate()));
            parameters.put(KEY_AGENCY_VAT_SERIES_NUMBER, HistoricalValueHelper.getValue((List)agency.getVatSeriesNumberHistory(), (Date)product.getIssueDate()));
            parameters.put(KEY_AGENCY_VAT_SERIES_DATE, HistoricalValueHelper.getValue((List)agency.getVatSeriesDateHistory(), (Date)product.getIssueDate()));
        }
        if (salesPoint != null) {
            address = ProfileHelper.filterAddresses((Collection)salesPoint.getAddresses(), (AddressType)AddressType.FACTUAL);
            StringJoiner salesPointLocation = new StringJoiner(", ");
            if (address != null) {
                String countryString;
                DictionaryReference country;
                String cityString;
                parameters.put(KEY_SALES_POINT_ADDRESS, ProfileHelper.buildFullAddress((Address)address, (Locale)locale, (boolean)true));
                DictionaryReference city = address.getCity();
                if (city != null && TextUtil.nonBlank((String)(cityString = city.toString(locale)))) {
                    parameters.put(KEY_SALES_POINT_CITY, cityString);
                    salesPointLocation.add(cityString);
                }
                if ((country = address.getCountry()) != null && TextUtil.nonBlank((String)(countryString = country.toString(locale)))) {
                    parameters.put(KEY_SALES_POINT_COUNTRY, countryString);
                    salesPointLocation.add(countryString);
                }
            }
            parameters.put(KEY_SALES_POINT_LOCATION, salesPointLocation.toString());
            Communication communication = ProfileHelper.filterCommunications((Collection)salesPoint.getCommunications(), (CommunicationType)CommunicationType.WORK_PHONE);
            if (communication == null) {
                communication = ProfileHelper.filterCommunications((Collection)salesPoint.getCommunications(), (CommunicationType)CommunicationType.MOBILE);
            }
            CommunicationFormat format = new CommunicationFormat("+C (T) N #I");
            parameters.put(KEY_SALES_POINT_PHONE, communication != null ? format.format(communication) : null);
        }
        if (validatorSalesPoint != null) {
            address = ProfileHelper.filterAddresses((Collection)validatorSalesPoint.getAddresses(), (AddressType)AddressType.FACTUAL);
            if (address != null) {
                DictionaryReference country;
                DictionaryReference city = address.getCity();
                if (city != null) {
                    parameters.put(KEY_VALIDATOR_SALES_POINT_CITY, city.toString(locale));
                }
                if ((country = address.getCountry()) != null) {
                    parameters.put(KEY_VALIDATOR_SALES_POINT_COUNTRY, country.toString(locale));
                }
            }
            for (Validator validator : validatorSalesPoint.getValidators()) {
                if (!TextUtil.isSame((String)validator.getNumber(), (String)product.getValidatorCode()) || !MiscUtil.equals((Object)validator.getBlankOwner(), (Object)product.getBlankOwnerRef()) || !TextUtil.isSame((String)product.getPcc(), (String)((String)MiscUtil.safeGet((Object)validator.getPCC(), Pcc::getCode)), (boolean)true)) continue;
                EntityContainer validatorSupplierContainer = EntityStorage.get().resolve(validator.getSupplier());
                EntityContainer validatorAgencyContainer = EntityStorage.get().resolve(validator.getAgency());
                if (validatorSupplierContainer == null || validatorAgencyContainer == null) continue;
                Organization validatorSupplier = (Organization)validatorSupplierContainer.getEntity();
                Organization validatorAgency = (Organization)validatorAgencyContainer.getEntity();
                if (ProfileHelper.isOrganizationCode((EntityReference)product.getBlankOwnerRef(), (String)"\u04281")) {
                    String agencyTchCode = ProfileHelper.findMetadataStringByCode((List)validatorAgency.getMetadata(), (String)MetadataKey.KEY_TCH_AGENCY_CODE.name());
                    parameters.put(KEY_AGENCY_TCH_CODE, agencyTchCode);
                }
                if (ProfileHelper.isOrganizationType((Organization)validatorSupplier, (OrganizationType)OrganizationType.BLANK_OWNER)) {
                    parameters.put(KEY_VALIDATOR_AGENCY_NAME, L10nStringHelper.getValue((L10nString)validatorAgency.getFullName(), (Locale)locale, (boolean)true));
                    break;
                }
                if (!ProfileHelper.isOrganizationType((Organization)validatorSupplier, (OrganizationType)OrganizationType.AGENCY)) continue;
                parameters.put(KEY_VALIDATOR_AGENCY_NAME, L10nStringHelper.getValue((L10nString)validatorSupplier.getFullName(), (Locale)locale, (boolean)true));
                break;
            }
        }
        parameters.put(KEY_PNR, CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
        parameters.put(KEY_BOOKING_NUMBER, product.getReservation().getBookingFile().getNumber());
        parameters.put(KEY_SYSTEM_NUMBER, this.getSystemNumberConj(product));
        parameters.put(KEY_ISSUE_DATE, product.getIssueDate());
        DictionaryReference validatingCarrier = product.getCarrier();
        if (validatingCarrier != null) {
            parameters.put(KEY_VALIDATING_CARRIER_NAME, validatingCarrier.toString(locale));
            Airline validatingAirline = (Airline)DictionaryCache.get().resolveReference(validatingCarrier);
            if (validatingAirline != null) {
                String validatingAirlineName = (validatingAirline.getLegalForm() != null ? validatingAirline.getLegalForm().toString(locale) + " " : "") + "\"" + validatingAirline.toString(locale) + "\"";
                parameters.put(KEY_VALIDATING_CARRIER_OFFICIAL_NAME, validatingAirlineName);
                String validatingCarrierRegistrationId = TextUtil.isBlank((String)validatingAirline.getRegistrationId()) ? null : validatingAirline.getRegistrationId();
                parameters.put(KEY_VALIDATING_CARRIER_REGISTRATION_ID, validatingCarrierRegistrationId);
                String validatingCarrierKpp = TextUtil.isBlank((String)validatingAirline.getKpp()) ? null : validatingAirline.getKpp();
                parameters.put(KEY_VALIDATING_CARRIER_KPP, validatingCarrierKpp);
                String validatingCarrierBin = TextUtil.isBlank((String)validatingAirline.getBin()) ? null : validatingAirline.getBin();
                parameters.put(KEY_VALIDATING_CARRIER_BIN, validatingCarrierBin);
                String validatingCarrierVatSeriesNumber = TextUtil.isBlank((String)validatingAirline.getVatSeriesNumber()) ? null : validatingAirline.getVatSeriesNumber();
                parameters.put(KEY_VALIDATING_CARRIER_VAT_SERIES_NUMBER, validatingCarrierVatSeriesNumber);
                parameters.put(KEY_VALIDATING_CARRIER_VAT_SERIES_DATE, validatingAirline.getVatSeriesDate());
            }
        }
        parameters.put(KEY_VALIDATING_CARRIER_CODE, product.getCarrierNumber());
        parameters.put(KEY_VALIDATOR, product.getValidatorCode());
        parameters.put(KEY_AGENT_CODE, product.getCashierCode());
        EntityContainer agent = EntityStorage.get().resolve(product.getCashier());
        if (agent != null && TextUtil.nonBlank((String)(agentShortName = new PersonalLocalizableNameFormatter().format((PersonalLocalizableName)agent.getEntity(), locale, false)))) {
            parameters.put(KEY_AGENT_SHORT_NAME, agentShortName);
        }
        if ((traveller = product.getTraveller()) != null) {
            String birthdayString;
            String travellerName;
            String cyrillicName = this.getCyrillicName(traveller);
            String string = travellerName = useCyrillicName && !TextUtil.isBlank((String)cyrillicName) ? cyrillicName : traveller.getName();
            if (TextUtil.isBlank((String)travellerName) && traveller.getPassport() != null) {
                PersonalNameFormat format = new PersonalNameFormat("L F S M");
                travellerName = format.format((PersonalName)traveller.getPassport());
            }
            if (ProfileHelper.isOrganizationCode((EntityReference)product.getBlankOwnerRef(), (String)"\u04281") && traveller.getPassport() != null) {
                boolean useShortMiddleName = false;
                if (useCyrillicName && TextUtil.nonBlank((String)cyrillicName)) {
                    String[] cyrillicNameWords = cyrillicName.split(" ");
                    if (cyrillicNameWords.length > 2 && TextUtil.nonBlank((String)traveller.getName())) {
                        String originalMiddleName;
                        String[] originalNameWords = traveller.getName().split(" ");
                        String cyrilliclMiddleName = cyrillicNameWords[cyrillicNameWords.length - 1];
                        if (cyrilliclMiddleName.equals(traveller.getPassport().getMiddleName())) {
                            useShortMiddleName = true;
                        } else if (TextUtil.nonBlank((String)traveller.getName()) && originalNameWords.length == cyrillicNameWords.length && (originalMiddleName = originalNameWords[originalNameWords.length - 1]).equals(traveller.getPassport().getMiddleName())) {
                            useShortMiddleName = true;
                        }
                    }
                    travellerName = this.createTchName(cyrillicNameWords, useShortMiddleName, product, traveller);
                } else {
                    String[] originalNameWords;
                    PersonalNameFormat format = new PersonalNameFormat("L F S M");
                    String passportName = format.format((PersonalName)traveller.getPassport());
                    String[] passportNameWords = passportName.split(" ");
                    if (TextUtil.nonBlank((String)passportName)) {
                        useShortMiddleName = TextUtil.nonBlank((String)traveller.getPassport().getMiddleName());
                        travellerName = this.createTchName(passportNameWords, useShortMiddleName, product, traveller);
                    } else if (TextUtil.nonBlank((String)traveller.getName()) && (originalNameWords = traveller.getName().split(" ")).length < 3) {
                        travellerName = this.createTchName(originalNameWords, useShortMiddleName, product, traveller);
                    }
                }
            }
            parameters.put(KEY_TRAVELLER_NAME, travellerName);
            parameters.put(KEY_TRAVELLER_NAME_PR, this.getTravellerName(traveller, locale, useCyrillicName, cyrillicName));
            if (traveller.getPassport() != null) {
                if (traveller.getPassport().getType() != null) {
                    parameters.put(KEY_TRAVELLER_PASSPORT_TYPE, LocaleHelper.toString((Object)traveller.getPassport().getType(), (Locale)locale));
                }
                parameters.put(KEY_TRAVELLER_PASSPORT_NUMBER, hidePassport ? ItineraryReceiptRender.hidePassport(traveller.getPassport().getNumber()) : traveller.getPassport().getNumber());
            }
            SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy", locale);
            String string2 = birthdayString = traveller.getBirthday() != null ? sdf.format(traveller.getBirthday()) : "";
            if (DictHelper.isChildrenPassengerType((DictionaryReference)product.getPassengerType())) {
                parameters.put(KEY_TRAVELLER_CHILD_BIRTHDAY_DATE, birthdayString + " / CHD");
            } else if (DictHelper.isInfantsPassengerType((DictionaryReference)product.getPassengerType())) {
                parameters.put(KEY_TRAVELLER_CHILD_BIRTHDAY_DATE, birthdayString + " / INF");
            }
            for (BookingAirlineBonusCard card : traveller.getAirlineBonusCards()) {
                if (card.getAirline() == null) continue;
                String cardStr = card.getAirline().getCode() + " : " + card.getNumber();
                String res = parameters.get(AIR_BONUS_CARDS) == null ? cardStr : parameters.get(AIR_BONUS_CARDS) + ", " + cardStr;
                parameters.put(AIR_BONUS_CARDS, res);
            }
        }
        String equivalentCurrencyString = null;
        CurrencyInfo currencyInfo = (CurrencyInfo)DictionaryCache.get().resolveReference(AirProductHelper.getClientContractRelation((Product)product).getGeneralData().getCurrency());
        String string = equivalentCurrency = currencyInfo != null ? currencyInfo.getCode() : DictHelper.getLocalCurrency2();
        if (equivalentCurrency != null && (currencyNames = localizedCurrencyNames.get(locale)) != null) {
            equivalentCurrencyString = currencyNames.get(equivalentCurrency);
        }
        parameters.put(KEY_USE_VAT, useVat);
        parameters.put(KEY_USE_FEES, useAgencyFees || useVendorFees);
        parameters.put(KEY_USE_AGENCY_FEES, useAgencyFees);
        parameters.put(KEY_USE_VENDOR_FEES, useVendorFees);
        parameters.put(KEY_USE_FEES_AS_TAXES, includeAgencyFeesIntoTaxes || includeVendorFeesIntoTaxes);
        parameters.put(KEY_USE_AGENCY_FEES_AS_TAXES, includeAgencyFeesIntoTaxes);
        parameters.put(KEY_USE_VENDOR_FEES_AS_TAXES, includeVendorFeesIntoTaxes);
        parameters.put(KEY_SHOW_TAXES_SUM, showTaxesSum);
        parameters.put(KEY_HIDE_PASSPORT, hidePassport);
        parameters.put(KEY_EQUIVALENT_CURRENCY_STRING, equivalentCurrencyString);
        parameters.put(KEY_EQUIVALENT_CURRENCY, equivalentCurrency);
        parameters.put(KEY_PAYMENTS_EQUIVALENT_AMOUNT, this.getPaymentsEquivalentAmountParamater(product, fopTypes, null, useAgencyFees, includeAgencyFeesIntoTaxes, useVendorFees, includeVendorFeesIntoTaxes, false, itTariff, usePayer, locale));
        parameters.put(KEY_PAYMENTS_PRODUCT_EQUIVALENT_AMOUNT, this.getPaymentsEquivalentAmountParamater(product, GeneralProductHelper.productFopTypes, null, useAgencyFees, includeAgencyFeesIntoTaxes, useVendorFees, includeVendorFeesIntoTaxes, false, itTariff, usePayer, locale));
        parameters.put(KEY_PAYMENTS_FEES_EQUIVALENT_AMOUNT, this.getPaymentsEquivalentAmountParamater(product, GeneralProductHelper.feeFopTypes, null, useAgencyFees, includeAgencyFeesIntoTaxes, useVendorFees, includeVendorFeesIntoTaxes, true, false, usePayer, locale));
        Money tariffBaseAmount = AirProductHelper.getBaseFare((Product)product);
        if (tariffBaseAmount != null && tariffBaseAmount.getValue() != null) {
            Money previousTariffBaseAmount;
            Map<String, String> currencyNames2;
            String currencyString = null;
            if (tariffBaseAmount.getCurrency() != null && (currencyNames2 = localizedCurrencyNames.get(locale)) != null) {
                currencyString = currencyNames2.get(tariffBaseAmount.getCurrency());
            }
            parameters.put(KEY_TARIFF_BASE_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", tariffBaseAmount.getValue()), currencyString != null ? currencyString : ""));
            if (exchange && (previousTariffBaseAmount = AirProductHelper.getBaseFare((Product)product.getPreviousProduct())) != null && previousTariffBaseAmount.getValue() != null) {
                BigDecimal tariffBaseAmountSurcharge = MiscUtil.sub((BigDecimal)tariffBaseAmount.getValue(), (BigDecimal[])new BigDecimal[]{previousTariffBaseAmount.getValue()});
                parameters.put(KEY_TARIFF_BASE_AMOUNT_SURCHARGE, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", tariffBaseAmountSurcharge), currencyString != null ? currencyString : ""));
            }
        }
        if ((paymentType = this.getPaymentType(AirProductHelper.getClientContractRelation((Product)product).getFops())) != null) {
            parameters.put(PAYMENT_TYPE, paymentType.toString(locale));
            parameters.put(PAYMENT_TYPE_LOCALIZED, ItineraryReceiptHelper.getLocalizedPaymentType((PaymentType)paymentType, (Locale)locale));
        }
        if ((tariffEquivalentAmount = AirProductHelper.getClientContractRelation((Product)product).getServiceData().getDetalization().getFare()) != null) {
            BigDecimal previousTariffEquivalentAmount;
            parameters.put(KEY_TARIFF_EQUIVALENT_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", tariffEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            if (exchange && (previousTariffEquivalentAmount = AirProductHelper.getClientContractRelation((Product)product.getPreviousProduct()).getServiceData().getDetalization().getFare()) != null) {
                BigDecimal tariffEquivalentAmountSurcharge = MiscUtil.sub((BigDecimal)tariffEquivalentAmount, (BigDecimal[])new BigDecimal[]{previousTariffEquivalentAmount});
                parameters.put(KEY_TARIFF_EQUIVALENT_AMOUNT_SURCHARGE, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", tariffEquivalentAmountSurcharge), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            }
        }
        StringBuilder taxesAndFeesEquivalentAmount = new StringBuilder();
        StringBuilder taxesAndFeesEquivalentAmountSurcharge = new StringBuilder();
        StringBuilder taxesSum = new StringBuilder();
        StringBuilder taxesSumSurcharge = new StringBuilder();
        StringBuilder taxesEquivalentAmount = new StringBuilder();
        StringBuilder taxesEquivalentAmountSurcharge = new StringBuilder();
        StringBuilder taxesEquivalentAmountWithVatRate = new StringBuilder();
        StringBuilder taxesAndFeesEquivalentAmountWithVatRate = new StringBuilder();
        StringBuilder feesDetailing = new StringBuilder();
        HashMap<String, String> taxesMap = new HashMap<String, String>();
        List taxes = AirProductHelper.getClientContractRelation((Product)product).getServiceData().getDetalization().getTaxes();
        BigDecimal taxesSumAmount = BigDecimal.ZERO;
        BigDecimal taxesSumAmountSurcharge = BigDecimal.ZERO;
        BigDecimal taxesAndFeesEquivAmount = null;
        BigDecimal taxesEquivAmount = null;
        for (Object tax : taxes) {
            taxesMap.put(tax.getSource(), tax.getCode());
            if (tax.getAmount() == null) continue;
            ArrayList previousTaxes = new ArrayList();
            if (exchange) {
                previousTaxes.addAll(product.getPreviousProduct().getTaxes().stream().filter(arg_0 -> ItineraryReceiptRender.lambda$fillParameters$2((SimpleTax)tax, arg_0)).collect(Collectors.toList()));
            }
            BigDecimal taxAmountSurcharge = MiscUtil.sub((BigDecimal)tax.getAmount(), (BigDecimal[])new BigDecimal[]{previousTaxes.stream().filter(item -> item.getAmount() != null).map(item -> item.getAmount().getValue()).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null)});
            if (showTaxesSum) {
                taxesSumAmount = taxesSumAmount.add(tax.getAmount());
                taxesSumAmountSurcharge = taxesSumAmountSurcharge.add(taxAmountSurcharge);
            }
            Double vatRate = null;
            if (product.getVendorVatDetalization() != null) {
                vatRate = product.getVendorVatDetalization().getComponents().stream().filter(arg_0 -> ItineraryReceiptRender.lambda$fillParameters$6((SimpleTax)tax, arg_0)).map(VatComponent::getRate).filter(Objects::nonNull).findFirst().orElse(null);
            }
            String taxCodeString = null;
            if (!TextUtil.isBlank((String)tax.getCode())) {
                taxCodeString = tax.getCode().trim();
            }
            if (taxesAndFeesEquivalentAmount.length() > 0) {
                taxesAndFeesEquivalentAmount.append(" ");
            }
            taxesAndFeesEquivalentAmount.append(String.format("%s%s%s", taxCodeString != null ? taxCodeString : "", String.format(locale, "%.2f", tax.getAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            String amount = String.format("%s\t%s%s", taxCodeString != null ? taxCodeString + ":" : "", String.format(locale, "%.2f", tax.getAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : "");
            if (taxesAndFeesEquivalentAmountWithVatRate.length() > 0) {
                taxesAndFeesEquivalentAmountWithVatRate.append("\n");
            }
            taxesAndFeesEquivalentAmountWithVatRate.append(amount);
            if (useVat) {
                taxesAndFeesEquivalentAmountWithVatRate.append(vatRate != null ? String.format(" (\u041d\u0414\u0421: %s)", new DecimalFormat("###0").format(vatRate) + "%") : " (\u0431\u0435\u0437 \u041d\u0414\u0421)");
            }
            taxesAndFeesEquivAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{taxesAndFeesEquivAmount, tax.getAmount()});
            if (taxesEquivalentAmount.length() > 0) {
                taxesEquivalentAmount.append(" ");
            }
            taxesEquivalentAmount.append(String.format("%s%s%s", taxCodeString != null ? taxCodeString : "", String.format(locale, "%.2f", tax.getAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            if (taxesEquivalentAmountWithVatRate.length() > 0) {
                taxesEquivalentAmountWithVatRate.append("\n");
            }
            taxesEquivalentAmountWithVatRate.append(amount);
            if (useVat) {
                taxesEquivalentAmountWithVatRate.append(vatRate != null ? String.format(" (\u041d\u0414\u0421: %s)", new DecimalFormat("###0").format(vatRate) + "%") : " (\u0431\u0435\u0437 \u041d\u0414\u0421)");
            }
            taxesEquivAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{taxesEquivAmount, tax.getAmount()});
            if (taxesAndFeesEquivalentAmountSurcharge.length() > 0) {
                taxesAndFeesEquivalentAmountSurcharge.append(" ");
            }
            String taxAmountSurchargeString = String.format("%s%s%s", taxCodeString != null ? taxCodeString : "", String.format(locale, "%.2f", taxAmountSurcharge), equivalentCurrencyString != null ? equivalentCurrencyString : "");
            taxesAndFeesEquivalentAmountSurcharge.append(taxAmountSurchargeString);
            if (taxesEquivalentAmountSurcharge.length() > 0) {
                taxesEquivalentAmountSurcharge.append(" ");
            }
            taxesEquivalentAmountSurcharge.append(taxAmountSurchargeString);
        }
        Collection hiddenFees = GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.hiddenCommissionCategories);
        for (Commission hiddenFee : hiddenFees) {
            EntityContainer hiddenFeePropertyContainer;
            if (hiddenFee.getEquivalentAmount() == null) continue;
            if (showTaxesSum && (includeAgencyFeesIntoTaxes || includeVendorFeesIntoTaxes)) {
                taxesSumAmount = taxesSumAmount.add(hiddenFee.getEquivalentAmount());
                if (exchange) {
                    taxesSumAmountSurcharge = taxesSumAmountSurcharge.add(hiddenFee.getEquivalentAmount());
                }
            }
            if ((hiddenFeePropertyContainer = EntityStorage.get().resolve(hiddenFee.getCommissionProperties())) == null) continue;
            FeeProperties hiddenFeeProperty = (FeeProperties)hiddenFeePropertyContainer.getEntity();
            Double vatRate = hiddenFeeProperty.getExternalFeeVatRate();
            String taxCodeString = null;
            if (!TextUtil.isBlank((String)hiddenFeeProperty.getHiddenFeeTaxCode())) {
                taxCodeString = hiddenFeeProperty.getHiddenFeeTaxCode().trim();
            }
            String amount = String.format("%s%s%s", taxCodeString != null ? taxCodeString : "", String.format(locale, "%.2f", hiddenFee.getEquivalentAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : "");
            if (taxesAndFeesEquivalentAmount.length() > 0) {
                taxesAndFeesEquivalentAmount.append(" ");
            }
            taxesAndFeesEquivalentAmount.append(amount);
            String amountValue = String.format("%s\t%s%s", taxCodeString != null ? taxCodeString + ":" : "", String.format(locale, "%.2f", hiddenFee.getEquivalentAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : "");
            if (taxesAndFeesEquivalentAmountWithVatRate.length() > 0) {
                taxesAndFeesEquivalentAmountWithVatRate.append("\n");
            }
            taxesAndFeesEquivalentAmountWithVatRate.append(amountValue);
            if (useVat) {
                taxesAndFeesEquivalentAmountWithVatRate.append(vatRate != null ? String.format(" (\u041d\u0414\u0421: %s)", new DecimalFormat("###0").format(vatRate) + "%") : " (\u0431\u0435\u0437 \u041d\u0414\u0421)");
            }
            taxesAndFeesEquivAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{taxesAndFeesEquivAmount, hiddenFee.getEquivalentAmount()});
            if (taxesEquivalentAmount.length() > 0) {
                taxesEquivalentAmount.append(" ");
            }
            taxesEquivalentAmount.append(amount);
            if (taxesEquivalentAmountWithVatRate.length() > 0) {
                taxesEquivalentAmountWithVatRate.append("\n");
            }
            taxesEquivalentAmountWithVatRate.append(amountValue);
            if (useVat) {
                taxesEquivalentAmountWithVatRate.append(vatRate != null ? String.format(" (\u041d\u0414\u0421: %s)", new DecimalFormat("###0").format(vatRate) + "%") : " (\u0431\u0435\u0437 \u041d\u0414\u0421)");
            }
            taxesEquivAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{taxesEquivAmount, hiddenFee.getEquivalentAmount()});
            if (!exchange) continue;
            if (taxesAndFeesEquivalentAmountSurcharge.length() > 0) {
                taxesAndFeesEquivalentAmountSurcharge.append(" ");
            }
            taxesAndFeesEquivalentAmountSurcharge.append(amount);
            if (taxesEquivalentAmountSurcharge.length() > 0) {
                taxesEquivalentAmountSurcharge.append(" ");
            }
            taxesEquivalentAmountSurcharge.append(amount);
        }
        parameters.put(KEY_TAXES_EQUIVALENT_AMOUNT, taxesEquivalentAmount.length() > 0 ? taxesEquivalentAmount.toString() : null);
        parameters.put(KEY_TAXES_EQUIVALENT_AMOUNT_SURCHARGE, taxesEquivalentAmountSurcharge.length() > 0 ? taxesEquivalentAmountSurcharge.toString() : null);
        parameters.put(KEY_TAXES_EQUIVALENT_AMOUNT_BIGDECIMAL, taxesEquivAmount);
        parameters.put(KEY_TAXES_EQUIVALENT_AMOUNT_WITH_VAT_RATE, taxesEquivalentAmountWithVatRate.length() > 0 ? taxesEquivalentAmountWithVatRate.toString() : null);
        BigDecimal penaltyEquivalentAmount = product.getPenalty();
        if (penaltyEquivalentAmount != null) {
            parameters.put(KEY_PENALTY_EQUIVALENT_AMOUNT, String.format("%s%s", String.format(locale, "%.2f", penaltyEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if ((tariffWithPenaltyEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{tariffEquivalentAmount, penaltyEquivalentAmount})) != null) {
            parameters.put(KEY_TARIFF_PENALTY_EQUIVALENT_AMOUNT, String.format("%s%s", String.format(locale, "%.2f", tariffWithPenaltyEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE && product.getPreviousProduct().getPreviousProduct() != null && product.getPreviousProduct().getPreviousProduct().getStatus() == ProductStatus.SELL) {
            String prevCN = this.getPreviousCN(product);
            String prevSN = this.getPreviousSN(product);
            parameters.put(KEY_PREVIOUS_TICKET_NUMBER, (TextUtil.nonBlank((String)prevCN) ? prevCN + "-" : "") + (TextUtil.nonBlank((String)prevSN) ? prevSN : ""));
        }
        if ((supplierFeesEquivalentAmount = AirProductHelper.calculateOBFeesEquivalentAmount((Product)product)) != null) {
            parameters.put(KEY_SUPPLIER_FEES_EQUIVALENT_AMOUNT, String.format("%s%s", String.format(locale, "%.2f", supplierFeesEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            parameters.put(KEY_SUPPLIER_FEES_EQUIVALENT_AMOUNT_BIGDECIMAL, supplierFeesEquivalentAmount);
        }
        BigDecimal supplierFeesEquivalentVat = null;
        BigDecimal hiddenFeesEquivalentAmount = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.hiddenCommissionCategories));
        Object hiddenFeesEquivalentVat = null;
        Collection commissions = GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.standardCommissionCategories);
        Collection vendorContractRelationCommissions = GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.standardCommissionCategories);
        List vendorCommissionProperties = vendorContractRelationCommissions.stream().map(BaseCommission::getCommissionProperties).filter(Objects::nonNull).collect(Collectors.toList());
        List agencyCommissions = commissions.stream().filter(c -> !vendorCommissionProperties.contains(c.getCommissionProperties())).collect(Collectors.toList());
        List vendorCommissions = commissions.stream().filter(c -> vendorCommissionProperties.contains(c.getCommissionProperties())).collect(Collectors.toList());
        BigDecimal agencyFeesEquivalentAmount = AirProductHelper.calculateCommissionsEquivalentValue(agencyCommissions);
        BigDecimal vendorFeesEquivalentAmount = AirProductHelper.calculateCommissionsEquivalentValue(vendorCommissions);
        BigDecimal agencyFees = useAgencyFees && !includeAgencyFeesIntoTaxes ? agencyFeesEquivalentAmount : null;
        BigDecimal vendorFees = useVendorFees && !includeVendorFeesIntoTaxes ? vendorFeesEquivalentAmount : null;
        BigDecimal feesEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{agencyFees, vendorFees});
        BigDecimal agencyFeesIncludedIntoTaxes = useAgencyFees && includeAgencyFeesIntoTaxes ? agencyFeesEquivalentAmount : null;
        BigDecimal vendorFeesIncludedIntoTaxes = useVendorFees && includeVendorFeesIntoTaxes ? vendorFeesEquivalentAmount : null;
        BigDecimal feesIncludedIntoTaxesEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{agencyFeesIncludedIntoTaxes, vendorFeesIncludedIntoTaxes});
        for (Commission commission : commissions) {
            if (commission.getEquivalentAmount() == null) continue;
            boolean isVendorCommission = vendorCommissionProperties.contains(commission.getCommissionProperties());
            if (useAgencyFees && includeAgencyFeesIntoTaxes && !isVendorCommission || useVendorFees && includeVendorFeesIntoTaxes && isVendorCommission) {
                String taxCodeString = null;
                if (FeeProperties.class.equals((Object)commission.getCommissionProperties().getType())) {
                    taxCodeString = Optional.ofNullable(EntityStorage.get().resolve(commission.getCommissionProperties())).map(item -> ((FeeProperties)item.getEntity()).getFinanceCode()).orElse(null);
                } else if (PaymentFeeProperties.class.equals((Object)commission.getCommissionProperties().getType())) {
                    taxCodeString = Optional.ofNullable(EntityStorage.get().resolve(commission.getCommissionProperties())).map(item -> ((PaymentFeeProperties)item.getEntity()).getFinanceCode()).orElse(null);
                }
                if (taxCodeString != null) {
                    taxCodeString = taxCodeString.trim();
                }
                String amount = String.format("%s%s%s", taxCodeString != null ? taxCodeString : "", String.format(locale, "%.2f", commission.getEquivalentAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : "");
                if (taxesAndFeesEquivalentAmount.length() > 0) {
                    taxesAndFeesEquivalentAmount.append(" ");
                }
                taxesAndFeesEquivalentAmount.append(amount);
                if (taxesAndFeesEquivalentAmountWithVatRate.length() > 0) {
                    taxesAndFeesEquivalentAmountWithVatRate.append("\n");
                }
                taxesAndFeesEquivalentAmountWithVatRate.append(String.format("%s\t%s%s", taxCodeString != null ? taxCodeString + ":" : "", String.format(locale, "%.2f", commission.getEquivalentAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
                if (useVat) {
                    BigDecimal vatRate = DictHelper.getDefaultVat((BaseProduct)product);
                    taxesAndFeesEquivalentAmountWithVatRate.append(vatRate != null ? String.format(" (\u041d\u0414\u0421: %s)", new DecimalFormat("###0").format(vatRate) + "%") : " (\u0431\u0435\u0437 \u041d\u0414\u0421)");
                }
                taxesAndFeesEquivAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{taxesAndFeesEquivAmount, commission.getEquivalentAmount()});
                if (exchange) {
                    if (taxesAndFeesEquivalentAmountSurcharge.length() > 0) {
                        taxesAndFeesEquivalentAmountSurcharge.append(" ");
                    }
                    taxesAndFeesEquivalentAmountSurcharge.append(amount);
                }
                if (showTaxesSum && (includeAgencyFeesIntoTaxes && !isVendorCommission || includeVendorFeesIntoTaxes && isVendorCommission)) {
                    taxesSumAmount = taxesSumAmount.add(commission.getEquivalentAmount());
                    if (exchange) {
                        taxesSumAmountSurcharge = taxesSumAmountSurcharge.add(commission.getEquivalentAmount());
                    }
                }
            }
            if (feesDetailing.length() > 0) {
                feesDetailing.append("\n");
            }
            feesDetailing.append(String.format("%s %s %s", commission.getCommissionProperties() != null ? commission.getCommissionProperties().getCaption() : "", String.format(locale, "%.2f", commission.getEquivalentAmount()), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if (showTaxesSum) {
            if (taxesSumAmount.compareTo(BigDecimal.ZERO) > 0) {
                taxesSum.append("XT").append(String.format(locale, "%.2f", taxesSumAmount)).append(equivalentCurrencyString != null ? equivalentCurrencyString : "");
            }
            if (taxesSumAmountSurcharge.compareTo(BigDecimal.ZERO) > 0) {
                taxesSumSurcharge.append("XT").append(String.format(locale, "%.2f", taxesSumAmountSurcharge)).append(equivalentCurrencyString != null ? equivalentCurrencyString : "");
            }
        }
        parameters.put(KEY_TAXES_SUM, taxesSum.length() > 0 ? taxesSum.toString() : null);
        parameters.put(KEY_TAXES_SUM_SURCHARGE, taxesSumSurcharge.length() > 0 ? taxesSumSurcharge.toString() : null);
        BigDecimal defaultVat = DictHelper.getDefaultVat((BaseProduct)product);
        BigDecimal feesEquivalentVat = null;
        if (feesEquivalentAmount != null) {
            String amountString = String.format("%s%s", String.format(locale, "%.2f", feesEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : "");
            parameters.put(KEY_AGENCY_FEES_EQUIVALENT_AMOUNT, amountString);
            parameters.put(KEY_AGENCY_FEES_EQUIVALENT_AMOUNT_BIGDECIMAL, feesEquivalentAmount);
            if (agency != null && !agency.isSimpleTaxed()) {
                VatAmount vatAmount;
                if (agencyFees != null) {
                    vatAmount = new VatAmount();
                    vatAmount.setTotalVat(agencyFees, defaultVat != null ? defaultVat.doubleValue() : 0.0);
                    feesEquivalentVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{feesEquivalentVat, vatAmount.getVatAmount()});
                }
                if (vendorFees != null) {
                    vatAmount = new VatAmount();
                    vatAmount.setTotalVat(vendorFees, defaultVat != null ? defaultVat.doubleValue() : 0.0);
                    feesEquivalentVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{feesEquivalentVat, vatAmount.getVatAmount()});
                }
                if (feesEquivalentVat != null && feesEquivalentVat.compareTo(BigDecimal.ZERO) != 0) {
                    parameters.put(KEY_AGENCY_FEES_EQUIVALENT_VAT, String.format("%s%s", String.format(locale, "%.2f", feesEquivalentVat), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
                    parameters.put(KEY_AGENCY_FEES_EQUIVALENT_VAT_BIGDECIMAL, feesEquivalentVat);
                }
            }
        }
        if (agencyFeesEquivalentAmount != null) {
            parameters.put(KEY_AGENCY_FEES_EQUIVALENT_AMOUNT_DETALIZATION, agencyFeesEquivalentAmount.toString());
            if (agency != null && !agency.isSimpleTaxed() && useAgencyFees) {
                VatAmount vatAmount = new VatAmount();
                vatAmount.setTotalVat(agencyFeesEquivalentAmount, defaultVat != null ? defaultVat.doubleValue() : 0.0);
                BigDecimal agencyFeesEquivalentVat = vatAmount.getVatAmount();
                if (agencyFeesEquivalentVat != null && agencyFeesEquivalentVat.compareTo(BigDecimal.ZERO) != 0) {
                    parameters.put(KEY_AGENCY_FEES_EQUIVALENT_VAT_DETALIZATION, agencyFeesEquivalentVat.toString());
                }
                if (defaultVat != null) {
                    parameters.put(KEY_AGENCY_FEES_EQUIVALENT_RATE, defaultVat + "%");
                }
            }
        }
        parameters.put(KEY_TAXES_AND_FEES_EQUIVALENT_AMOUNT, taxesAndFeesEquivalentAmount.length() > 0 ? taxesAndFeesEquivalentAmount.toString() : null);
        parameters.put(KEY_TAXES_AND_FEES_EQUIVALENT_AMOUNT_SURCHARGE, taxesAndFeesEquivalentAmountSurcharge.length() > 0 ? taxesAndFeesEquivalentAmountSurcharge.toString() : null);
        parameters.put(KEY_TAXES_AND_FEES_EQUIVALENT_AMOUNT_BIGDECIMAL, taxesAndFeesEquivAmount);
        parameters.put(KEY_TAXES_AND_FEES_EQUIVALENT_AMOUNT_WITH_VAT_RATE, taxesAndFeesEquivalentAmountWithVatRate.length() > 0 ? taxesAndFeesEquivalentAmountWithVatRate.toString() : null);
        parameters.put(KEY_FEES_DETAILING, feesDetailing.length() > 0 ? feesDetailing.toString() : null);
        BigDecimal totalEquivalentAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{AirProductHelper.getClientContractRelation((Product)product).getServiceData().getTotalPrice(), MiscUtil.negate((BigDecimal)supplierFeesEquivalentAmount), hiddenFeesEquivalentAmount});
        if (totalEquivalentAmount != null) {
            parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalEquivalentAmount), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_BIGDECIMAL, totalEquivalentAmount);
        }
        BigDecimal totalEquivalentVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{product.getTotalVendorEquivalentVatAmount(), MiscUtil.negate(supplierFeesEquivalentVat), hiddenFeesEquivalentVat});
        boolean bl = isZeroVatRate = product.getVendorVatDetalization() != null && product.getVendorVatDetalization().getComponents().stream().allMatch(item -> item.getRate() != null && item.getRate().compareTo(0.0) == 0);
        if (!itTariff && totalEquivalentVat != null && (totalEquivalentVat.compareTo(BigDecimal.ZERO) != 0 || totalEquivalentVat.compareTo(BigDecimal.ZERO) == 0 && isZeroVatRate)) {
            parameters.put(KEY_TOTAL_EQUIVALENT_VAT, String.format("%s%s", String.format(locale, "%.2f", totalEquivalentVat), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            parameters.put(KEY_TOTAL_EQUIVALENT_VAT_BIGDECIMAL, totalEquivalentVat);
        }
        if ((totalEquivalentAmountIncludingFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentAmount, feesIncludedIntoTaxesEquivalentAmount})) != null) {
            parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_INCLUDING_AGENCY_FEES, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalEquivalentAmountIncludingFees), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_INCLUDING_AGENCY_FEES_BIGDECIMAL, totalEquivalentAmountIncludingFees);
        }
        BigDecimal feesIncludedIntoTaxesEquivalentVat = null;
        if (agency != null && !agency.isSimpleTaxed()) {
            VatAmount vatAmount;
            if (agencyFeesIncludedIntoTaxes != null) {
                vatAmount = new VatAmount();
                vatAmount.setTotalVat(agencyFeesIncludedIntoTaxes, defaultVat != null ? defaultVat.doubleValue() : 0.0);
                feesIncludedIntoTaxesEquivalentVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{feesIncludedIntoTaxesEquivalentVat, vatAmount.getVatAmount()});
            }
            if (vendorFeesIncludedIntoTaxes != null) {
                vatAmount = new VatAmount();
                vatAmount.setTotalVat(vendorFeesIncludedIntoTaxes, defaultVat != null ? defaultVat.doubleValue() : 0.0);
                feesIncludedIntoTaxesEquivalentVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{feesIncludedIntoTaxesEquivalentVat, vatAmount.getVatAmount()});
            }
        }
        BigDecimal totalEquivalentVatIncludingFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentVat, feesIncludedIntoTaxesEquivalentVat});
        if (!itTariff && totalEquivalentVatIncludingFees != null && totalEquivalentVatIncludingFees.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_EQUIVALENT_VAT_INCLUDING_AGENCY_FEES, String.format("%s%s", String.format(locale, "%.2f", totalEquivalentVatIncludingFees), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            parameters.put(KEY_TOTAL_EQUIVALENT_VAT_INCLUDING_AGENCY_FEES_BIGDECIMAL, totalEquivalentVatIncludingFees);
        }
        if ((totalEquivalentAmountIncludingAllFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentAmount, supplierFeesEquivalentAmount, feesIncludedIntoTaxesEquivalentAmount, feesEquivalentAmount})) != null) {
            parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_INCLUDING_ALL_FEES, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalEquivalentAmountIncludingAllFees), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_INCLUDING_ALL_FEES_BIGDECIMAL, totalEquivalentAmountIncludingAllFees);
        }
        BigDecimal totalEquivalentVatIncludingAllFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentVat, supplierFeesEquivalentVat, feesIncludedIntoTaxesEquivalentVat, feesEquivalentVat});
        if (!itTariff && totalEquivalentVatIncludingAllFees != null && totalEquivalentVatIncludingAllFees.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_EQUIVALENT_VAT_INCLUDING_ALL_FEES, String.format("%s%s", String.format(locale, "%.2f", totalEquivalentVatIncludingAllFees), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            parameters.put(KEY_TOTAL_EQUIVALENT_VAT_INCLUDING_ALL_FEES_BIGDECIMAL, totalEquivalentVatIncludingAllFees);
        }
        if ((totalEquivalentAmountIncludingSupplierFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentAmount, supplierFeesEquivalentAmount, agencyFeesIncludedIntoTaxes, vendorFeesIncludedIntoTaxes})) != null) {
            parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_INCLUDING_SUPPLIER_FEES, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalEquivalentAmountIncludingSupplierFees), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_INCLUDING_SUPPLIER_FEES_BIGDECIMAL, totalEquivalentAmountIncludingSupplierFees);
        }
        BigDecimal totalEquivalentVatIncludingSupplierFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentVat, supplierFeesEquivalentVat, feesIncludedIntoTaxesEquivalentVat});
        if (!itTariff && totalEquivalentVatIncludingSupplierFees != null && totalEquivalentVatIncludingSupplierFees.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_EQUIVALENT_VAT_INCLUDING_SUPPLIER_FEES, String.format("%s%s", String.format(locale, "%.2f", totalEquivalentVatIncludingSupplierFees), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if (product.getVendorVatDetalization() != null) {
            Airline tch;
            if (!itTariff) {
                parameters.put(KEY_TARIFF_VAT_RATE, product.getVendorVatDetalization().getComponents().stream().filter(Objects::nonNull).filter(comp -> comp.getBasisTypes().contains(VatBasisType.FARE)).map(VatComponent::getRate).filter(Objects::nonNull).findFirst().orElse(null));
            }
            List<VatComponent> vatComponentsWithoutZZ = product.getVendorVatDetalization().getComponents().stream().filter(Objects::nonNull).filter(comp -> comp.getTaxesUids().stream().allMatch(uid -> uid == null || !"ZZ".equalsIgnoreCase((String)taxesMap.get(uid)))).collect(Collectors.toList());
            List<VatComponent> vatComponentsWithZZ = product.getVendorVatDetalization().getComponents().stream().filter(Objects::nonNull).filter(comp -> !comp.getTaxesUids().stream().allMatch(uid -> uid == null || !"ZZ".equalsIgnoreCase((String)taxesMap.get(uid)))).collect(Collectors.toList());
            ArrayList<VatComponent> vatComponentsWithoutZZSurcharge = new ArrayList<VatComponent>();
            ArrayList<VatComponent> vatComponentsWithZZSurcharge = new ArrayList<VatComponent>();
            if (exchange && product.getPreviousProduct().getVendorVatDetalization() != null) {
                ArrayList previousComponents = new ArrayList(product.getPreviousProduct().getVendorVatDetalization().getComponents());
                for (VatComponent vatComponent : product.getVendorVatDetalization().getComponents()) {
                    List components = previousComponents.stream().filter(item -> MiscUtil.equals((Object)item.getBasisTypes(), (Object)vatComponent.getBasisTypes()) && MiscUtil.equals((Object)item.getRate(), (Object)vatComponent.getRate()) && item.getTaxesUids().stream().map(uid -> product.getPreviousProduct().getTaxes().stream().filter(tax -> tax.getUid().equals(uid)).map(Tax::getCode).findFirst().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList()).containsAll(vatComponent.getTaxesUids().stream().map(uid -> product.getTaxes().stream().filter(tax -> tax.getUid().equals(uid)).map(Tax::getCode).findFirst().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList()))).collect(Collectors.toList());
                    VatComponent component = new VatComponent();
                    component.setBasis(MiscUtil.sub((BigDecimal)vatComponent.getBasis(), (BigDecimal[])new BigDecimal[]{components.stream().map(VatComponent::getBasis).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null)}));
                    component.getBasisTypes().addAll(vatComponent.getBasisTypes());
                    component.setRate(vatComponent.getRate());
                    component.setSum(MiscUtil.sub((BigDecimal)vatComponent.getSum(), (BigDecimal[])new BigDecimal[]{components.stream().map(VatComponent::getSum).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null)}));
                    component.getTaxesUids().addAll(vatComponent.getTaxesUids());
                    if (!component.getTaxesUids().isEmpty() && component.getTaxesUids().stream().allMatch(uid -> "ZZ".equalsIgnoreCase((String)taxesMap.get(uid)))) {
                        vatComponentsWithZZSurcharge.add(component);
                    } else {
                        vatComponentsWithoutZZSurcharge.add(component);
                    }
                    previousComponents.removeAll(components);
                }
            }
            if (!(vatComponentsWithoutZZ.isEmpty() && vatComponentsWithZZ.isEmpty() && vatComponentsWithoutZZSurcharge.isEmpty() && vatComponentsWithZZSurcharge.isEmpty())) {
                parameters.put(KEY_VAT_DETALIZATION, useVatDetalization);
            }
            if (!vatComponentsWithoutZZ.isEmpty()) {
                parameters.put(KEY_VAT_SUM, this.vatSumToString(vatComponentsWithoutZZ, "\n"));
                parameters.put(KEY_VAT_RATE, this.vatRateToString(vatComponentsWithoutZZ, "\n"));
                parameters.put(KEY_VAT_BASIS, this.vatBasisToString(vatComponentsWithoutZZ, "\n"));
                parameters.put(VAT_SUM_IN_LINE, this.getVatSumToString(vatComponentsWithoutZZ));
            }
            if (!vatComponentsWithZZ.isEmpty()) {
                parameters.put(KEY_VAT_TCH_SUM, this.vatSumToString(vatComponentsWithZZ, "\n"));
                parameters.put(KEY_VAT_TCH_RATE, this.vatRateToString(vatComponentsWithZZ, "\n"));
                parameters.put(KEY_VAT_TCH_BASIS, this.vatBasisToString(vatComponentsWithZZ, "\n"));
            }
            if (!vatComponentsWithoutZZSurcharge.isEmpty()) {
                parameters.put(KEY_VAT_SUM_SURCHARGE, this.vatSumToString(vatComponentsWithoutZZSurcharge, "\n"));
                parameters.put(KEY_VAT_RATE_SURCHARGE, this.vatRateToString(vatComponentsWithoutZZSurcharge, "\n"));
                parameters.put(KEY_VAT_BASIS_SURCHARGE, this.vatBasisToString(vatComponentsWithoutZZSurcharge, "\n"));
                parameters.put(VAT_SUM_IN_LINE_SURCHARGE, this.getVatSumToString(vatComponentsWithoutZZSurcharge));
            }
            if (!vatComponentsWithZZSurcharge.isEmpty()) {
                parameters.put(KEY_VAT_TCH_SUM_SURCHARGE, this.vatSumToString(vatComponentsWithZZSurcharge, "\n"));
                parameters.put(KEY_VAT_TCH_RATE_SURCHARGE, this.vatRateToString(vatComponentsWithZZSurcharge, "\n"));
                parameters.put(KEY_VAT_TCH_BASIS_SURCHARGE, this.vatBasisToString(vatComponentsWithZZSurcharge, "\n"));
            }
            if (!(vatComponentsWithZZ.isEmpty() && vatComponentsWithZZSurcharge.isEmpty() || (tch = (Airline)DictionaryCache.get().findByCode(Airline.class, "\u04281")) == null)) {
                String tchName = (tch.getLegalForm() != null ? tch.getLegalForm().toString(locale) + " " : "") + "\"" + tch.toString(locale) + "\"";
                parameters.put(KEY_TCH_NAME, tch.toString(locale));
                parameters.put(KEY_TCH_OFFICIAL_NAME, tchName);
                parameters.put(KEY_TCH_REGISTRATION_ID, tch.getRegistrationId());
                parameters.put(KEY_TCH_KPP, tch.getKpp());
                parameters.put(KEY_TCH_BIN, tch.getBin());
                parameters.put(KEY_TCH_VAT_SERIES_NUMBER, tch.getVatSeriesNumber());
                parameters.put(KEY_TCH_VAT_SERIES_DATE, tch.getVatSeriesDate());
            }
        }
        String endorsement = product.getEndorsement();
        String endorsementIncludingVat = product.getEndorsement();
        if (ProfileHelper.isOrganizationCode((EntityReference)product.getBlankOwnerRef(), (String)"\u04281")) {
            if (!TextUtil.isBlank((String)product.getEndorsement()) && (Pattern.compile("\u041d\u0414\u0421\u0410/\u041a\\d+\\.\\d+ \u041d\u0414\u0421ZZ(=)*\\d+\\.\\d+").matcher(product.getEndorsement()).find() || Pattern.compile("NDSA/C\\d+\\.\\d+ NDSZZ(=)*\\d+\\.\\d+").matcher(product.getEndorsement()).find())) {
                endorsement = product.getEndorsement().replaceAll("\\s*\u041d\u0414\u0421\u0410/\u041a\\d+\\.\\d+ \u041d\u0414\u0421ZZ(=)*\\d+\\.\\d+\\s*", " ").replaceAll("\\s*NDSA/C\\d+\\.\\d+ NDSZZ(=)*\\d+\\.\\d+\\s*", " ").trim();
                endorsementIncludingVat = product.getEndorsement();
            } else {
                Object endorsementVatEntry;
                endorsement = product.getEndorsement();
                Map<String, String> endorsementVatEntries = localizedEndorsementVatEntries.get(locale);
                if (endorsementVatEntries != null && (endorsementVatEntry = endorsementVatEntries.get("\u04281")) != null) {
                    BigDecimal taxVat = AirProductHelper.calculateTaxesVatAmount((Product)product, (String)"ZZ");
                    BigDecimal airlineVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentVat, MiscUtil.negate((BigDecimal)taxVat)});
                    endorsementIncludingVat = String.format((String)endorsementVatEntry, String.format(locale, "%.2f", airlineVat != null ? airlineVat : BigDecimal.ZERO), String.format(locale, "%.2f", taxVat != null ? taxVat : BigDecimal.ZERO));
                    if (!TextUtil.isBlank((String)product.getEndorsement())) {
                        endorsementIncludingVat = endorsementIncludingVat + " " + product.getEndorsement();
                    }
                }
            }
        }
        parameters.put(KEY_ENDORSEMENT, endorsement);
        parameters.put(KEY_ENDORSEMENT_INCLUDING_VAT, endorsementIncludingVat);
        parameters.put(KEY_TAX_FEE, this.getTaxAndFee(product));
        parameters.put(IS_EXCHANGE, exchange);
        parameters.put(EXCHANGE_TOTAL, this.getExchangeTotal(product));
        parameters.put(EXCHANGE_PENALTY, product.getPenalty());
        if (product.getFareCalculationData() != null && itTariff) {
            parameters.put(KEY_FARE_CALCULATION_DATA, product.getFareCalculationData().replaceAll("[0-9]{2,}", "IT"));
        } else {
            parameters.put(KEY_FARE_CALCULATION_DATA, product.getFareCalculationData());
        }
        StringBuilder informationNotesValue = new StringBuilder();
        for (InformationNote note : notes) {
            String informationNoteValue = ItineraryReceiptRender.getInformationNoteValue(note, locale, false);
            if (TextUtil.isBlank((String)informationNoteValue)) continue;
            if (informationNotesValue.length() > 0) {
                informationNotesValue.append("\n\n");
            }
            informationNotesValue.append(informationNoteValue.trim());
        }
        parameters.put(KEY_INFORMATION_NOTES, informationNotesValue.length() > 0 ? informationNotesValue.toString() : null);
        String route = AirProductHelper.getRouteLine((Product)product);
        parameters.put(KEY_ITINERARY, route);
        if (product.getMcoCategory() != null) {
            parameters.put(EMD_TYPE, product.getMcoCategory().toString(locale));
            if (product.getPreviousProduct() != null && ProductStatus.EXCHANGE == product.getPreviousProduct().getStatus()) {
                parameters.put(TOTAL_PRICE_STRING, this.getMoneyStr(this.getExchangeTotal(product), locale, DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB")));
            } else if ((useAgencyFees && includeAgencyFeesIntoTaxes || useVendorFees && includeVendorFeesIntoTaxes) && totalEquivalentAmountIncludingAllFees != null) {
                parameters.put(TOTAL_PRICE_STRING, this.getMoneyStr(totalEquivalentAmountIncludingAllFees, locale, DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB")));
            } else if (totalEquivalentAmount != null) {
                parameters.put(TOTAL_PRICE_STRING, this.getMoneyStr(totalEquivalentAmount, locale, DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB")));
            }
            HashSet<String> relProdNumber = new HashSet<String>();
            for (Product relProd : product.getRelatedProducts()) {
                relProdNumber.add((TextUtil.nonBlank((String)relProd.getCarrierNumber()) ? relProd.getCarrierNumber() + "-" : "") + (TextUtil.nonBlank((String)relProd.getSystemNumber()) ? relProd.getSystemNumber() : ""));
            }
            if (relProdNumber.isEmpty()) {
                String mainProdDoc = (TextUtil.nonBlank((String)product.getMainProductCode()) ? product.getMainProductCode() + "-" : "") + (TextUtil.nonBlank((String)product.getMainProductNumber()) ? product.getMainProductNumber() : "");
                relProdNumber.add(mainProdDoc);
            }
            parameters.put(RELATED_NUMBERS, !relProdNumber.isEmpty() ? String.join((CharSequence)", ", relProdNumber) : null);
            boolean isEmptySigments = false;
            if (product.getSegmentTariffs().isEmpty()) {
                isEmptySigments = true;
            }
            parameters.put(IS_EMPTY_SIGMENTS, isEmptySigments);
            parameters.put(TOTAL_EQ_AMMOUNT, AirProductHelper.getTotalEquivalentFare((Product)product));
            if (TextUtil.nonBlank((String)product.getMainProductNumber())) {
                parameters.put(MAIN_PRODUCT_NUMBER, product.getMainProductNumber());
            }
        }
        if (!TextUtil.isBlank((String)(itineraryInfo = this.getItineraryInfo(product, locale)))) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                QRCodeUtil.generateToStream((String)itineraryInfo, (int)200, (int)200, (OutputStream)os, (QRCodeUtil.ImageFormat)QRCodeUtil.ImageFormat.PNG);
                ImageUtil.ImageData imageData = new ImageUtil.ImageData(os.toByteArray());
                parameters.put(KEY_QR_CODE, imageData.getData());
                parameters.put(KEY_QR_CODE_WIDTH, imageData.getWidth());
                parameters.put(KEY_QR_CODE_HEIGHT, imageData.getHeight());
            }
            catch (IIOException e) {
                this.log.error("Failed write PNG file with OutputStream generated from string:\n" + itineraryInfo, (Throwable)e);
            }
        }
        if (showDownloadQrCode && (url = BookingHelper.createBookingDocumentUrl((String)bookingFileUid, (BaseProduct)product, (DocumentType)ItineraryReceiptRender.getDocumentType())) != null) {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                QRCodeUtil.generateToStream((String)url, (int)200, (int)200, (OutputStream)os, (QRCodeUtil.ImageFormat)QRCodeUtil.ImageFormat.PNG);
                ImageUtil.ImageData imageData = new ImageUtil.ImageData(os.toByteArray());
                parameters.put(KEY_DOWNLOAD_QR_CODE, imageData.getData());
            }
        }
        if (exchange) {
            this.fillExchangeProductParameters(product, parameters, locale, agency, itTariff, usePayer, equivalentCurrencyString, useAgencyFees, includeAgencyFeesIntoTaxes, useVendorFees, includeVendorFeesIntoTaxes);
        } else {
            this.fillExchangeProductParametersAsNull(parameters);
        }
    }

    private void fillExchangeProductParametersAsNull(Map<String, Object> parameters) {
        parameters.put(KEY_SUPPLIER_FEES_EQUIVALENT_AMOUNT_SURCHARGE, null);
        parameters.put(KEY_AGENCY_FEES_EQUIVALENT_AMOUNT_SURCHARGE, null);
        parameters.put(KEY_AGENCY_FEES_EQUIVALENT_AMOUNT_SURCHARGE_DETALIZATION, null);
        parameters.put(KEY_AGENCY_FEES_EQUIVALENT_VAT_SURCHARGE, null);
        parameters.put(KEY_AGENCY_FEES_EQUIVALENT_VAT_SURCHARGE_DETALIZATION, null);
        parameters.put(KEY_AGENCY_FEES_EQUIVALENT_RATE_SURCHARGE, null);
        parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_SURCHARGE, null);
        parameters.put(KEY_TOTAL_EQUIVALENT_VAT_SURCHARGE, null);
        parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_SURCHARGE_INCLUDING_SUPPLIER_FEES, null);
        parameters.put(KEY_TOTAL_EQUIVALENT_VAT_SURCHARGE_INCLUDING_SUPPLIER_FEES, null);
        parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_SURCHARGE_INCLUDING_AGENCY_FEES, null);
        parameters.put(KEY_TOTAL_EQUIVALENT_VAT_SURCHARGE_INCLUDING_AGENCY_FEES, null);
        parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_SURCHARGE_INCLUDING_ALL_FEES, null);
        parameters.put(KEY_TOTAL_EQUIVALENT_VAT_SURCHARGE_INCLUDING_ALL_FEES, null);
        parameters.put(KEY_PAYMENTS_FEES_EQUIVALENT_AMOUNT_SURCHARGE, null);
        parameters.put(KEY_TAXES_AND_FEES_EQUIVALENT_AMOUNT_SURCHARGE, null);
    }

    private void fillExchangeProductParameters(Product product, Map<String, Object> parameters, Locale locale, Organization agency, boolean itTariff, boolean usePayer, String equivalentCurrencyString, boolean useAgencyFees, boolean includeAgencyFeesIntoTaxes, boolean useVendorFees, boolean includeVendorFeesIntoTaxes) {
        BigDecimal totalEquivalentAmountSurchargeIncludingAllFees;
        BigDecimal totalEquivalentAmountSurchargeIncludingAgencyFees;
        BigDecimal totalEquivalentAmountSurchargeIncludingSupplierFees;
        BigDecimal totalEquivalentAmountSurcharge;
        BigDecimal supplierFeesEquivalentAmountSurcharge = MiscUtil.sum((BigDecimal[])new BigDecimal[]{AirProductHelper.calculateOBFeesEquivalentAmount((Product)product), AirProductHelper.calculateOBFeesEquivalentAmount((Product)product.getPreviousProduct())});
        if (supplierFeesEquivalentAmountSurcharge != null) {
            parameters.put(KEY_SUPPLIER_FEES_EQUIVALENT_AMOUNT_SURCHARGE, String.format("%s%s", String.format(locale, "%.2f", supplierFeesEquivalentAmountSurcharge), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        BigDecimal hiddenFeesEquivalentAmount = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.hiddenCommissionCategories));
        Object hiddenFeesEquivalentVat = null;
        Object supplierFeesEquivalentVat = null;
        Collection commissions = GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.standardCommissionCategories);
        ArrayList surchargeCommissions = new ArrayList(commissions);
        surchargeCommissions.removeAll(GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product.getPreviousProduct(), (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.standardCommissionCategories));
        BigDecimal agencyFeesEquivalentAmountSurcharge = AirProductHelper.calculateCommissionsEquivalentValue(surchargeCommissions);
        BigDecimal agencyFeesEquivalentVat = null;
        if (agencyFeesEquivalentAmountSurcharge != null) {
            parameters.put(KEY_AGENCY_FEES_EQUIVALENT_AMOUNT_SURCHARGE, String.format("%s%s", String.format(locale, "%.2f", agencyFeesEquivalentAmountSurcharge), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
            parameters.put(KEY_AGENCY_FEES_EQUIVALENT_AMOUNT_SURCHARGE_DETALIZATION, agencyFeesEquivalentAmountSurcharge.toString());
            if (agency != null && !agency.isSimpleTaxed()) {
                BigDecimal defaultVat = DictHelper.getDefaultVat((BaseProduct)product);
                VatAmount vatAmount = new VatAmount();
                vatAmount.setTotalVat(agencyFeesEquivalentAmountSurcharge, defaultVat != null ? defaultVat.doubleValue() : 0.0);
                agencyFeesEquivalentVat = vatAmount.getVatAmount();
                if (agencyFeesEquivalentVat != null && agencyFeesEquivalentVat.compareTo(BigDecimal.ZERO) != 0) {
                    parameters.put(KEY_AGENCY_FEES_EQUIVALENT_VAT_SURCHARGE, String.format("%s%s", String.format(locale, "%.2f", agencyFeesEquivalentVat), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
                    parameters.put(KEY_AGENCY_FEES_EQUIVALENT_VAT_SURCHARGE_DETALIZATION, agencyFeesEquivalentVat.toString());
                }
                if (defaultVat != null) {
                    parameters.put(KEY_AGENCY_FEES_EQUIVALENT_RATE_SURCHARGE, defaultVat + "%");
                }
            }
        }
        if ((totalEquivalentAmountSurcharge = MiscUtil.sum((BigDecimal[])new BigDecimal[]{AirProductHelper.getClientContractRelation((Product)product).getServiceData().getTotalPrice(), MiscUtil.negate((BigDecimal)AirProductHelper.getClientContractRelation((Product)product.getPreviousProduct()).getServiceData().getTotalPrice()), MiscUtil.negate((BigDecimal)supplierFeesEquivalentAmountSurcharge), hiddenFeesEquivalentAmount})) != null) {
            parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_SURCHARGE, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalEquivalentAmountSurcharge), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        BigDecimal totalEquivalentVatSurcharge = MiscUtil.sum((BigDecimal[])new BigDecimal[]{product.getTotalVendorEquivalentVatAmount(), MiscUtil.negate((BigDecimal)product.getPreviousProduct().getTotalVendorEquivalentVatAmount()), hiddenFeesEquivalentVat});
        if (!itTariff && totalEquivalentVatSurcharge != null && totalEquivalentVatSurcharge.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_EQUIVALENT_VAT_SURCHARGE, String.format("%s%s", String.format(locale, "%.2f", totalEquivalentVatSurcharge), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if ((totalEquivalentAmountSurchargeIncludingSupplierFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentAmountSurcharge, supplierFeesEquivalentAmountSurcharge})) != null) {
            parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_SURCHARGE_INCLUDING_SUPPLIER_FEES, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalEquivalentAmountSurchargeIncludingSupplierFees), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        BigDecimal totalEquivalentVatSurchargeIncludingSupplierFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentVatSurcharge, supplierFeesEquivalentAmountSurcharge});
        if (!itTariff && totalEquivalentVatSurchargeIncludingSupplierFees != null && totalEquivalentVatSurchargeIncludingSupplierFees.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_EQUIVALENT_VAT_SURCHARGE_INCLUDING_SUPPLIER_FEES, String.format("%s%s", String.format(locale, "%.2f", totalEquivalentVatSurchargeIncludingSupplierFees), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if ((totalEquivalentAmountSurchargeIncludingAgencyFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentAmountSurcharge, agencyFeesEquivalentAmountSurcharge})) != null) {
            parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_SURCHARGE_INCLUDING_AGENCY_FEES, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalEquivalentAmountSurchargeIncludingAgencyFees), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        BigDecimal totalEquivalentVatSurchargeIncludingAgencyFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentVatSurcharge, agencyFeesEquivalentVat});
        if (!itTariff && totalEquivalentVatSurchargeIncludingAgencyFees != null && totalEquivalentVatSurchargeIncludingAgencyFees.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_EQUIVALENT_VAT_SURCHARGE_INCLUDING_AGENCY_FEES, String.format("%s%s", String.format(locale, "%.2f", totalEquivalentVatSurchargeIncludingAgencyFees), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        if ((totalEquivalentAmountSurchargeIncludingAllFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentAmountSurcharge, supplierFeesEquivalentAmountSurcharge, agencyFeesEquivalentAmountSurcharge})) != null) {
            parameters.put(KEY_TOTAL_EQUIVALENT_AMOUNT_SURCHARGE_INCLUDING_ALL_FEES, String.format("%s%s", itTariff ? "IT" : String.format(locale, "%.2f", totalEquivalentAmountSurchargeIncludingAllFees), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        BigDecimal totalEquivalentVatSurchargeIncludingAllFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentVatSurcharge, supplierFeesEquivalentVat, agencyFeesEquivalentVat});
        if (!itTariff && totalEquivalentVatSurchargeIncludingAllFees != null && totalEquivalentVatSurchargeIncludingAllFees.compareTo(BigDecimal.ZERO) != 0) {
            parameters.put(KEY_TOTAL_EQUIVALENT_VAT_SURCHARGE_INCLUDING_ALL_FEES, String.format("%s%s", String.format(locale, "%.2f", totalEquivalentVatSurchargeIncludingAllFees), equivalentCurrencyString != null ? equivalentCurrencyString : ""));
        }
        HashSet<PaymentType> paymentTypes = new HashSet<PaymentType>(Arrays.asList(PaymentType.values()));
        paymentTypes.remove(PaymentType.TICKET);
        parameters.put(KEY_PAYMENTS_EQUIVALENT_AMOUNT_SURCHARGE, this.getPaymentsEquivalentAmountParamater(product, fopTypes, paymentTypes, useAgencyFees, includeAgencyFeesIntoTaxes, useVendorFees, includeVendorFeesIntoTaxes, false, itTariff, usePayer, locale));
        parameters.put(KEY_PAYMENTS_PRODUCT_EQUIVALENT_AMOUNT_SURCHARGE, this.getPaymentsEquivalentAmountParamater(product, GeneralProductHelper.productFopTypes, paymentTypes, useAgencyFees, includeAgencyFeesIntoTaxes, useVendorFees, includeVendorFeesIntoTaxes, false, itTariff, usePayer, locale));
    }

    private static String hidePassport(String passportNumber) {
        String safePassportNumber = null;
        if (TextUtil.nonBlank((String)passportNumber)) {
            StringBuilder str = new StringBuilder();
            if (passportNumber.length() > 4) {
                for (int i = 0; i < passportNumber.length() - 4; ++i) {
                    str.append("*");
                }
                str.append(passportNumber, passportNumber.length() - 4, passportNumber.length());
            }
            safePassportNumber = TextUtil.nonBlank((String)str.toString()) ? str.toString() : passportNumber;
        }
        return safePassportNumber;
    }

    private String getItineraryInfo(Product product, Locale locale) {
        String bookingFileInfo;
        String reservatinInfo;
        String carrierInfo;
        String routeLineInfo;
        Format format;
        String travellerInfo;
        Traveller traveller;
        String paymentTypeInfo;
        Format format2;
        String contractInfo;
        Contract contract;
        StringBuilder info = new StringBuilder();
        Organization agency = Optional.ofNullable(EntityStorage.get().resolve(AirProductHelper.getSubagency((Product)product))).map(item -> (Organization)item.getEntity()).orElse(null);
        Organization client = Optional.ofNullable(EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile())).map(item -> (Organization)item.getEntity()).orElse(null);
        EntityStorageContext storageContext = new EntityStorageContext();
        if (agency != null || client != null) {
            String clientInfo;
            String agencyInfo;
            Format format3 = Format.of((String)String.format("[value={id=%s:%s}][padding= |value={id=%1$s:%s}][padding= \u0418\u041d\u041d |value={id=%1$s:%s}][padding= \u041a\u041f\u041f |value={id=%1$s:%s}]", ModelFormatObjects.ORGANIZATION.getId(), ModelFormatObjectOrganizationProperties.LEGAL_FORM.getId(), ModelFormatObjectOrganizationProperties.FULL_NAME.getId(), ModelFormatObjectOrganizationProperties.REGISTRATION_ID.getId(), ModelFormatObjectOrganizationProperties.KPP.getId()));
            if (agency != null && !TextUtil.isBlank((String)(agencyInfo = format3.format(Format.FormatObjectDataBuilder.get().object((Object)agency, ModelFormatObjects.ORGANIZATION.getId()).build(), storageContext, locale)))) {
                if (info.length() > 0) {
                    info.append("\n");
                }
                info.append(agencyInfo);
            }
            if (client != null && !TextUtil.isBlank((String)(clientInfo = format3.format(Format.FormatObjectDataBuilder.get().object((Object)client, ModelFormatObjects.ORGANIZATION.getId()).build(), storageContext, locale)))) {
                if (info.length() > 0) {
                    info.append("\n");
                }
                info.append(clientInfo);
            }
        }
        if ((contract = (Contract)Optional.ofNullable(AirProductHelper.getClientContractRelation((Product)product)).map(item -> EntityStorage.get().resolve(item.getGeneralData().getContractData().getContract())).map(item -> (Contract)item.getEntity()).orElse(null)) != null && !TextUtil.isBlank((String)(contractInfo = (format2 = Format.of((String)String.format("[prefix=\u0414\u043e\u0433\u043e\u0432\u043e\u0440|value=[prefix= \u2116|value={id=%s:%s}][prefix= \u043e\u0442 |value={id=%1$s:%s}]]", ModelFormatObjects.CONTRACT.getId(), ModelFormatObjectContractProperties.NUMBER.getId(), ModelFormatObjectContractProperties.DATE.getId()))).format(Format.FormatObjectDataBuilder.get().object((Object)contract, ModelFormatObjects.CONTRACT.getId()).build(), storageContext, locale)))) {
            if (info.length() > 0) {
                info.append("\n");
            }
            info.append(contractInfo);
        }
        if (!TextUtil.isBlank((String)(paymentTypeInfo = AirProductHelper.getClientContractRelation((Product)product).getFops().stream().map(item -> item.getType()).filter(item -> item != null).distinct().map(item -> item.toString(locale)).sorted().collect(Collectors.joining(", "))))) {
            if (info.length() > 0) {
                info.append("\n");
            }
            info.append(paymentTypeInfo);
        }
        if ((traveller = product.getTraveller()) != null && !TextUtil.isBlank((String)(travellerInfo = (format = Format.of((String)String.format("[value={id=%s:%s}]", ModelFormatObjects.TRAVELLER.getId(), ModelFormatObjectTravellerProperties.NAME.getId()))).format(Format.FormatObjectDataBuilder.get().object((Object)traveller, ModelFormatObjects.TRAVELLER.getId()).build(), storageContext, locale)))) {
            if (info.length() > 0) {
                info.append("\n");
            }
            info.append(travellerInfo);
        }
        if (!TextUtil.isBlank((String)(routeLineInfo = AirProductHelper.getRouteLine((Product)product, (Locale)locale, (boolean)true, (CodeSystem)CodeSystem.IATA)))) {
            if (info.length() > 0) {
                info.append("\n");
            }
            info.append(routeLineInfo);
        }
        if (!TextUtil.isBlank((String)(carrierInfo = product.getSegmentTariffs().stream().flatMap(item -> item.getSegments().stream()).map(item -> DictHelper.getCodeVariant((DictionaryReference)item.getAirline(), (CodeSystem[])new CodeSystem[]{CodeSystem.IATA})).filter(item -> item != null).distinct().sorted().collect(Collectors.joining(", "))))) {
            if (info.length() > 0) {
                info.append("\n");
            }
            info.append(carrierInfo);
        }
        if (!TextUtil.isBlank((String)(reservatinInfo = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation())))) {
            if (info.length() > 0) {
                info.append("\n");
            }
            info.append(reservatinInfo);
        }
        if (!TextUtil.isBlank((String)(bookingFileInfo = product.getReservation().getBookingFile().getNumber()))) {
            if (info.length() > 0) {
                info.append("\n");
            }
            info.append(bookingFileInfo);
        }
        return info.length() > 0 ? info.toString() : null;
    }

    private String getVatSumToString(List<VatComponent> vatComponents) {
        BigDecimal res = BigDecimal.ZERO;
        for (VatComponent vat : vatComponents) {
            if (vat.getSum() == null || vat.getSum().compareTo(BigDecimal.ZERO) == 0) continue;
            res = MiscUtil.sum((BigDecimal[])new BigDecimal[]{res, vat.getSum()});
        }
        return res.toString();
    }

    private String getFullAddress(Address a, Locale locale) {
        String address;
        StringBuilder result = new StringBuilder();
        if (TextUtil.nonBlank((String)a.getZip())) {
            result.append(a.getZip());
        }
        if (a.getCity() != null) {
            String city = a.getCity().toString(locale);
            result.append(", ").append(city);
        }
        if (!a.getAddress().getValues().isEmpty() && TextUtil.nonBlank((String)(address = a.getAddress().toString(locale)))) {
            result.append(", ").append(address);
        }
        return result.toString();
    }

    private String createTchName(String[] splitName, boolean useShortLastWord, Product product, Traveller traveller) {
        StringBuilder sb = new StringBuilder();
        if (splitName.length > 0) {
            sb.append(splitName[0]);
            if (splitName.length > 1) {
                sb.append("/").append(splitName[1]);
                for (int i = 2; i < splitName.length; ++i) {
                    String item = splitName[i];
                    if (useShortLastWord && i == splitName.length - 1 && !item.isEmpty()) {
                        item = item.substring(0, 1);
                    }
                    sb.append(" ").append(item);
                }
            }
        }
        if (TextUtil.isCyrillic((String)sb.toString(), (boolean)true)) {
            if (traveller.getGender() == Gender.MALE) {
                sb.append(" \u0413-\u041d");
            } else if (traveller.getGender() == Gender.FEMALE) {
                sb.append(" \u0413-\u0416\u0410");
            }
        } else if (traveller.getGender() == Gender.MALE) {
            sb.append(" MR");
        } else if (traveller.getGender() == Gender.FEMALE) {
            sb.append(" MRS");
        }
        return sb.toString();
    }

    private PaymentType getPaymentType(Collection<ProductFop> fops) {
        for (ProductFop fop : fops) {
            if (fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
            return fop.getType();
        }
        return null;
    }

    private String getPaymentsEquivalentAmountParamater(Product product, Set<FopType> fopTypes, Set<PaymentType> filterPaymentTypes, boolean useAgencyFees, boolean includeAgencyFeesIntoTaxes, boolean useVendorFees, boolean includeVendorFeesIntoTaxes, boolean toDisplayInFeesString, boolean itTariff, boolean usePayer, Locale locale) {
        Collection vendorFees = GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null);
        List vendorProperties = vendorFees.stream().map(BaseCommission::getCommissionProperties).filter(Objects::nonNull).collect(Collectors.toList());
        Collection fops = AirProductHelper.filterFops((Collection)AirProductHelper.getClientContractRelation((Product)product).getFops(), fopTypes, filterPaymentTypes, null, null);
        LinkedHashMap payers = new LinkedHashMap();
        for (ProductFop fop : fops) {
            TreeMap<String, BigDecimal> currencyCodes;
            TreeMap paymentTypes;
            EntityContainer payerContainer;
            BigDecimal value;
            if (fop.getAmount() == null || (value = fop.getAmount().getValue()) == null) continue;
            FopType fopType = AirProductHelper.getFopType((ProductFop)fop);
            if (!GeneralProductHelper.productFopTypes.contains(fopType)) {
                List vendorCommissions = fop.getCommissions().stream().filter(c -> vendorProperties.contains(c.getCommissionProperties())).collect(Collectors.toList());
                BigDecimal vendorCommissionsAmount = vendorCommissions.stream().map(BaseCommission::getEquivalentAmount).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
                List agencyCommissions = fop.getCommissions().stream().filter(c -> !vendorProperties.contains(c.getCommissionProperties())).collect(Collectors.toList());
                BigDecimal agencyCommissionsAmount = agencyCommissions.stream().map(BaseCommission::getEquivalentAmount).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
                if (toDisplayInFeesString) {
                    if (!useVendorFees || includeVendorFeesIntoTaxes) {
                        value = MiscUtil.sub((BigDecimal)value, (BigDecimal[])new BigDecimal[]{vendorCommissionsAmount});
                    }
                    if (!useAgencyFees || includeAgencyFeesIntoTaxes) {
                        value = MiscUtil.sub((BigDecimal)value, (BigDecimal[])new BigDecimal[]{agencyCommissionsAmount});
                    }
                } else {
                    if (!useVendorFees || !includeVendorFeesIntoTaxes) {
                        value = MiscUtil.sub((BigDecimal)value, (BigDecimal[])new BigDecimal[]{vendorCommissionsAmount});
                    }
                    if (!useAgencyFees || !includeAgencyFeesIntoTaxes) {
                        value = MiscUtil.sub((BigDecimal)value, (BigDecimal[])new BigDecimal[]{agencyCommissionsAmount});
                    }
                }
                if (value.compareTo(BigDecimal.ZERO) < 0) continue;
            }
            Organization payer = null;
            if (usePayer && (payerContainer = EntityStorage.get().resolve(fop.getPayer())) != null && !TextUtil.isSame((String)((Organization)payerContainer.getEntity()).getCode(), (String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.RETAIL_PROFILE_CODE, null))) {
                payer = (Organization)payerContainer.getEntity();
            }
            if ((paymentTypes = (TreeMap)payers.get(payer)) == null) {
                paymentTypes = new TreeMap((o1, o2) -> MiscUtil.compare((Comparable)((Comparable)o1.getFirst()), (Comparable)((Comparable)o2.getFirst())));
                payers.put(payer, paymentTypes);
            }
            String extraFopInfo = null;
            if (fop.getType() == PaymentType.CREDIT || fop.getType() == PaymentType.MTD) {
                if (fop.getPassengerStatus() != null) {
                    extraFopInfo = fop.getPassengerStatus().toString(locale);
                }
                if (fop.getRelatedTicketNumber() != null) {
                    extraFopInfo = extraFopInfo + " " + fop.getRelatedTicketNumber();
                }
            }
            Map<String, BigDecimal> map = currencyCodes = fop.getType() != null && Optional.ofNullable(paymentTypes.get(new MiscUtil.Pair((Object)fop.getType(), (Object)extraFopInfo))).isPresent() ? (Map)paymentTypes.get(new MiscUtil.Pair((Object)fop.getType(), (Object)extraFopInfo)) : null;
            if (currencyCodes == null) {
                currencyCodes = new TreeMap<String, BigDecimal>();
                paymentTypes.put(new MiscUtil.Pair((Object)fop.getType(), (Object)extraFopInfo), currencyCodes);
            }
            String currencyCode = fop.getAmount().getCurrency() != null ? fop.getAmount().getCurrency() : null;
            currencyCodes.put(currencyCode, MiscUtil.sum((BigDecimal[])new BigDecimal[]{(BigDecimal)currencyCodes.get(currencyCode), value}));
        }
        StringBuilder paymentsEquivalentAmount = new StringBuilder();
        for (Map.Entry payerEntry : payers.entrySet()) {
            Organization payer = (Organization)payerEntry.getKey();
            Map paymentTypes = (Map)payerEntry.getValue();
            for (Map.Entry paymentTypeEntry : paymentTypes.entrySet()) {
                PaymentType paymentType = (PaymentType)((MiscUtil.Pair)paymentTypeEntry.getKey()).getFirst();
                Map currencyCodes = (Map)paymentTypeEntry.getValue();
                for (Map.Entry currencyCodeEntry : currencyCodes.entrySet()) {
                    Map<String, String> currencyNames;
                    Map<PaymentType, String> paymentTypeNames;
                    String currencyCode = (String)currencyCodeEntry.getKey();
                    BigDecimal amount = (BigDecimal)currencyCodeEntry.getValue();
                    String paymentTypeString = null;
                    String currencyString = null;
                    String payerString = null;
                    if (paymentType != null && (paymentTypeNames = localizedPaymentTypeNames.get(locale)) != null) {
                        paymentTypeString = paymentTypeNames.get(paymentType);
                        if (((MiscUtil.Pair)paymentTypeEntry.getKey()).getSecond() != null) {
                            paymentTypeString = paymentTypeString + " " + (String)((MiscUtil.Pair)paymentTypeEntry.getKey()).getSecond();
                        }
                    }
                    if (currencyCode != null && (currencyNames = localizedCurrencyNames.get(locale)) != null) {
                        currencyString = currencyNames.get(currencyCode);
                    }
                    if (payer != null) {
                        LegalForm legalForm = (LegalForm)DictionaryCache.get().resolveReference(payer.getLegalForm());
                        String string = payerString = legalForm != null ? String.format("%s %s", DictHelper.getValueByLocale((Map)legalForm.getAbbreviations(), (Locale)locale), L10nStringHelper.getValue((L10nString)payer.getFullName(), (Locale)locale, (boolean)true)) : L10nStringHelper.getValue((L10nString)payer.getFullName(), (Locale)locale, (boolean)true);
                    }
                    if (paymentsEquivalentAmount.length() > 0) {
                        paymentsEquivalentAmount.append(" / ");
                    }
                    paymentsEquivalentAmount.append(String.format("%s - %s%s", paymentTypeString != null ? paymentTypeString : "", itTariff ? "IT" : String.format(locale, "%.2f", amount), currencyString != null ? currencyString : ""));
                    if (payerString == null) continue;
                    paymentsEquivalentAmount.append(String.format(" - %s", payerString));
                }
            }
        }
        return paymentsEquivalentAmount.length() > 0 ? paymentsEquivalentAmount.toString() : null;
    }

    private static String getInformationNoteValue(InformationNote note, Locale locale, boolean strict) {
        String value = (String)MiscUtil.findByLocale((Map)note.getNotes(), (Locale)locale);
        if (strict || value != null) {
            return value;
        }
        if (!MiscUtil.equals((Object)locale, (Object)LocaleHelper.EN_LOCALE)) {
            value = (String)MiscUtil.findByLocale((Map)note.getNotes(), (Locale)LocaleHelper.EN_LOCALE);
        }
        if (value != null) {
            return value;
        }
        return note.getNotes().size() > 0 ? (String)note.getNotes().values().iterator().next() : null;
    }

    private JRDataSource getDataSource(Product product, Locale locale, List<InformationNote> notes, boolean itTariff, boolean useCyrillicName, boolean usePayer, boolean useVat, boolean useLogo, boolean showTaxesSum, boolean useVatDetalization, boolean hidePassport, List<ItineraryData> itineraryDataList, Map<String, Object> parameters) {
        ArrayList data = new ArrayList();
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                DictionaryReference operatingCarrier;
                Object arriveCity;
                String departureTerminalString;
                GeoLocation departureCity;
                HashMap<String, Object> record = new HashMap<String, Object>();
                ItineraryData itineraryData = new ItineraryData();
                itineraryData.setSegmentDataTitle(this.getSegmentDataTitle());
                record.put(FIELD_DEPARTURE_DATE, segment.getStartDate());
                GeoLocation departureLocation = (GeoLocation)DictionaryCache.get().resolveReference(segment.getDepartureLocation());
                String departureAirportString = null;
                String arriveAirportString = null;
                if (departureLocation != null) {
                    String departureCityString = departureLocation.toString(locale);
                    String departureCityEnString = departureLocation.toString(LocaleHelper.getLocale((String)"EN"));
                    departureAirportString = departureLocation.toString(locale);
                    if (departureLocation.getType() == LocationType.AIRPORT && (departureCity = DictHelper.findCity((GeoLocation)departureLocation)) != null) {
                        departureCityString = departureCity.toString(locale);
                        departureCityEnString = departureCity.toString(LocaleHelper.getLocale((String)"EN"));
                    }
                    record.put(FIELD_DEPARTURE_CITY, departureCityString);
                    record.put(FIELD_DEPARTURE_CITY_EN, departureCityEnString);
                    if (!TextUtil.isSame((String)departureCityString, (String)departureAirportString)) {
                        record.put(FIELD_DEPARTURE_AIRPORT, departureAirportString);
                    }
                    record.put(FIELD_DEPARTURE_AIRPORT_TUI, departureAirportString);
                }
                if ((departureTerminalString = MiscUtil.translateTerminal((String)segment.getDepartTerminal(), (Locale)locale)) != null) {
                    boolean find = false;
                    departureCity = terminalKeys.iterator();
                    while (departureCity.hasNext()) {
                        String terminalKey = departureCity.next();
                        if (!departureTerminalString.toLowerCase().contains(terminalKey.toLowerCase())) continue;
                        find = true;
                        break;
                    }
                    if (!find && localizedTerminalEntries.get(locale) != null) {
                        departureTerminalString = String.format("%s %s", localizedTerminalEntries.get(locale), departureTerminalString);
                    }
                }
                record.put(FIELD_DEPARTURE_TERMINAL, departureTerminalString);
                record.put(FIELD_ARRIVE_DATE, segment.getEndDate());
                GeoLocation arriveLocation = (GeoLocation)DictionaryCache.get().resolveReference(segment.getArriveLocation());
                if (arriveLocation != null) {
                    String arriveCityString = arriveLocation.toString(locale);
                    String arriveCityEnString = arriveLocation.toString(LocaleHelper.getLocale((String)"EN"));
                    arriveAirportString = arriveLocation.toString(locale);
                    if (arriveLocation.getType() == LocationType.AIRPORT && (arriveCity = DictHelper.findCity((GeoLocation)arriveLocation)) != null) {
                        arriveCityString = arriveCity.toString(locale);
                        arriveCityEnString = arriveCity.toString(LocaleHelper.getLocale((String)"EN"));
                    }
                    record.put(FIELD_ARRIVE_CITY, arriveCityString);
                    record.put(FIELD_ARRIVE_CITY_EN, arriveCityEnString);
                    if (!TextUtil.isSame((String)arriveCityString, (String)arriveAirportString)) {
                        record.put(FIELD_ARRIVE_AIRPORT, arriveAirportString);
                    }
                    record.put(FIELD_ARRIVE_AIRPORT_TUI, arriveAirportString);
                }
                record.put(MEAL, segment.getMealServiceIndicator() != null ? segment.getMealServiceIndicator().getCaption() : null);
                record.put(BOARD, segment.getBoard() != null ? segment.getBoard().getCaption() : null);
                record.put(DEPARTURE_AIRPORT_CODE, departureLocation != null ? (Object)departureLocation.getCodeVariants().get(CodeSystem.IATA.name()) : null);
                record.put(ARRIVE_AIRPORT_CODE, arriveLocation != null ? (Object)arriveLocation.getCodeVariants().get(CodeSystem.IATA.name()) : null);
                String arriveTerminalString = MiscUtil.translateTerminal((String)segment.getArriveTerminal(), (Locale)locale);
                if (arriveTerminalString != null) {
                    boolean find = false;
                    arriveCity = terminalKeys.iterator();
                    while (arriveCity.hasNext()) {
                        String terminalKey = (String)arriveCity.next();
                        if (!arriveTerminalString.toLowerCase().contains(terminalKey.toLowerCase())) continue;
                        find = true;
                        break;
                    }
                    if (!find && localizedTerminalEntries.get(locale) != null) {
                        arriveTerminalString = String.format("%s %s", localizedTerminalEntries.get(locale), arriveTerminalString);
                    }
                }
                record.put(FIELD_ARRIVE_TERMINAL, arriveTerminalString);
                DictionaryReference marketingCarrier = segment.getAirline();
                String marketingCarrierCode = null;
                if (marketingCarrier != null) {
                    record.put(FIELD_MARKETING_CARRIER_NAME, marketingCarrier.toString(locale));
                    Airline marketingAirline = (Airline)DictionaryCache.get().resolveReference(marketingCarrier);
                    if (marketingAirline != null && (marketingCarrierCode = DictHelper.getCodeVariant((BaseDictionary)marketingAirline, Arrays.asList(CodeSystem.IATA, CodeSystem.CRT))) == null && marketingAirline.getCodeVariants().size() > 0) {
                        marketingCarrierCode = (String)marketingAirline.getCodeVariants().values().iterator().next();
                    }
                    if (marketingCarrierCode == null) {
                        marketingCarrierCode = marketingCarrier.getCode();
                    }
                    record.put(FIELD_MARKETING_CARRIER_CODE, marketingCarrierCode);
                }
                if ((operatingCarrier = segment.getCodeShareCarrier()) != null) {
                    record.put(FIELD_OPERATING_CARRIER_NAME, operatingCarrier.toString(locale));
                    String operatingCarrierCode = null;
                    Airline operatingAirline = (Airline)DictionaryCache.get().resolveReference(operatingCarrier);
                    if (operatingAirline != null && (operatingCarrierCode = DictHelper.getCodeVariant((BaseDictionary)operatingAirline, Arrays.asList(CodeSystem.IATA, CodeSystem.CRT))) == null && operatingAirline.getCodeVariants().size() > 0) {
                        operatingCarrierCode = (String)operatingAirline.getCodeVariants().values().iterator().next();
                    }
                    if (operatingCarrierCode == null) {
                        operatingCarrierCode = operatingCarrier.getCode();
                    }
                    record.put(FIELD_OPERATING_CARRIER_CODE, operatingCarrierCode);
                }
                record.put(FIELD_FLIGHT_NUMBER, segment.getFlightNo());
                record.put(FIELD_AIRLINE_LOCATOR, segment.getAirlineLocator());
                String serviceClassCode = segment.getClassOfSvcCode();
                String serviceClass = null;
                if (!TextUtil.isBlank((String)serviceClassCode)) {
                    ClassOfService classOfService = DictHelper.findClassOfService((Segment)segment, (Date)product.getIssueDate());
                    serviceClass = String.format("%s (%s)", classOfService != null ? LocaleHelper.toString((Object)classOfService, (Locale)locale) : "", serviceClassCode.trim());
                    record.put(FIELD_SERVICE_CLASS, serviceClass);
                    record.put(FIELD_SERVICE_CLASS_CODE, serviceClassCode);
                }
                record.put(FIELD_SEAT_NUMBER, !TextUtil.isBlank((String)segment.getSeatNo()) ? segment.getSeatNo().trim() : null);
                record.put(FIELD_BAGGAGE_ALLOWANCE, ItineraryReceiptHelper.luggageInfoToString((Segment)segment, (Locale)locale));
                Optional.ofNullable(segment.getFareDetails()).map(FareDetails::getCabinLuggageInfo).ifPresent(cabinLuggageInfo -> record.put(FIELD_CABIN_LUGGAGE_INFO, ItineraryReceiptHelper.extendedLuggageInfoToString((ExtendedLuggageInfo)cabinLuggageInfo, (Locale)locale)));
                record.put(FIELD_FARE_BASIS, segment.getFareBasis());
                record.put(FIELD_NOT_VALID_BEFORE_DATE, segment.getNotValidBefore());
                record.put(FIELD_NOT_VALID_AFTER_DATE, segment.getNotValidAfter());
                String departureCityNameTui = this.getCityNameTui(departureLocation, locale);
                String arrivalCityNameTui = this.getCityNameTui(arriveLocation, locale);
                record.put(FIELD_DEPARTURE_CITY_TUI, departureCityNameTui);
                record.put(FIELD_ARRIVE_CITY_TUI, arrivalCityNameTui);
                FareDetails fareDetails = segment.getFareDetails();
                if (fareDetails != null) {
                    record.put(FIELD_BRAND_NAME, L10nStringHelper.getValue((L10nString)fareDetails.getBrandName(), (Locale)locale));
                }
                String departureDataString = this.getItineraryDataString(departureCityNameTui, departureAirportString, departureTerminalString, segment.getStartDate(), locale);
                StringBuilder builder = new StringBuilder(departureDataString);
                builder.append("\n").append("\n");
                if (TextUtil.nonBlank((String)marketingCarrierCode)) {
                    builder.append(marketingCarrierCode.toUpperCase());
                }
                if (TextUtil.nonBlank((String)segment.getFlightNo())) {
                    builder.append(" ").append(segment.getFlightNo().toUpperCase());
                }
                if (TextUtil.nonBlank((String)serviceClass)) {
                    builder.append(", ").append(serviceClass.toUpperCase());
                }
                itineraryData.setDepartureData(builder.toString());
                itineraryData.setArrivalData(this.getItineraryDataString(arrivalCityNameTui, arriveAirportString, arriveTerminalString, segment.getEndDate(), locale));
                itineraryData.setSegmentData(this.getSegmentDataString(segment, locale));
                itineraryDataList.add(itineraryData);
                data.add(record);
            }
        }
        parameters.put(KEY_TOTAL_ROWS_COUNT, data.size());
        if (data.isEmpty()) {
            data.add(new HashMap());
        }
        return new JRMapCollectionDataSource(data);
    }

    private static List<EntityContainer<SalesPoint>> getSalesPointsByValidatorAndPcc(String validator, String pcc) throws Exception {
        SearchQuery query = ItineraryReceiptRender.createValidatorQuery(pcc, validator);
        return EntityStorage.get().search(ValidatorIndex.class, query).getData().stream().map(EntityIndex::getSource).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static SearchQuery createValidatorQuery(String pcc, String validatorNumber) {
        SearchQuery query = new SearchQuery();
        if (TextUtil.nonBlank((String)pcc)) {
            query.getCriteria().getCriterions().add(SearchCriterion.ieq((String)ValidatorIndex.Property.pcc.name(), (String)pcc));
        }
        if (TextUtil.nonBlank((String)validatorNumber)) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.number.name(), (Object)validatorNumber));
        }
        return query;
    }

    private static SearchQuery createQueryPccValidator(String pcc, String validator, String terminal) {
        SearchQuery query = new SearchQuery();
        if (!TextUtil.isBlank((String)pcc)) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)SalesPointIndex.Property.pccs.name(), (Object)pcc));
        }
        if (!TextUtil.isBlank((String)validator)) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)SalesPointIndex.Property.validators.name(), (Object)validator));
        }
        if (!TextUtil.isBlank((String)terminal)) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)SalesPointIndex.Property.terminals.name(), (Object)terminal));
        }
        return query;
    }

    private Locale getLocale(TemplateDocument templateDocument) {
        String language = SystemHelper.findMetadataAsString((Collection)templateDocument.getMetadata(), (MetadataKey)MetadataKey.KEY_LOCALE);
        if (!TextUtil.isBlank((String)language)) {
            return LocaleHelper.getLocale((String)language);
        }
        return LocaleHelper.getCurrentLocale();
    }

    private String getFileName(Product product, TemplateDocument templateDocument) {
        return this.getReportTitle(product, templateDocument);
    }

    private static DocumentType getDocumentType() {
        return DocumentType.RECEIPT;
    }

    private String getReportTitle(Product product, TemplateDocument templateDocument) {
        StringBuilder reportTitle = new StringBuilder();
        reportTitle.append(templateDocument.getTitle()).append(" ").append(this.getSystemNumberConj(product)).append(" ").append(product.getTraveller().getName()).append(" (").append(new SimpleDateFormat("yyyyMMdd_HHmm").format(new Date())).append(")");
        return reportTitle.toString();
    }

    private String vatSumToString(List<VatComponent> vatComponents, String delimiter) {
        return TextUtil.nullOrNonBlankString((String)vatComponents.stream().filter(Objects::nonNull).filter(c -> c.getRate() != null).map(comp -> GeneralProductHelper.getNonNullString((Object)comp.getSum())).collect(Collectors.joining(delimiter)));
    }

    private String vatRateToString(List<VatComponent> vatComponents, String delimiter) {
        return TextUtil.nullOrNonBlankString((String)vatComponents.stream().filter(Objects::nonNull).filter(c -> c.getRate() != null).map(comp -> comp.getRate() + "%").collect(Collectors.joining(delimiter)));
    }

    private String vatBasisToString(List<VatComponent> vatComponents, String delimiter) {
        return TextUtil.nullOrNonBlankString((String)vatComponents.stream().filter(Objects::nonNull).filter(c -> c.getRate() != null).map(comp -> GeneralProductHelper.getNonNullString((Object)comp.getBasis())).collect(Collectors.joining(delimiter)));
    }

    private String getTravellerName(Traveller traveller, Locale locale, boolean useCyrillicName, String cyrillicName) {
        Person entity;
        EntityContainer person = EntityStorage.get().resolve(traveller.getPassenger());
        if (person != null && (entity = (Person)person.getEntity()) != null) {
            String lastName = L10nStringHelper.getValue((L10nString)entity.getLastName(), (Locale)locale);
            String firstName = L10nStringHelper.getValue((L10nString)entity.getFirstName(), (Locale)locale);
            String middleName = L10nStringHelper.getValue((L10nString)entity.getMiddleName(), (Locale)locale);
            return (lastName != null ? lastName : "") + (firstName != null ? (lastName != null ? " " + firstName : firstName) : "") + (middleName != null ? (lastName != null || firstName != null ? " " + middleName : middleName) : "");
        }
        String result = useCyrillicName ? (cyrillicName != null ? cyrillicName : traveller.getName()) : traveller.getName();
        return result;
    }

    private String getCyrillicName(Traveller traveller) {
        EntityContainer person = EntityStorage.get().resolve(traveller.getPassenger());
        if (EntityStorageHelper.isEmpty((EntityContainer)person)) {
            return traveller.getCyrillicName();
        }
        String personRussianName = new PersonalLocalizableNameFormatter("L F S M").format((PersonalLocalizableName)person.getEntity(), LocaleHelper.RU_LOCALE, true);
        return TextUtil.nonBlank((String)personRussianName) ? personRussianName : traveller.getCyrillicName();
    }

    private BigDecimal getTaxAndFee(Product product) {
        BigDecimal result = BigDecimal.ZERO;
        if (!product.getTaxes().isEmpty()) {
            for (Tax tax : product.getTaxes()) {
                result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, tax.getEquivalentAmount()});
            }
        }
        if (!product.getObFees().isEmpty()) {
            for (OBFee fee : product.getObFees()) {
                if (fee.getAmount() == null) continue;
                result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, fee.getAmount().getValue()});
            }
        }
        return result;
    }

    private BigDecimal getExchangeTotal(Product product) {
        List fops = AirProductHelper.getClientContractRelation((Product)product).getFops();
        BigDecimal result = null;
        for (ProductFop fop : fops) {
            if (PaymentType.TICKET == fop.getType() || FopType.PRODUCT != AirProductHelper.getFopType((ProductFop)fop)) continue;
            result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, fop.getAmount().getValue()});
        }
        return result;
    }

    private String getCityNameTui(GeoLocation firstLocation, Locale locale) {
        StringBuilder result = new StringBuilder();
        if (firstLocation == null) {
            return null;
        }
        GeoLocation location = (GeoLocation)DictionaryCache.get().resolveReference(firstLocation.getParent());
        if (location == null) {
            location = firstLocation;
        }
        if (location.getTranslations().isEmpty()) {
            return null;
        }
        Map translations = location.getTranslations();
        result.append(translations.get(locale) != null ? (String)translations.get(locale) : translations.values().stream().findFirst().orElse(""));
        if (!firstLocation.getCodeVariants().isEmpty()) {
            Map codeVariants = firstLocation.getCodeVariants();
            result.append(", ").append(codeVariants.get(CodeSystem.IATA.name()) != null ? (String)codeVariants.get(CodeSystem.IATA.name()) : (codeVariants.get(CodeSystem.CRT.name()) != null ? (String)codeVariants.get(CodeSystem.CRT.name()) : codeVariants.values().stream().findFirst().orElse("")));
        }
        return TextUtil.nonBlank((String)result.toString()) ? result.toString() : null;
    }

    private String buildPhoneString(List<Communication> communications, List<CommunicationType> communicationTypes, Locale locale) {
        for (CommunicationType communicationType : communicationTypes) {
            for (Communication communication : ProfileHelper.filterCommunications(communications, Collections.singleton(communicationType))) {
                String phoneString = ProfileHelper.buildFullPhoneNumber((Communication)communication);
                if (TextUtil.isBlank((String)phoneString)) continue;
                return phoneString.trim();
            }
        }
        return null;
    }

    private String getMoneyStr(BigDecimal price, Locale locale, String currency) {
        Number2WordsConverter number2WordsConverter = ((Number2WordsConverterRegistry)Environment.getPublished(Number2WordsConverterRegistry.class)).findConverter(locale, currency);
        if (number2WordsConverter != null) {
            try {
                return TextUtil.capitalize((String)number2WordsConverter.toCurrencyWords(price, currency, false, false, false)).replace("\u0440\u0443\u0431\u043b\u044f", "\u0440\u0443\u0431\u043b\u0435\u0439");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String getPreviousCN(Product product) {
        if (product.getPreviousProduct() == null) {
            return null;
        }
        Product previousProduct = product.getPreviousProduct();
        if (previousProduct.getPreviousProduct() == null) {
            return null;
        }
        return previousProduct.getPreviousProduct().getCarrierNumber();
    }

    private String getPreviousSN(Product product) {
        if (product.getPreviousProduct() == null) {
            return null;
        }
        Product previousProduct = product.getPreviousProduct();
        if (previousProduct.getPreviousProduct() == null) {
            return null;
        }
        return previousProduct.getPreviousProduct().getSystemNumber();
    }

    private String getItineraryDataString(String cityName, String airportString, String terminalString, Date date, Locale locale) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM. - HH:mm", locale);
        StringBuilder builder = new StringBuilder();
        builder.append(TextUtil.nonBlank((String)cityName) ? cityName.toUpperCase() : "");
        if (builder.length() > 0) {
            builder.append("\n");
        }
        if (TextUtil.nonBlank((String)airportString)) {
            builder.append("(\u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442 ").append(airportString);
            if (TextUtil.nonBlank((String)terminalString)) {
                builder.append(" ").append(terminalString).append(")");
            } else {
                builder.append(")");
            }
        } else if (TextUtil.nonBlank((String)terminalString)) {
            builder.append("(").append(terminalString).append(")");
        }
        if (builder.length() > 0) {
            builder.append("\n");
        }
        if (date != null) {
            builder.append(dateFormat.format(date).toUpperCase());
        }
        return builder.toString();
    }

    private String getSegmentDataString(Segment segment, Locale locale) {
        StringBuilder builder = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy", locale);
        builder.append("OK");
        builder.append("\n");
        builder.append(TextUtil.nonBlank((String)segment.getFareBasis()) ? segment.getFareBasis() : "-");
        builder.append("\n");
        builder.append(segment.getNotValidBefore() != null ? dateFormat.format(segment.getNotValidBefore()) : "-");
        builder.append("\n");
        builder.append(segment.getNotValidAfter() != null ? dateFormat.format(segment.getNotValidAfter()) : "-");
        builder.append("\n");
        String luggageInfo = ItineraryReceiptHelper.luggageInfoToString((Segment)segment, (Locale)locale);
        builder.append(TextUtil.nonBlank((String)luggageInfo) ? luggageInfo : "-");
        builder.append("\n");
        builder.append(segment.getMealServiceIndicator() != null ? segment.getMealServiceIndicator().getCaption() : "-");
        return builder.toString();
    }

    private String getSystemNumberConj(Product product) {
        String sysNumber = product.getSystemNumber();
        for (int conjCount = product.getConjCount(); conjCount > 0; --conjCount) {
            StringBuilder adding = new StringBuilder();
            adding.append("/");
            int lastDigs = Integer.parseInt(sysNumber.substring(sysNumber.length() - 2)) + 1;
            String digs = String.valueOf(lastDigs);
            while (digs.length() < 2) {
                digs = "0".concat(digs);
            }
            adding.append(digs.substring(digs.length() - 2));
            sysNumber = sysNumber.concat(adding.toString());
        }
        return sysNumber;
    }

    private String getSegmentDataTitle() {
        return "\u0421\u0442\u0430\u0442\u0443\u0441\n\u0411\u0430\u0437\u043e\u0432\u044b\u0439 \u0442\u0430\u0440\u0438\u0444\n\u041d\u0414\u0414\n\u041d\u0414\u041f\n\u041d\u043e\u0440\u043c\u0430 \u0431\u0430\u0433\u0430\u0436\u0430\n\u041f\u0438\u0442\u0430\u043d\u0438\u0435";
    }

    private static /* synthetic */ boolean lambda$fillParameters$6(SimpleTax tax, VatComponent c) {
        return c.getTaxesUids().contains(tax.getSource());
    }

    private static /* synthetic */ boolean lambda$fillParameters$2(SimpleTax tax, Tax item) {
        return MiscUtil.equals((Object)item.getCode(), (Object)tax.getCode());
    }

    static {
        Locale enLocale = LocaleHelper.getLocale((String)"EN");
        HashMap<PaymentType, String> enPaymentTypeNames = new HashMap<PaymentType, String>();
        enPaymentTypeNames.put(PaymentType.CASH, "cash");
        enPaymentTypeNames.put(PaymentType.INVOICE, "invoice");
        enPaymentTypeNames.put(PaymentType.CREDIT_CARD, "credit card");
        enPaymentTypeNames.put(PaymentType.CREDIT_CARD_AGENCY, "credit card");
        enPaymentTypeNames.put(PaymentType.CREDIT_CARD_TCH, "credit card");
        enPaymentTypeNames.put(PaymentType.CREDIT, "credit card");
        enPaymentTypeNames.put(PaymentType.MTD, "mtd");
        enPaymentTypeNames.put(PaymentType.TICKET, "ticket");
        localizedPaymentTypeNames.put(enLocale, enPaymentTypeNames);
        HashMap<String, String> enCurrencyNames = new HashMap<String, String>();
        enCurrencyNames.put("USD", "usd");
        enCurrencyNames.put("EUR", "eur");
        enCurrencyNames.put("RUB", "rub");
        enCurrencyNames.put("AZN", "man");
        enCurrencyNames.put("KZT", "KZT");
        localizedCurrencyNames.put(enLocale, enCurrencyNames);
        HashMap<String, String> enEndorsementVatEntries = new HashMap<String, String>();
        enEndorsementVatEntries.put("\u04281", "NDSA/C%s NDSZZ%s");
        localizedEndorsementVatEntries.put(enLocale, enEndorsementVatEntries);
        localizedTerminalEntries.put(enLocale, "Terminal");
        Locale ruLocale = LocaleHelper.getLocale((String)"RU");
        HashMap<PaymentType, String> ruPaymentTypeNames = new HashMap<PaymentType, String>();
        ruPaymentTypeNames.put(PaymentType.CASH, "\u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435");
        ruPaymentTypeNames.put(PaymentType.INVOICE, "\u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0435 \u043f\u043e\u0440\u0443\u0447\u0435\u043d\u0438\u0435");
        ruPaymentTypeNames.put(PaymentType.CREDIT_CARD, "\u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430");
        ruPaymentTypeNames.put(PaymentType.CREDIT_CARD_AGENCY, "\u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430");
        ruPaymentTypeNames.put(PaymentType.CREDIT_CARD_TCH, "\u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430");
        ruPaymentTypeNames.put(PaymentType.CREDIT, "\u043a\u0440");
        ruPaymentTypeNames.put(PaymentType.MTD, "\u0432\u043f\u0434");
        ruPaymentTypeNames.put(PaymentType.TICKET, "\u0431\u0438\u043b\u0435\u0442");
        localizedPaymentTypeNames.put(ruLocale, ruPaymentTypeNames);
        HashMap<String, String> ruCurrencyNames = new HashMap<String, String>();
        ruCurrencyNames.put("USD", "\u0434\u043e\u043b");
        ruCurrencyNames.put("EUR", "\u0435\u0432\u0440");
        ruCurrencyNames.put("RUB", "\u0440\u0443\u0431");
        ruCurrencyNames.put("AZN", "\u043c\u0430\u043d");
        ruCurrencyNames.put("KZT", "KZT");
        localizedCurrencyNames.put(ruLocale, ruCurrencyNames);
        HashMap<String, String> ruEndorsementVatEntries = new HashMap<String, String>();
        ruEndorsementVatEntries.put("\u04281", "\u041d\u0414\u0421\u0410/\u041a%s \u041d\u0414\u0421ZZ%s");
        localizedEndorsementVatEntries.put(ruLocale, ruEndorsementVatEntries);
        localizedTerminalEntries.put(ruLocale, "\u0422\u0435\u0440\u043c\u0438\u043d\u0430\u043b");
        Locale azLocale = LocaleHelper.getLocale((String)"AZ");
        HashMap<PaymentType, String> azPaymentTypeNames = new HashMap<PaymentType, String>();
        azPaymentTypeNames.put(PaymentType.CASH, "na\u011fd");
        azPaymentTypeNames.put(PaymentType.INVOICE, "i\u0307nvoi\u0307ce");
        azPaymentTypeNames.put(PaymentType.CREDIT_CARD, "kredit karti");
        azPaymentTypeNames.put(PaymentType.CREDIT_CARD_AGENCY, "kredit karti");
        azPaymentTypeNames.put(PaymentType.CREDIT_CARD_TCH, "kredit karti");
        azPaymentTypeNames.put(PaymentType.CREDIT, "kredit karti");
        azPaymentTypeNames.put(PaymentType.MTD, "mtd");
        azPaymentTypeNames.put(PaymentType.TICKET, "bilet");
        localizedPaymentTypeNames.put(azLocale, azPaymentTypeNames);
        HashMap<String, String> azCurrencyNames = new HashMap<String, String>();
        azCurrencyNames.put("USD", "dol");
        azCurrencyNames.put("EUR", "evr");
        azCurrencyNames.put("RUB", "rub");
        azCurrencyNames.put("AZN", "man");
        azCurrencyNames.put("KZT", "KZT");
        localizedCurrencyNames.put(azLocale, azCurrencyNames);
        HashMap<String, String> azEndorsementVatEntries = new HashMap<String, String>();
        azEndorsementVatEntries.put("\u04281", "NDSA/C%s NDSZZ%s");
        localizedEndorsementVatEntries.put(azLocale, azEndorsementVatEntries);
        localizedTerminalEntries.put(azLocale, "Terminal");
        Locale kaLocale = LocaleHelper.getLocale((String)"KA");
        HashMap<PaymentType, String> kaPaymentTypeNames = new HashMap<PaymentType, String>();
        kaPaymentTypeNames.put(PaymentType.CASH, "\u10dc\u10d0\u10e6\u10d3\u10d8");
        kaPaymentTypeNames.put(PaymentType.INVOICE, "\u10e1\u10d0\u10d2\u10d0\u10d3\u10d0\u10ee\u10d3\u10dd \u10d3\u10d0\u10d5\u10d0\u10da\u10d4\u10d1\u10d0");
        kaPaymentTypeNames.put(PaymentType.CREDIT_CARD, "\u10de\u10da\u10d0\u10e1\u10e2\u10d8\u10d9\u10e3\u10e0\u10d8 \u10d1\u10d0\u10e0\u10d0\u10d7\u10d8");
        kaPaymentTypeNames.put(PaymentType.CREDIT_CARD_AGENCY, "\u10de\u10da\u10d0\u10e1\u10e2\u10d8\u10d9\u10e3\u10e0\u10d8 \u10d1\u10d0\u10e0\u10d0\u10d7\u10d8");
        kaPaymentTypeNames.put(PaymentType.CREDIT_CARD_TCH, "\u10de\u10da\u10d0\u10e1\u10e2\u10d8\u10d9\u10e3\u10e0\u10d8 \u10d1\u10d0\u10e0\u10d0\u10d7\u10d8");
        kaPaymentTypeNames.put(PaymentType.CREDIT, "\u10de\u10da\u10d0\u10e1\u10e2\u10d8\u10d9\u10e3\u10e0\u10d8 \u10d1\u10d0\u10e0\u10d0\u10d7\u10d8");
        kaPaymentTypeNames.put(PaymentType.MTD, "mtd");
        kaPaymentTypeNames.put(PaymentType.TICKET, "\u10d1\u10d8\u10da\u10d4\u10d7\u10d8");
        localizedPaymentTypeNames.put(kaLocale, kaPaymentTypeNames);
        HashMap<String, String> kaCurrencyNames = new HashMap<String, String>();
        kaCurrencyNames.put("USD", "\u10d3\u10dd\u10da");
        kaCurrencyNames.put("EUR", "\u10d4\u10d5\u10e0");
        kaCurrencyNames.put("RUB", "\u10e0\u10e3\u10d1");
        kaCurrencyNames.put("GEL", "\u10da\u10d0\u10e0\u10d8");
        kaCurrencyNames.put("KZT", "KZT");
        localizedCurrencyNames.put(kaLocale, kaCurrencyNames);
        HashMap<String, String> kaEndorsementVatEntries = new HashMap<String, String>();
        kaEndorsementVatEntries.put("\u04281", "NDSA/C%s NDSZZ%s");
        localizedEndorsementVatEntries.put(kaLocale, kaEndorsementVatEntries);
        localizedTerminalEntries.put(kaLocale, "Terminal");
        fopTypes.addAll(GeneralProductHelper.productFopTypes);
        fopTypes.addAll(GeneralProductHelper.feeFopTypes);
        Collection handlers = HandlersRegistry.get().getAllItineraryReceiptHandlers();
        for (ItineraryReceiptHandler handler : handlers) {
            handler.fillPaymentTypeMaps(ruPaymentTypeNames, enPaymentTypeNames, azPaymentTypeNames, kaPaymentTypeNames);
        }
    }

    public static class ItineraryData {
        private String departureData;
        private String arrivalData;
        private String segmentData;
        private String segmentDataTitle;

        public String getDepartureData() {
            return this.departureData;
        }

        public void setDepartureData(String departureData) {
            this.departureData = departureData;
        }

        public String getArrivalData() {
            return this.arrivalData;
        }

        public void setArrivalData(String arrivalData) {
            this.arrivalData = arrivalData;
        }

        public String getSegmentDataTitle() {
            return this.segmentDataTitle;
        }

        public void setSegmentDataTitle(String segmentDataTitle) {
            this.segmentDataTitle = segmentDataTitle;
        }

        public String getSegmentData() {
            return this.segmentData;
        }

        public void setSegmentData(String segmentData) {
            this.segmentData = segmentData;
        }
    }
}

