/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.ukrain;

import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;

public class NBURateTask
extends BaseScheduledTask {
    private static final String DTF = "yyyy-MM-dd";
    private static final String DTF2 = "dd.MM.yyyy";
    private String urlBGU;
    private String urlBU;
    private final Set<String> currencyCodes = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doJob() {
        try {
            String url = TextUtil.nonBlank((String)this.urlBGU) ? this.urlBGU : this.urlBU;
            long start = System.currentTimeMillis();
            URL serviceUrl = new URL(url);
            URLConnection urlConnection = serviceUrl.openConnection();
            ((HttpURLConnection)urlConnection).setRequestMethod("GET");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setRequestProperty("Content-Type", "text/html; charset=windows-1251");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (DataInputStream in = new DataInputStream(urlConnection.getInputStream());){
                IoUtil.copyStream((InputStream)in, (OutputStream)out, (int)256);
            }
            byte[] byteArray = out.toByteArray();
            this.log.trace(String.format("NBU request: GET %s;\r\n response: {%s}\r\n;timing = %s msec", url, new String(byteArray, "cp1251"), Long.toString(System.currentTimeMillis() - start)));
            Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(byteArray)).getDocumentElement();
            if (TextUtil.nonBlank((String)this.urlBGU)) {
                this.log.debug("NBULength = " + XmlUtil.getElements((Element)root, (String)"currency").length);
                this.addCurrencyRateOfUrlBgu(root, new SimpleDateFormat(DTF2));
            } else {
                this.log.debug("NBULength = " + XmlUtil.getElements((Element)root, (String)"item").length);
                this.addCurrencyRateOfUrlBu(root, new SimpleDateFormat(DTF));
            }
        }
        catch (Exception e) {
            this.log.error("failed updating currency rates", (Throwable)e);
        }
    }

    private void addCurrencyRateOfUrlBgu(Element root, SimpleDateFormat simpleDateFormat) throws Exception {
        for (Element elm : XmlUtil.getElements((Element)root, (String)"currency")) {
            Date date = MiscUtil.clearTime((Date)simpleDateFormat.parse(XHelper.readString((Element)elm, (String)"exchangedate")));
            this.log.debug("NBUDate = " + date);
            String currencyCode = XHelper.readString((Element)elm, (String)"cc");
            this.log.debug("NBUCode = " + currencyCode);
            if (!this.currencyCodes.isEmpty() && !this.currencyCodes.contains(currencyCode)) {
                this.log.debug("skipping update of rate for " + currencyCode);
                continue;
            }
            BigDecimal rate = BigDecimal.valueOf(Double.parseDouble(XHelper.readString((Element)elm, (String)"rate").replace(",", ".")));
            this.log.debug("NBURate = " + rate);
            CurrencyRate currencyRate = BookingHelper.findCurrencyRate((String)"UAH", (String)currencyCode, (Date)date, (CurrencyRateType)CurrencyRateType.NBU, (TariffType)TariffType.REGULAR, null, null);
            this.log.debug("NBURate2 = " + currencyRate);
            if (currencyRate != null && currencyRate.getType() == CurrencyRateType.NBU && currencyRate.getDate() != null && rate.compareTo(BigDecimal.valueOf(currencyRate.getRate())) == 0) {
                this.log.debug(String.format("currency rate not changed for %s, value=%s", currencyCode, rate));
                continue;
            }
            if (currencyRate != null && currencyRate.getType() == CurrencyRateType.NBU && currencyRate.getDate() != null && MiscUtil.compare((Date)date, (Date)MiscUtil.clearTime((Date)currencyRate.getDate())) == 0) {
                LogicalStorage.get().getStandardDictionaryStorage().delete((BaseDictionary)currencyRate);
                this.log.debug(String.format("deleted currency rate for %s for date %s with code %s", currencyCode, currencyRate.getDate(), currencyRate.getCode()));
            }
            this.saveCurrency(date, currencyCode, rate);
        }
    }

    private void addCurrencyRateOfUrlBu(Element root, SimpleDateFormat simpleDateFormat) throws Exception {
        for (Element elm : XmlUtil.getElements((Element)root, (String)"item")) {
            Date date = MiscUtil.clearTime((Date)simpleDateFormat.parse(XHelper.readString((Element)elm, (String)"date")));
            this.log.debug("NBUDate = " + date);
            String currencyCode = XHelper.readString((Element)elm, (String)"char3");
            this.log.debug("NBUCode = " + currencyCode);
            if (!this.currencyCodes.isEmpty() && !this.currencyCodes.contains(currencyCode)) {
                this.log.debug("skipping update of rate for " + currencyCode);
                continue;
            }
            BigDecimal rate = BigDecimal.valueOf(Double.parseDouble(XHelper.readString((Element)elm, (String)"rate").replace(",", "."))).divide(BigDecimal.valueOf(Integer.parseInt(XHelper.readString((Element)elm, (String)"size"))), 20, RoundingMode.HALF_UP);
            this.log.debug("NBURate = " + rate);
            CurrencyRate currencyRate = BookingHelper.findCurrencyRate((String)"UAH", (String)currencyCode, (Date)date, (CurrencyRateType)CurrencyRateType.NBU, (TariffType)TariffType.REGULAR, null, null);
            this.log.debug("NBURate2 = " + currencyRate);
            if (currencyRate != null && currencyRate.getType() == CurrencyRateType.NBU && currencyRate.getDate() != null && rate.compareTo(BigDecimal.valueOf(currencyRate.getRate())) == 0) {
                this.log.debug(String.format("currency rate not changed for %s, value=%s", currencyCode, rate));
                continue;
            }
            if (currencyRate != null && currencyRate.getType() == CurrencyRateType.NBU && currencyRate.getDate() != null && MiscUtil.compare((Date)date, (Date)MiscUtil.clearTime((Date)currencyRate.getDate())) == 0) {
                LogicalStorage.get().getStandardDictionaryStorage().delete((BaseDictionary)currencyRate);
                this.log.debug(String.format("deleted currency rate for %s for date %s with code %s", currencyCode, currencyRate.getDate(), currencyRate.getCode()));
            }
            this.saveCurrency(date, currencyCode, rate);
        }
    }

    private void saveCurrency(Date date, String currencyCode, BigDecimal rate) {
        CurrencyRate currencyRate = new CurrencyRate();
        currencyRate.setCurrency(currencyCode);
        currencyRate.setRate(rate.doubleValue());
        currencyRate.setTariffType(TariffType.REGULAR);
        currencyRate.setType(CurrencyRateType.NBU);
        currencyRate.setBaseCurrency("UAH");
        currencyRate.setDate(date);
        LogicalStorage.get().getStandardDictionaryStorage().save((BaseDictionary)currencyRate);
        this.log.debug(String.format("added currency rate for %s for date %s with code %s", currencyCode, currencyRate.getDate(), currencyRate.getCode()));
    }

    public void configure(Properties config) throws Exception {
        if (config.getProperty("url").contains("bank.gov.ua")) {
            this.urlBGU = config.getProperty("url");
        } else if (config.getProperty("url").contains("bank-ua.com")) {
            this.urlBU = config.getProperty("url");
        }
        if (TextUtil.isBlank((String)this.urlBU) && TextUtil.isBlank((String)this.urlBGU)) {
            this.log.info("NBU service url is not defined");
            return;
        }
        String currencies = config.getProperty("currencies");
        if (!TextUtil.isBlank((String)currencies)) {
            for (String item : currencies.split(",")) {
                if (TextUtil.isBlank((String)item)) continue;
                this.currencyCodes.add(item.trim().toUpperCase());
            }
        }
    }
}

