/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.utils;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.RichTextString;
import org.junit.Test;

public class GeoRegionsImporter
extends ModelTestBase {
    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("GeoRegion.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mergeData() throws Exception {
        HSSFWorkbook countryWb;
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("countries_merge.xls");){
            countryWb = new HSSFWorkbook(new POIFSFileSystem(is));
        }
        HashMap regions = new HashMap();
        for (GeoRegion region : DictionaryCache.get().getAll(GeoRegion.class).values()) {
            regions.put(region.getTranslations().get(Locale.ENGLISH), region.getCode());
        }
        HashMap<String, String> iata2crt = new HashMap<String, String>();
        HashMap<String, Boolean> iata2cis = new HashMap<String, Boolean>();
        HashMap<String, Boolean> iata2dom = new HashMap<String, Boolean>();
        HSSFSheet s1 = countryWb.getSheetAt(0);
        for (int n = 1; n <= s1.getLastRowNum(); ++n) {
            String crt;
            HSSFRow row = s1.getRow(n);
            if (row == null) continue;
            String iata = row.getCell(7).getRichStringCellValue().getString();
            iata2cis.put(iata, row.getCell(5).getBooleanCellValue());
            iata2dom.put(iata, row.getCell(4).getBooleanCellValue());
            HSSFCell cell = row.getCell(8);
            if (cell == null || cell.getCellType() == 3 || TextUtil.isBlank((String)(crt = cell.getRichStringCellValue().getString()))) continue;
            iata2crt.put(iata.trim(), crt);
        }
        HashMap<String, String> c2en = new HashMap<String, String>();
        HashMap<String, String> c2ru = new HashMap<String, String>();
        HashMap<String, String> c2r = new HashMap<String, String>();
        HSSFSheet s2 = countryWb.getSheetAt(1);
        for (int n = 1; n <= s2.getLastRowNum(); ++n) {
            HSSFRow row = s2.getRow(n);
            if (row == null) continue;
            String iata = row.getCell(9).getRichStringCellValue().getString();
            c2en.put(iata, row.getCell(7).getRichStringCellValue().getString());
            c2ru.put(iata, row.getCell(8).getRichStringCellValue().getString());
            String rc = (String)regions.get(row.getCell(10).getRichStringCellValue().getString());
            if (rc == null) {
                throw new Exception("unknown region " + row.getCell(10).getRichStringCellValue().getString());
            }
            c2r.put(row.getCell(9).getRichStringCellValue().getString(), rc);
        }
        ArrayList lst = new ArrayList(c2en.keySet());
        Collections.sort(lst);
        HSSFSheet s3 = countryWb.getSheetAt(2);
        for (int n = 0; n < lst.size(); ++n) {
            String region;
            HSSFRow row = s3.getRow(n + 1);
            if (row == null) {
                row = s3.createRow(n + 1);
            }
            String iata = (String)lst.get(n);
            this.getCell(row, 0).setCellValue((RichTextString)new HSSFRichTextString(UUIDGenerator.generate((boolean)false).toString().toUpperCase()));
            String en = (String)c2en.get(iata);
            if (TextUtil.isBlank((String)en)) {
                throw new Exception("english name is undefined for " + iata);
            }
            this.getCell(row, 1).setCellValue((RichTextString)new HSSFRichTextString(en));
            String ru = (String)c2ru.get(iata);
            if (TextUtil.isBlank((String)ru)) {
                throw new Exception("russian name is undefined for " + iata);
            }
            this.getCell(row, 2).setCellValue((RichTextString)new HSSFRichTextString(ru));
            this.getCell(row, 3).setCellValue((RichTextString)new HSSFRichTextString(iata));
            Boolean dom = (Boolean)iata2dom.get(iata);
            if (dom == null) {
                dom = Boolean.FALSE;
                this.log.warn("domestic flag is undefined for " + iata);
            }
            this.getCell(row, 4).setCellValue(dom.booleanValue());
            Boolean cis = (Boolean)iata2cis.get(iata);
            if (cis == null) {
                cis = Boolean.FALSE;
                this.log.warn("cis flag is undefined for " + iata);
            }
            if ((region = (String)c2r.get(iata)) == null) {
                throw new Exception("region is undefined for " + iata);
            }
            this.getCell(row, 5).setCellValue((RichTextString)new HSSFRichTextString((cis != false ? "<item>CIS</item>" : "") + "<item>" + region + "</item>"));
            this.getCell(row, 6).setCellType(3);
            this.getCell(row, 7).setCellValue((RichTextString)new HSSFRichTextString(iata));
            String crt = (String)iata2crt.get(iata);
            if (TextUtil.isBlank((String)crt)) {
                this.getCell(row, 8).setCellType(3);
                continue;
            }
            this.getCell(row, 8).setCellValue((RichTextString)new HSSFRichTextString(crt));
        }
        File tempFolder = Environment.getTempFolder();
        if (!tempFolder.exists() && !tempFolder.mkdirs()) {
            throw new Exception("unable to create temp folder");
        }
        try (FileOutputStream fileOut = new FileOutputStream(new File(tempFolder, "countries.xls"));){
            countryWb.write((OutputStream)fileOut);
        }
    }

    private HSSFCell getCell(HSSFRow row, int i) {
        HSSFCell cell = row.getCell(i);
        if (cell == null) {
            cell = row.createCell(i);
        }
        return cell;
    }
}

