/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.utils.aksima;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfileHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AksimaExcelImportTestUtil {
    private static final String EXCEL_SHEET_NAME_ORG = "organizations";
    private static final int MAX_ENTRIES_PER_DOCUMENT = 600;
    private static final int EXCEL_ROW_NUM_VALUE_START_ORG = 1;
    private static final int EXCEL_ROW_NUM_VALUE_FINISH_ORG = 1162;
    private static final int EXCEL_ROW_NUM_DEFINITION_PER = 0;
    private static int orgCount = 0;
    private static final String EXCEL_COL_NUM_VALUE_START_ORG = "A";
    private static final String EXCEL_COL_NUM_VALUE_FINISH_ORG = "K";
    private static final String CELL_DK = "\u041a\u041e\u0414";
    private static final String CELL_SHORT_NAME = "\u041a\u0420\u0410\u0422\u041a\u041e\u0415 \u041d\u0410\u0417\u0412\u0410\u041d\u0418\u0415 \u041a\u041e\u041c\u041f\u0410\u041d\u0418\u0418";
    private static final String CELL_FULL_NAME = "\u041f\u041e\u041b\u041d\u041e\u0415 \u041d\u0410\u0417\u0412\u0410\u041d\u0418\u0415 \u041a\u041e\u041c\u041f\u0410\u041d\u0418\u0418";
    private static final String CELL_INN = "\u0418\u041d\u041d";
    private static final String CELL_KPP = "\u041a\u041f\u041f";
    private static final String CELL_ADDRESS = "\u0410\u0414\u0420\u0415\u0421 \u041a\u041e\u041c\u041f\u0410\u041d\u0418\u0418 - \u0410\u0414\u0420\u0415\u0421";
    private static final String CELL_ACCOUNT = "\u0421\u0427\u0415\u0422 - \u0420\u0410\u0421\u0427\u0415\u0422\u041d\u042b\u0419 \u0421\u0427\u0415\u0422";
    private static final String CELL_BANK = "\u0421\u0427\u0415\u0422 - \u0411\u0410\u041d\u041a";
    private static final String CELL_CITY = "\u0421\u0427\u0415\u0422 - \u0413\u041e\u0420\u041e\u0414";
    private static final String CELL_CORR_ACCOUNT = "\u0421\u0427\u0415\u0422 - \u041a\u041e\u0420\u0420\u0415\u0421\u041f\u041e\u041d\u0414\u0415\u041d\u0422\u0421\u041a\u0418\u0419 \u0421\u0427\u0415\u0422";
    private static final String CELL_BIK = "\u0421\u0427\u0415\u0422 - \u0411\u0418\u041a";
    private static final Map<String, EntityContainer<Organization>> organizationContainers = new HashMap<String, EntityContainer<Organization>>();

    public static List<Document> convert(HSSFWorkbook excelInputOrgs, List<BaseEntity> containers, List<Message> messages) {
        ArrayList<Document> res = new ArrayList();
        List<EntityContainer<Organization>> orgContainers = AksimaExcelImportTestUtil.createContainers(excelInputOrgs, messages);
        try {
            res = AksimaExcelImportTestUtil.fillResultDocumentList(orgContainers);
        }
        catch (Exception e) {
            System.out.println("Exception while converting containers to XML");
            e.printStackTrace();
        }
        return res;
    }

    private static List<EntityContainer<Organization>> createContainers(HSSFWorkbook excelInputOrgs, List<Message> messages) {
        ArrayList<EntityContainer<Organization>> res = new ArrayList<EntityContainer<Organization>>();
        HSSFSheet sheet = ExcelUtils.findSheet((HSSFWorkbook)excelInputOrgs, (String)EXCEL_SHEET_NAME_ORG);
        List dataRows = ExcelUtils.prepareDataRows((int)1, (int)1162);
        HSSFRow titleRow = sheet.getRow(0);
        List dataCols = ExcelUtils.prepareDataColumns((String)EXCEL_COL_NUM_VALUE_START_ORG, (String)EXCEL_COL_NUM_VALUE_FINISH_ORG);
        LinkedHashMap<String, String> definitions = new LinkedHashMap<String, String>();
        for (String col : dataCols) {
            HSSFCell cellTitle = titleRow.getCell(ExcelUtils.stringToIndex((String)col));
            if (cellTitle == null) continue;
            String def = AksimaExcelImportTestUtil.readCell(cellTitle);
            definitions.put(col, def.toUpperCase());
        }
        for (Integer rowNum : dataRows) {
            EntityContainer<Organization> orgCont;
            HSSFRow row = sheet.getRow(rowNum.intValue());
            if (row == null) continue;
            LinkedHashMap<String, List<String>> values = new LinkedHashMap<String, List<String>>();
            for (String col : dataCols) {
                HSSFCell cellValue = row.getCell(ExcelUtils.stringToIndex((String)col));
                if (cellValue == null) continue;
                String value = AksimaExcelImportTestUtil.readCell(cellValue);
                if (!definitions.containsKey(col) || TextUtil.isBlank((String)value)) continue;
                String key = (String)definitions.get(col);
                List<Object> temp = values.containsKey(key) ? values.get(key) : new ArrayList();
                temp.add(value);
                values.put(key, temp);
            }
            if (values.size() <= 0 || (orgCont = AksimaExcelImportTestUtil.parseExcelDataOrg(values, messages)) == null) continue;
            res.add(orgCont);
        }
        return res;
    }

    private static List<Document> fillResultDocumentList(List<EntityContainer<Organization>> list) throws Exception {
        ArrayList<Document> res = new ArrayList<Document>();
        int count = 0;
        Node element = null;
        Document convertDocument = null;
        for (BaseEntity baseEntity : list) {
            if (count % 600 == 0) {
                count = 0;
                convertDocument = DocumentBuilderHelper.newDocument();
                res.add(convertDocument);
                element = convertDocument.createElementNS(null, "objects");
                convertDocument.appendChild(element);
            }
            Element entityElement = null;
            if (baseEntity instanceof EntityContainer) {
                entityElement = AksimaExcelImportTestUtil.createEntityContainerElement(convertDocument, baseEntity);
            }
            if (element != null && entityElement != null) {
                element.appendChild(entityElement);
                element.setAttribute("totalCount", String.valueOf(count + 1));
            }
            ++count;
        }
        return res;
    }

    private static EntityContainer<Organization> parseExcelDataOrg(LinkedHashMap<String, List<String>> values, List<Message> messages) {
        EntityContainer<Organization> res = null;
        if (!values.containsKey(CELL_DK)) {
            return res;
        }
        List<String> dkNumbers = values.get(CELL_DK);
        if (dkNumbers.size() != 1) {
            return res;
        }
        String dkNumber = dkNumbers.get(0);
        if (organizationContainers.containsKey(dkNumber)) {
            messages.add(MessageHelper.createErrorMessage((String)("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 DK = " + dkNumber + " \u0443\u0436\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u0430"), (Object[])null));
            return res;
        }
        if (dkNumber.length() != 6 && dkNumber.length() != 7 && dkNumber.length() != 10) {
            messages.add(MessageHelper.createErrorMessage((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 DK (\u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c 6,7 \u0438\u043b\u0438 10 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432) = " + dkNumber), (Object[])null));
            return res;
        }
        res = AksimaExcelImportTestUtil.createOrganizationContainer(dkNumber);
        Organization org = (Organization)res.getEntity();
        org.getTypes().add(OrganizationType.CORPORATE_CLIENT);
        String orgShortName = dkNumber;
        String orgFullName = dkNumber;
        if (values.get(CELL_SHORT_NAME) != null && values.get(CELL_SHORT_NAME).size() > 0) {
            orgShortName = values.get(CELL_SHORT_NAME).get(0);
        }
        if (values.get(CELL_FULL_NAME) != null && values.get(CELL_FULL_NAME).size() > 0) {
            orgFullName = values.get(CELL_FULL_NAME).get(0);
        }
        L10nStringHelper.setValue((L10nString)org.getShortName(), (String)orgShortName, (Locale)LocaleUtil.LOCALE_RU);
        L10nStringHelper.setValue((L10nString)org.getFullName(), (String)orgFullName, (Locale)LocaleUtil.LOCALE_RU);
        if (values.get(CELL_INN) != null && values.get(CELL_INN).size() > 0) {
            org.setRegistrationId(values.get(CELL_INN).get(0));
        }
        if (values.get(CELL_KPP) != null && values.get(CELL_KPP).size() > 0) {
            org.setKpp(values.get(CELL_KPP).get(0));
        }
        if (values.get(CELL_ADDRESS) != null && values.get(CELL_ADDRESS).size() > 0) {
            Address address = new Address();
            address.setAddressType(AddressType.LEGAL);
            L10nStringHelper.setValue((L10nString)address.getAddress(), (String)values.get(CELL_ADDRESS).get(0), (Locale)LocaleUtil.LOCALE_RU);
            org.getAddresses().add(address);
        }
        if (values.get(CELL_ACCOUNT) != null && values.get(CELL_ACCOUNT).size() > 0) {
            BankAccount ba = new BankAccount();
            ba.setSettlementAccount(values.get(CELL_ACCOUNT).get(0));
            if (values.get(CELL_BANK) != null && values.get(CELL_BANK).size() > 0) {
                ba.setBankName(values.get(CELL_BANK).get(0));
            }
            if (values.get(CELL_BIK) != null && values.get(CELL_BIK).size() > 0) {
                ba.setBik(values.get(CELL_BIK).get(0));
            }
            if (values.get(CELL_CORR_ACCOUNT) != null && values.get(CELL_CORR_ACCOUNT).size() > 0) {
                ba.setCorrespondentAccount(values.get(CELL_CORR_ACCOUNT).get(0));
            }
            org.getBankAccounts().add(ba);
        }
        organizationContainers.put(dkNumber, res);
        ++orgCount;
        return res;
    }

    private static String readCell(HSSFCell cell) {
        String res = "";
        try {
            res = cell.getRichStringCellValue() != null ? cell.getRichStringCellValue().getString().toUpperCase().trim() : "";
        }
        catch (Exception e) {
            try {
                res = String.format("%.0f", cell.getNumericCellValue());
            }
            catch (Exception e2) {
                res = "";
            }
        }
        return res;
    }

    private static Element createEntityContainerElement(Document convertDocument, BaseEntity entityContainer) throws Exception {
        Element entityContainerElement = convertDocument.createElementNS(null, "object");
        entityContainerElement.setAttribute("class", EntityContainer.class.getName());
        entityContainer.toXML(entityContainerElement);
        return entityContainerElement;
    }

    public static String toString(Node node) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Transformer transformer = XUtil.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.transform(new DOMSource(node), new StreamResult(baos));
        return baos.toString("utf-8");
    }

    private static final EntityContainer<Organization> createOrganizationContainer(String dkCode) {
        EntityContainer newOrgCont = null;
        try {
            newOrgCont = SabreProfileHelper.createEntityContainer(Organization.class, (String)UUIDGenerator.generate().toString());
        }
        catch (Exception e) {
            return null;
        }
        Organization org = (Organization)newOrgCont.getEntity();
        org.setCode(dkCode);
        return newOrgCont;
    }
}

