/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.utils.aksima;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.model.test.ModelConvertTestBase;
import com.gridnine.xtrip.server.model.utils.aksima.AksimaExcelImportTestUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AksimaImportTest
extends ModelConvertTestBase {
    private static final String PATH_TO_EXCEL_SOURCE = "C:/astar/development/aksima/organizations080513.xls";
    private static final String PATH_TO_LOG = "C:/astar/development/aksima/import.log";
    private static final String PATH_TO_OUTPUT_ZIP = "C:/astar/development/aksima/import.zip";
    private static final boolean DETAILED_MESSAGE = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAksimaImport() throws Exception {
        Node node;
        System.out.println("testing Aksima import!");
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList<BaseEntity> containers = new ArrayList<BaseEntity>();
        HSSFWorkbook excelInputOrgs = new HSSFWorkbook();
        try {
            excelInputOrgs = new HSSFWorkbook((InputStream)new FileInputStream(PATH_TO_EXCEL_SOURCE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<Document> convertDocuments = AksimaExcelImportTestUtil.convert(excelInputOrgs, containers, messages);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("= MESSAGES ====================================");
        stringBuilder.append("\n");
        for (Message message : messages) {
            if (message.getType() != MessageType.MESSAGE) continue;
            stringBuilder.append(message.getMessage().toString());
            stringBuilder.append("\n");
            stringBuilder.append(message.getDetails());
            stringBuilder.append("\n");
            if (!message.getMessage().getParameters().isEmpty()) {
                node = (Node)message.getMessage().getParameters().get(0);
                stringBuilder.append(AksimaExcelImportTestUtil.toString(node));
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("= WARNINGS ====================================");
        stringBuilder.append("\n");
        for (Message message : messages) {
            if (message.getType() != MessageType.WARNING && message.getType() != MessageType.ERROR) continue;
            stringBuilder.append(message.getMessage().toString());
            stringBuilder.append("\n");
            stringBuilder.append(message.getDetails());
            stringBuilder.append("\n");
            if (!message.getMessage().getParameters().isEmpty()) {
                node = (Node)message.getMessage().getParameters().get(0);
                stringBuilder.append(AksimaExcelImportTestUtil.toString(node));
            }
            stringBuilder.append("\n");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(PATH_TO_LOG))), "utf-8");
        try {
            outputStreamWriter.write(stringBuilder.toString());
        }
        finally {
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        if (convertDocuments.size() > 0) {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(new File(PATH_TO_OUTPUT_ZIP))));){
                zipOutputStream.setComment("Excel to Mid Office Manager convertation");
                int count2 = 0;
                for (Document convertDocument : convertDocuments) {
                    zipOutputStream.putNextEntry(new ZipEntry(String.format("%08d.xml", count2 + 1)));
                    Transformer transformer = XUtil.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    try {
                        transformer.transform(new DOMSource(convertDocument), new StreamResult(zipOutputStream));
                        ++count2;
                    }
                    finally {
                        zipOutputStream.closeEntry();
                    }
                }
            }
        }
    }
}

