/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.utils.albion;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLImportTestUtil {
    private static final Map<String, Set<String>> map = new TreeMap<String, Set<String>>();
    private static final Set<String> set = new TreeSet<String>();
    private static final int MAX_ENTRIES_PER_DOCUMENT = 600;
    private static final String IMPORTER = "importer";
    private static final String AIR_COMMISSION_FIXED_COMMISSION_CATEGORY_CODE = "COMMISSION_CATEGORY_AIR_COMMISSION_FIXED";
    private static final String AIR_COMMISSION_PERCENT_COMMISSION_CATEGORY_CODE = "COMMISSION_CATEGORY_AIR_COMMISSION_PERCENT";
    private static final String AIR_COMMISSION_FIXED_COMMISSION_PROPERTIES_UID = "COMMISSION_PROPERTIES_AIR_COMMISSION_FIXED";
    private static final String AIR_COMMISSION_PERCENT_COMMISSION_PROPERTIES_UID = "COMMISSION_PROPERTIES_AIR_COMMISSION_PERCENT";
    private static final String DISPLAY_EQUALS = "=";
    private static final String DISPLAY_FROM_LIST = "\u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430";
    private static final String DISPLAY_CONTAINS_FROM_LIST = "\u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 (\u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430)";
    private static final Map<String, EntityContainer<? extends BaseEntity>> entityContainers = new HashMap<String, EntityContainer<? extends BaseEntity>>();
    private static final Map<String, BaseDictionary> dictionaryContainers = new HashMap<String, BaseDictionary>();
    private static final DateFormat ALBION_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final RuleRestrictionPriorityComparator ruleRestrictionPriorityComparator = new RuleRestrictionPriorityComparator();
    private static final RuleSettingsPriorityComparator ruleSettingsPriorityComparator = new RuleSettingsPriorityComparator();

    public static List<Document> convert(Document sourceDocument, List<Message> messages) throws Exception {
        Calendar startCalendar = Calendar.getInstance();
        XMLImportTestUtil.createRequiredDictionaries(sourceDocument, messages);
        XMLImportTestUtil.createRequiredEntities(sourceDocument, messages);
        XMLImportTestUtil.convertContracts(sourceDocument, messages);
        Calendar endCalendar = Calendar.getInstance();
        System.out.println(String.format(" -> STARTED -> %s", DATE_FORMAT.format(startCalendar.getTime())));
        System.out.println(String.format(" -> FINISHED -> %s", DATE_FORMAT.format(endCalendar.getTime())));
        long estimatedTime = endCalendar.getTimeInMillis() - startCalendar.getTimeInMillis();
        String hours = String.format("%02d", estimatedTime / 1000L / 3600L);
        String minutes = String.format("%02d", estimatedTime / 1000L / 60L);
        String seconds = String.format("%02d", estimatedTime / 1000L % 60L);
        System.out.println(String.format(" -> ESTIMATED TIME -> %s:%s:%s", hours, minutes, seconds));
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            String key = entry.getKey();
            Set<String> value = entry.getValue();
            System.out.println("Name: " + key);
            for (String string : value) {
                System.out.println("\tDisp: " + string);
            }
        }
        for (String string : set) {
            System.out.println("Disp: " + string);
        }
        ArrayList<Document> convertDocuments = new ArrayList<Document>();
        Document convertDocument = null;
        Node element = null;
        int count = 0;
        for (EntityContainer<? extends BaseEntity> entityContainer : entityContainers.values()) {
            if (count % 600 == 0) {
                count = 0;
                convertDocument = DocumentBuilderHelper.newDocument();
                convertDocuments.add(convertDocument);
                element = convertDocument.createElementNS(null, "objects");
                convertDocument.appendChild(element);
            }
            Element entityElement = XMLImportTestUtil.createEntityContainerElement(convertDocument, entityContainer);
            element.appendChild(entityElement);
            element.setAttribute("totalCount", String.valueOf(count + 1));
            ++count;
        }
        for (BaseDictionary dictionaryContainer : dictionaryContainers.values()) {
            if (count % 600 == 0) {
                count = 0;
                convertDocument = DocumentBuilderHelper.newDocument();
                convertDocuments.add(convertDocument);
                element = convertDocument.createElementNS(null, "objects");
                convertDocument.appendChild(element);
            }
            Element dictionaryElement = XMLImportTestUtil.createDictionatyContainerElement(convertDocument, dictionaryContainer);
            element.appendChild(dictionaryElement);
            element.setAttribute("totalCount", String.valueOf(count + 1));
            ++count;
        }
        return convertDocuments;
    }

    private static final <T extends BaseEntity> EntityContainer<T> createEntityContainer(Class<T> entityClass, String uid) throws Exception {
        EntityContainer entityContainer = new EntityContainer(entityClass, uid);
        entityContainer.setCreatedBy(IMPORTER);
        entityContainer.setModifiedBy(IMPORTER);
        VersionInfo versionInfo = entityContainer.getVersionInfo();
        String versionInfoUid = UUIDGenerator.generate((boolean)false).toString();
        versionInfo.setUid(versionInfoUid);
        versionInfo.setCreatedBy(IMPORTER);
        versionInfo.setModifiedBy(IMPORTER);
        String dataSource = "file";
        versionInfo.setDataSource(dataSource);
        return entityContainer;
    }

    private static final <T extends BaseDictionary> T createDictionaryContainer(Class<T> dictionaryClass, String uid) throws Exception {
        BaseDictionary dictionaryContainer = (BaseDictionary)dictionaryClass.newInstance();
        dictionaryContainer.setUid(uid);
        dictionaryContainer.setCode(uid);
        dictionaryContainer.setCreatedBy(IMPORTER);
        dictionaryContainer.setModifiedBy(IMPORTER);
        return (T)dictionaryContainer;
    }

    private static <T extends BaseEntity> Element createEntityContainerElement(Document convertDocument, EntityContainer<T> entityContainer) throws Exception {
        Element entityContainerElement = convertDocument.createElementNS(null, "object");
        entityContainerElement.setAttribute("class", EntityContainer.class.getName());
        entityContainer.toXML(entityContainerElement);
        return entityContainerElement;
    }

    private static <D extends BaseDictionary> Element createDictionatyContainerElement(Document convertDocument, D dictionaryContainer) throws Exception {
        Element dictionaryContainerElement = convertDocument.createElementNS(null, "object");
        dictionaryContainerElement.setAttribute("class", dictionaryContainer.getClass().getName());
        dictionaryContainer.toXML(dictionaryContainerElement);
        return dictionaryContainerElement;
    }

    private static void createRequiredDictionaries(Document sourceDocument, List<Message> messages) throws Exception {
        CommissionCategory airCommissionFixedCommissionCategoryContainer = XMLImportTestUtil.createDictionaryContainer(CommissionCategory.class, AIR_COMMISSION_FIXED_COMMISSION_CATEGORY_CODE);
        airCommissionFixedCommissionCategoryContainer.getTranslations().put(new Locale("en"), "Air Commission Fixed");
        airCommissionFixedCommissionCategoryContainer.getTranslations().put(new Locale("ru", "RU"), "\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0430\u0432\u0438\u0430 (\u0444\u0438\u043a\u0441)");
        dictionaryContainers.put(AIR_COMMISSION_FIXED_COMMISSION_CATEGORY_CODE, (BaseDictionary)airCommissionFixedCommissionCategoryContainer);
        CommissionCategory airCommissionPercentCommissionCategoryContainer = XMLImportTestUtil.createDictionaryContainer(CommissionCategory.class, AIR_COMMISSION_PERCENT_COMMISSION_CATEGORY_CODE);
        airCommissionPercentCommissionCategoryContainer.getTranslations().put(new Locale("en"), "Air Commission Percent");
        airCommissionPercentCommissionCategoryContainer.getTranslations().put(new Locale("ru", "RU"), "\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0430\u0432\u0438\u0430 (%)");
        dictionaryContainers.put(AIR_COMMISSION_PERCENT_COMMISSION_CATEGORY_CODE, (BaseDictionary)airCommissionPercentCommissionCategoryContainer);
    }

    private static void createRequiredEntities(Document sourceDocument, List<Message> messages) throws Exception {
        EntityContainer<CommissionProperties> airCommissionFixedCommissionPropertiesContainer = XMLImportTestUtil.createEntityContainer(CommissionProperties.class, AIR_COMMISSION_FIXED_COMMISSION_PROPERTIES_UID);
        CommissionProperties airCommissionFixedCommissionProperties = (CommissionProperties)airCommissionFixedCommissionPropertiesContainer.getEntity();
        CommissionCategory airCommissionFixedCommissionCategory = (CommissionCategory)dictionaryContainers.get(AIR_COMMISSION_FIXED_COMMISSION_CATEGORY_CODE);
        airCommissionFixedCommissionProperties.setCategory((DictionaryReference)airCommissionFixedCommissionCategory.toReference());
        airCommissionFixedCommissionProperties.setDisplayName("\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0430\u0432\u0438\u0430 (\u0444\u0438\u043a\u0441)");
        airCommissionFixedCommissionProperties.setBspCommission(true);
        airCommissionFixedCommissionProperties.setRate(false);
        airCommissionFixedCommissionProperties.setRoundingMode(RoundingMode.MATH);
        airCommissionFixedCommissionProperties.setRoundingValue(RoundingValue.V_0_0_1);
        entityContainers.put(AIR_COMMISSION_FIXED_COMMISSION_PROPERTIES_UID, airCommissionFixedCommissionPropertiesContainer);
        EntityContainer<CommissionProperties> airCommissionPercentCommissionPropertiesContainer = XMLImportTestUtil.createEntityContainer(CommissionProperties.class, AIR_COMMISSION_PERCENT_COMMISSION_PROPERTIES_UID);
        CommissionProperties airCommissionPercentCommissionProperties = (CommissionProperties)airCommissionPercentCommissionPropertiesContainer.getEntity();
        CommissionCategory airCommissionPercentCommissionCategory = (CommissionCategory)dictionaryContainers.get(AIR_COMMISSION_PERCENT_COMMISSION_CATEGORY_CODE);
        airCommissionPercentCommissionProperties.setCategory((DictionaryReference)airCommissionPercentCommissionCategory.toReference());
        airCommissionPercentCommissionProperties.setDisplayName("\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0430\u0432\u0438\u0430 (%)");
        airCommissionPercentCommissionProperties.setBspCommission(true);
        airCommissionPercentCommissionProperties.setRate(true);
        airCommissionPercentCommissionProperties.setRoundingMode(RoundingMode.MATH);
        airCommissionPercentCommissionProperties.setRoundingValue(RoundingValue.V_0_0_1);
        entityContainers.put(AIR_COMMISSION_PERCENT_COMMISSION_PROPERTIES_UID, airCommissionPercentCommissionPropertiesContainer);
    }

    public static void convertContracts(Document sourceDocument, List<Message> messages) throws Exception {
        String uid = UUIDGenerator.generate((boolean)false).toString();
        EntityContainer<Contract> contractContainer = XMLImportTestUtil.createEntityContainer(Contract.class, uid);
        Contract contract = (Contract)contractContainer.getEntity();
        contract.setContractType(ContractType.VENDOR);
        NodeList sourceRNodeList = sourceDocument.getElementsByTagName("r");
        for (int i = 0; i < sourceRNodeList.getLength(); ++i) {
            String commissionValueString;
            String periodEndString;
            Element sourceRElement = (Element)sourceRNodeList.item(i);
            Date periodBegin = null;
            Date periodEnd = null;
            String periodBeginString = XHelper.readString((Element)sourceRElement, (String)"@FDate");
            if (!TextUtil.isBlank((String)periodBeginString)) {
                try {
                    periodBegin = ALBION_DATE_FORMAT.parse(periodBeginString.trim());
                }
                catch (ParseException e) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0443\u044e \u0434\u0430\u0442\u0443 \u043f\u0440\u0430\u0432\u0438\u043b\u0430", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"%s\" \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u0430\u0442\u043e\u0439", periodBeginString.trim()), (Object[])new Object[]{sourceRElement}));
                    continue;
                }
            }
            if (!TextUtil.isBlank((String)(periodEndString = XHelper.readString((Element)sourceRElement, (String)"@TDate")))) {
                try {
                    periodEnd = ALBION_DATE_FORMAT.parse(periodEndString.trim());
                }
                catch (ParseException e) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0435\u0447\u043d\u0443\u044e \u0434\u0430\u0442\u0443 \u043f\u0440\u0430\u0432\u0438\u043b\u0430", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"%s\" \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u0430\u0442\u043e\u0439", periodEndString.trim()), (Object[])new Object[]{sourceRElement}));
                    continue;
                }
            }
            if (TextUtil.isBlank((String)(commissionValueString = XHelper.readString((Element)sourceRElement, (String)"@Rate")))) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0435\u043b\u0438\u0447\u0438\u043d\u0443 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"r\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \"Rate\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceRElement}));
                continue;
            }
            BigDecimal commissionValue = null;
            try {
                commissionValue = new BigDecimal(commissionValueString.trim());
            }
            catch (NumberFormatException e) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0432\u0435\u043b\u0438\u0447\u0438\u043d\u0443 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"%s\" \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0447\u0438\u0441\u043b\u043e\u043c", commissionValueString.trim()), (Object[])new Object[]{sourceRElement}));
                continue;
            }
            if (commissionValue.compareTo(BigDecimal.ZERO) == 0) {
                messages.add(MessageHelper.createWarningMessage((String)"\u041f\u0440\u0430\u0432\u0438\u043b\u043e \u043d\u0435 \u0431\u044b\u043b\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e", (String)String.format("\u041f\u0440\u0430\u0432\u0438\u043b\u043e \u0441 \u0432\u0435\u043b\u0438\u0447\u0438\u043d\u043e\u0439 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u0440\u0430\u0432\u043d\u043e\u0439 0 \u043d\u0435 \u0438\u043c\u0435\u044e\u0442 \u0441\u043c\u044b\u0441\u043b\u0430", new Object[0]), (Object[])new Object[]{sourceRElement}));
                continue;
            }
            NodeList sourceTNodeList = sourceRElement.getElementsByTagName("t");
            for (int j = 0; j < sourceTNodeList.getLength(); ++j) {
                Element sourceTElement = (Element)sourceTNodeList.item(j);
                String commissionTypeString = XHelper.readString((Element)sourceTElement, (String)"@RateType");
                if (TextUtil.isBlank((String)commissionTypeString)) {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"t\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \"RateType\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceTElement}));
                    continue;
                }
                EntityContainer<? extends BaseEntity> commissionPropertiesContainer = null;
                if (TextUtil.isSame((String)commissionTypeString, (String)"\u0441\u0442\u0430\u0432\u043a\u0430 \u043d\u0430 \u0411\u0421\u041e")) {
                    commissionPropertiesContainer = entityContainers.get(AIR_COMMISSION_FIXED_COMMISSION_PROPERTIES_UID);
                } else if (TextUtil.isSame((String)commissionTypeString, (String)"% \u043d\u0430 \u0411\u0421\u041e")) {
                    commissionPropertiesContainer = entityContainers.get(AIR_COMMISSION_PERCENT_COMMISSION_PROPERTIES_UID);
                    String commissionCalculationBasisString = XHelper.readString((Element)sourceTElement, (String)"@RateSubType");
                    if (!TextUtil.isSame((String)commissionCalculationBasisString, (String)"TR")) {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0431\u0430\u0437\u0443 \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438", (String)String.format("\u0411\u0430\u0437\u0430 \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", commissionCalculationBasisString.trim()), (Object[])new Object[]{sourceTElement}));
                        continue;
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438", (String)String.format("\u0422\u0438\u043f \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", commissionTypeString.trim()), (Object[])new Object[]{sourceTElement}));
                    continue;
                }
                ArrayList<RuleRestriction> ruleRestrictions = new ArrayList<RuleRestriction>();
                NodeList sourceANodeList = sourceTElement.getElementsByTagName("a");
                for (int k = 0; k < sourceANodeList.getLength(); ++k) {
                    Element sourceAElement = (Element)sourceANodeList.item(k);
                    String nameString = XHelper.readString((Element)sourceAElement, (String)"@Name");
                    if (TextUtil.isBlank((String)nameString)) {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0443\u0441\u043b\u043e\u0432\u0438\u044f", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"a\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \"Name\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceAElement}));
                        continue;
                    }
                    Element sourceTTElement = XmlUtil.getElement((Element)sourceAElement, (String)"tt");
                    if (sourceTTElement == null) {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u0440\u0438\u0442\u0435\u0440\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u044f", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"a\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"tt\"", new Object[0]), (Object[])new Object[]{sourceAElement}));
                        continue;
                    }
                    String displayString = XHelper.readString((Element)sourceTTElement, (String)"@Disp");
                    if (TextUtil.isBlank((String)displayString)) {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u0440\u0438\u0442\u0435\u0440\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u044f", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"tt\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \"Disp\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceTTElement}));
                        continue;
                    }
                    Element sourceCElement = XmlUtil.getElement((Element)sourceTTElement, (String)"c");
                    if (sourceCElement == null) {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u044f", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"tt\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \"c\"", new Object[0]), (Object[])new Object[]{sourceTTElement}));
                        continue;
                    }
                    String conditionsString = XHelper.readString((Element)sourceCElement, (String)"@Condition");
                    if (TextUtil.isBlank((String)displayString)) {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u044f", (String)String.format("\u041e\u0431\u044a\u0435\u043a\u0442 \"c\" \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \"Condition\" \u043b\u0438\u0431\u043e \u043e\u043d \u043f\u0443\u0441\u0442\u043e\u0439", new Object[0]), (Object[])new Object[]{sourceCElement}));
                        continue;
                    }
                    List<RuleRestriction> restrictions = XMLImportTestUtil.createRuleRestriction(sourceAElement, nameString.trim(), displayString.trim(), conditionsString.trim(), messages);
                    ruleRestrictions.addAll(restrictions);
                    Collections.sort(ruleRestrictions, ruleRestrictionPriorityComparator);
                }
                RuleResultValue ruleResultValue = new RuleResultValue();
                ruleResultValue.setValue(commissionValue.doubleValue());
                ruleResultValue.setTarget(commissionPropertiesContainer.toReference());
                RuleResult ruleResult = new RuleResult();
                ruleResult.setAction((RuleAction)Actions.SIMPLE_COMMISSION);
                ruleResult.setValue((Object)ruleResultValue);
                RuleSettings ruleSettings = new RuleSettings();
                ruleSettings.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
                ruleSettings.setPeriodBegin(periodBegin);
                ruleSettings.setPeriodEnd(periodEnd);
                ruleSettings.getRestrictions().addAll(ruleRestrictions);
                ruleSettings.getResults().add(ruleResult);
                if (contract.getRuleSet() == null) {
                    RuleSet ruleSet = new RuleSet();
                    contract.setRuleSet(ruleSet);
                }
                contract.getRuleSet().getRules().add(ruleSettings);
            }
        }
        entityContainers.put(uid, contractContainer);
    }

    private static List<RuleRestriction> createRuleRestriction(Element sourceElement, String nameString, String displayString, String conditionsString, List<Message> messages) throws Exception {
        Set<String> displayStrings = map.get(nameString);
        if (displayStrings == null) {
            displayStrings = new TreeSet<String>();
            map.put(nameString, displayStrings);
        }
        displayStrings.add(displayString);
        set.add(displayString);
        ArrayList<RuleRestriction> ruleRestrictions = new ArrayList<RuleRestriction>();
        if (!TextUtil.isSame((String)nameString, (String)"\u0412\u0438\u0434 \u0432\u044b\u0440\u0443\u0447\u043a\u0438") && !TextUtil.isSame((String)nameString, (String)"\u0412\u0438\u0434 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f")) {
            if (TextUtil.isSame((String)nameString, (String)"\u041a\u043b\u0430\u0441\u0441 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")) {
                if (TextUtil.isSame((String)displayString, (String)DISPLAY_FROM_LIST)) {
                    RuleRestriction ruleRestriction = new RuleRestriction();
                    ruleRestriction.setProperty((RuleProperty)Properties.BOOKING_CLASSES);
                    ruleRestriction.setCondition((RuleCondition)Conditions.CONFINED_TO);
                    ruleRestriction.setValue(XMLImportTestUtil.split(conditionsString.trim()));
                    ruleRestrictions.add(ruleRestriction);
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u0440\u0438\u0442\u0435\u0440\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u044f", (String)String.format("\u041a\u0440\u0438\u0442\u0435\u0440\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u044f \"%s\" \u0434\u043b\u044f \u0442\u0438\u043f\u0430 \u0443\u0441\u043b\u043e\u0432\u0438\u044f \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", displayString.trim(), nameString.trim()), (Object[])new Object[]{sourceElement}));
                }
            } else if (TextUtil.isSame((String)nameString, (String)"\u041a\u043e\u0434 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430")) {
                if (TextUtil.isSame((String)displayString, (String)DISPLAY_EQUALS)) {
                    RuleRestriction ruleRestriction = new RuleRestriction();
                    ruleRestriction.setProperty((RuleProperty)Properties.AIRLINES);
                    ruleRestriction.setCondition((RuleCondition)Conditions.CONFINED_TO);
                    ruleRestriction.setValue(Arrays.asList(conditionsString.trim()));
                    ruleRestrictions.add(ruleRestriction);
                } else if (TextUtil.isSame((String)displayString, (String)DISPLAY_CONTAINS_FROM_LIST)) {
                    RuleRestriction ruleRestriction = new RuleRestriction();
                    ruleRestriction.setProperty((RuleProperty)Properties.AIRLINES);
                    ruleRestriction.setCondition((RuleCondition)Conditions.INCLUDE);
                    ruleRestriction.setValue(XMLImportTestUtil.split(conditionsString.trim()));
                    ruleRestrictions.add(ruleRestriction);
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u0440\u0438\u0442\u0435\u0440\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u044f", (String)String.format("\u041a\u0440\u0438\u0442\u0435\u0440\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u044f \"%s\" \u0434\u043b\u044f \u0442\u0438\u043f\u0430 \u0443\u0441\u043b\u043e\u0432\u0438\u044f \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", displayString.trim(), nameString.trim()), (Object[])new Object[]{sourceElement}));
                }
            } else if (TextUtil.isSame((String)nameString, (String)"\u041d\u0443\u043b\u0435\u0432\u043e\u0439\u0422\u0430\u0440\u0438\u0444")) {
                if (TextUtil.isSame((String)displayString, (String)DISPLAY_EQUALS)) {
                    if (TextUtil.isSame((String)conditionsString, (String)"Y")) {
                        RuleRestriction ruleRestriction = new RuleRestriction();
                        ruleRestriction.setProperty((RuleProperty)Properties.FARE);
                        ruleRestriction.setCondition((RuleCondition)Conditions.EQUALS);
                        ruleRestriction.setValue((Object)0.0);
                        ruleRestrictions.add(ruleRestriction);
                    } else {
                        messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f", (String)String.format("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u044f \"%s\" \u0434\u043b\u044f \u0442\u0438\u043f\u0430 \u0443\u0441\u043b\u043e\u0432\u0438\u044f \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", conditionsString.trim(), nameString.trim()), (Object[])new Object[]{sourceElement}));
                    }
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u0440\u0438\u0442\u0435\u0440\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u044f", (String)String.format("\u041a\u0440\u0438\u0442\u0435\u0440\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u044f \"%s\" \u0434\u043b\u044f \u0442\u0438\u043f\u0430 \u0443\u0441\u043b\u043e\u0432\u0438\u044f \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", displayString.trim(), nameString.trim()), (Object[])new Object[]{sourceElement}));
                }
            } else if (!TextUtil.isSame((String)nameString, (String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f") && !TextUtil.isSame((String)nameString, (String)"\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a")) {
                if (TextUtil.isSame((String)nameString, (String)"\u0420\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u0439 \u043a\u043e\u0434 \u0422\u041a\u041f,BSP")) {
                    ArrayList<String> codes = new ArrayList<String>();
                    for (String number : XMLImportTestUtil.split(conditionsString.trim())) {
                        boolean found = false;
                        Airline airline = DictHelper.findAirlineByNumber((String)number);
                        if (airline != null) {
                            String code = DictHelper.getCodeVariant((BaseDictionary)airline, Arrays.asList(CodeSystem.IATA, CodeSystem.CRT));
                            if (!TextUtil.isBlank((String)code)) {
                                codes.add(code);
                                found = true;
                            } else {
                                messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043a\u043e\u0434 \u0430\u0432\u0438\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438. \u0412\u043c\u0435\u0441\u0442\u043e \u043a\u043e\u0434\u0430 \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438", (String)String.format("\u0410\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c \"%s\" \u043d\u0435 \u0431\u044b\u043b\u0430 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435", number), (Object[])new Object[]{sourceElement}));
                            }
                        }
                        if (found) continue;
                        codes.add(number);
                    }
                    RuleRestriction ruleRestriction = new RuleRestriction();
                    ruleRestriction.setProperty((RuleProperty)Properties.CARRIERS);
                    ruleRestriction.setCondition((RuleCondition)Conditions.INCLUDE);
                    ruleRestriction.setValue(codes);
                    ruleRestrictions.add(ruleRestriction);
                } else {
                    messages.add(MessageHelper.createWarningMessage((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0443\u0441\u043b\u043e\u0432\u0438\u044f", (String)String.format("\u0422\u0438\u043f \u0443\u0441\u043b\u043e\u0432\u0438\u044f \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", nameString), (Object[])new Object[]{sourceElement}));
                }
            }
        }
        return ruleRestrictions;
    }

    private static List<String> split(String string) {
        String[] entries;
        ArrayList<String> list = new ArrayList<String>();
        for (String entry : entries = string.split(";")) {
            if (TextUtil.isBlank((String)entry)) continue;
            list.add(entry.trim());
        }
        return list;
    }

    public static Document getSourceDocument(File file) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return document;
    }

    public static String toString(Node node) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Transformer transformer = XUtil.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.transform(new DOMSource(node), new StreamResult(baos));
        return baos.toString("utf-8");
    }

    public static String toStructure(Node node) throws Exception {
        return XMLImportTestUtil.toStructure(node, 0);
    }

    public static String toStructure(Node node, int depth) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TextUtil.repeat((String)"    ", (int)depth));
        stringBuilder.append(node.getNodeName());
        stringBuilder.append("\n");
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            stringBuilder.append(XMLImportTestUtil.toStructure(children.item(i), depth + 1));
        }
        return stringBuilder.toString();
    }

    public static void verbose(Document sourceDocument, Document convertDocument) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("= SOURCE STRING ===============================");
        stringBuilder.append("\n");
        stringBuilder.append(XMLImportTestUtil.toString(sourceDocument));
        stringBuilder.append("= CONVERT STRING ==============================");
        stringBuilder.append("\n");
        stringBuilder.append(XMLImportTestUtil.toString(convertDocument));
        stringBuilder.append("= SOURCE STRUCTURE ============================");
        stringBuilder.append("\n");
        stringBuilder.append(XMLImportTestUtil.toStructure(sourceDocument));
        stringBuilder.append("= CONVERT STRUCTURE ===========================");
        stringBuilder.append("\n");
        stringBuilder.append(XMLImportTestUtil.toStructure(convertDocument));
        System.out.println(stringBuilder.toString());
    }

    static class RuleSettingsPriorityComparator
    implements Comparator<RuleSettings> {
        RuleSettingsPriorityComparator() {
        }

        private int getPriority(RuleSettings ruleSettings) {
            int priority = 0;
            for (RuleRestriction ruleRestriction : ruleSettings.getRestrictions()) {
                RuleProperty ruleProperty = ruleRestriction.getProperty();
                if (ruleProperty == Properties.CARRIERS) {
                    priority |= 1;
                    continue;
                }
                if (ruleProperty == Properties.BOOKING_CLASSES) {
                    priority |= 2;
                    continue;
                }
                if (ruleProperty == Properties.AIRLINES) {
                    priority |= 4;
                    continue;
                }
                if (ruleProperty != Properties.FARE) continue;
                priority |= 8;
            }
            return priority;
        }

        @Override
        public int compare(RuleSettings o1, RuleSettings o2) {
            int result = this.getPriority(o2) - this.getPriority(o1);
            return result != 0 ? result / Math.abs(result) : 0;
        }
    }

    static class RuleRestrictionPriorityComparator
    implements Comparator<RuleRestriction> {
        RuleRestrictionPriorityComparator() {
        }

        private int getPriority(RuleRestriction ruleRestriction) {
            RuleProperty ruleProperty = ruleRestriction.getProperty();
            if (ruleProperty == Properties.CARRIERS) {
                return 1;
            }
            if (ruleProperty == Properties.AIRLINES) {
                return 2;
            }
            if (ruleProperty == Properties.BOOKING_CLASSES) {
                return 4;
            }
            if (ruleProperty == Properties.FARE) {
                return 8;
            }
            return 0;
        }

        @Override
        public int compare(RuleRestriction o1, RuleRestriction o2) {
            int result = this.getPriority(o1) - this.getPriority(o2);
            return result != 0 ? result / Math.abs(result) : 0;
        }
    }
}

