/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.utils.corptravel;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.model.test.ModelConvertTestBase;
import com.gridnine.xtrip.server.model.utils.corptravel.CorptravelImportData;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CorptravelImportTest
extends ModelConvertTestBase {
    private static final String PATH_TO_XML_SOURCE_CLIENTS = "C:/astar/Development/current/XTR-4348/clients.xml";
    private static final String PATH_TO_XML_SOURCE_AGENCIES = "C:/astar/Development/current/XTR-4348/agencies.xml";
    private static final String PATH_TO_LOG = "C:/astar/Development/current/XTR-4348/import.log";
    private static final String PATH_TO_OUTPUT_ZIP = "C:/astar/Development/current/XTR-4348/import.zip";
    private static final int MAX_ENTRIES_PER_DOCUMENT = 600;
    private static final String IMPORTER = "importer";
    private static final List<String> foldersForClients = Stream.of("\u041f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u0438", "\u041f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u0438 \u043d\u0435\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442\u044b", "\u041f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u0438-\u0410\u0433\u0435\u043d\u0442\u0441\u043a\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440").collect(Collectors.toList());
    private static final List<String> foldersForAgents = Stream.of("\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0438 \u0430\u0440\u0435\u043d\u0434\u0430", "\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0438 \u0432\u0438\u0437\u044b", "\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0438 \u043f\u0438\u0442\u0430\u043d\u0438\u0435", "\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0438 \u043f\u0440\u043e\u0436\u0438\u0432\u0430\u043d\u0438\u0435", "\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0438 \u0441\u0430\u043d\u0430\u0442\u043e\u0440\u0438\u0438, \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u0430", "\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0438 \u0442\u0440\u0430\u043d\u0441\u043f.\u0443\u0441\u043b\u0443\u0433\u0438", "\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0438 \u0445\u043e\u0437.\u043d\u0443\u0436\u0434\u044b", "\u041f\u0440\u043e\u0447\u0438\u0435 (\u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f)").collect(Collectors.toList());
    private static final List<String> foldersToIgnore = Stream.of("\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0438 \u0430\u0432\u0438\u0430 \u0438 \u0436\u0434 \u0431\u0438\u043b\u0435\u0442\u043e\u0432").collect(Collectors.toList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSusaninImport() throws Exception {
        XStream xstream = new XStream();
        xstream.setMode(1001);
        xstream.processAnnotations(CorptravelImportData.class);
        xstream.ignoreUnknownElements();
        FileInputStream streamClients = new FileInputStream(new File(PATH_TO_XML_SOURCE_CLIENTS));
        FileInputStream streamAgencies = new FileInputStream(new File(PATH_TO_XML_SOURCE_AGENCIES));
        CorptravelImportData clients = (CorptravelImportData)xstream.fromXML((InputStream)streamClients);
        CorptravelImportData agencies = (CorptravelImportData)xstream.fromXML((InputStream)streamAgencies);
        ArrayList<Message> messages = new ArrayList<Message>();
        List<Document> convertDocuments = this.convert(clients, agencies, messages);
        StringBuilder stringBuilder = new StringBuilder();
        messages.sort((m1, m2) -> m1.getMessage().toString().compareTo(m2.getMessage().toString()));
        for (Message message : messages) {
            stringBuilder.append(message.getMessage().toString());
            stringBuilder.append("\n");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(PATH_TO_LOG))), "utf-8");
        try {
            outputStreamWriter.write(stringBuilder.toString());
        }
        finally {
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        if (convertDocuments.size() > 0) {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(new File(PATH_TO_OUTPUT_ZIP))));){
                zipOutputStream.setComment("1C to Mid Office Manager convert");
                int count2 = 0;
                for (Document convertDocument : convertDocuments) {
                    zipOutputStream.putNextEntry(new ZipEntry(String.format("%08d.xml", count2 + 1)));
                    Transformer transformer = XUtil.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    try {
                        transformer.transform(new DOMSource(convertDocument), new StreamResult(zipOutputStream));
                        ++count2;
                    }
                    finally {
                        zipOutputStream.closeEntry();
                    }
                }
            }
        }
    }

    private List<Document> convert(CorptravelImportData clients, CorptravelImportData agencies, List<Message> messages) throws Exception {
        ArrayList<Document> convertDocuments = new ArrayList<Document>();
        List<EntityContainer<Organization>> orgContainers = this.createOrganizationContainers(clients, agencies, messages);
        Document convertDocument = null;
        Node element = null;
        int count = 0;
        for (EntityContainer<Organization> entityContainer : orgContainers) {
            if (count % 600 == 0) {
                count = 0;
                convertDocument = DocumentBuilderHelper.newDocument();
                convertDocuments.add(convertDocument);
                element = convertDocument.createElementNS(null, "objects");
                convertDocument.appendChild(element);
            }
            Element entityElement = CorptravelImportTest.createEntityContainerElement(convertDocument, entityContainer);
            element.appendChild(entityElement);
            element.setAttribute("totalCount", String.valueOf(count + 1));
            ++count;
        }
        return convertDocuments;
    }

    private List<EntityContainer<Organization>> createOrganizationContainers(CorptravelImportData clients, CorptravelImportData agencies, List<Message> messages) throws Exception {
        EntityContainer<Organization> orgCont;
        ArrayList<EntityContainer<Organization>> res = new ArrayList<EntityContainer<Organization>>();
        for (CorptravelImportData.CorptravelImportItem item : clients.getItems()) {
            orgCont = this.createOrganizationContainer(item, messages);
            if (orgCont == null) continue;
            res.add(orgCont);
        }
        for (CorptravelImportData.CorptravelImportItem item : agencies.getItems()) {
            orgCont = this.createOrganizationContainer(item, messages);
            if (orgCont == null) continue;
            res.add(orgCont);
        }
        return res;
    }

    private EntityContainer<Organization> createOrganizationContainer(CorptravelImportData.CorptravelImportItem item, List<Message> messages) throws Exception {
        EntityContainer<Organization> orgCont = CorptravelImportTest.createEntityContainer(Organization.class, UUIDGenerator.generate().toString());
        Organization org = (Organization)orgCont.getEntity();
        if (TextUtil.isBlank((String)item.getInn())) {
            messages.add(MessageHelper.createWarningMessage((String)("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0418\u041d\u041d \u0434\u043b\u044f \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430: " + item.getContragent() + " \u043f\u0430\u043f\u043a\u0430: " + item.getFolder()), (Object[])null));
            return null;
        }
        if (item.getInn().trim().length() != 10) {
            messages.add(MessageHelper.createWarningMessage((String)("\u0414\u043b\u0438\u043d\u0430 \u0418\u041d\u041d \u043d\u0435 \u0440\u0430\u0432\u043d\u0430 10 \u0441\u0438\u043c\u0432\u043e\u043b\u0430\u043c \u0434\u043b\u044f \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430: " + item.getContragent() + " \u043f\u0430\u043f\u043a\u0430: " + item.getFolder() + " \u0418\u041d\u041d: " + item.getInn()), (Object[])null));
        }
        org.setCode(item.getInn().trim());
        org.setRegistrationId(item.getInn().trim());
        org.setKpp(item.getKpp().trim());
        if (TextUtil.isBlank((String)item.getContragent())) {
            messages.add(MessageHelper.createWarningMessage((String)("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430 \u0441 \u0418\u041d\u041d: " + item.getInn() + " \u043f\u0430\u043f\u043a\u0430: " + item.getFolder()), (Object[])null));
        }
        if (item.getContragent() != null) {
            L10nStringHelper.setValue((L10nString)org.getShortName(), (String)item.getContragent().trim(), (Locale)LocaleUtil.LOCALE_RU);
            L10nStringHelper.setValue((L10nString)org.getFullName(), (String)item.getContragent().trim(), (Locale)LocaleUtil.LOCALE_RU);
        }
        if (foldersForAgents.contains(item.getFolder())) {
            org.getTypes().add(OrganizationType.AGENCY);
        }
        if (foldersForClients.contains(item.getFolder())) {
            org.getTypes().add(OrganizationType.CORPORATE_CLIENT);
        }
        if (foldersToIgnore.contains(item.getFolder())) {
            return null;
        }
        if (org.getTypes().isEmpty()) {
            messages.add(MessageHelper.createWarningMessage((String)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0440\u043e\u043b\u044c \u0434\u043b\u044f \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430: " + item.getContragent() + " \u043f\u0430\u043f\u043a\u0430: " + item.getFolder()), (Object[])null));
        }
        if (!TextUtil.isBlank((String)item.getFactualAddress())) {
            Address addrFact = new Address();
            addrFact.setAddressType(AddressType.FACTUAL);
            L10nStringHelper.setValue((L10nString)addrFact.getAddress(), (String)item.getFactualAddress().trim(), (Locale)LocaleUtil.LOCALE_RU);
            org.getAddresses().add(addrFact);
        }
        if (!TextUtil.isBlank((String)item.getLegalAddress())) {
            Address addrLegal = new Address();
            addrLegal.setAddressType(AddressType.LEGAL);
            L10nStringHelper.setValue((L10nString)addrLegal.getAddress(), (String)item.getFactualAddress().trim(), (Locale)LocaleUtil.LOCALE_RU);
            org.getAddresses().add(addrLegal);
        }
        return orgCont;
    }

    private static final <T extends BaseEntity> EntityContainer<T> createEntityContainer(Class<T> entityClass, String uid) throws Exception {
        EntityContainer entityContainer = new EntityContainer(entityClass, uid);
        entityContainer.setCreatedBy(IMPORTER);
        entityContainer.setModifiedBy(IMPORTER);
        VersionInfo versionInfo = entityContainer.getVersionInfo();
        String versionInfoUid = UUIDGenerator.generate((boolean)false).toString();
        versionInfo.setUid(versionInfoUid);
        versionInfo.setCreatedBy(IMPORTER);
        versionInfo.setModifiedBy(IMPORTER);
        String dataSource = "file";
        versionInfo.setDataSource(dataSource);
        return entityContainer;
    }

    private static <T extends BaseEntity> Element createEntityContainerElement(Document convertDocument, EntityContainer<T> entityContainer) throws Exception {
        Element entityContainerElement = convertDocument.createElementNS(null, "object");
        entityContainerElement.setAttribute("class", EntityContainer.class.getName());
        entityContainer.toXML(entityContainerElement);
        return entityContainerElement;
    }
}

