/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.utils.dvfo;

import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoRegionReference;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.model.db.update.DVFODictionaryUpdateHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.junit.Ignore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class DVFOTest
extends TestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    public void testDVFO() throws Exception {
        Set<String> codes = new DVFODictionaryUpdateHandler().getDVFOLocationsCrtCodes();
        File file = new File("config/xtrip/server/setup/dict/GeoLocation.xml");
        Element root = null;
        try (FileInputStream strm = new FileInputStream(file);){
            root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement();
        }
        HashMap<String, GeoLocation> codesMap = new HashMap<String, GeoLocation>();
        HashMap<String, ArrayList<GeoLocation>> crtMap = new HashMap<String, ArrayList<GeoLocation>>();
        ArrayList<GeoLocation> allLocations = new ArrayList<GeoLocation>();
        for (Element elm : XmlUtil.getElements((Element)root, (String)"object")) {
            GeoLocation dict = new GeoLocation();
            dict.fromXML(elm);
            if (TextUtil.isBlank((String)dict.getUid())) {
                throw new Exception("no uid");
            }
            codesMap.put(dict.getCode(), dict);
            String crtCode = (String)dict.getCodeVariants().get(CodeSystem.CRT.name());
            if (crtCode != null) {
                ArrayList<GeoLocation> locs = (ArrayList<GeoLocation>)crtMap.get(crtCode);
                if (locs == null) {
                    locs = new ArrayList<GeoLocation>();
                    crtMap.put(crtCode, locs);
                }
                locs.add(dict);
            }
            allLocations.add(dict);
        }
        GeoRegionReference dvfoRegion = new GeoRegionReference("DVFO", "\u0414\u0430\u043b\u044c\u043d\u0435\u0432\u043e\u0441\u0442\u043e\u0447\u043d\u044b\u0439 \u0444\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u0439 \u043e\u043a\u0440\u0443\u0433");
        for (String code : codes) {
            List locs = (List)crtMap.get(code);
            if (locs == null) continue;
            for (GeoLocation loc : locs) {
                GeoLocation parent;
                if (loc.getRegions().contains(dvfoRegion) || loc.getType() == LocationType.AIRPORT && loc.getParent() != null && (parent = (GeoLocation)codesMap.get(loc.getParent().getCode())) != null && codes.contains(parent.getCodeVariants().get(CodeSystem.CRT.name())) || loc.getRegions().contains(dvfoRegion)) continue;
                loc.getRegions().add(dvfoRegion);
            }
        }
        try (FileOutputStream faos = new FileOutputStream(file);){
            Document result = DocumentBuilderHelper.newDocument();
            result.appendChild(result.createElement("objects"));
            result.getDocumentElement().setAttribute("totalCount", Integer.toString(allLocations.size()));
            for (GeoLocation obj : allLocations) {
                Element elm = result.createElement("object");
                result.getDocumentElement().appendChild(elm);
                elm.setAttribute("class", obj.getClass().getName());
                obj.toXML(elm);
            }
            XUtil.newTransformer().transform(new DOMSource(result), new StreamResult(faos));
        }
    }
}

