/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.utils.susanin;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.model.test.ModelConvertTestBase;
import com.gridnine.xtrip.server.model.utils.susanin.XMLImportTestUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SusaninImportTest
extends ModelConvertTestBase {
    private static final boolean DETAILED_MESSAGE = true;
    private static final String PATH_TO_OLD_PROFILES_ZIP = "C:\\astar\\Development\\Susanin\\import3108.sabre.zip";
    private static final String PATH_TO_XML_SOURCE = "C:/astar/development/susanin/test9.xml";
    private static final String PATH_TO_LOG = "C:/astar/development/susanin/import.log";
    private static final String PATH_TO_SEPARATE_LOG = "C:/astar/development/susanin/import/import%08d.xml";
    private static final String PATH_TO_OUTPUT_ZIP = "C:/astar/development/susanin/import.zip";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSusaninImport() throws Exception {
        Object node;
        System.out.println("testing Susanin import!");
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList<BaseEntity> containers = new ArrayList<BaseEntity>();
        ZipInputStream zipInput = null;
        ZipFile zipFile = null;
        try {
            zipInput = new ZipInputStream(new FileInputStream(new File(PATH_TO_OLD_PROFILES_ZIP)));
            zipFile = new ZipFile(new File(PATH_TO_OLD_PROFILES_ZIP));
            messages.add(MessageHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"Zip file found.", null, (Object[])null));
        }
        catch (FileNotFoundException e) {
            if (zipInput != null) {
                zipInput.close();
            }
            zipInput = null;
            e.printStackTrace();
        }
        catch (Exception e) {
            if (zipFile != null) {
                zipFile.close();
            }
            zipFile = null;
            e.printStackTrace();
        }
        if (zipFile == null || zipInput == null) {
            messages.add(MessageHelper.createErrorMessage((String)"Zip file not found.", (Object[])null));
            if (zipInput != null) {
                zipInput.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
            return;
        }
        try {
            ZipEntry entry;
            while ((entry = zipInput.getNextEntry()) != null) {
                Document doc;
                System.out.println("Reading entry: " + entry.getName());
                try {
                    DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                    doc = docBuilder.parse(zipFile.getInputStream(entry));
                }
                catch (Exception e) {
                    doc = null;
                    e.printStackTrace();
                }
                if (doc == null) continue;
                List<BaseEntity> list = XMLImportTestUtil.getContainersFromXml(doc);
                containers.addAll(list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            zipInput.close();
        }
        Document sourceDocument = XMLImportTestUtil.getSourceDocument(new File(PATH_TO_XML_SOURCE));
        List<Document> convertDocuments = XMLImportTestUtil.convert(sourceDocument, containers, messages);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("= MESSAGES ====================================");
        stringBuilder.append("\n");
        for (Message message : messages) {
            if (message.getType() != MessageType.MESSAGE) continue;
            stringBuilder.append(message.getMessage().toString());
            stringBuilder.append("\n");
            stringBuilder.append(message.getDetails());
            stringBuilder.append("\n");
            if (!message.getMessage().getParameters().isEmpty()) {
                node = (Node)message.getMessage().getParameters().get(0);
                stringBuilder.append(XMLImportTestUtil.toString((Node)node));
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("= WARNINGS ====================================");
        stringBuilder.append("\n");
        for (Message message : messages) {
            if (message.getType() != MessageType.WARNING && message.getType() != MessageType.ERROR) continue;
            stringBuilder.append(message.getMessage().toString());
            stringBuilder.append("\n");
            stringBuilder.append(message.getDetails());
            stringBuilder.append("\n");
            if (!message.getMessage().getParameters().isEmpty()) {
                node = (Node)message.getMessage().getParameters().get(0);
                stringBuilder.append(XMLImportTestUtil.toString((Node)node));
            }
            stringBuilder.append("\n");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(PATH_TO_LOG))), "utf-8");
        try {
            outputStreamWriter.write(stringBuilder.toString());
        }
        finally {
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        int count = 0;
        for (Document convertDocument : convertDocuments) {
            try (FileOutputStream outputStream = new FileOutputStream(new File(String.format(PATH_TO_SEPARATE_LOG, count + 1)));){
                Transformer transformer = XUtil.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.transform(new DOMSource(convertDocument), new StreamResult(outputStream));
                ++count;
            }
        }
        if (convertDocuments.size() > 0) {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(new File(PATH_TO_OUTPUT_ZIP))));){
                zipOutputStream.setComment("1C to Mid Office Manager convert");
                int count2 = 0;
                for (Document convertDocument : convertDocuments) {
                    zipOutputStream.putNextEntry(new ZipEntry(String.format("%08d.xml", count2 + 1)));
                    Transformer transformer = XUtil.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    try {
                        transformer.transform(new DOMSource(convertDocument), new StreamResult(zipOutputStream));
                        ++count2;
                    }
                    finally {
                        zipOutputStream.closeEntry();
                    }
                }
            }
        }
    }
}

