/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.utils.susanin;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLImportTestUtil {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final int MAX_ENTRIES_PER_DOCUMENT = 600;
    public static final Locale LOCALE_RU = new Locale("ru");
    public static final Locale LOCALE_EN = new Locale("en");
    private static final String IMPORTER = "importer";
    private static final String NULL_KEY = "NULL_KEY";
    private static final String TAG_L1 = "\u042e\u0440\u041b\u0438\u0446\u043e";
    private static final String TAG_L2 = "\u0424\u0438\u0437\u041b\u0438\u0446\u043e";
    private static final String TAG_TYPE = "\u042e\u0440\u0424\u0438\u0437\u041b\u0438\u0446\u043e";
    private static final String TAG_DK = "DKNumber";
    private static final String TAG_DK_FOR_PER = "DKNumber\u042e\u0440\u041b\u0438\u0446\u0430";
    private static final String TAG_INN = "\u0418\u041d\u041d";
    private static final String TAG_OKPO = "\u041a\u043e\u0434\u041f\u043e\u041e\u041a\u041f\u041e";
    private static final String TAG_KPP = "\u041a\u041f\u041f";
    private static final String TAG_NAME_SHORT = "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435";
    private static final String TAG_NAME_SHORT_ENG = "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435\u0410\u043d\u0433\u043b";
    private static final String TAG_NAME_FULL = "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435\u041f\u043e\u043b\u043d\u043e\u0435";
    private static final String TAG_NAME_FULL_ENG = "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435\u041f\u043e\u043b\u043d\u043e\u0435\u0410\u043d\u0433\u043b";
    private static final String TAG_ADDRESS_LEGAL = "\u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0439\u0410\u0434\u0440\u0435\u0441";
    private static final String TAG_ADDRESS_LEGAL_ENG = "\u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0439\u0410\u0434\u0440\u0435\u0441\u0410\u043d\u0433";
    private static final String TAG_ADDRESS_FACT = "\u0424\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439\u0410\u0434\u0440\u0435\u0441";
    private static final String TAG_ADDRESS_FACT_ENG = "\u0424\u0430\u043a\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439\u0410\u0434\u0440\u0435\u0441\u0410\u043d\u0433";
    private static final String TAG_PHONES = "\u0422\u0435\u043b\u0435\u0444\u043e\u043d\u044b";
    private static final String TAG_CONTACT = "\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0435\u041b\u0438\u0446\u043e";
    private static final String TAG_COMMENT = "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439";
    private static final String TAG_BANK_ACCOUNTS = "\u0411\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435\u0421\u0447\u0435\u0442\u0430";
    private static final String TAG_BANK_CODE = "\u041a\u043e\u0434_";
    private static final String TAG_BANK_ACCOUNT_TITLE = "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435";
    private static final String TAG_BANK_ACCOUNT_NUMBER = "\u0420\u0430\u0441\u0441\u0447\u0435\u0442\u043d\u044b\u0439\u0421\u0447\u0435\u0442";
    private static final String TAG_BANK_NAME = "\u0411\u0430\u043d\u043a";
    private static final String TAG_BANK_BIK = "\u0411\u0418\u041a";
    private static final String TAG_BANK_CORR = "\u041a\u043e\u0440\u0440\u0421\u0447\u0435\u0442";
    private static final String TAG_LASTNAME = "\u0424\u0430\u043c\u0438\u043b\u0438\u044f";
    private static final String TAG_FIRSTNAME = "\u0418\u043c\u044f";
    private static final String TAG_MIDDLENAME = "\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e";
    private static final String TAG_LASTNAME_ENG = "\u0424\u0430\u043c\u0438\u043b\u0438\u044f\u0410\u043d\u0433\u043b";
    private static final String TAG_FIRSTNAME_ENG = "\u0418\u043c\u044f\u0410\u043d\u0433\u043b";
    private static final String TAG_MIDDLENAME_ENG = "\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e\u0410\u043d\u0433\u043b";
    private static final String TAG_PASSPORT = "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0423\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u044f\u044e\u0449\u0438\u0439\u041b\u0438\u0447\u043d\u043e\u0441\u0442\u044c";
    private static final String TAG_PASSPORT_SERIE = "\u0421\u0435\u0440\u0438\u044f\u0418\u041d\u043e\u043c\u0435\u0440";
    private static final String TAG_PASSPORT_DATE = "\u0414\u0430\u0442\u0430\u0412\u044b\u0434\u0430\u0447\u0438";
    private static final String TAG_PASSPORT_ORG = "\u041a\u0435\u043c\u0412\u044b\u0434\u0430\u043d";
    private static final String VAL_ORG = "\u042e\u0440. \u043b\u0438\u0446\u043e";
    private static final String VAL_PER = "\u0424\u0438\u0437. \u043b\u0438\u0446\u043e";
    private static final String NODE_OBJECT = "object";
    private static final Map<String, EntityContainer<Organization>> oldOrganizationContainers = new HashMap<String, EntityContainer<Organization>>();
    private static final List<EntityReference<Organization>> oldAgencyReferences = new ArrayList<EntityReference<Organization>>();
    private static final Map<String, Organization> oldReferenceOrganizationContainers = new HashMap<String, Organization>();
    private static final Map<String, List<EntityContainer<Person>>> oldPersonContainers = new HashMap<String, List<EntityContainer<Person>>>();
    private static final Map<String, EntityContainer<? extends BaseEntity>> entityContainers = new HashMap<String, EntityContainer<? extends BaseEntity>>();
    private static final Map<String, BaseDictionary> dictionaryContainers = new HashMap<String, BaseDictionary>();
    private static final List<Element> organizations = new ArrayList<Element>();
    private static final List<Element> persons = new ArrayList<Element>();
    private static final Map<String, EntityReference<Organization>> dk2OrgRefMap = new HashMap<String, EntityReference<Organization>>();
    private static final Set<String> dkSet = new HashSet<String>();

    public static Document getSourceDocument(File file) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(file);
    }

    public static List<Document> convert(Document sourceDocument, List<BaseEntity> containers, List<Message> messages) throws Exception {
        Calendar startCalendar = Calendar.getInstance();
        XMLImportTestUtil.arrangeOldContainers(containers, messages);
        XMLImportTestUtil.createEntities(sourceDocument, messages);
        Calendar endCalendar = Calendar.getInstance();
        System.out.printf(" -> STARTED -> %s%n", DATE_FORMAT.format(startCalendar.getTime()));
        System.out.printf(" -> FINISHED -> %s%n", DATE_FORMAT.format(endCalendar.getTime()));
        long estimatedTime = endCalendar.getTimeInMillis() - startCalendar.getTimeInMillis();
        String hours = String.format("%02d", estimatedTime / 1000L / 3600L);
        String minutes = String.format("%02d", estimatedTime / 1000L / 60L);
        String seconds = String.format("%02d", estimatedTime / 1000L % 60L);
        System.out.printf(" -> ESTIMATED TIME -> %s:%s:%s%n", hours, minutes, seconds);
        ArrayList<Document> convertDocuments = new ArrayList<Document>();
        Document convertDocument = null;
        Node element = null;
        int count = 0;
        for (EntityContainer<? extends BaseEntity> entityContainer : entityContainers.values()) {
            if (count % 600 == 0) {
                count = 0;
                convertDocument = DocumentBuilderHelper.newDocument();
                convertDocuments.add(convertDocument);
                element = convertDocument.createElementNS(null, "objects");
                convertDocument.appendChild(element);
            }
            Element entityElement = XMLImportTestUtil.createEntityContainerElement(convertDocument, entityContainer);
            element.appendChild(entityElement);
            element.setAttribute("totalCount", String.valueOf(count + 1));
            ++count;
        }
        for (BaseDictionary dictionaryContainer : dictionaryContainers.values()) {
            if (count % 600 == 0) {
                count = 0;
                convertDocument = DocumentBuilderHelper.newDocument();
                convertDocuments.add(convertDocument);
                element = convertDocument.createElementNS(null, "objects");
                convertDocument.appendChild(element);
            }
            Element dictionaryElement = XMLImportTestUtil.createDictionatyContainerElement(convertDocument, dictionaryContainer);
            element.appendChild(dictionaryElement);
            element.setAttribute("totalCount", String.valueOf(count + 1));
            ++count;
        }
        return convertDocuments;
    }

    private static void arrangeOldContainers(List<BaseEntity> containers, List<Message> messages) {
        int numOrg = 0;
        int numPer = 0;
        int numOther = 0;
        for (BaseEntity base : containers) {
            if (base instanceof EntityContainer) {
                String key;
                if (((EntityContainer)base).getEntity() instanceof Organization) {
                    Organization org = (Organization)((EntityContainer)base).getEntity();
                    if (org == null) continue;
                    String string = key = !TextUtil.isBlank((String)org.getCode()) ? org.getCode() : NULL_KEY;
                    if (org.getTypes().contains(OrganizationType.AGENCY)) {
                        oldAgencyReferences.add((EntityReference<Organization>)((EntityContainer)base).toReference());
                    }
                    if (oldOrganizationContainers.containsKey(key) && !key.equals(NULL_KEY)) {
                        messages.add(MessageHelper.createErrorMessage((String)("\u0412\u043e \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0439 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0441 DK = " + key + ", \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 = " + org.getShortName()), (Object[])null));
                    }
                    if (!key.equals(NULL_KEY) && !oldOrganizationContainers.containsKey(key)) {
                        oldOrganizationContainers.put(key, (EntityContainer<Organization>)((EntityContainer)base));
                        oldReferenceOrganizationContainers.put(((EntityContainer)base).toReference().getUid(), (Organization)((EntityContainer)base).getEntity());
                    }
                    ++numOrg;
                    continue;
                }
                if (((EntityContainer)base).getEntity() instanceof Person) {
                    Person per = (Person)((EntityContainer)base).getEntity();
                    key = XMLImportTestUtil.getKeyForPerson(per);
                    if (!key.equals(NULL_KEY)) {
                        List<Object> list = !oldPersonContainers.containsKey(key) ? new ArrayList() : oldPersonContainers.get(key);
                        list.add((EntityContainer)base);
                        oldPersonContainers.put(key, list);
                    }
                    ++numPer;
                    continue;
                }
                ++numOther;
                continue;
            }
            ++numOther;
        }
    }

    private static void createEntities(Document sourceDocument, List<Message> messages) throws Exception {
        if (sourceDocument == null || sourceDocument.getChildNodes().getLength() == 0) {
            messages.add(MessageHelper.createErrorMessage((String)"No nodes in XML!", (Object[])null));
            return;
        }
        Node rootNode = sourceDocument.getChildNodes().item(0);
        int num = rootNode.getChildNodes().getLength();
        for (int i = 0; i < num; ++i) {
            Node node = rootNode.getChildNodes().item(i);
            if (!(node instanceof Element)) continue;
            if (TAG_L1.equals(node.getNodeName())) {
                organizations.add((Element)node);
                continue;
            }
            if (TAG_L2.equals(node.getNodeName())) {
                persons.add((Element)node);
                continue;
            }
            messages.add(MessageHelper.createWarningMessage((String)("Unknown tag in child elements: " + node.getNodeValue()), (Object[])null));
        }
        for (Element el : organizations) {
            XMLImportTestUtil.createOrganization(el, messages);
        }
        for (Element el : persons) {
            XMLImportTestUtil.createPerson(el, messages);
        }
        messages.add(MessageHelper.createMessage((String)("Number of nodes processed: " + num), (Object[])null));
        System.out.println("Number of nodes processed: " + num);
        System.out.println("Number of Organizations: " + organizations.size());
        System.out.println("Number of Persons: " + persons.size());
    }

    private static void createPerson(Element elem, List<Message> messages) throws Exception {
        Person per;
        EntityContainer<Person> perCont;
        String dkNumber = XHelper.readString((Element)elem, (String)TAG_DK_FOR_PER);
        if (TextUtil.isBlank((String)dkNumber)) {
            messages.add(MessageHelper.createErrorMessage((String)("No DKnumber found: " + elem.getNodeName()), (Object[])null));
            return;
        }
        String lastName = XHelper.readString((Element)elem, (String)TAG_LASTNAME);
        String firstName = XHelper.readString((Element)elem, (String)TAG_FIRSTNAME);
        String middleName = XHelper.readString((Element)elem, (String)TAG_MIDDLENAME);
        String lastNameEng = XHelper.readString((Element)elem, (String)TAG_LASTNAME_ENG);
        String firstNameEng = XHelper.readString((Element)elem, (String)TAG_FIRSTNAME_ENG);
        String middleNameEng = XHelper.readString((Element)elem, (String)TAG_MIDDLENAME_ENG);
        String comment = XHelper.readString((Element)elem, (String)TAG_COMMENT);
        if (TextUtil.isBlank((String)lastNameEng) && TextUtil.isBlank((String)firstNameEng)) {
            messages.add(MessageHelper.createErrorMessage((String)("Empty fields for : lastNameEng and firstNameEng  for person with DKnumber = " + dkNumber), (Object[])null));
            return;
        }
        if (TextUtil.isBlank((String)lastNameEng)) {
            messages.add(MessageHelper.createErrorMessage((String)("Empty fields for: lastNameEng for person with DKnumber = " + dkNumber), (Object[])null));
            return;
        }
        if (TextUtil.isBlank((String)firstNameEng)) {
            messages.add(MessageHelper.createErrorMessage((String)("Empty fields for: firstNameEng  for person with DKnumber = " + dkNumber), (Object[])null));
            return;
        }
        String key = XMLImportTestUtil.getKeyForPerson(lastNameEng, firstNameEng, middleNameEng, dk2OrgRefMap.get(dkNumber));
        if (!oldPersonContainers.containsKey(key)) {
            perCont = XMLImportTestUtil.createEntityContainer(Person.class, UUIDGenerator.generate().toString());
            per = (Person)perCont.getEntity();
        } else {
            List<EntityContainer<Person>> list = oldPersonContainers.get(key);
            if (list == null || list.size() == 0) {
                perCont = XMLImportTestUtil.createEntityContainer(Person.class, UUIDGenerator.generate().toString());
                per = (Person)perCont.getEntity();
                messages.add(MessageHelper.createErrorMessage((String)("In oldPersonsProfiles found empty list for key: " + key), (Object[])null));
            } else if (list.size() > 1) {
                perCont = XMLImportTestUtil.createEntityContainer(Person.class, UUIDGenerator.generate().toString());
                per = (Person)perCont.getEntity();
                messages.add(MessageHelper.createErrorMessage((String)("In oldPersonsProfiles found list with more than 1 person for key: " + key), (Object[])null));
            } else {
                perCont = list.get(0);
                per = (Person)perCont.getEntity();
                XMLImportTestUtil.clearAllPersonData(per);
            }
        }
        per.getTypes().add(PersonType.PASSENGER);
        per.setNotes(comment);
        L10nStringHelper.setValue((L10nString)per.getLastName(), (String)lastNameEng, (Locale)LOCALE_EN);
        L10nStringHelper.setValue((L10nString)per.getFirstName(), (String)firstNameEng, (Locale)LOCALE_EN);
        L10nStringHelper.setValue((L10nString)per.getMiddleName(), (String)middleNameEng, (Locale)LOCALE_EN);
        L10nStringHelper.setValue((L10nString)per.getLastName(), (String)lastName, (Locale)LOCALE_RU);
        L10nStringHelper.setValue((L10nString)per.getFirstName(), (String)firstName, (Locale)LOCALE_RU);
        L10nStringHelper.setValue((L10nString)per.getMiddleName(), (String)middleName, (Locale)LOCALE_RU);
        if (!dk2OrgRefMap.containsKey(dkNumber)) {
            messages.add(MessageHelper.createErrorMessage((String)("Ogranization not found with DKnumber " + dkNumber + " for person"), (Object[])null));
        } else {
            PersonEmployment pe = new PersonEmployment();
            pe.setOrganization(dk2OrgRefMap.get(dkNumber));
            per.getEmployments().add(pe);
        }
        NodeList childNodes = elem.getElementsByTagName(TAG_PASSPORT);
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!(childNodes.item(i) instanceof Element)) continue;
            Element el = (Element)childNodes.item(i);
            String number = XHelper.readString((Element)el, (String)TAG_PASSPORT_SERIE);
            String issueDateStr = XHelper.readString((Element)el, (String)TAG_PASSPORT_DATE);
            String org = XHelper.readString((Element)el, (String)TAG_PASSPORT_ORG);
            Passport passport = new Passport();
            passport.setLastName(lastNameEng);
            passport.setFirstName(firstNameEng);
            passport.setMiddleName(middleNameEng);
            passport.setNumber(number);
            passport.setIssueOrganization(org);
            Date issueDate = null;
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yy");
                issueDate = sdf.parse(issueDateStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            passport.setIssued(issueDate);
            if (TextUtil.isBlank((String)number)) continue;
            per.getPassports().add(passport);
        }
        entityContainers.put(per.getUid(), perCont);
    }

    private static void createOrganization(Element elem, List<Message> messages) {
        EntityContainer<Organization> orgCont;
        String dkNumber = XHelper.readString((Element)elem, (String)TAG_DK);
        if (TextUtil.isBlank((String)dkNumber)) {
            messages.add(MessageHelper.createErrorMessage((String)("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d DKnumber: " + elem.getNodeName()), (Object[])null));
            return;
        }
        if (dkSet.contains(dkNumber)) {
            messages.add(MessageHelper.createErrorMessage((String)("Duplicate DKnumber for organization: " + dkNumber), (Object[])null));
        } else {
            dkSet.add(dkNumber);
        }
        Organization org = null;
        if (oldOrganizationContainers.containsKey(dkNumber)) {
            orgCont = oldOrganizationContainers.get(dkNumber);
            if (orgCont != null) {
                org = (Organization)orgCont.getEntity();
                XMLImportTestUtil.clearAllOrganizationData(org);
            }
        } else {
            orgCont = XMLImportTestUtil.createEntityContainer(Organization.class, UUIDGenerator.generate().toString());
            org = (Organization)orgCont.getEntity();
        }
        String inn = XHelper.readString((Element)elem, (String)TAG_INN);
        String okpo = XHelper.readString((Element)elem, (String)TAG_OKPO);
        String kpp = XHelper.readString((Element)elem, (String)TAG_KPP);
        String shortName = XHelper.readString((Element)elem, (String)"\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
        String shortNameEng = XHelper.readString((Element)elem, (String)TAG_NAME_SHORT_ENG);
        String fullName = XHelper.readString((Element)elem, (String)TAG_NAME_FULL);
        String fullNameEng = XHelper.readString((Element)elem, (String)TAG_NAME_FULL_ENG);
        String addrLegalStr = XHelper.readString((Element)elem, (String)TAG_ADDRESS_LEGAL);
        String addrLegalEngStr = XHelper.readString((Element)elem, (String)TAG_ADDRESS_LEGAL_ENG);
        String addrFactStr = XHelper.readString((Element)elem, (String)TAG_ADDRESS_FACT);
        String addrFactEngStr = XHelper.readString((Element)elem, (String)TAG_ADDRESS_FACT_ENG);
        String phonesStr = XHelper.readString((Element)elem, (String)TAG_PHONES);
        String comment = XHelper.readString((Element)elem, (String)TAG_COMMENT);
        int num = elem.getChildNodes().getLength();
        ArrayList<Element> bankAccountElements = new ArrayList<Element>();
        for (int i = 0; i < num; ++i) {
            String[] node = elem.getChildNodes().item(i);
            if (!(node instanceof Element) || !TAG_BANK_ACCOUNTS.equals(node.getNodeName())) continue;
            int num2 = node.getChildNodes().getLength();
            for (int j = 0; j < num2; ++j) {
                Node node2 = node.getChildNodes().item(j);
                if (!(node2 instanceof Element) || !node2.getNodeName().startsWith(TAG_BANK_CODE)) continue;
                bankAccountElements.add((Element)node2);
            }
        }
        if (TextUtil.isBlank((String)fullNameEng) && TextUtil.isBlank((String)shortNameEng)) {
            messages.add(MessageHelper.createErrorMessage((String)("Empty fields for: fullNameEng and shortNameEng  for Organization with DKnumber = " + dkNumber), (Object[])null));
            return;
        }
        if (TextUtil.isBlank((String)fullNameEng)) {
            messages.add(MessageHelper.createErrorMessage((String)("Empty fields for: fullNameEng for organization with DKnumber = " + dkNumber), (Object[])null));
            return;
        }
        if (TextUtil.isBlank((String)shortNameEng)) {
            messages.add(MessageHelper.createErrorMessage((String)("Empty fields for: shortNameEng for Organization with DKnumber = " + dkNumber), (Object[])null));
            return;
        }
        org.getTypes().add(OrganizationType.CORPORATE_CLIENT);
        org.setCode(dkNumber);
        org.setKpp(kpp);
        org.setOkpoCode(okpo);
        org.setRegistrationId(inn);
        org.setNotes(comment);
        if (!TextUtil.isBlank((String)addrFactEngStr)) {
            Address addrFact = new Address();
            addrFact.setAddressType(AddressType.FACTUAL);
            if (ProfileSynchronizationUtil.checkForLatinSymbols((String)addrFactEngStr, (boolean)true)) {
                L10nStringHelper.setValue((L10nString)addrFact.getAddress(), (String)addrFactEngStr, (Locale)LOCALE_EN);
            } else {
                L10nStringHelper.setValue((L10nString)addrFact.getAddress(), (String)addrFactEngStr, (Locale)LOCALE_RU);
            }
            if (!TextUtil.isBlank((String)addrFactStr)) {
                L10nStringHelper.setValue((L10nString)addrFact.getAddress(), (String)addrFactStr, (Locale)LOCALE_RU);
            }
            org.getAddresses().add(addrFact);
        }
        if (!TextUtil.isBlank((String)addrLegalEngStr)) {
            Address addrLegal = new Address();
            addrLegal.setAddressType(AddressType.LEGAL);
            if (ProfileSynchronizationUtil.checkForLatinSymbols((String)addrLegalEngStr, (boolean)true)) {
                L10nStringHelper.setValue((L10nString)addrLegal.getAddress(), (String)addrLegalEngStr, (Locale)LOCALE_EN);
            } else {
                L10nStringHelper.setValue((L10nString)addrLegal.getAddress(), (String)addrLegalEngStr, (Locale)LOCALE_RU);
            }
            if (!TextUtil.isBlank((String)addrLegalStr)) {
                L10nStringHelper.setValue((L10nString)addrLegal.getAddress(), (String)addrLegalStr, (Locale)LOCALE_RU);
            }
            org.getAddresses().add(addrLegal);
        }
        if (!TextUtil.isBlank((String)phonesStr)) {
            String[] phones;
            for (String phone : phones = phonesStr.split(",")) {
                String clearedStr = phone.replaceAll("[^0-9 ]+", "").trim();
                if (TextUtil.isBlank((String)clearedStr)) continue;
                Communication comm = new Communication();
                comm.setType(CommunicationType.WORK_PHONE);
                comm.setSense(clearedStr);
                org.getCommunications().add(comm);
            }
        }
        L10nStringHelper.setValue((L10nString)org.getShortName(), (String)shortNameEng, (Locale)LOCALE_EN);
        L10nStringHelper.setValue((L10nString)org.getFullName(), (String)fullNameEng, (Locale)LOCALE_EN);
        L10nStringHelper.setValue((L10nString)org.getShortName(), (String)shortName, (Locale)LOCALE_RU);
        L10nStringHelper.setValue((L10nString)org.getFullName(), (String)fullName, (Locale)LOCALE_RU);
        for (Element el : bankAccountElements) {
            String accTitle = XHelper.readString((Element)el, (String)"\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
            String accNumber = XHelper.readString((Element)el, (String)TAG_BANK_ACCOUNT_NUMBER);
            String bankName = XHelper.readString((Element)el, (String)TAG_BANK_NAME);
            String bik = XHelper.readString((Element)el, (String)TAG_BANK_BIK);
            String corr = XHelper.readString((Element)el, (String)TAG_BANK_CORR);
            BankAccount ba = new BankAccount();
            ba.setBankName(bankName);
            ba.setSettlementAccount(accNumber);
            ba.setBik(bik);
            ba.setCorrespondentAccount(corr);
            ba.setRemarks(accTitle);
            org.getBankAccounts().add(ba);
        }
        entityContainers.put(org.getUid(), orgCont);
        dk2OrgRefMap.put(dkNumber, (EntityReference<Organization>)orgCont.toReference());
    }

    private static <T extends BaseEntity> EntityContainer<T> createEntityContainer(Class<T> entityClass, String uid) {
        EntityContainer entityContainer = new EntityContainer(entityClass, uid);
        entityContainer.setCreatedBy(IMPORTER);
        entityContainer.setModifiedBy(IMPORTER);
        VersionInfo versionInfo = entityContainer.getVersionInfo();
        String versionInfoUid = UUIDGenerator.generate((boolean)false).toString();
        versionInfo.setUid(versionInfoUid);
        versionInfo.setCreatedBy(IMPORTER);
        versionInfo.setModifiedBy(IMPORTER);
        String dataSource = "file";
        versionInfo.setDataSource(dataSource);
        return entityContainer;
    }

    private static <T extends BaseDictionary> T createDictionaryContainer(Class<T> dictionaryClass, String uid) throws Exception {
        BaseDictionary dictionaryContainer = (BaseDictionary)dictionaryClass.newInstance();
        dictionaryContainer.setUid(uid);
        dictionaryContainer.setCode(uid);
        dictionaryContainer.setCreatedBy(IMPORTER);
        dictionaryContainer.setModifiedBy(IMPORTER);
        return (T)dictionaryContainer;
    }

    private static <T extends BaseEntity> Element createEntityContainerElement(Document convertDocument, EntityContainer<T> entityContainer) throws Exception {
        Element entityContainerElement = convertDocument.createElementNS(null, NODE_OBJECT);
        entityContainerElement.setAttribute("class", EntityContainer.class.getName());
        entityContainer.toXML(entityContainerElement);
        return entityContainerElement;
    }

    private static <D extends BaseDictionary> Element createDictionatyContainerElement(Document convertDocument, D dictionaryContainer) throws Exception {
        Element dictionaryContainerElement = convertDocument.createElementNS(null, NODE_OBJECT);
        dictionaryContainerElement.setAttribute("class", dictionaryContainer.getClass().getName());
        dictionaryContainer.toXML(dictionaryContainerElement);
        return dictionaryContainerElement;
    }

    public static String toString(Node node) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Transformer transformer = XUtil.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.transform(new DOMSource(node), new StreamResult(baos));
        return baos.toString("utf-8");
    }

    public static List<BaseEntity> getContainersFromXml(Document doc) throws Exception {
        ArrayList<BaseEntity> res = new ArrayList<BaseEntity>();
        Element docEle = doc.getDocumentElement();
        NodeList containers = docEle.getElementsByTagName(NODE_OBJECT);
        if (containers.getLength() > 0) {
            for (int i = 0; i < containers.getLength(); ++i) {
                Node node = containers.item(i);
                if (node.getNodeType() != 1) continue;
                Element elm = (Element)node;
                String className = elm.getAttribute("class");
                if (className.contains("EntityContainer")) {
                    String typeClass = XHelper.readString((Element)elm, (String)"entityType");
                    Class<?> cls = Class.forName(typeClass);
                    EntityContainer etc = (EntityContainer)EntityContainer.class.getConstructor(Class.class).newInstance(cls);
                    etc.fromXML(elm);
                    res.add((BaseEntity)etc);
                    continue;
                }
                Class<?> cls = Class.forName(className);
                BaseDictionary dictionary = (BaseDictionary)cls.newInstance();
                dictionary.fromXML(elm);
                res.add((BaseEntity)dictionary);
            }
        }
        return res;
    }

    private static void clearAllOrganizationData(Organization org) {
        org.getAddresses().clear();
        org.getBankAccounts().clear();
        org.getCards().clear();
        org.getCommunications().clear();
        org.getCostCodeProperties().clear();
        org.getCostCodes().clear();
        org.getManagers().clear();
        org.getMetadata().clear();
        org.getPayers().clear();
        org.getResponsiblePersons().clear();
        org.getReasonCodes().clear();
        org.getSabreAdditionalCommand1Lines().clear();
        org.getSabreAdditionalCommand2Lines().clear();
        org.getSabreAdditionalCommand3Lines().clear();
        org.getSabreAdditionalProfileLines().clear();
        org.getTypes().clear();
        org.getVatLicenseNumberHistory().clear();
        org.getVatPayerHistory().clear();
        org.getWorkModes().clear();
        org.setAfsSettings(null);
        org.setAirline(null);
        org.setClientID(null);
        org.setKpp(null);
        org.setLegalForm(null);
        org.setNotes(null);
        org.setOkpoCode(null);
        org.setOldShortName(null);
        org.setOldDkNumber(null);
        org.setParent(null);
        org.setPreferredLocale(null);
        org.setRegistrationId(null);
        org.setSabreNotes(null);
        org.setSigner(null);
        org.setVatLicenseNumber(null);
        org.setVatPayer(null);
        org.getFullName().setStringValue(null);
        org.getShortName().setStringValue(null);
    }

    private static void clearAllPersonData(Person per) {
        per.getLastName().getValues().clear();
        per.getFirstName().getValues().clear();
        per.getMiddleName().getValues().clear();
        per.getAddresses().clear();
        per.getAirlineBonusCards().clear();
        per.getBankAccounts().clear();
        per.getCards().clear();
        per.setCode(null);
        per.getCostCodes().clear();
        per.getCommunications().clear();
        per.getEmployments().clear();
        per.getGdsReferences().clear();
        per.setGender(null);
        per.setLoginName(null);
        per.setNotes(null);
        per.setOldFirstName(null);
        per.setOldLastName(null);
        per.getSabreAdditionalProfileLines().clear();
        per.getSabreEmailContacts().clear();
        per.getSabrePhoneContacts().clear();
        per.getSalesPoints().clear();
        per.getTypes().clear();
        per.getVisas().clear();
        per.getPassports().clear();
    }

    private static String getKeyForPerson(Person per) {
        String res = "";
        if (per == null || TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true)) && TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
            return NULL_KEY;
        }
        if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
            res = L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        } else if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)true))) {
            res = L10nStringHelper.getValue((L10nString)per.getLastName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)true);
        }
        if (!ProfileSynchronizationUtil.checkForLatinSymbols((String)res, (boolean)false)) {
            res = TextUtil.translit((String)res, (boolean)true);
        }
        String firstName = "";
        if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
            firstName = L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        } else if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)true))) {
            firstName = L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)true);
        }
        if (!ProfileSynchronizationUtil.checkForLatinSymbols((String)firstName, (boolean)false)) {
            firstName = TextUtil.translit((String)firstName, (boolean)true);
        }
        String middleName = "";
        if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getMiddleName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true))) {
            middleName = L10nStringHelper.getValue((L10nString)per.getMiddleName(), (Locale)LocaleUtil.LOCALE_EN, (boolean)true);
        } else if (!TextUtil.isBlank((String)L10nStringHelper.getValue((L10nString)per.getMiddleName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)true))) {
            middleName = L10nStringHelper.getValue((L10nString)per.getFirstName(), (Locale)LocaleUtil.LOCALE_RU, (boolean)true);
        }
        if (!ProfileSynchronizationUtil.checkForLatinSymbols((String)middleName, (boolean)false)) {
            middleName = TextUtil.translit((String)middleName, (boolean)true);
        }
        EntityReference orgRef = per.getEmployments().size() > 0 ? (per.getEmployments().get(0) != null ? ((PersonEmployment)per.getEmployments().get(0)).getOrganization() : null) : null;
        return XMLImportTestUtil.getKeyForPerson(res, firstName, middleName, orgRef);
    }

    private static String getKeyForPerson(String res, String firstName, String middleName, EntityReference<Organization> orgRef) {
        String result = res;
        if (!result.contains(firstName)) {
            result = result + (result.length() > 0 ? " " : "") + firstName;
        }
        if (!result.contains(middleName)) {
            result = result + (result.length() > 0 ? " " : "") + middleName;
        }
        if (orgRef != null) {
            result = result + " " + orgRef.getUid();
        }
        if (TextUtil.isBlank((String)result)) {
            result = NULL_KEY;
        }
        return result.toUpperCase();
    }
}

