/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.utils.vct;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.model.utils.vct.VctXmlImportUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class VctImportTest
extends ModelTestBase {
    private static final String PATH_TO_OLD_PROFILES_ZIP = "C:\\astar\\Development\\current\\VIP-5504\\data\\importOLD.zip";
    private static final String PATH_TO_XML_SOURCE = "C:/astar/development/current/VIP-5504/data/contragents.xml";
    private static final String PATH_TO_LOG = "C:/astar/development/current/VIP-5504/data/import.log";
    private static final String PATH_TO_OUTPUT_ZIP = "C:/astar/development/current/VIP-5504/data/import.zip";
    public static final String PATH_TO_LEGAL_FORM_DICT = "C:/astar/development/current/VIP-5504/data/LegalForm.xml";
    public static final String PATH_TO_POSITIONS_DICT = "C:/astar/development/current/VIP-5504/data/Positions.xml";
    public static final String PATH_TO_METADATA_KEY_DICT = "C:/astar/development/current/VIP-5504/data/MetadataKey.xml";
    public static final String PATH_TO_LOCATIONS_DICT = "C:/astar/development/current/VIP-5504/data/GeoLocation.xml";
    public static final String PATH_TO_COST_CODE_CATEGORIES_DICT = "C:/astar/development/current/VIP-5504/data/CostCodeCategory.xml";
    public static final String PATH_TO_VCT_VIPCA_PROFILES_ZIP = "C:/astar/development/current/VIP-5504/data/VCT_VIPCA profiles.zip";
    public static final String PATH_TO_UDID_DATA_XML = "C:/astar/development/current/VIP-5504/data/UDIDData.xml";
    public static final String PATH_TO_UDID_DATA_DESCRIPTION = "C:/astar/development/current/VIP-5504/data/UDIDdescription.csv";
    private static final boolean DETAILED_MESSAGE = true;

    public void testVctImport() throws Exception {
        ArrayList<Message> messages = new ArrayList<Message>();
        List<BaseEntity> containers = this.parsePreviousImportEntities(messages);
        VctXmlImportUtil.loadDictionaryFromFile(PATH_TO_LEGAL_FORM_DICT);
        VctXmlImportUtil.loadDictionaryFromFile(PATH_TO_POSITIONS_DICT);
        VctXmlImportUtil.loadDictionaryFromFile(PATH_TO_METADATA_KEY_DICT);
        VctXmlImportUtil.loadDictionaryFromFile(PATH_TO_LOCATIONS_DICT);
        VctXmlImportUtil.loadDictionaryFromFile(PATH_TO_COST_CODE_CATEGORIES_DICT);
        VctXmlImportUtil.readUdidAndAFSMapping(PATH_TO_UDID_DATA_DESCRIPTION, messages);
        Document sourceDocument = VctXmlImportUtil.getSourceDocument(new File(PATH_TO_XML_SOURCE));
        Document udidDocument = VctXmlImportUtil.getSourceDocument(new File(PATH_TO_UDID_DATA_XML));
        List<Document> convertDocuments = VctXmlImportUtil.convert(sourceDocument, udidDocument, containers, messages);
        String logData = VctImportTest.prepareLogData(messages);
        this.writeToLogFile(logData);
        this.writeToImportFile(convertDocuments);
    }

    public static String prepareLogData(List<Message> messages) {
        StringBuilder str = new StringBuilder();
        Collections.sort(messages, new Comparator<Message>(){

            @Override
            public int compare(Message o1, Message o2) {
                if (o1 == null || o1.getMessage() == null || o2 == null || o2.getMessage() == null) {
                    return 0;
                }
                return o1.getMessage().toString().compareTo(o2.getMessage().toString());
            }
        });
        for (Message msg : messages) {
            str.append(MessageType.ERROR.name() + ": " + msg.getMessage() + "\n");
        }
        return str.toString();
    }

    private void writeToLogFile(String logData) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(PATH_TO_LOG))), "utf-8");
        try {
            outputStreamWriter.write(logData);
        }
        finally {
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToImportFile(List<Document> convertDocuments) throws Exception {
        if (convertDocuments.size() > 0) {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(new File(PATH_TO_OUTPUT_ZIP))));){
                zipOutputStream.setComment("1C to Mid Office Manager convertation");
                int count2 = 0;
                for (Document convertDocument : convertDocuments) {
                    zipOutputStream.putNextEntry(new ZipEntry(String.format("%08d.xml", count2 + 1)));
                    Transformer transformer = XUtil.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("encoding", "UTF-8");
                    try {
                        transformer.transform(new DOMSource(convertDocument), new StreamResult(zipOutputStream));
                        ++count2;
                    }
                    finally {
                        zipOutputStream.closeEntry();
                    }
                }
            }
        }
    }

    private List<BaseEntity> parsePreviousImportEntities(List<Message> messages) throws Exception {
        ArrayList<BaseEntity> containers = new ArrayList<BaseEntity>();
        containers.addAll(this.parseEntitiesFromFile(PATH_TO_OLD_PROFILES_ZIP, messages));
        containers.addAll(this.parseEntitiesFromFile(PATH_TO_VCT_VIPCA_PROFILES_ZIP, messages));
        return containers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BaseEntity> parseEntitiesFromFile(String path, List<Message> messages) throws Exception {
        ArrayList<BaseEntity> containers = new ArrayList<BaseEntity>();
        ZipInputStream zipInput = null;
        ZipFile zipFile = null;
        try {
            zipInput = new ZipInputStream(new FileInputStream(new File(path)));
            zipFile = new ZipFile(new File(path));
            messages.add(MessageHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"Zip file found.", null, (Object[])null));
        }
        catch (FileNotFoundException e) {
            if (zipInput != null) {
                zipInput.close();
            }
            zipInput = null;
            e.printStackTrace();
        }
        catch (Exception e) {
            if (zipFile != null) {
                zipFile.close();
            }
            zipFile = null;
            e.printStackTrace();
        }
        if (zipFile == null || zipInput == null) {
            messages.add(MessageHelper.createErrorMessage((String)"Zip file not found.", (Object[])null));
            if (zipInput != null) {
                zipInput.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
            return containers;
        }
        try {
            ZipEntry entry;
            while ((entry = zipInput.getNextEntry()) != null) {
                Document doc;
                System.out.println("Reading entry: " + entry.getName());
                try {
                    DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                    doc = docBuilder.parse(zipFile.getInputStream(entry));
                }
                catch (Exception e) {
                    doc = null;
                    e.printStackTrace();
                }
                if (doc == null) continue;
                List<BaseEntity> list = VctXmlImportUtil.getContainersFromXml(doc);
                containers.addAll(list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            zipInput.close();
        }
        return containers;
    }
}

